/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.voa.validator;

import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.voa.util.ServiceUtils;
import gov.va.med.esr.voa.webservice.PhoneInfo;
import gov.va.med.fw.service.AbstractComponent;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class PhoneInfoValidator
extends AbstractComponent
implements Validator {
    public boolean supports(Class clazz) {
        return PhoneInfo.class.equals((Object)clazz);
    }

    public void validate(Object target, Errors errors) {
        this.logger.debug((Object)"Phone info validation...");
        if (target != null) {
            PhoneInfo phoneInfo = (PhoneInfo)target;
            String phoneNumber = phoneInfo.getPhoneNumber();
            String type = phoneInfo.getType();
            if (PhoneType.CODE_HOME.getCode().equalsIgnoreCase(type)) {
                if (!ServiceUtils.validatePhone(phoneNumber)) {
                    errors.reject("VOA_0037", "Invalid Veteran Home Phone Number.");
                    this.logger.debug((Object)("Invalid veteran home phone number. " + phoneNumber));
                }
            } else if (PhoneType.CODE_MOBILE.getCode().equalsIgnoreCase(type) && !ServiceUtils.validatePhone(phoneNumber)) {
                errors.reject("VOA_0038", "Invalid Veteran cellular phone Number.");
                this.logger.debug((Object)("Invalid veteran cellular phone number. " + phoneNumber));
            }
        }
        this.logger.debug((Object)"Phone info validation - Done.");
    }
}

