/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.voa.validator;

import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.voa.util.ServiceUtils;
import gov.va.med.esr.voa.validator.AbstractValidator;
import gov.va.med.esr.voa.webservice.PersonInfo;
import gov.va.med.fw.util.StringUtils;
import org.springframework.validation.Errors;

public class PersonInfoValidator
extends AbstractValidator {
    private static final int LIMIT_LESS_THAN_20_CHARS = 20;
    private static final int LIMIT_LESS_THAN_30_CHARS = 30;
    private static final int LIMIT_LESS_THAN_35_CHARS = 35;

    public boolean supports(Class clazz) {
        return PersonInfo.class.equals((Object)clazz);
    }

    public void validate(Object target, Errors errors) {
        block31: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Person info validation...");
            }
            if (target != null) {
                PersonInfo personInfo;
                block30: {
                    String ssnTxt;
                    String mothersMaidenName;
                    String middleName;
                    String firstName;
                    personInfo = (PersonInfo)target;
                    String lastName = personInfo.getLastName();
                    if (StringUtils.isBlank((String)lastName)) {
                        errors.reject("VOA_0001", "Missing Required Field: Veteran Last Name.");
                    }
                    if (StringUtils.isBlank((String)(firstName = personInfo.getFirstName()))) {
                        errors.reject("VOA_0002", "Missing Required Field: Veteran First Name.");
                    }
                    if (StringUtils.isNotBlank((String)(middleName = personInfo.getMiddleName())) && middleName.length() > 30) {
                        errors.reject("VOA_0003", "Invalid middle name.");
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)"Invalid middle name.");
                        }
                    }
                    if (StringUtils.isNotBlank((String)(mothersMaidenName = personInfo.getMothersMaidenName())) && mothersMaidenName.length() > 35) {
                        errors.reject("VOA_0006", "Invalid Veteran's mother's maiden name.");
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)"Invalid Veteran's mother's maiden name.");
                        }
                    }
                    if (StringUtils.isBlank((String)(ssnTxt = personInfo.getSsnText()))) {
                        errors.reject("VOA_0007", "Missing Required Field:  Veteran SSN.");
                    } else {
                        boolean isValid = ServiceUtils.validateSsn(ssnTxt);
                        if (!isValid) {
                            errors.reject("VOA_0008", "Invalid Veteran SSN value.");
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)"Invalid Veteran SSN value.");
                            }
                        }
                    }
                    String dob = personInfo.getDob();
                    if (StringUtils.isBlank((String)dob)) {
                        errors.reject("VOA_0009", "Missing Required Field:  Veteran Date of Birth.");
                    } else {
                        boolean isValid = ServiceUtils.validateDate(dob);
                        if (isValid) {
                            boolean isFuture = ServiceUtils.isFutureDate(dob);
                            if (isFuture) {
                                errors.reject("VOA_0011", "Veteran Date of Birth cannot be a future date.");
                            }
                        } else {
                            errors.reject("VOA_0238", "Invalid Veteran date of birth.");
                        }
                    }
                    String gender = personInfo.getGender();
                    if (StringUtils.isBlank((String)gender)) {
                        try {
                            this.getLookupService().getGenderByCode(Gender.UNKNOWN.getName());
                        }
                        catch (UnknownLookupTypeException e) {
                            if (this.logger.isErrorEnabled()) {
                                this.logger.error((Object)("Unknown gender lookup type" + e.getMessage()));
                            }
                            break block30;
                        }
                        catch (UnknownLookupCodeException e) {
                            if (this.logger.isErrorEnabled()) {
                                this.logger.error((Object)("Unknown gender lookup code" + e.getMessage()));
                            }
                            break block30;
                        }
                    }
                    try {
                        this.getLookupService().getGenderByCode(gender);
                    }
                    catch (Exception e) {
                        errors.reject("VOA_0013", "Invalid Gender value for Veteran.");
                        if (!this.logger.isDebugEnabled()) break block30;
                        this.logger.debug((Object)("Invalid Gender value for Veteran. " + e.getMessage()));
                    }
                }
                String birthCity = personInfo.getPlaceOfBirthCity();
                if (StringUtils.isNotBlank((String)birthCity) && birthCity.length() > 20) {
                    errors.reject("VOA_0014", "Invalid City of birth for Veteran.");
                }
                try {
                    String birthStateCode = personInfo.getPlaceOfBirthState();
                    if (StringUtils.isNotBlank((String)birthStateCode)) {
                        this.getLookupService().getStateByCode(birthStateCode);
                    }
                }
                catch (Exception e) {
                    errors.reject("VOA_0015", "Invalid State value.");
                    if (!this.logger.isDebugEnabled()) break block31;
                    this.logger.debug((Object)("Cannot getAllStates because of code exception. " + e.getMessage()));
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Person info validation - Done");
        }
    }
}

