/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.voa.validator;

import gov.va.med.esr.voa.util.ServiceUtils;
import gov.va.med.esr.voa.validator.AbstractValidator;
import gov.va.med.esr.voa.webservice.MilitaryServiceEpisodeInfo;
import gov.va.med.fw.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;

public class MilitaryServiceEpisodeInfoValidator
extends AbstractValidator {
    public boolean supports(Class clazz) {
        return MilitaryServiceEpisodeInfo.class.equals((Object)clazz);
    }

    public void validate(Object target, Errors errors) {
        this.logger.debug((Object)"MilitaryServiceEpisodeInfo validation...");
        if (target != null) {
            MilitaryServiceEpisodeInfo militaryServiceEpisodeInfo = (MilitaryServiceEpisodeInfo)target;
            String serviceBranch = militaryServiceEpisodeInfo.getServiceBranch();
            if (StringUtils.isBlank((String)serviceBranch)) {
                errors.reject("VOA_0103", "Missing Required Field:  Last branch of service.");
            } else {
                try {
                    this.getLookupService().getServiceBranchByCode(serviceBranch);
                }
                catch (Exception e) {
                    errors.reject("VOA_0104", "Invalid Branch of service entered.");
                    this.logger.debug((Object)("Invalid Branch of service entered. " + e.getMessage()));
                }
            }
            String startDate = militaryServiceEpisodeInfo.getStartDate();
            if (StringUtils.isBlank((String)startDate)) {
                ValidationUtils.rejectIfEmpty((Errors)errors, (String)"startDate", (String)"VOA_0105", (String)"Missing Required Field:  Last service entry date.");
            } else {
                boolean isValidDate = ServiceUtils.validateDate(startDate);
                boolean isValidMonthYear = ServiceUtils.isValidMonthYear(startDate);
                if (isValidDate || isValidMonthYear) {
                    boolean isFutureDate = false;
                    if (isValidDate) {
                        isFutureDate = ServiceUtils.isFutureDate(startDate);
                    } else if (isValidMonthYear) {
                        isFutureDate = ServiceUtils.isFutureMonthYear(startDate);
                    }
                    if (isFutureDate) {
                        errors.reject("VOA_0106", "Invalid format for Last Service Entry Date.");
                        this.logger.debug((Object)"Invalid format for Last Service Entry Date.");
                    }
                } else {
                    errors.reject("VOA_0106", "Invalid format for Last Service Entry Date.");
                    this.logger.debug((Object)"Invalid format for Last Service Entry Date.");
                }
            }
            String endDate = militaryServiceEpisodeInfo.getEndDate();
            if (StringUtils.isBlank((String)endDate)) {
                ValidationUtils.rejectIfEmpty((Errors)errors, (String)"endDate", (String)"VOA_0107", (String)"Missing Required Field:  Last service discharge date.");
            } else {
                boolean isValidDate = ServiceUtils.validateDate(endDate);
                boolean isValidMonthYear = ServiceUtils.isValidMonthYear(endDate);
                if (isValidDate || isValidMonthYear) {
                    boolean isFutureDate = false;
                    if (isValidDate) {
                        isFutureDate = ServiceUtils.isFutureDate(endDate);
                    } else if (isValidMonthYear) {
                        isFutureDate = ServiceUtils.isFutureMonthYear(endDate);
                    }
                    if (isFutureDate) {
                        errors.reject("VOA_0108", "Invalid format for Last Service Discharge Date.");
                        this.logger.debug((Object)"Invalid format for Last Service Discharge Date.");
                    }
                } else {
                    errors.reject("VOA_0108", "Invalid format for Last Service Discharge Date.");
                    this.logger.debug((Object)"Invalid format for Last Service Discharge Date.");
                }
            }
            String dischargeType = militaryServiceEpisodeInfo.getDischargeType();
            if (StringUtils.isBlank((String)dischargeType)) {
                errors.reject("VOA_0109", "Missing Required Field: Type of Discharge.");
                this.logger.debug((Object)("Missing Required Field: Type of Discharge." + dischargeType));
            } else {
                try {
                    this.getLookupService().getDischargeTypeByCode(dischargeType);
                }
                catch (Exception e) {
                    errors.reject("VOA_0110", "Invalid discharge type value.");
                    this.logger.debug((Object)("Invalid discharge type value. " + e.getMessage()));
                }
            }
        }
        this.logger.debug((Object)"MilitaryServiceEpisodeInfo validation - Done.");
    }
}

