/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.voa.validator;

import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.voa.util.ServiceUtils;
import gov.va.med.esr.voa.validator.AbstractValidator;
import gov.va.med.esr.voa.webservice.AddressInfo;
import gov.va.med.esr.voa.webservice.InsuranceInfo;
import gov.va.med.fw.util.StringUtils;
import org.springframework.validation.Errors;

public class InsuranceInfoValidator
extends AbstractValidator {
    private static final String INSURANCE_TYPE_PRIVATE = "PI";
    private static final String INSURANCE_TYPE_MEDICARE = "MDCR";

    public boolean supports(Class clazz) {
        return InsuranceInfo.class.equals((Object)clazz);
    }

    public void validate(Object target, Errors errors) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"InsuranceInfo validation...");
        }
        if (target != null) {
            InsuranceInfo insuranceInfo = (InsuranceInfo)target;
            String policyNumber = insuranceInfo.getPolicyNumber();
            String insuranceMappingType = insuranceInfo.getInsuranceMappingTypeName();
            if (INSURANCE_TYPE_PRIVATE.equalsIgnoreCase(insuranceMappingType)) {
                String companyName = insuranceInfo.getCompanyName();
                if (StringUtils.isBlank((String)companyName)) {
                    errors.reject("VOA_0059", "Missing Required Field: Name of Insurance Company.");
                }
                AddressInfo addressInfo = insuranceInfo.getInsAddress();
                this.validateAddress(addressInfo, errors);
                String policyHolderName = insuranceInfo.getPolicyHolderName();
                if (StringUtils.isBlank((String)policyHolderName)) {
                    errors.reject("VOA_0065", "Missing Required Field:  Name of Insurance policy holder.");
                }
                String groupNumber = insuranceInfo.getGroupNumber();
                if (StringUtils.isBlank((String)policyNumber) && StringUtils.isBlank((String)groupNumber)) {
                    errors.reject("VOA_0066", "Missing Required Field:  Insurance policy number or group code.");
                }
            } else if (INSURANCE_TYPE_MEDICARE.equalsIgnoreCase(insuranceMappingType)) {
                Boolean isEnrolledInPartA = insuranceInfo.isEnrolledInPartA();
                String partAEffectiveDate = insuranceInfo.getPartAEffectiveDate();
                if (isEnrolledInPartA == null) {
                    errors.reject("VOA_0069", "Missing Required Field: Medicare Insurance Part A enrollment.");
                } else if (isEnrolledInPartA.booleanValue()) {
                    if (StringUtils.isBlank((String)partAEffectiveDate)) {
                        errors.reject("VOA_0070", "Missing Required Field: Effective date of Medicare Insurance Part A enrollment.");
                    } else {
                        boolean isValid = ServiceUtils.validateDate(partAEffectiveDate);
                        if (!isValid) {
                            errors.reject("VOA_0071", "Invalid Medicare part A effective date.");
                        } else {
                            boolean isFutureDate = ServiceUtils.isFutureDate(partAEffectiveDate);
                            if (isFutureDate) {
                                errors.reject("VOA_0071", "Invalid Medicare part A effective date.");
                            }
                        }
                    }
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"InsuranceInfo validation - Done.");
        }
    }

    public void validateAddress(AddressInfo addressInfo, Errors errors) {
        this.logger.debug((Object)"AddressInfo validation...");
        if (addressInfo != null) {
            boolean isValid;
            String phoneNumber;
            block27: {
                String country;
                String zip;
                block28: {
                    String city;
                    String line1 = addressInfo.getLine1();
                    if (StringUtils.isNotBlank((String)line1) && line1.length() > 35) {
                        errors.reject("VOA_0060", "Invalid street address for Insurance company.");
                    }
                    if (StringUtils.isNotBlank((String)(city = addressInfo.getCity())) && city.length() > 25) {
                        errors.reject("VOA_0061", "Invalid City for Insurance company address.");
                    }
                    zip = addressInfo.getZipCode();
                    country = addressInfo.getCountry();
                    if (StringUtils.isBlank((String)country) && StringUtils.isBlank((String)zip)) {
                        try {
                            this.getLookupService().getCountryByCode(Country.CODE_USA.getCode());
                        }
                        catch (Exception e) {
                            errors.reject("VOA_0226", "Invalid country provided for insurance company.");
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Invalid country for insurance company. " + country + "\n" + e.getMessage()));
                            }
                            break block27;
                        }
                    }
                    try {
                        if (StringUtils.isNotBlank((String)zip)) {
                            if (this.getLookupService().getZipCodeByCode(zip) != null) {
                                this.getLookupService().getCountryByCode(Country.CODE_USA.getCode());
                            } else {
                                errors.reject("VOA_0063", "Invalid zip code for insurance company.");
                            }
                        } else if (StringUtils.isBlank((String)zip) && StringUtils.isNotBlank((String)country)) {
                            this.getLookupService().getCountryByCode(country);
                        }
                    }
                    catch (Exception e) {
                        errors.reject("VOA_0226", "Invalid country for insurance company.");
                        if (!this.logger.isDebugEnabled()) break block28;
                        this.logger.debug((Object)("Invalid country for insurance company. " + country + "\n" + e.getMessage()));
                    }
                }
                String stateProvince = null;
                if (Country.CODE_USA.getCode().equalsIgnoreCase(country)) {
                    boolean isValid2;
                    String zipPlus;
                    boolean isValid3;
                    stateProvince = addressInfo.getState();
                    zip = addressInfo.getZipCode();
                    if (StringUtils.isNotBlank((String)zip) && !(isValid3 = ServiceUtils.validateZip(zip))) {
                        errors.reject("VOA_0063", "Invalid zip code for insurance company.");
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Invalid zip code for insurance company. " + zip));
                        }
                    }
                    if (StringUtils.isNotBlank((String)(zipPlus = addressInfo.getZipPlus4())) && !(isValid2 = ServiceUtils.validateZipPlus(zipPlus))) {
                        errors.reject("VOA_0233", "Invalid zip code plus 4 for insurance company.");
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Invalid zip code plus 4 for insurance company. " + zip));
                        }
                    }
                } else if (Country.CODE_CAN.getCode().equalsIgnoreCase(country) || Country.CODE_MEX.getCode().equalsIgnoreCase(country)) {
                    stateProvince = addressInfo.getProvinceCode();
                }
                if ((Country.CODE_USA.getCode().equalsIgnoreCase(country) || Country.CODE_CAN.getCode().equalsIgnoreCase(country) || Country.CODE_MEX.getCode().equalsIgnoreCase(country)) && StringUtils.isNotBlank((String)stateProvince)) {
                    try {
                        this.getLookupService().getStateByCode(stateProvince);
                    }
                    catch (Exception e) {
                        errors.reject("VOA_0062", "Invalid state or province for insurance company.");
                        if (!this.logger.isDebugEnabled()) break block27;
                        this.logger.debug((Object)("Invalid state or province for insurance company. " + stateProvince + "\n" + e.getMessage()));
                    }
                }
            }
            if (StringUtils.isNotBlank((String)(phoneNumber = addressInfo.getPhoneNumber())) && !(isValid = ServiceUtils.validatePhone(phoneNumber))) {
                errors.reject("VOA_0064", "Invalid phone number for insurance company.");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Invalid phone number for insurance company. " + phoneNumber));
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"AddressInfo validation - Done.");
        }
    }
}

