/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.voa.validator;

import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.lookup.EmploymentStatus;
import gov.va.med.esr.common.model.lookup.MaritalStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.VAFacilityType;
import gov.va.med.esr.voa.util.ServiceUtils;
import gov.va.med.esr.voa.validator.AbstractValidator;
import gov.va.med.esr.voa.validator.DemographicInfoValidator;
import gov.va.med.esr.voa.validator.EnrollmentDeterminationInfoValidator;
import gov.va.med.esr.voa.validator.FinancialInfoValidator;
import gov.va.med.esr.voa.validator.InsuranceInfoValidator;
import gov.va.med.esr.voa.validator.MilitaryServiceEpisodeInfoValidator;
import gov.va.med.esr.voa.validator.PersonInfoValidator;
import gov.va.med.esr.voa.webservice.AddressCollection;
import gov.va.med.esr.voa.webservice.AddressInfo;
import gov.va.med.esr.voa.webservice.ApplicationCollection;
import gov.va.med.esr.voa.webservice.ApplicationInfo;
import gov.va.med.esr.voa.webservice.ContactInfo;
import gov.va.med.esr.voa.webservice.DemographicInfo;
import gov.va.med.esr.voa.webservice.EeSummary;
import gov.va.med.esr.voa.webservice.EmploymentInfo;
import gov.va.med.esr.voa.webservice.EnrollmentDeterminationInfo;
import gov.va.med.esr.voa.webservice.FinancialStatementInfo;
import gov.va.med.esr.voa.webservice.FinancialsInfo;
import gov.va.med.esr.voa.webservice.Form;
import gov.va.med.esr.voa.webservice.FormIdentifier;
import gov.va.med.esr.voa.webservice.InsuranceCollection;
import gov.va.med.esr.voa.webservice.InsuranceInfo;
import gov.va.med.esr.voa.webservice.MilitaryServiceEpisodeCollection;
import gov.va.med.esr.voa.webservice.MilitaryServiceEpisodeInfo;
import gov.va.med.esr.voa.webservice.MilitaryServiceInfo;
import gov.va.med.esr.voa.webservice.MilitaryServiceSiteRecordCollection;
import gov.va.med.esr.voa.webservice.MilitaryServiceSiteRecordInfo;
import gov.va.med.esr.voa.webservice.PersonInfo;
import gov.va.med.esr.voa.webservice.SpouseFinancialsCollection;
import gov.va.med.esr.voa.webservice.SpouseFinancialsInfo;
import gov.va.med.esr.voa.webservice.SpouseInfo;
import java.util.Iterator;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public class FormValidator
extends AbstractValidator {
    private static final String TYPE_1010EZ = "100";
    private static final String TYPE_21526EZ = "105";
    private static final PersonInfoValidator personInfoValidator = new PersonInfoValidator();
    private static final DemographicInfoValidator demographicInfoValidator = new DemographicInfoValidator();
    private static final EnrollmentDeterminationInfoValidator enrollmentDeterminationInfoValidator = new EnrollmentDeterminationInfoValidator();

    public boolean supports(Class clazz) {
        return Form.class.equals((Object)clazz);
    }

    public void validate(Object target, Errors errors) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"validate form.");
        }
        if (target != null) {
            Form form = (Form)target;
            EeSummary eeSummary = form.getSummary();
            if (eeSummary != null) {
                FinancialsInfo financialsInfo;
                MilitaryServiceSiteRecordCollection militaryServiceSiteRecordCollection;
                MilitaryServiceInfo militaryServiceInfo;
                InsuranceCollection insuranceCollection;
                EnrollmentDeterminationInfo enrollmentDeterminationInfo;
                DemographicInfo demographicInfo;
                block20: {
                    PersonInfo personInfo = eeSummary.getPersonInfo();
                    if (personInfo != null) {
                        ValidationUtils.invokeValidator((Validator)personInfoValidator, (Object)personInfo, (Errors)errors);
                    }
                    demographicInfo = eeSummary.getDemographics();
                    if (form.getFormIdentifier().getType().equalsIgnoreCase(TYPE_21526EZ)) {
                        List<AddressInfo> addressInfoList;
                        AddressCollection addressCollection;
                        AddressInfo addressInfo = null;
                        String zipCode = null;
                        ContactInfo contactInfo = demographicInfo.getContactInfo();
                        if (contactInfo != null && (addressCollection = contactInfo.getAddresses()) != null && !(addressInfoList = addressCollection.getAddress()).isEmpty()) {
                            addressInfo = addressInfoList.get(0);
                        }
                        if (addressInfo != null) {
                            zipCode = addressInfo.getZipCode();
                            try {
                                VAFacility nearest = this.findNearestFacilityByZip(zipCode);
                                if (nearest != null) {
                                    demographicInfo.setPreferredFacility(nearest.getStationNumber());
                                    break block20;
                                }
                                this.logger.info((Object)"VOA 526 PF nearest facility is Null for zip code");
                                errors.reject("VOA_0021", "Nearest VA Facility cannot be determined from zip code.");
                            }
                            catch (Exception e) {
                                this.logger.info((Object)("VOA 526 PF failed for Exception: " + e.getMessage()));
                                errors.reject("VOA_0021", "Nearest VA Facility cannot be determined from zip code.");
                            }
                        } else {
                            this.logger.info((Object)"VOA 526 PF failed for Null AddressInfo");
                            errors.reject("VOA_0021", "Nearest VA Facility cannot be determined from zip code.");
                        }
                    }
                }
                if (demographicInfo != null) {
                    ValidationUtils.invokeValidator((Validator)demographicInfoValidator, (Object)demographicInfo, (Errors)errors);
                }
                if ((enrollmentDeterminationInfo = eeSummary.getEnrollmentDeterminationInfo()) != null) {
                    ValidationUtils.invokeValidator((Validator)enrollmentDeterminationInfoValidator, (Object)enrollmentDeterminationInfo, (Errors)errors);
                }
                if ((insuranceCollection = eeSummary.getInsuranceList()) != null) {
                    List<InsuranceInfo> insuranceInfoList = insuranceCollection.getInsurance();
                    for (InsuranceInfo insuranceInfo : insuranceInfoList) {
                        ValidationUtils.invokeValidator((Validator)new InsuranceInfoValidator(), (Object)insuranceInfo, (Errors)errors);
                    }
                }
                if ((militaryServiceInfo = eeSummary.getMilitaryServiceInfo()) != null && (militaryServiceSiteRecordCollection = militaryServiceInfo.getMilitaryServiceSiteRecords()) != null) {
                    List<MilitaryServiceSiteRecordInfo> militaryServiceSiteRecordInfoList = militaryServiceSiteRecordCollection.getMilitaryServiceSiteRecord();
                    for (MilitaryServiceSiteRecordInfo militaryServiceSiteRecordInfo : militaryServiceSiteRecordInfoList) {
                        MilitaryServiceEpisodeCollection militaryServiceEpisodeCollection = militaryServiceSiteRecordInfo.getMilitaryServiceEpisodes();
                        if (militaryServiceEpisodeCollection == null) continue;
                        List<MilitaryServiceEpisodeInfo> militaryServiceEpisodeInfoList = militaryServiceEpisodeCollection.getMilitaryServiceEpisode();
                        for (MilitaryServiceEpisodeInfo militaryServiceEpisodeInfo : militaryServiceEpisodeInfoList) {
                            ValidationUtils.invokeValidator((Validator)new MilitaryServiceEpisodeInfoValidator(), (Object)militaryServiceEpisodeInfo, (Errors)errors);
                        }
                    }
                }
                if ((financialsInfo = eeSummary.getFinancialsInfo()) != null) {
                    ValidationUtils.invokeValidator((Validator)new FinancialInfoValidator(), (Object)financialsInfo, (Errors)errors);
                }
            }
            ApplicationCollection applicationCollection = form.getApplications();
            this.validateApplicationInfo(applicationCollection, errors);
            this.validateAppDate(form, errors);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("validate form - Done:" + form));
            }
        }
    }

    private VAFacility findNearestFacilityByZip(String zip) throws Exception {
        if (zip == null) {
            return null;
        }
        List facilities = this.getLookupService().getAllVaFacilitys();
        boolean match = false;
        int level = 5;
        VAFacility nearest = null;
        for (int i = 0; i < 5 && !match; ++i) {
            zip = zip.substring(0, level);
            Iterator itr = facilities.iterator();
            while (itr != null && itr.hasNext()) {
                String vaZip;
                VAFacility vamc = (VAFacility)itr.next();
                if (vamc == null || vamc.getEndDate() != null || !vamc.getType().getIsMedicalTreating() || !vamc.getType().getCode().equals(VAFacilityType.CODE_OPC.getName()) && !vamc.getType().getCode().equals(VAFacilityType.CODE_CBOC.getName()) && !vamc.getType().getCode().equals(VAFacilityType.CODE_VAMC.getName()) || vamc.getStreetAddress() == null || vamc.getStreetAddress().getZipCode() == null || !zip.equals(vaZip = vamc.getStreetAddress().getZipCode().substring(0, level))) continue;
                match = true;
                nearest = vamc;
                this.logger.info((Object)("setting VOA form 526 PF for zip code level match:" + vaZip + " to site:" + vamc.getStationNumber()));
                break;
            }
            --level;
        }
        return nearest;
    }

    private void validateSpouseEmploymentInfo(DemographicInfo demographicInfo, FinancialsInfo financialsInfo, Errors errors) {
        if (demographicInfo != null) {
            SpouseFinancialsCollection spouseFinancialsCollection;
            FinancialStatementInfo financialStatementInfo;
            String maritialStatus = demographicInfo.getMaritalStatus();
            if ((MaritalStatus.CODE_MARRIED.getCode().equalsIgnoreCase(maritialStatus) || MaritalStatus.CODE_SEPARATED.getCode().equalsIgnoreCase(maritialStatus)) && financialsInfo != null && (financialStatementInfo = financialsInfo.getFinancialStatement()) != null && (spouseFinancialsCollection = financialStatementInfo.getSpouseFinancialsList()) != null) {
                List<SpouseFinancialsInfo> SpouseFinancialsInfoList = spouseFinancialsCollection.getSpouseFinancials();
                for (SpouseFinancialsInfo spouseFinancialsInfo : SpouseFinancialsInfoList) {
                    SpouseInfo spouseInfo = spouseFinancialsInfo.getSpouse();
                    this.validateSpouseEmployment(spouseInfo, errors);
                }
            }
        }
    }

    private void validateSpouseEmployment(SpouseInfo spouseInfo, Errors errors) {
        EmploymentInfo employmentInfo;
        if (spouseInfo != null && (employmentInfo = spouseInfo.getEmployment()) != null) {
            String employmentStatus = employmentInfo.getEmploymentStatus();
            if (StringUtils.isBlank((String)employmentStatus) && !this.isNewOMBApprovedForm) {
                errors.reject("VOA_0089", "Missing required field: Spouse's employment status.");
            }
            if (EmploymentStatus.CODE_RETIRED.getCode().equalsIgnoreCase(employmentStatus)) {
                String retirementDate = employmentInfo.getRetirementDate();
                if (StringUtils.isBlank((String)retirementDate)) {
                    errors.reject("VOA_0090", "Missing required field: Spouse's date of retirement.");
                } else {
                    boolean isValidDate = ServiceUtils.validateDate(retirementDate);
                    boolean isValidYear = ServiceUtils.isValidYear(retirementDate);
                    if (isValidDate || isValidYear) {
                        boolean isFutureDate = false;
                        if (isValidDate) {
                            isFutureDate = ServiceUtils.isFutureDate(retirementDate);
                        } else if (isValidYear) {
                            isFutureDate = ServiceUtils.isFutureYear(retirementDate);
                        }
                        if (isFutureDate) {
                            errors.reject("VOA_0091", "Invalid date of retirement for spouse.");
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)"Invalid date of retirement for spouse.");
                            }
                        }
                    } else {
                        errors.reject("VOA_0091", "Invalid date of retirement for spouse.");
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)"Invalid date of retirement for spouse.");
                        }
                    }
                }
            }
            if (EmploymentStatus.CODE_FULL_TIME.getCode().equalsIgnoreCase(employmentStatus) || EmploymentStatus.CODE_PART_TIME.getCode().equalsIgnoreCase(employmentStatus)) {
                boolean isValid;
                String employmentName = employmentInfo.getEmployerName();
                if (StringUtils.isBlank((String)employmentName)) {
                    errors.reject("VOA_0092", "Missing required field: Name of Spouse's employer.");
                } else {
                    boolean isValid2 = ServiceUtils.hasLessThan30Chars(employmentName);
                    if (!isValid2) {
                        errors.reject("VOA_0093", "Invalid value for the Name of Spouse's employer.");
                    }
                }
                AddressInfo addressInfo = employmentInfo.getEmployerAddress();
                if (addressInfo == null) {
                    errors.reject("VOA_0094", "Missing required field: Street address of Spouse's employer.");
                } else {
                    this.validateSpouseEmploymentAddress(addressInfo, errors);
                }
                String phoneNumber = employmentInfo.getEmployerPhone();
                if (phoneNumber != null && !(isValid = ServiceUtils.validatePhoneWithExtension(phoneNumber))) {
                    errors.reject("VOA_0102", "Invalid phone number for Spouse's employer.");
                }
            }
        }
    }

    private void validateSpouseEmploymentAddress(AddressInfo addressInfo, Errors errors) {
        block27: {
            String line1;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"AddressInfo validation...");
            }
            if (StringUtils.isBlank((String)(line1 = addressInfo.getLine1()))) {
                errors.reject("VOA_0094", "Missing required field: Street address of Spouse's employer.");
            } else if (!ServiceUtils.hasLessThan30Chars(line1)) {
                errors.reject("VOA_0095", "Invalid value for Street address of Spouse's employer.");
            }
            String city = addressInfo.getCity();
            if (StringUtils.isBlank((String)city)) {
                errors.reject("VOA_0096", "Missing required field: City of Spouse's employer.");
            } else if (!ServiceUtils.hasLessThan30Chars(city)) {
                errors.reject("VOA_0097", "Invalid value for City of Spouse's employer.");
            }
            String country = addressInfo.getCountry();
            if (StringUtils.isBlank((String)country)) {
                errors.reject("VOA_0237", "Missing required field: Country of Spouse's employer.");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Missing required field: Country of Spouse's employer. ");
                }
            } else {
                block26: {
                    try {
                        this.getLookupService().getCountryByCode(country);
                    }
                    catch (Exception e) {
                        errors.reject("VOA_0245", "Invalid country for Spouse's employer.");
                        if (!this.logger.isDebugEnabled()) break block26;
                        this.logger.debug((Object)("Invalid country for Spouse's employer. " + e.getMessage()));
                    }
                }
                String stateProvince = null;
                if (Country.CODE_USA.getCode().equalsIgnoreCase(country)) {
                    boolean isValid;
                    stateProvince = addressInfo.getState();
                    String zip = addressInfo.getZipCode();
                    if (StringUtils.isBlank((String)zip)) {
                        errors.reject("VOA_0101", "Missing required field: Zip code for Spouse's employer.");
                    } else {
                        boolean isValid2 = ServiceUtils.validateZip(zip);
                        if (!isValid2) {
                            errors.reject("VOA_0100", "Invalid zip code for Spouse's employer.");
                        }
                    }
                    String zipPlus = addressInfo.getZipPlus4();
                    if (StringUtils.isNotBlank((String)zipPlus) && !(isValid = ServiceUtils.validateZipPlus(zipPlus))) {
                        errors.reject("VOA_0235", "Invalid zip code plus 4 for Spouse's employer.");
                    }
                } else if (Country.CODE_CAN.getCode().equalsIgnoreCase(country) || Country.CODE_MEX.getCode().equalsIgnoreCase(country)) {
                    stateProvince = addressInfo.getProvinceCode();
                }
                if (Country.CODE_USA.getCode().equalsIgnoreCase(country) || Country.CODE_CAN.getCode().equalsIgnoreCase(country) || Country.CODE_MEX.getCode().equalsIgnoreCase(country)) {
                    if (StringUtils.isBlank((String)stateProvince)) {
                        errors.reject("VOA_0099", "Missing required field: State or Pronince for Spouse's employer.");
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)"Missing required field: State or Pronince for Spouse's employer.");
                        }
                    } else {
                        try {
                            this.getLookupService().getStateByCode(stateProvince);
                        }
                        catch (Exception e) {
                            errors.reject("VOA_0098", "Invalid value for State or Province for Spouse's employer.");
                            if (!this.logger.isDebugEnabled()) break block27;
                            this.logger.debug((Object)("Invalid value for State or Province for Spouse's employer. " + e.getMessage()));
                        }
                    }
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"AddressInfo validation - Done.");
        }
    }

    private void validateApplicationInfo(ApplicationCollection applicationCollection, Errors errors) {
        if (applicationCollection != null) {
            List<ApplicationInfo> applicationInfoList = applicationCollection.getApplicationInfo();
            for (ApplicationInfo applicationInfo : applicationInfoList) {
                String benefitType = applicationInfo.getBenefitType();
            }
        }
    }

    private void validateAppDate(Form form, Errors errors) {
        String formType;
        FormIdentifier formIdentifier = form.getFormIdentifier();
        if (formIdentifier != null && (TYPE_1010EZ.equalsIgnoreCase(formType = formIdentifier.getType()) || TYPE_21526EZ.equalsIgnoreCase(formType))) {
            XMLGregorianCalendar appDate = null;
            ApplicationCollection applicationCollection = form.getApplications();
            if (applicationCollection != null) {
                List<ApplicationInfo> applicationInfoList = applicationCollection.getApplicationInfo();
                for (ApplicationInfo applicationInfo : applicationInfoList) {
                    XMLGregorianCalendar temp = applicationInfo.getAppDate();
                    if (temp == null) continue;
                    appDate = temp;
                    break;
                }
            }
            if (appDate == null) {
                if (TYPE_1010EZ.equalsIgnoreCase(formType)) {
                    errors.reject("VOA_0248", "Missing required field for 10-10EZ Application:  Application Date.");
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Missing required field for 10-10EZ Application:  Application Date.");
                    }
                } else if (TYPE_21526EZ.equalsIgnoreCase(formType)) {
                    errors.reject("VOA_0253", "Missing required field for 21526EZ Application:  Application Date.");
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Missing required field for 21526EZ Application:  Application Date.");
                    }
                }
            }
        }
    }
}

