/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.voa.validator;

import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.voa.util.ServiceUtils;
import gov.va.med.esr.voa.validator.AbstractValidator;
import gov.va.med.esr.voa.validator.SpouseInfoValidator;
import gov.va.med.esr.voa.webservice.AddressInfo;
import gov.va.med.esr.voa.webservice.AssetCollection;
import gov.va.med.esr.voa.webservice.AssetInfo;
import gov.va.med.esr.voa.webservice.DependentFinancialsCollection;
import gov.va.med.esr.voa.webservice.DependentFinancialsInfo;
import gov.va.med.esr.voa.webservice.DependentInfo;
import gov.va.med.esr.voa.webservice.ExpenseCollection;
import gov.va.med.esr.voa.webservice.ExpenseInfo;
import gov.va.med.esr.voa.webservice.FinancialStatementInfo;
import gov.va.med.esr.voa.webservice.FinancialsInfo;
import gov.va.med.esr.voa.webservice.IncomeCollection;
import gov.va.med.esr.voa.webservice.IncomeInfo;
import gov.va.med.esr.voa.webservice.SpouseFinancialsCollection;
import gov.va.med.esr.voa.webservice.SpouseFinancialsInfo;
import gov.va.med.esr.voa.webservice.SpouseInfo;
import gov.va.med.esr.voa.webservice.SsnCollection;
import gov.va.med.esr.voa.webservice.SsnInfo;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public class FinancialInfoValidator
extends AbstractValidator {
    private static final int LIMIT_30_CHARS = 30;
    private static final BigDecimal MINIMUM = new BigDecimal(0.0);
    private static final BigDecimal MAXIMUM = new BigDecimal(9999999.99);

    public boolean supports(Class clazz) {
        return FinancialsInfo.class.equals((Object)clazz);
    }

    public void validate(Object target, Errors errors) {
        FinancialsInfo financialsInfo;
        FinancialStatementInfo financialStatementInfo;
        this.logger.debug((Object)"FinancialsInfo validation...");
        if (target != null && (financialStatementInfo = (financialsInfo = (FinancialsInfo)target).getFinancialStatement()) != null) {
            AssetCollection assetCollection;
            ExpenseCollection expenseCollection;
            IncomeCollection incomeCollection;
            List<DependentFinancialsInfo> dependentFinancialsList;
            Iterator<DependentFinancialsInfo> i$;
            DependentFinancialsCollection dependentFinancialsCollection;
            List<SpouseFinancialsInfo> spouseFinancialsInfoList;
            Iterator<SpouseFinancialsInfo> i$2;
            SpouseFinancialsCollection spouseFinancialsCollection = financialStatementInfo.getSpouseFinancialsList();
            if (spouseFinancialsCollection != null && (i$2 = (spouseFinancialsInfoList = spouseFinancialsCollection.getSpouseFinancials()).iterator()).hasNext()) {
                SpouseFinancialsInfo spouseFinancialsInfo = i$2.next();
                this.validateSpouseFinancialInfo(spouseFinancialsInfo, errors);
            }
            if ((dependentFinancialsCollection = financialStatementInfo.getDependentFinancialsList()) != null && (i$ = (dependentFinancialsList = dependentFinancialsCollection.getDependentFinancials()).iterator()).hasNext()) {
                DependentFinancialsInfo dependentFinancialsInfo = i$.next();
                this.validateDependentFinancialInfo(dependentFinancialsInfo, errors);
            }
            if ((incomeCollection = financialStatementInfo.getIncomes()) != null) {
                List<IncomeInfo> incomeInfoList = incomeCollection.getIncome();
                for (IncomeInfo incomeInfo : incomeInfoList) {
                    this.validateVeteranIncome(incomeInfo, errors);
                }
            }
            if ((expenseCollection = financialStatementInfo.getExpenses()) != null) {
                List<ExpenseInfo> expenseInfoList = expenseCollection.getExpense();
                for (ExpenseInfo expenseInfo : expenseInfoList) {
                    String expenseType = expenseInfo.getExpenseType();
                    BigDecimal amount = expenseInfo.getAmount();
                    if (ExpenseType.EXPENSE_TYPE_NON_REIMBURSED_MEDICAL.getCode().equalsIgnoreCase(expenseType)) {
                        if (amount == null) {
                            errors.reject("VOA_0187", "Missing Required Field: Total non-reimbursed medical expense paid by Veteran or spouse.");
                            continue;
                        }
                        if (amount.compareTo(MINIMUM) >= 0 && amount.compareTo(MAXIMUM) <= 0) continue;
                        errors.reject("VOA_0188", "Value outside range of  0 to 9999999.99 for  total non-reimbursed medical expense paid by Veteran or spouse.");
                        continue;
                    }
                    if (ExpenseType.EXPENSE_TYPE_FUNERAL_AND_BURIAL.getCode().equalsIgnoreCase(expenseType)) {
                        if (amount == null) {
                            errors.reject("VOA_0190", "Missing Required Field: Amount you paid last calendar year for burial expenses.");
                            continue;
                        }
                        if (amount.compareTo(MINIMUM) >= 0 && amount.compareTo(MAXIMUM) <= 0) continue;
                        errors.reject("VOA_0191", "Value outside range of  0 to 9999999.99 for amount you paid last calendar year for burial expenses.");
                        continue;
                    }
                    if (!ExpenseType.EXPENSE_TYPE_COLLEGE_AND_VOCATION.getCode().equalsIgnoreCase(expenseType)) continue;
                    if (amount == null) {
                        errors.reject("VOA_0193", "Missing Required Field: Amount you paid last calendar year for educational expenses.");
                        continue;
                    }
                    if (amount.compareTo(MINIMUM) >= 0 && amount.compareTo(MAXIMUM) <= 0) continue;
                    errors.reject("VOA_0194", "Value outside range of  0 to 9999999.99 for amount you paid last calendar year for educational expenses.");
                }
            }
            if ((assetCollection = financialStatementInfo.getAssets()) != null) {
                this.validateVeteranAsset(assetCollection, errors);
            }
        }
        this.logger.debug((Object)"FinancialsInfo validation - Done.");
    }

    private void validateVeteranAsset(AssetCollection assetCollection, Errors errors) {
        List<AssetInfo> assetInfoList = assetCollection.getAsset();
        for (AssetInfo assetInfo : assetInfoList) {
            BigDecimal amount = assetInfo.getAmount();
            String assetType = assetInfo.getAssetType();
            if (AssetType.CODE_CASH.getCode().equalsIgnoreCase(assetType)) {
                if (amount == null) {
                    errors.reject("VOA_0196", "Missing required field: Cash, amount in back accounts for Veteran.");
                    continue;
                }
                if (amount.compareTo(MINIMUM) >= 0 && amount.compareTo(MAXIMUM) <= 0) continue;
                errors.reject("VOA_0197", "Value outside range of  0 to 9999999.99 for cash, amount in back accounts for Veteran.");
                continue;
            }
            if (AssetType.CODE_REAL_ESTATE.getCode().equalsIgnoreCase(assetType)) {
                if (amount == null) {
                    errors.reject("VOA_0205", "Missing required field: Market value of land/buildings/lien for Veteran.");
                    continue;
                }
                if (amount.compareTo(MINIMUM) >= 0 && amount.compareTo(MAXIMUM) <= 0) continue;
                errors.reject("VOA_0206", "Value outside range of  0 to 9999999.99 for market value of land/buildings/lien for Veteran.");
                continue;
            }
            if (!AssetType.CODE_OTHER.getCode().equalsIgnoreCase(assetType)) continue;
            if (amount == null) {
                errors.reject("VOA_0214", "Missing required field: Value of other property or assets for Veteran.");
                continue;
            }
            if (amount.compareTo(MINIMUM) >= 0 && amount.compareTo(MAXIMUM) <= 0) continue;
            errors.reject("VOA_0215", "Value outside range of  0 to 9999999.99 for value of other property or assets for Veteran.");
        }
    }

    private void validateDependentFinancialInfo(DependentFinancialsInfo dependentFinancialsInfo, Errors errors) {
        if (dependentFinancialsInfo != null) {
            IncomeCollection incomeCollection;
            Boolean isLivedWithPatient;
            ExpenseCollection expenseCollection;
            Boolean isIncapableOfSelfSupport;
            DependentInfo dependentInfo = dependentFinancialsInfo.getDependentInfo();
            if (dependentInfo != null) {
                Date date;
                String relationShip;
                String lastName = dependentInfo.getFamilyName();
                if (StringUtils.isBlank((String)lastName)) {
                    errors.reject("VOA_0135", "Missing required field:  child's last name.");
                } else if (lastName.length() > 30) {
                    errors.reject("VOA_0136", "Invalid value for Child's last name.");
                }
                String firstName = dependentInfo.getGivenName();
                if (StringUtils.isBlank((String)firstName)) {
                    errors.reject("VOA_0137", "Missing required field:  Child's first name.");
                } else if (firstName.length() > 30) {
                    errors.reject("VOA_0138", "Invalid value for Child's first name.");
                }
                String middleName = dependentInfo.getMiddleName();
                if (StringUtils.isNotBlank((String)middleName) && middleName.length() > 30) {
                    errors.reject("VOA_0139", "Invalid value for Child's first name.");
                }
                if (StringUtils.isBlank((String)(relationShip = dependentInfo.getRelationship()))) {
                    errors.reject("VOA_0141", "Missing Required Field: Child's relationship to Veteran.");
                } else {
                    boolean isValid = ServiceUtils.isAlphaNumeric(relationShip);
                    if (!isValid) {
                        errors.reject("VOA_0142", "Invalid value for child's relationship to Veteran.");
                        this.logger.debug((Object)("Invalid value for child's relationship to Veteran. " + relationShip + "\n"));
                    }
                }
                SsnCollection ssnCollection = dependentInfo.getSsns();
                if (ssnCollection == null) {
                    errors.reject("VOA_0143", "Missing Required Field: Child's SSN.");
                } else {
                    List<SsnInfo> ssnInfoList = ssnCollection.getSsn();
                    if (ssnInfoList.isEmpty()) {
                        errors.reject("VOA_0143", "Missing Required Field: Child's SSN.");
                    } else {
                        for (SsnInfo ssnInfo : ssnInfoList) {
                            String ssnTxt = ssnInfo.getSsnText();
                            boolean isValid = ServiceUtils.validateSsn(ssnTxt);
                            if (isValid) continue;
                            errors.reject("VOA_0144", "Invalid Child's SSN value.");
                            break;
                        }
                    }
                }
                String startDate = dependentInfo.getStartDate();
                if (StringUtils.isBlank((String)startDate)) {
                    errors.reject("VOA_0145", "Missing Required Field: Date child became your dependent.");
                } else {
                    boolean isValidOnlyYear;
                    boolean isValid = ServiceUtils.validateDate(startDate);
                    if (isValid) {
                        try {
                            Date date2 = new SimpleDateFormat("MM/dd/yyyy", Locale.ENGLISH).parse(startDate);
                            if (new Date().before(date2)) {
                                errors.reject("VOA_0147", "Date child became dependent cannot be a future date.");
                            }
                        }
                        catch (ParseException e) {
                            this.logger.debug((Object)("cannot convert date " + startDate + " to mm/dd/yyyy format."));
                        }
                    }
                    if (isValidOnlyYear = ServiceUtils.isValidYear(startDate)) {
                        try {
                            date = new SimpleDateFormat("yyyy", Locale.ENGLISH).parse(startDate);
                            if (new Date().before(date)) {
                                errors.reject("VOA_0147", "Date child became dependent cannot be a future date.");
                            }
                        }
                        catch (ParseException e) {
                            this.logger.debug((Object)("cannot convert date " + startDate + " to yyyy format."));
                        }
                    }
                    boolean bl = isValid = isValid || isValidOnlyYear;
                    if (!isValid) {
                        errors.reject("VOA_0146", "Invalid date when child became dependent.");
                    }
                }
                String dob = dependentInfo.getDob();
                if (StringUtils.isBlank((String)dob)) {
                    errors.reject("VOA_0148", "Missing Required Field: Child's date of birth.");
                } else {
                    boolean isValidOnlyYear;
                    boolean isValid = ServiceUtils.validateDate(dob);
                    if (isValid) {
                        try {
                            date = new SimpleDateFormat("MM/dd/yyyy", Locale.ENGLISH).parse(dob);
                            if (new Date().before(date)) {
                                errors.reject("VOA_0150", "Child's date of birth cannot be a future date.");
                            }
                        }
                        catch (ParseException e) {
                            this.logger.error((Object)("cannot convert date " + dob + " to mm/dd/yyyy format."));
                        }
                    }
                    if (isValidOnlyYear = ServiceUtils.isValidYear(dob)) {
                        try {
                            Date date3 = new SimpleDateFormat("yyyy", Locale.ENGLISH).parse(dob);
                            if (new Date().before(date3)) {
                                errors.reject("VOA_0150", "Child's date of birth cannot be a future date.");
                            }
                        }
                        catch (ParseException e) {
                            this.logger.error((Object)("cannot convert date " + dob + " to yyyy format."));
                        }
                    }
                    boolean bl = isValid = isValid || isValidOnlyYear;
                    if (!isValid) {
                        errors.reject("VOA_0149", "Invalid child's date of birth.");
                    }
                }
            }
            if ((isIncapableOfSelfSupport = dependentFinancialsInfo.isIncapableOfSelfSupport()) == null) {
                errors.reject("VOA_0151", "Missing Required Field: Was child permanently and totally disabled before age of 18.");
            }
            if ((expenseCollection = dependentFinancialsInfo.getExpenses()) != null) {
                List<ExpenseInfo> expenseList = expenseCollection.getExpense();
                for (ExpenseInfo expenseInfo : expenseList) {
                    BigDecimal amount;
                    String expenseType = expenseInfo.getExpenseType();
                    if (!ExpenseType.EXPENSE_TYPE_EDUCATIONAL_EXPENSES_BY_DEPENDENT.equals((Object)expenseType) || (amount = expenseInfo.getAmount()) == null || amount.compareTo(MINIMUM) >= 0 && amount.compareTo(MAXIMUM) <= 0) continue;
                    errors.reject("VOA_0154", "Value outside range of  0 to 9999999.99 for expenses paid by child for college, vocational rehabilitation or training.");
                }
            }
            if ((isLivedWithPatient = dependentFinancialsInfo.isLivedWithPatient()) == null) {
                errors.reject("VOA_0156", "Missing Required Field: Did your child live with you last year.");
            }
            if ((incomeCollection = dependentFinancialsInfo.getIncomes()) != null) {
                List<IncomeInfo> incomeInfoList = incomeCollection.getIncome();
                for (IncomeInfo incomeInfo : incomeInfoList) {
                    this.validateDependentIncome(incomeInfo, errors);
                }
            }
            AssetCollection dependentAssetCollection = dependentFinancialsInfo.getAssets();
            this.validateDependentAsset(dependentAssetCollection, errors);
        }
    }

    private void validateDependentAsset(AssetCollection dependentAssetCollection, Errors errors) {
        if (dependentAssetCollection != null) {
            List<AssetInfo> assetInfoList = dependentAssetCollection.getAsset();
            for (AssetInfo assetInfo : assetInfoList) {
                BigDecimal amount = assetInfo.getAmount();
                String assetType = assetInfo.getAssetType();
                if (AssetType.CODE_CASH.getCode().equalsIgnoreCase(assetType)) {
                    if (amount == null) {
                        errors.reject("VOA_0202", "Missing required field: Cash, amount in back accounts for child.");
                        continue;
                    }
                    if (amount.compareTo(MINIMUM) >= 0 && amount.compareTo(MAXIMUM) <= 0) continue;
                    errors.reject("VOA_0203", "Value outside range of  0 to 9999999.99 for cash, amount in back accounts for child.");
                    continue;
                }
                if (AssetType.CODE_REAL_ESTATE.getCode().equalsIgnoreCase(assetType)) {
                    if (amount == null) {
                        errors.reject("VOA_0211", "Missing required field: Market value of land/buildings/lien for child.");
                        continue;
                    }
                    if (amount.compareTo(MINIMUM) >= 0 && amount.compareTo(MAXIMUM) <= 0) continue;
                    errors.reject("VOA_0212", "Value outside range of  0 to 9999999.99 for market value of land/buildings/lien for child.");
                    continue;
                }
                if (!AssetType.CODE_OTHER.getCode().equalsIgnoreCase(assetType)) continue;
                if (amount == null) {
                    errors.reject("VOA_0220", "Missing required field: Value of other property or assets for child.");
                    continue;
                }
                if (amount.compareTo(MINIMUM) >= 0 && amount.compareTo(MAXIMUM) <= 0) continue;
                errors.reject("VOA_0221", "Value outside range of  0 to 9999999.99 for value of other property or assets for child.");
            }
        }
    }

    private void validateSpouseFinancialInfo(SpouseFinancialsInfo spouseFinancialsInfo, Errors errors) {
        if (spouseFinancialsInfo != null) {
            IncomeCollection incomeCollection;
            SpouseInfo spouseInfo;
            Boolean isLiveWithPatient = spouseFinancialsInfo.isLivedWithPatient();
            if (isLiveWithPatient == null) {
                errors.reject("VOA_0125", "Missing Required Field: Did your child live with you last year.");
            }
            if ((spouseInfo = spouseFinancialsInfo.getSpouse()) != null) {
                ValidationUtils.invokeValidator((Validator)new SpouseInfoValidator(), (Object)spouseInfo, (Errors)errors);
                AddressInfo addressInfo = spouseInfo.getAddress();
                if (addressInfo != null) {
                    boolean isValid;
                    String city;
                    String line1 = addressInfo.getLine1();
                    if (!ServiceUtils.hasLessThan30Chars(line1)) {
                        errors.reject("VOA_0128", "Missing Required Field: Spouse street address.");
                    }
                    if (StringUtils.isBlank((String)(city = addressInfo.getCity()))) {
                        errors.reject("VOA_0129", "Missing Required Field: City for Spouse address.");
                    } else {
                        boolean isValid2 = ServiceUtils.hasLessThan30Chars(city);
                        if (!isValid2) {
                            errors.reject("VOA_0129", "Missing Required Field: City for Spouse address.");
                        }
                    }
                    String country = addressInfo.getCountry();
                    if (StringUtils.isBlank((String)country)) {
                        errors.reject("VOA_0246", "Missing required field: Country for Spouse address.");
                        this.logger.debug((Object)"Missing required field: Country for Spouse address.");
                    } else {
                        try {
                            this.getLookupService().getCountryByCode(country);
                        }
                        catch (Exception e) {
                            errors.reject("VOA_0229", "Invalid country for Spouse address.");
                            this.logger.debug((Object)("Invalid country for Spouse address. " + country + "\n" + e.getMessage()));
                        }
                        String stateProvince = null;
                        if (Country.CODE_USA.getCode().equalsIgnoreCase(country)) {
                            boolean isValid3;
                            stateProvince = addressInfo.getState();
                            String zipCode = addressInfo.getZipCode();
                            if (StringUtils.isBlank((String)zipCode)) {
                                errors.reject("VOA_0132", "Missing required field: Zip code for Spouse address.");
                            } else {
                                boolean isValid4 = ServiceUtils.validateZip(zipCode);
                                if (!isValid4) {
                                    errors.reject("VOA_0133", "Invalid Zip Code for spouse's address.");
                                }
                            }
                            String zipPlus = addressInfo.getZipPlus4();
                            if (StringUtils.isNotBlank((String)zipPlus) && !(isValid3 = ServiceUtils.validateZipPlus(zipPlus))) {
                                errors.reject("VOA_0236", "Invalid Zip Code plus 4 for spouse's address.");
                            }
                        } else if (Country.CODE_CAN.getCode().equalsIgnoreCase(country) || Country.CODE_MEX.getCode().equalsIgnoreCase(country)) {
                            stateProvince = addressInfo.getProvinceCode();
                        }
                        if (Country.CODE_USA.getCode().equalsIgnoreCase(country) || Country.CODE_CAN.getCode().equalsIgnoreCase(country) || Country.CODE_MEX.getCode().equalsIgnoreCase(country)) {
                            if (StringUtils.isBlank((String)stateProvince)) {
                                errors.reject("VOA_0130", "Missing required field: State or province for Spouse address.");
                                this.logger.debug((Object)"Missing required field: State or province for Spouse address.");
                            } else {
                                try {
                                    this.getLookupService().getStateByCode(stateProvince);
                                }
                                catch (Exception e) {
                                    errors.reject("VOA_0131", "Invalid state or province for Spouse address.");
                                    this.logger.debug((Object)("Invalid state or province for Spouse address. " + e.getMessage()));
                                }
                            }
                        }
                    }
                    String phoneNumber = addressInfo.getPhoneNumber();
                    if (StringUtils.isNotBlank((String)phoneNumber) && !(isValid = ServiceUtils.validatePhone(phoneNumber))) {
                        errors.reject("VOA_0134", "Invalid phone number for spouse.");
                    }
                }
            }
            if ((incomeCollection = spouseFinancialsInfo.getIncomes()) != null) {
                List<IncomeInfo> incomeInfoList = incomeCollection.getIncome();
                for (IncomeInfo incomeInfo : incomeInfoList) {
                    this.validateSpouseIncome(incomeInfo, errors);
                }
            }
            AssetCollection spouseAssetCollection = spouseFinancialsInfo.getAssets();
            this.validateSpouseAsset(spouseAssetCollection, errors);
        }
    }

    private void validateSpouseAsset(AssetCollection spouseAssetCollection, Errors errors) {
        if (spouseAssetCollection != null) {
            List<AssetInfo> assetInfoList = spouseAssetCollection.getAsset();
            for (AssetInfo assetInfo : assetInfoList) {
                BigDecimal amount = assetInfo.getAmount();
                String assetType = assetInfo.getAssetType();
                if (AssetType.CODE_CASH.getCode().equalsIgnoreCase(assetType)) {
                    if (amount == null) {
                        errors.reject("VOA_0199", "Missing required field: Cash, amount in back accounts for spouse.");
                        continue;
                    }
                    if (amount.compareTo(MINIMUM) >= 0 && amount.compareTo(MAXIMUM) <= 0) continue;
                    errors.reject("VOA_0200", "Value outside range of  0 to 9999999.99 for cash, amount in back accounts for spouse.");
                    continue;
                }
                if (AssetType.CODE_REAL_ESTATE.getCode().equalsIgnoreCase(assetType)) {
                    if (amount == null) {
                        errors.reject("VOA_0208", "Missing required field: Market value of land/buildings/lien for spouse.");
                        continue;
                    }
                    if (amount.compareTo(MINIMUM) >= 0 && amount.compareTo(MAXIMUM) <= 0) continue;
                    errors.reject("VOA_0209", "Value outside range of  0 to 9999999.99 for market value of land/buildings/lien for spouse.");
                    continue;
                }
                if (!AssetType.CODE_OTHER.getCode().equalsIgnoreCase(assetType)) continue;
                if (amount == null) {
                    errors.reject("VOA_0217", "Missing required field:  Value of other property or assets for spouse.");
                    continue;
                }
                if (amount.compareTo(MINIMUM) >= 0 && amount.compareTo(MAXIMUM) <= 0) continue;
                errors.reject("VOA_0218", "Value outside range of  0 to 9999999.99 for  value of other property or assets for spouse.");
            }
        }
    }

    private void validateVeteranIncome(IncomeInfo incomeInfo, Errors errors) {
        if (incomeInfo != null) {
            String incomeType = incomeInfo.getType();
            BigDecimal amount = incomeInfo.getAmount();
            if (IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT.getCode().equalsIgnoreCase(incomeType)) {
                if (amount == null) {
                    errors.reject("VOA_0160", "Missing required Field: Gross annual income from employment for Veteran.");
                } else if (amount.compareTo(MINIMUM) < 0 || amount.compareTo(MAXIMUM) > 0) {
                    errors.reject("VOA_0161", "Value outside range of  0 to 9999999.99 for net income from property or business for Veteran.");
                }
            } else if (IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME.getCode().equalsIgnoreCase(incomeType)) {
                if (amount == null) {
                    errors.reject("VOA_0169", "Missing Required Field: Gross annual income from employment for Veteran.");
                } else if (amount.compareTo(MINIMUM) < 0 || amount.compareTo(MAXIMUM) > 0) {
                    errors.reject("VOA_0170", "Value outside range of  0 to 9999999.99 for gross annual income from employment for Veteran.");
                }
            } else if (IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME.getCode().equalsIgnoreCase(incomeType)) {
                if (amount == null) {
                    errors.reject("VOA_0178", "Missing Required Field: List other income amounts for Veteran.");
                } else if (amount.compareTo(MINIMUM) < 0 || amount.compareTo(MAXIMUM) > 0) {
                    errors.reject("VOA_0179", "Value outside range of  0 to 9999999.99 for list other income amounts for Veteran.");
                }
            }
        }
    }

    private void validateSpouseIncome(IncomeInfo incomeInfo, Errors errors) {
        if (incomeInfo != null) {
            String incomeType = incomeInfo.getType();
            BigDecimal amount = incomeInfo.getAmount();
            if (IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT.getCode().equalsIgnoreCase(incomeType)) {
                if (amount == null) {
                    errors.reject("VOA_0163", "Missing Required Field: Gross annual income from employment for spouse.");
                } else if (amount.compareTo(MINIMUM) < 0 || amount.compareTo(MAXIMUM) > 0) {
                    errors.reject("VOA_0164", "Value outside range of  0 to 9999999.99 for gross annual income from employment for spouse.");
                }
            } else if (IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME.getCode().equalsIgnoreCase(incomeType)) {
                if (amount == null) {
                    errors.reject("VOA_0172", "Missing Required Field: Net income from property or business for spouse.");
                } else if (amount.compareTo(MINIMUM) < 0 || amount.compareTo(MAXIMUM) > 0) {
                    errors.reject("VOA_0173", "Value outside range of  0 to 9999999.99 for net income from property or business for spouse.");
                }
            } else if (IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME.getCode().equalsIgnoreCase(incomeType)) {
                if (amount == null) {
                    errors.reject("VOA_0181", "Missing Required Field:  List other income amounts for spouse.");
                } else if (amount.compareTo(MINIMUM) < 0 || amount.compareTo(MAXIMUM) > 0) {
                    errors.reject("VOA_0182", "Value outside range of  0 to 9999999.99 for list other income amounts for spouse.");
                }
            }
        }
    }

    private void validateDependentIncome(IncomeInfo incomeInfo, Errors errors) {
        if (incomeInfo != null) {
            String incomeType = incomeInfo.getType();
            BigDecimal amount = incomeInfo.getAmount();
            if (IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT.getCode().equalsIgnoreCase(incomeType)) {
                if (amount == null) {
                    errors.reject("VOA_0166", "Missing Required Field: Gross annual income from employment for child.");
                } else if (amount.compareTo(MINIMUM) < 0 || amount.compareTo(MAXIMUM) > 0) {
                    errors.reject("VOA_0167", "Value outside range of  0 to 9999999.99 for gross annual income from employment for child.");
                }
            } else if (IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME.getCode().equalsIgnoreCase(incomeType)) {
                if (amount == null) {
                    errors.reject("VOA_0175", "Missing Required Field: Net income from property or business for child.");
                } else if (amount.compareTo(MINIMUM) < 0 || amount.compareTo(MAXIMUM) > 0) {
                    errors.reject("VOA_0176", "Value outside range of  0 to 9999999.99 for  net income from property or business for child.");
                }
            } else if (IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME.getCode().equalsIgnoreCase(incomeType)) {
                if (amount == null) {
                    errors.reject("VOA_0184", "Missing Required Field: List other income amounts for child.");
                } else if (amount.compareTo(MINIMUM) < 0 || amount.compareTo(MAXIMUM) > 0) {
                    errors.reject("VOA_0185", "Value outside range of  0 to 9999999.99 for list other income amounts for child.");
                }
            }
        }
    }
}

