/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.voa.validator;

import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.lookup.EmploymentStatus;
import gov.va.med.esr.voa.util.ServiceUtils;
import gov.va.med.esr.voa.validator.AbstractValidator;
import gov.va.med.esr.voa.webservice.AddressInfo;
import gov.va.med.esr.voa.webservice.EmploymentInfo;
import gov.va.med.fw.util.StringUtils;
import org.springframework.validation.Errors;

public class EmploymentInfoValidator
extends AbstractValidator {
    public boolean supports(Class clazz) {
        return EmploymentInfo.class.equals((Object)clazz);
    }

    public void validate(Object target, Errors errors) {
        this.logger.debug((Object)"EmploymentInfo validation...");
        if (target != null) {
            EmploymentInfo employmentInfo = (EmploymentInfo)target;
            String employmentStatus = employmentInfo.getEmploymentStatus();
            if (StringUtils.isBlank((String)employmentStatus)) {
                if (!this.isNewOMBApprovedForm) {
                    errors.reject("VOA_0076", "Missing Required Field:  Veteran's employment status.");
                }
            } else {
                try {
                    this.getLookupService().getEmploymentStatusByCode(employmentStatus);
                }
                catch (Exception e) {
                    errors.reject("VOA_0077", "Invalid employment status.");
                    this.logger.debug((Object)("Invalid employment status. status = " + employmentStatus + "\n" + e.getMessage()));
                }
            }
            if (EmploymentStatus.CODE_RETIRED.getCode().equalsIgnoreCase(employmentStatus)) {
                String retirementDate = employmentInfo.getRetirementDate();
                if (StringUtils.isBlank((String)retirementDate)) {
                    errors.reject("VOA_0078", "Missing required field: Veteran date of retirement.");
                } else {
                    boolean isValidDate = ServiceUtils.validateDate(retirementDate);
                    boolean isValidYear = ServiceUtils.isValidYear(retirementDate);
                    if (isValidDate || isValidYear) {
                        boolean isFutureDate = false;
                        if (isValidDate) {
                            isFutureDate = ServiceUtils.isFutureDate(retirementDate);
                        } else if (isValidYear) {
                            isFutureDate = ServiceUtils.isFutureYear(retirementDate);
                        }
                        if (isFutureDate) {
                            errors.reject("VOA_0079", "Invalid date of retirement for Veteran.");
                            this.logger.debug((Object)"Invalid date of retirement for Veteran.");
                        }
                    } else {
                        errors.reject("VOA_0079", "Invalid date of retirement for Veteran.");
                        this.logger.debug((Object)"Invalid date of retirement for Veteran.");
                    }
                }
            } else if (EmploymentStatus.CODE_FULL_TIME.getCode().equalsIgnoreCase(employmentStatus) || EmploymentStatus.CODE_PART_TIME.getCode().equalsIgnoreCase(employmentStatus)) {
                boolean isValid;
                AddressInfo addressInfo;
                String employerName = employmentInfo.getEmployerName();
                if (StringUtils.isBlank((String)employerName)) {
                    errors.reject("VOA_0080", "Missing required field: Name of Veteran's employer.");
                }
                if ((addressInfo = employmentInfo.getEmployerAddress()) == null) {
                    errors.reject("VOA_0081", "Missing required field: Address of Veteran's employer.");
                } else {
                    String country;
                    String line1 = addressInfo.getLine1();
                    if (StringUtils.isBlank((String)line1)) {
                        errors.reject("VOA_0081", "Missing required field: Address of Veteran's employer");
                    } else if (line1.length() > 30) {
                        errors.reject("VOA_0082", "Invalid street address for Veteran\u2019s employer");
                    }
                    String city = addressInfo.getCity();
                    if (StringUtils.isBlank((String)city)) {
                        errors.reject("VOA_0083", "Missing required field: City of Veteran's employer.");
                    }
                    if (StringUtils.isBlank((String)(country = addressInfo.getCountry()))) {
                        errors.reject("VOA_0244", "Missing required field: Country for Veteran's employer.");
                        this.logger.debug((Object)"Missing required field: Country for Veteran's employer.");
                    } else {
                        try {
                            this.getLookupService().getCountryByCode(country);
                        }
                        catch (Exception e) {
                            errors.reject("VOA_0228", "Invalid country for Veteran's employer.");
                            this.logger.debug((Object)("Invalid country for Veteran's employer. " + country + "\n" + e.getMessage()));
                        }
                        String stateProvince = null;
                        if (Country.CODE_USA.getCode().equalsIgnoreCase(country)) {
                            boolean isValid2;
                            stateProvince = addressInfo.getState();
                            String zipCode = addressInfo.getZipCode();
                            if (StringUtils.isBlank((String)zipCode)) {
                                errors.reject("VOA_0086", "Missing required field: Zip Code of Veteran's employer.");
                            } else {
                                boolean isValid3 = ServiceUtils.validateZip(zipCode);
                                if (!isValid3) {
                                    errors.reject("VOA_0087", "Invalid zip code for Veteran's employer.");
                                }
                            }
                            String zipPlus = addressInfo.getZipPlus4();
                            if (StringUtils.isNotBlank((String)zipPlus) && !(isValid2 = ServiceUtils.validateZipPlus(zipPlus))) {
                                errors.reject("VOA_0234", "Invalid zip code plus 4 for Veteran's employer.");
                            }
                        } else if (Country.CODE_CAN.getCode().equalsIgnoreCase(country) || Country.CODE_MEX.getCode().equalsIgnoreCase(country)) {
                            stateProvince = addressInfo.getProvinceCode();
                        }
                        if (Country.CODE_USA.getCode().equalsIgnoreCase(country) || Country.CODE_CAN.getCode().equalsIgnoreCase(country) || Country.CODE_MEX.getCode().equalsIgnoreCase(country)) {
                            if (StringUtils.isBlank((String)stateProvince)) {
                                errors.reject("VOA_0084", "Missing required field: State or province for Veteran's employer.");
                                this.logger.debug((Object)"Missing required field: State or province for Veteran's employer. ");
                            } else {
                                try {
                                    this.getLookupService().getStateByCode(stateProvince);
                                }
                                catch (Exception e) {
                                    errors.reject("VOA_0085", "Invalid state or province for Veteran's employer.");
                                    this.logger.debug((Object)("Invalid state or province for Veteran's employer. " + e.getMessage()));
                                }
                            }
                        }
                    }
                }
                String phoneNumber = employmentInfo.getEmployerPhone();
                if (StringUtils.isNotBlank((String)phoneNumber) && !(isValid = ServiceUtils.validatePhoneWithExtension(phoneNumber))) {
                    errors.reject("VOA_0088", "Invalid phone number for  Veteran's employer.");
                }
            }
        }
        this.logger.debug((Object)"EmploymentInfo validation - Done.");
    }
}

