/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.voa.validator;

import gov.va.med.esr.voa.webservice.EmailInfo;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class EmailInfoValidator
extends AbstractComponent
implements Validator {
    private static final Pattern pattern = Pattern.compile("^([0-9a-zA-Z]([-\\.\\w]*[0-9a-zA-Z])*@([0-9a-zA-Z][-\\w]*[0-9a-zA-Z]\\.)+[a-zA-Z]{2,9})$");

    public boolean supports(Class clazz) {
        return EmailInfo.class.equals((Object)clazz);
    }

    public void validate(Object target, Errors errors) {
        EmailInfo emailInfo;
        String emailAddress;
        this.logger.debug((Object)"start email address validation...");
        if (target != null && StringUtils.isNotBlank((String)(emailAddress = (emailInfo = (EmailInfo)target).getAddress()))) {
            Matcher matcher = pattern.matcher(emailAddress);
            boolean matchFound = matcher.matches();
            if (!matchFound) {
                errors.reject("VOA_0036", "Invalid Veteran email address.");
                this.logger.debug((Object)("email address " + emailAddress + " is not valid."));
            } else {
                int numberOfChars = emailAddress.length();
                if (numberOfChars < 3 || numberOfChars > 50) {
                    errors.reject("VOA_0036", "Invalid Veteran email address.");
                    this.logger.debug((Object)("email address " + emailAddress + " has less than 3 digits."));
                }
            }
        }
        this.logger.debug((Object)"end email address validation.");
    }
}

