/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.voa.validator;

import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.voa.util.ServiceUtils;
import gov.va.med.esr.voa.validator.AbstractValidator;
import gov.va.med.esr.voa.validator.EmailInfoValidator;
import gov.va.med.esr.voa.validator.PhoneInfoValidator;
import gov.va.med.esr.voa.webservice.AddressCollection;
import gov.va.med.esr.voa.webservice.AddressInfo;
import gov.va.med.esr.voa.webservice.ContactInfo;
import gov.va.med.esr.voa.webservice.DemographicInfo;
import gov.va.med.esr.voa.webservice.EmailCollection;
import gov.va.med.esr.voa.webservice.EmailInfo;
import gov.va.med.esr.voa.webservice.PhoneCollection;
import gov.va.med.esr.voa.webservice.PhoneInfo;
import gov.va.med.fw.util.StringUtils;
import java.util.List;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public class DemographicInfoValidator
extends AbstractValidator {
    public boolean supports(Class clazz) {
        return DemographicInfo.class.equals((Object)clazz);
    }

    public void validate(Object target, Errors errors) {
        this.logger.debug((Object)"Validate Demographic information.");
        if (target != null) {
            DemographicInfo demographicInfo = (DemographicInfo)target;
            String maritalStatus = demographicInfo.getMaritalStatus();
            if (StringUtils.isBlank((String)maritalStatus)) {
                errors.reject("VOA_0016", "Missing Required Field.");
            } else {
                try {
                    this.getLookupService().getMaritalStatusByCode(maritalStatus);
                }
                catch (Exception e) {
                    errors.reject("VOA_0017", "Invalid Marital Status.");
                    this.logger.debug((Object)("Cannot find marital status. " + e.getMessage()));
                }
            }
            String preferredFacility = demographicInfo.getPreferredFacility();
            if (StringUtils.isBlank((String)preferredFacility)) {
                errors.reject("VOA_0020", "Missing Required Field: Preferred VA Facility.");
            } else {
                try {
                    this.getLookupService().getVaFacilityByCode(preferredFacility);
                }
                catch (Exception e) {
                    errors.reject("VOA_0021", "Invalid VA Facility.");
                    this.logger.debug((Object)("Invalid VA Facility. " + preferredFacility + "\n" + e.getMessage()));
                }
            }
            String ethnicityCode = demographicInfo.getEthnicity();
            try {
                this.getLookupService().getEthnicityTypeByCode(ethnicityCode);
            }
            catch (Exception e) {
                errors.reject("VOA_0022", "Not a valid reference value.");
                this.logger.debug((Object)("Not a valid reference value. " + e.getMessage()));
            }
            String religion = demographicInfo.getReligion();
            try {
                this.getLookupService().getReligionByCode(religion);
            }
            catch (Exception e) {
                errors.reject("VOA_0029", "Invalid religion.");
                this.logger.debug((Object)("Not a valid reference value. " + e.getMessage()));
            }
            ContactInfo contactInfo = demographicInfo.getContactInfo();
            if (contactInfo != null) {
                PhoneCollection phoneCollection;
                EmailCollection emailCollection;
                AddressCollection addressCollection = contactInfo.getAddresses();
                if (addressCollection != null) {
                    List<AddressInfo> addressInfoList = addressCollection.getAddress();
                    for (AddressInfo addressInfo : addressInfoList) {
                        this.validateAddress(addressInfo, errors);
                    }
                }
                if ((emailCollection = contactInfo.getEmails()) != null) {
                    List<EmailInfo> emailInfoList = emailCollection.getEmail();
                    for (EmailInfo emailInfo : emailInfoList) {
                        ValidationUtils.invokeValidator((Validator)new EmailInfoValidator(), (Object)emailInfo, (Errors)errors);
                    }
                }
                if ((phoneCollection = contactInfo.getPhones()) != null) {
                    List<PhoneInfo> phoneInfoList = phoneCollection.getPhone();
                    for (PhoneInfo phoneInfo : phoneInfoList) {
                        ValidationUtils.invokeValidator((Validator)new PhoneInfoValidator(), (Object)phoneInfo, (Errors)errors);
                    }
                }
            }
            if (demographicInfo.isAcaIndicator() == null) {
                errors.reject("VOA_0252", "Missing required field: COVERAGE UNDER THE AFFORDABLE CARE ACT");
            }
        }
        this.logger.debug((Object)"Validate Demographic information - Done.");
    }

    private void validateAddress(AddressInfo addressInfo, Errors errors) {
        this.logger.debug((Object)"AddressInfo validation...");
        if (addressInfo != null) {
            String country;
            String city;
            String line1 = addressInfo.getLine1();
            if (StringUtils.isBlank((String)line1)) {
                errors.reject("VOA_0030", "Missing required Field:  Street for Veteran Permanent Address.");
            }
            if (StringUtils.isBlank((String)(city = addressInfo.getCity()))) {
                errors.reject("VOA_0031", "Missing required Field:  City for Veteran Permanent Address.");
            }
            if (StringUtils.isBlank((String)(country = addressInfo.getCountry()))) {
                errors.reject("VOA_0240", "Missing required Field: Country for Veteran Permanent Address.");
                this.logger.debug((Object)"Missing required Field: Country for Veteran Permanent Address.");
            } else {
                try {
                    this.getLookupService().getCountryByCode(country);
                }
                catch (Exception e) {
                    errors.reject("VOA_0223", "Invalid country for Veteran Permanent Address.");
                    this.logger.debug((Object)("Invalid country for Veteran Permanent Address. " + e.getMessage()));
                }
                String stateProvince = null;
                if (Country.CODE_USA.getCode().equalsIgnoreCase(country)) {
                    boolean isValid;
                    stateProvince = addressInfo.getState();
                    String zip = addressInfo.getZipCode();
                    if (StringUtils.isBlank((String)zip)) {
                        errors.reject("VOA_0034", "Missing Required Field: Veteran Permanent Address Zip Code.");
                    } else {
                        boolean isValid2 = ServiceUtils.validateZip(zip);
                        if (!isValid2) {
                            errors.reject("VOA_0035", "Invalid Zip Code for  Veteran Permanent Address.");
                        }
                    }
                    String zipPlus = addressInfo.getZipPlus4();
                    if (StringUtils.isNotBlank((String)zipPlus) && !(isValid = ServiceUtils.validateZipPlus(zipPlus))) {
                        errors.reject("VOA_0230", "Invalid Zip Code plus 4 for  Veteran Permanent Address.");
                    }
                } else if (Country.CODE_CAN.getCode().equalsIgnoreCase(country) || Country.CODE_MEX.getCode().equalsIgnoreCase(country)) {
                    stateProvince = addressInfo.getProvinceCode();
                }
                if (Country.CODE_USA.getCode().equalsIgnoreCase(country) || Country.CODE_CAN.getCode().equalsIgnoreCase(country) || Country.CODE_MEX.getCode().equalsIgnoreCase(country)) {
                    if (StringUtils.isBlank((String)stateProvince)) {
                        errors.reject("VOA_0032", "Missing required Field: State or Province for Veteran Permanent Address.");
                    } else {
                        try {
                            this.getLookupService().getStateByCode(stateProvince);
                        }
                        catch (Exception e) {
                            errors.reject("VOA_0033", "Invalid State or Province for Veteran Permanent Address.");
                            this.logger.debug((Object)("Invalid State or Province for Veteran Permanent Address. " + stateProvince + " " + e.getMessage()));
                        }
                    }
                }
            }
        }
        this.logger.debug((Object)"AddressInfo validation - Done.");
    }
}

