/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.voa.validator;

import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.voa.util.ServiceUtils;
import gov.va.med.esr.voa.validator.AbstractValidator;
import gov.va.med.esr.voa.webservice.AssociationInfo;
import gov.va.med.esr.voa.webservice.BaseAddressInfo;
import gov.va.med.fw.util.StringUtils;
import org.springframework.validation.Errors;

public class AssociationInfoValidator
extends AbstractValidator {
    private static final int LIMIT_LESS_THAN_30_CHARS = 30;

    public boolean supports(Class clazz) {
        return AssociationInfo.class.equals((Object)clazz);
    }

    public void validate(Object target, Errors errors) {
        this.logger.debug((Object)"Association info validation...");
        AssociationInfo associationInfo = (AssociationInfo)target;
        if (associationInfo != null) {
            String contactType = associationInfo.getContactType();
            String familyName = associationInfo.getFamilyName();
            String givenName = associationInfo.getGivenName();
            String phoneNumber = associationInfo.getPrimaryPhone();
            String alternatePhone = associationInfo.getAlternatePhone();
            BaseAddressInfo addressInfo = associationInfo.getAddress();
            if (AssociationType.CODE_EMERGENCY_CONTACT.getCode().equalsIgnoreCase(contactType)) {
                boolean isValid;
                String relationShip;
                if (!this.isNewOMBApprovedForm && StringUtils.isBlank((String)familyName)) {
                    errors.reject("VOA_0049", "Missing Required Field: Emergency contact last name.");
                }
                if (!this.isNewOMBApprovedForm && StringUtils.isBlank((String)givenName)) {
                    errors.reject("VOA_0050", "Missing Required Field: Emergency contact first name.");
                }
                if (addressInfo != null) {
                    String line1 = addressInfo.getLine1();
                    String city = addressInfo.getCity();
                    String state = addressInfo.getState();
                    String provinceCode = addressInfo.getProvinceCode();
                    String zip = addressInfo.getZipCode();
                    String zipPlus = addressInfo.getZipPlus4();
                    String country = addressInfo.getCountry();
                    if (StringUtils.isNotBlank((String)line1) && line1.length() > 30) {
                        errors.reject("VOA_0051", "Invalid street address for Veteran's emergency contact.");
                    }
                    if (StringUtils.isNotBlank((String)city) && city.length() > 30) {
                        errors.reject("VOA_0052", "Invalid City  for Veteran's emergency contact address.");
                    }
                    if (StringUtils.isBlank((String)country)) {
                        errors.reject("VOA_0242", "Missing required Field:  Country for Emergency contact address.");
                        this.logger.debug((Object)"Missing required Field:  Country for Emergency contact address.");
                    } else {
                        try {
                            this.getLookupService().getCountryByCode(country);
                        }
                        catch (Exception e) {
                            errors.reject("VOA_0225", "Invalid country for Emergency contact address.");
                            this.logger.debug((Object)("Invalid country for Emergency contact address. " + country + "\n" + e.getMessage()));
                        }
                        String stateProvince = null;
                        if (Country.CODE_USA.getCode().equalsIgnoreCase(country)) {
                            boolean isValid2;
                            stateProvince = state;
                            if (StringUtils.isNotBlank((String)zip) && !(isValid2 = ServiceUtils.validateZip(zip))) {
                                errors.reject("VOA_0054", "Invalid Zip Code for emergency contact address.");
                            }
                            if (StringUtils.isNotBlank((String)zipPlus) && !(isValid2 = ServiceUtils.validateZipPlus(zipPlus))) {
                                errors.reject("VOA_0232", "Invalid Zip Code for emergency contact address.");
                            }
                        } else if (Country.CODE_CAN.getCode().equalsIgnoreCase(country) || Country.CODE_MEX.getCode().equalsIgnoreCase(country)) {
                            stateProvince = provinceCode;
                        }
                        if ((Country.CODE_USA.getCode().equalsIgnoreCase(country) || Country.CODE_CAN.getCode().equalsIgnoreCase(country) || Country.CODE_MEX.getCode().equalsIgnoreCase(country)) && StringUtils.isNotBlank((String)stateProvince)) {
                            try {
                                this.getLookupService().getStateByCode(stateProvince);
                            }
                            catch (Exception e) {
                                errors.reject("VOA_0053", "Invalid State or Province for Emergency contact address.");
                                this.logger.debug((Object)("Invalid State or Province for Emergency contact address. " + stateProvince + "\n" + e.getMessage()));
                            }
                        }
                    }
                }
                if (StringUtils.isBlank((String)(relationShip = associationInfo.getRelationship()))) {
                    if (!this.isNewOMBApprovedForm) {
                        errors.reject("VOA_0055", "Missing Required Field:  Relationship for emergency contact.");
                    }
                } else {
                    boolean isValid3 = ServiceUtils.isAlphaNumeric(relationShip);
                    if (!isValid3) {
                        errors.reject("VOA_0222", "Invalid relationship value for Emergency Contact.");
                        this.logger.debug((Object)("Invalid relationship value for Emergency Contact. " + relationShip + "\n"));
                    }
                }
                if (phoneNumber != null && !(isValid = ServiceUtils.validatePhone(phoneNumber))) {
                    errors.reject("VOA_0056", "Invalid home telephone number for emergency contact.");
                }
                if (StringUtils.isNotBlank((String)alternatePhone) && !(isValid = ServiceUtils.validatePhoneWithExtension(alternatePhone))) {
                    errors.reject("VOA_0057", "Invalid work telephone number for emergency contact.");
                }
            } else if (AssociationType.CODE_PRIMARY_NEXT_OF_KIN.getCode().equalsIgnoreCase(contactType)) {
                boolean isValid;
                String relationShip;
                if (!this.isNewOMBApprovedForm && StringUtils.isBlank((String)familyName)) {
                    errors.reject("VOA_0039", "Missing Required Field:  Next of kin last name.");
                }
                if (!this.isNewOMBApprovedForm && StringUtils.isBlank((String)givenName)) {
                    errors.reject("VOA_0040", "Missing Required Field: Next of kin first name.");
                }
                if (addressInfo != null) {
                    String line1 = addressInfo.getLine1();
                    String city = addressInfo.getCity();
                    String state = addressInfo.getState();
                    String provinceCode = addressInfo.getProvinceCode();
                    String zip = addressInfo.getZipCode();
                    String zipPlus = addressInfo.getZipPlus4();
                    String country = addressInfo.getCountry();
                    if (StringUtils.isNotBlank((String)line1) && line1.length() > 30) {
                        errors.reject("VOA_0041", "Invalid street address for next of kin.");
                    }
                    if (StringUtils.isNotBlank((String)city) && city.length() > 30) {
                        errors.reject("VOA_0042", "Invalid City for next of kin address.");
                    }
                    if (StringUtils.isBlank((String)country)) {
                        errors.reject("VOA_0241", "Missing required Field: Country Next of Kin.");
                        this.logger.debug((Object)"Missing required Field: Country Next of Kin.");
                    } else {
                        try {
                            this.getLookupService().getCountryByCode(country);
                        }
                        catch (Exception e) {
                            errors.reject("VOA_0224", "Invalid country for Next of Kin address.");
                            this.logger.debug((Object)("Invalid country for Next of Kin address. " + country + "\n" + e.getMessage()));
                        }
                        String stateProvince = null;
                        if (Country.CODE_USA.getCode().equalsIgnoreCase(country)) {
                            boolean isValid4;
                            stateProvince = state;
                            if (StringUtils.isNotBlank((String)zip) && !(isValid4 = ServiceUtils.validateZip(zip))) {
                                errors.reject("VOA_0044", "Invalid Zip Code for next of kin Address.");
                            }
                            if (StringUtils.isNotBlank((String)zipPlus) && !(isValid4 = ServiceUtils.validateZipPlus(zipPlus))) {
                                errors.reject("VOA_0231", "Invalid Zip Code plus 4 for next of kin Address.");
                            }
                        } else if (Country.CODE_CAN.getCode().equalsIgnoreCase(country) || Country.CODE_MEX.getCode().equalsIgnoreCase(country)) {
                            stateProvince = provinceCode;
                        }
                        if ((Country.CODE_USA.getCode().equalsIgnoreCase(country) || Country.CODE_CAN.getCode().equalsIgnoreCase(country) || Country.CODE_MEX.getCode().equalsIgnoreCase(country)) && StringUtils.isNotBlank((String)stateProvince)) {
                            try {
                                this.getLookupService().getStateByCode(stateProvince);
                            }
                            catch (Exception e) {
                                errors.reject("VOA_0043", "Invalid State or Province for Next of Kin state.");
                                this.logger.debug((Object)("Invalid State or Province for Next of Kin state. " + stateProvince + "\n" + e.getMessage()));
                            }
                        }
                    }
                }
                if (StringUtils.isBlank((String)(relationShip = associationInfo.getRelationship()))) {
                    if (!this.isNewOMBApprovedForm) {
                        errors.reject("VOA_0045", "Missing Required Field: Relationship to veteran of next of kin.");
                    }
                } else {
                    boolean isValid5 = ServiceUtils.isAlphaNumeric(relationShip);
                    if (!isValid5) {
                        errors.reject("VOA_0046", "Invalid relationship type for next of kin.");
                        this.logger.debug((Object)("Invalid relationship type for next of kin. " + relationShip + "\n"));
                    }
                }
                if (phoneNumber != null && !(isValid = ServiceUtils.validatePhone(phoneNumber))) {
                    errors.reject("VOA_0047", "Invalid next of kin home telephone number.");
                }
                if (alternatePhone != null && !(isValid = ServiceUtils.validatePhoneWithExtension(alternatePhone))) {
                    errors.reject("VOA_0048", "Invalid next of kin work telephone number.");
                }
            }
        }
        this.logger.debug((Object)"Association info validation - Done.");
    }
}

