/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.voa.util;

import gov.va.med.fw.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class ServiceUtils {
    public static final String PATTERN_ALPHA_NUMERIC = "^\\w+$";
    public static final String PATTERN_LESS_THAN_10_DIGITS = "^\\d{1,10}$";
    public static final String PATTERN_ZIP = "^\\d{5}$";
    public static final String PATTERN_ZIP_PLUS = "^\\d{4}$";
    public static final String PATTERN_SSN = "^\\d{9}$";
    public static final String PATTERN_PHONE = "^\\d{10}$";
    public static final String PATTERN_PHONE_WITH_EXT = "^\\d{10}[0-9a-zA-Z-]{0,5}$";
    public static final String PATTERN_MM_DD_YYYY_FORMAT = "^(0[1-9]|1[012])[- /.](0[1-9]|[12][0-9]|3[01])[- /.](19|20)\\d\\d$";
    public static final String PATTERN_MM_YYYY_FORMAT = "^(0[1-9]|1[012])[- /.](19|20)\\d\\d$";
    public static final String PATTERN_YYYY_FORMAT = "^((19|20)\\d\\d)$";
    public static final int LIMIT_LESS_THAN_35_CHARS = 35;
    public static final int LIMIT_LESS_THAN_30_CHARS = 30;
    public static final int LIMIT_LESS_THAN_25_CHARS = 25;
    public static final int LIMIT_LESS_THAN_10_CHARS = 10;

    public static boolean isAlphaNumeric(String input) {
        boolean isValid = false;
        if (StringUtils.isNotBlank((String)input)) {
            isValid = StringUtils.validateEntry((String)input, (String)PATTERN_ALPHA_NUMERIC);
        }
        return isValid;
    }

    public static boolean validatePhone(String phoneNumber) {
        boolean isValid = false;
        if (StringUtils.isNotBlank((String)phoneNumber)) {
            isValid = StringUtils.validateEntry((String)phoneNumber, (String)PATTERN_PHONE);
        }
        return isValid;
    }

    public static boolean validatePhoneWithExtension(String phoneNumber) {
        boolean isValid = false;
        if (StringUtils.isNotBlank((String)phoneNumber)) {
            isValid = StringUtils.validateEntry((String)phoneNumber, (String)PATTERN_PHONE_WITH_EXT);
        }
        return isValid;
    }

    public static boolean hasLessThan10Digits(String input) {
        boolean isValid = false;
        if (StringUtils.isNotBlank((String)input)) {
            isValid = StringUtils.validateEntry((String)input, (String)PATTERN_LESS_THAN_10_DIGITS);
        }
        return isValid;
    }

    public static boolean validateSsn(String ssn) {
        boolean isValid = false;
        if (StringUtils.isNotBlank((String)ssn)) {
            isValid = StringUtils.validateEntry((String)ssn, (String)PATTERN_SSN);
        }
        return isValid;
    }

    public static boolean validateZip(String zipCode) {
        boolean isValid = false;
        if (StringUtils.isNotBlank((String)zipCode)) {
            isValid = StringUtils.validateEntry((String)zipCode, (String)PATTERN_ZIP);
        }
        return isValid;
    }

    public static boolean validateZipPlus(String zipPlus) {
        boolean isValid = false;
        if (StringUtils.isNotBlank((String)zipPlus)) {
            isValid = StringUtils.validateEntry((String)zipPlus, (String)PATTERN_ZIP_PLUS);
        }
        return isValid;
    }

    public static boolean validateDate(String dateStr) {
        boolean isValid = false;
        if (StringUtils.isNotBlank((String)dateStr)) {
            isValid = StringUtils.validateEntry((String)dateStr, (String)PATTERN_MM_DD_YYYY_FORMAT);
        }
        return isValid;
    }

    public static boolean isValidMonthYear(String dateStr) {
        boolean isValid = false;
        if (StringUtils.isNotBlank((String)dateStr)) {
            isValid = StringUtils.validateEntry((String)dateStr, (String)PATTERN_MM_YYYY_FORMAT);
        }
        return isValid;
    }

    public static boolean isValidYear(String dateStr) {
        boolean isValid = false;
        if (StringUtils.isNotBlank((String)dateStr)) {
            isValid = StringUtils.validateEntry((String)dateStr, (String)PATTERN_YYYY_FORMAT);
        }
        return isValid;
    }

    public static boolean hasLessThan10Chars(String input) {
        return StringUtils.isNotBlank((String)input) && input.length() <= 10;
    }

    public static boolean hasLessThan25Chars(String input) {
        return StringUtils.isNotBlank((String)input) && input.length() <= 25;
    }

    public static boolean hasLessThan30Chars(String input) {
        return StringUtils.isNotBlank((String)input) && input.length() <= 30;
    }

    public static boolean hasLessThan35Chars(String input) {
        return StringUtils.isNotBlank((String)input) && input.length() <= 35;
    }

    public static boolean isFutureDate(String input) {
        boolean result = false;
        boolean isValid = ServiceUtils.validateDate(input);
        if (isValid) {
            try {
                Date date = new SimpleDateFormat("MM/dd/yyyy", Locale.ENGLISH).parse(input);
                if (new Date().before(date)) {
                    result = true;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean isFutureMonthYear(String input) {
        boolean result = false;
        if (StringUtils.isNotBlank((String)input)) {
            try {
                Date date = new SimpleDateFormat("mm/yyyy", Locale.ENGLISH).parse(input);
                GregorianCalendar current = new GregorianCalendar();
                int currentYear = current.get(1);
                int currentMonth = current.get(2);
                GregorianCalendar inputDate = new GregorianCalendar();
                inputDate.setTime(date);
                int inputYear = inputDate.get(1);
                int inputMonth = inputDate.get(2);
                if (currentYear < inputYear) {
                    result = true;
                } else if (currentYear == inputYear && currentMonth < inputMonth) {
                    result = true;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean isFutureYear(String input) {
        boolean result = false;
        if (StringUtils.isNotBlank((String)input)) {
            try {
                Date date = new SimpleDateFormat("yyyy", Locale.ENGLISH).parse(input);
                int currentYear = new GregorianCalendar().get(1);
                GregorianCalendar inputDate = new GregorianCalendar();
                inputDate.setTime(date);
                int inputYear = inputDate.get(1);
                if (currentYear < inputYear) {
                    result = true;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }
}

