unit uGN_Utils;
interface
uses
  ORFn
  , rGN_Core
  , Windows
  , Controls
  , ExtCtrls
  , Buttons
  , ComCtrls
  , uCore
  , uTIU
  , Forms
  ;
type
  TViewMode = (vmParentedForm, vmDialog, vmConfirmationDlg);

procedure MenuItemMoveRight(aMenu: hMenu;aCommand:Cardinal);

procedure setFormParented(aForm: TForm; aParent: TWinControl;
  anAlign: TAlign = alClient);

function HintString(aHint:String;aLimit: Integer = 80):String;
function LongDescriptionByCode(aCode,aDefault:String;aDate:TFMDateTime;AI10Active:Boolean):String;
function RemoveDuplicate(aTarget,aDelimeter:String):String;
function DebugInfo:String;
function IsCorrectVersion(bDebug:Boolean): Boolean;
function getLongDescriptionByCode(aCode,aDefault:String):String;

function getMainFormTextHeight:Integer;
function getMainFormTextWidth(aText:String): Integer;
procedure adjustBitBtn(aBB:TBitBtn);

function EncounterToStr(anEncounter:TEncounter):String;
function EditNoteRecToStr(aRecord: TEditNoteRec):String;
var
{$IFDEF ICD10TEST01}
  gDebugProblemList: Boolean; // setting to True forces open an editor of data
                              // returned by the RPC call
{$ENDIF}
  _marginW: Integer;
  _marginH: Integer;

implementation
uses
  Classes
  , SysUtils
  , ORNet
  , rPCE
  , rMisc
  , VAUtils
  , ORSystem
  , Dialogs
  , fxBroker
  , uGN_Const
  ;

procedure MenuItemMoveRight(aMenu: hMenu; aCommand: Cardinal);
var
  mii: TMenuItemInfo;
  Buffer: array [0 .. 79] of Char;

begin
  // GET Help Menu Item Info
  mii.cbSize := SizeOf(mii);
  mii.fMask := MIIM_TYPE;
  mii.dwTypeData := Buffer;
  mii.cch := SizeOf(Buffer);
  GetMenuItemInfo(aMenu, aCommand, False, mii);
  // SET Help Menu Item Info
  mii.fType := mii.fType or MFT_RIGHTJUSTIFY;
  if SetMenuItemInfo(aMenu, aCommand, False, mii) then
    if Assigned(Application.MainForm) then
    begin
      Application.MainForm.Width := Application.MainForm.Width + 1;
      Application.ProcessMessages;
      Application.MainForm.Width := Application.MainForm.Width - 1;
      Application.ProcessMessages;
    end;
end;

function HintString(aHint: String; aLimit: Integer = 80): String;
var
  i: Integer;
  s, sHint: String;
  sl: TStringList;
begin
  // ICD-10. Removing duplicate data from Hint text
  if pos(' - ', aHint) > 0 then
    sHint := copy(aHint, pos(' - ', aHint) + 3, Length(aHint))
  else
    sHint := aHint;

  sHint := StringReplace(sHint, #9, ' ', [rfReplaceAll]);

  sl := TStringList.Create;
  sl.Delimiter := ' ';
  sl.DelimitedText := sHint;
  s := '';
  for i := 0 to sl.Count - 1 do
  begin
    if Length(s + sl[i]) > aLimit then
    begin
      Result := Result + s + #13#10;
      s := sl[i] + ' ';
    end
    else
      s := s + sl[i] + ' ';
  end;
  Result := Result + s;
end;

function FMDateToWindowsDate(aDate:String):TFMDateTime;
var
  year,month,day: Word;
begin
  year  := StrToIntDef(Copy(aDate, 1, 3), 0) + 1700;
  month := StrToIntDef(Copy(aDate, 4, 2), 0);
  day   := StrToIntDef(Copy(aDate, 6, 2), 0);
  Result := EncodeDate(year, month, day);
end;

//ICD-10 Remediation. CodeCR:184
function getLongDescriptionByCode(aCode,aDefault:String):String;
var
  SL: TStringList;
  S: String;
begin
  Result := aDefault;
  SL := TStringList.Create;
  tCallV(SL,'ORWPCE GET DX TEXT',['',aCode]);
  if SL.Count > 0 then
    begin
      s := SL[0];
      FreeAndNil(SL);
      if (pos('-',s) =1) or (trim(s) = '') then
        Result := aDefault
      else
        Result := copy(s,4,Length(s));
    end
  else
    Result := aDefault;
end;

function LongDescriptionByCode(aCode,aDefault:String;aDate:TFMDateTime;AI10Active:Boolean):String;
var
  s: String;
  bExtend,bActive: Boolean;
  dDate: TFMDateTime;
  LexResults: TSTringList;
begin
  if trim(aCode) = '' then
    begin
      Result := aDefault;
      Exit;
    end;

  LexResults := TStringList.Create;

  if pos('ICD-10',aDefault)> 0 then
    begin
      dDate := StrToFloat(GImplementationDate);
      bExtend := True;
      bActive := True;
    end
  else
    begin
      dDate := FMDateToWindowsDate(GImplementationDate) -1;
      dDate := DateTimeToFMDateTime(dDate);
      bExtend := True;
      bActive := False;
    end;

  ListLexicon(LexResults,aCode,LX_ICD,dDate,bExtend,bActive);
  s := LexResults.Text;
  if (pos('-',s) =1) or (trim(s) = '') then
    Result := aDefault
  else
    Result := Piece(S,U,2) + ' ('+Piece(s,U,3) + ' '+ Piece(s,U,4) + ')';

  FreeAndNil(LexResults);
end;

function RemoveDuplicate(aTarget,aDelimeter:String):String;
begin
  if pos(aDelimeter,aTarget) > 0 then
    Result := copy(aTarget,pos(aDelimeter,aTarget)+Length(aDelimeter),Length(aTarget))
  else
    Result := aTarget;
end;

function DebugInfo:String;
begin
   Result :=
   'This is the DEBUG version of the Group Notes application.'+CRLF+
   'File Version: ' +  FileVersionValue(Application.ExeName, 'FileVersion')+
   ' ('+FileVersionValue(Application.ExeName, FILE_VER_FILEDESCRIPTION)+')'+
   CRLF+CRLF+
   'Code CRs addressed:' + CRLF +
//                     '  ??   - incorrect date value passed to LEX search'+ CRLF +
                        '  184  - Code truncated in the diagnosis list'+ CRLF +
                        '  186  - invalid codes can be selected if entered in CPRS'+ CRLF +
                        '  235  - missing default provider'+ CRLF +
   CRLF+
   'Compiled with conditionals:' + CRLF +
                         '  ICD10DEBUG  - dubug code included'+ CRLF +
{$IFDEF RPCLOG}          '  RPCLOG      - enhanced RPC Log support' + CRLF + {$ENDIF}
{$IFDEF ICD10DEBUG235}   '  ICD10DEBUG235 - debug details for CodeCR 235' + CRLF + {$ENDIF}
{$IFDEF ICD10TEST01}     '  ICD10TEST01 - Problems List items editing' + CRLF + {$ENDIF}
{$IFDEF ICD10NOPREVDIAG} '  ICD10NOPREVDIAG - no support for "Previous Diagnosis" section' + CRLF + {$ENDIF}
   CRLF + 'Debug Info:' + CRLF+ '  ' + FileVersionValue(Application.ExeName, 'DEBUG')+CRLF+
   CRLF +
   'The debug version supports all functions of the production one plus:'+CRLF+
   '- /ICD10DEBUG startup parameter'+CRLF+
{$IFDEF RPCLOG} '- Enhanced RPC Log.'+ CRLF + {$ENDIF}
   CRLF+
   'Use /ICD10DEBUG parameter to: ' + CRLF+
   '- bypass the GUI version control (registered in the Log) ' + CRLF+
   '- enable selection of the future dates for the Encounters' + CRLF+
{$IFDEF RPCLOG} '- open RPC Log window at the startup.' + CRLF + {$ENDIF}
   ''
   ;
end;

function IsCorrectVersion(bDebug:Boolean): Boolean;
var
  sMessage,
  ClientVer, ServerVer, ServerReq: string;

  procedure AddLogLine(aText,aHeader:String);
  begin
    // 2FA: dummy procedure to ensure compatibility with an old code
  end;

  procedure LogInfoBox(aText,aCaption:String;aBtn: Integer);
  begin
    AddLogLine(aText,aCaption);
    InfoBox(aText,aCaption,aBtn);
  end;

begin
  Result := bDebug;
{$IFDEF DEBUG}
  InfoBox('The DEBUG build ignores version validation.'+CRLF+CRLF+
    ' DO NOT USE IT IN PRODUCTION ACCOUNTS!', 'DEBUG INFO', MB_OK);
{$ENDIF}
  if not IsAuthUser then
    InfoBox('You are not authorized to use Group Notes.','Group Notes',MB_OK)
{$IFDEF DEBUG}
    ;
{$ELSE}
  else
{$ENDIF}
    begin
      ClientVer := ClientVersion(Application.ExeName);
      ServerReq := Piece(FileVersionValue(Application.ExeName, FILE_VER_INTERNALNAME), ' ', 1);
      ServerVer := ServerVersion('OR GN SET LOCATIONS', ClientVer);
      sMessage := 'Client:          '+ClientVer + CRLF +
        'Server:          ' + ServerVer + CRLF + 'Required Server: ' + ServerReq;
      AddLogLine(sMessage,'Version Info');

      if (ServerVer = '0.0.0.0') then
        LogInfoBox('Unable to determine current version of server, please make sure you installed latest patch OR*3*222.', 'Group Notes', MB_OK)
      else
        begin
          ClientVer := ClientVersion(Application.ExeName);
          ServerReq := Piece(FileVersionValue(Application.ExeName, FILE_VER_INTERNALNAME), ' ', 1);

          sMessage := 'Client:          '+ClientVer + CRLF +
            'Server:          ' + ServerVer + CRLF + 'Required Server: ' + ServerReq;

          if (CompareVersion(ServerVer, ClientVer) > 0) then // Server newer than Client
            LogInfoBox(TX_CLIENT_MISMATCH
{$IFDEF DEBUG}
             + CRLF + CRLF + sMessage
{$ENDIF}
             , TC_CLIERR, MB_OK)

          else
            begin
              if (CompareVersion(ServerVer, ServerReq) <> 0) then
              begin
{
                if (CompareVersion(ServerVer, ServerReq) > 0) then // Server newer than Required
                begin
                  if (CompareVersion(ServerVer, ClientVer) > 0) then  //  Server newer than Client
                  begin
                    sMessage :=TX_VER1 + ClientVer + TX_VER2 + CRLF + ServerReq + TX_VER_REQ + TX_VER3 + ServerVer + '.' + TX_VER_OLD2;
                    LogInfoBox(sMessage, TC_VER, MB_OK);
                  end;
                end
                else // if (CompareVersion(ServerVer, ServerReq) < 0) then // Server older then Required

                begin
                  sMessage := TX_VER1 + ClientVer + TX_VER2 + CRLF + ServerReq + TX_VER_REQ + TX_VER3 + ServerVer + '.' + TX_VER_NEW;
                  LogInfoBox(sMessage, TC_VER, MB_OK);
                end;
}
                sMessage := TX_VER1 + ClientVer + TX_VER2 + CRLF + ServerReq + TX_VER_REQ + TX_VER3 + ServerVer + '.' + TX_VER_NEW;
                LogInfoBox(sMessage, TC_VER, MB_OK);
              end
              else
                Result := True;
            end;
        end;
  end;
end;

procedure setFormParented(aForm: TForm; aParent: TWinControl;
  anAlign: TAlign = alClient);
begin
  if aForm.Parent <> aParent then
  begin
    aForm.BorderStyle := bsNone;
    aForm.Parent := aParent;
    aForm.Align := anAlign;
//    aForm.Menu := nil;
    if not aForm.Visible then
      aForm.Show;
  end;
end;

function getMainFormTextHeight:Integer;
begin
  Result := 12;
  if assigned(Application.MainForm) then
    Result := Application.MainForm.Canvas.TextHeight('qwerty1234567890');
end;

function getMainFormTextWidth(aText:String): Integer;
begin
  Result := 0;
  if assigned(Application.MainForm) then
    Result := Application.MainForm.Canvas.TextWidth(aText);
end;

procedure adjustBitBtn(aBB:TBitBtn);
var
  i: integer;
begin
  if not assigned(Application.MainForm) then
    exit;
  aBB.Font.Size := Application.MainForm.Font.Size;
  i := getMainFormTextWidth(aBB.Caption + 'W') + 2 * _MarginW;
  aBB.Width := i;
end;

const
  fmtName = '%-22.22s';
  fmtNameValue = '%-22.22s: %s';
  fmtNameValueD = '%-22.22s: %d';
  fmtNameValueCode = '%-22.22s: %s (%d)';


function NamedBool(aName:String;aValue:Boolean):String;
begin
  if aValue then
    Result := format(fmtNameValue,[aName,'TRUE'])
  else
    Result := format(fmtNameValue,[aName,'False']);
  Result := Result + CRLF;
end;

function EncounterToStr(anEncounter:TEncounter):String;
begin
  Result := 'Encounter: Not assigned';
  if not assigned(anEncounter) then
    exit;
  with anEncounter do
    begin
      Result := 'Encounter---------------------------------------------begin' + CRLF;
      Result := Result + NamedBool('Need Visit',NeedVisit);
      Result := Result + format(fmtNameValue,['Date/Time: ',DateTimeToStr(DateTime)]) + CRLF;
      Result := Result + NamedBool('Inpatient',Inpatient);
      Result := Result + format(fmtNameValueCode,['Location (ID)',LocationName,Location]) + CRLF;
      Result := Result + format(fmtNameValue,['Location Text',LocationText]) + CRLF;
      Result := Result + format(fmtNameValueCode,['Provider (ID)',ProviderName,Provider]) + CRLF;
      Result := Result + NamedBool('Standalone',Standalone);

      Result := Result + format(fmtNameValue,['Visit Category: ',''])+ VisitCategory + CRLF;
      Result := Result + format(fmtNameValue,['Visit String: ', VisitStr]) + CRLF;

      Result := Result + 'Encounter-----------------------------------------------end' + CRLF;
    end;
end;

function EditNoteRecToStr(aRecord: TEditNoteRec):String;
begin
  with aRecord do
    begin
      Result := 'Note Record-------------------------------------------begin' + CRLF;
      Result := Result + format(fmtNameValueD,['Record',NoteIEN]) + CRLF;
      Result := Result + format(fmtNameValueD,['DocType',DocType]) + CRLF;
      Result := Result + format(fmtNameValueCode,['Title (IEN)',TitleName,Title]) + CRLF;
      Result := Result + format(fmtNameValueD,['Record',NoteIEN]) + CRLF;
//      'DateTime: ' + TFMDateTime;
      Result := Result + format(fmtNameValueCode,['Author  (IEN)',AuthorName,Author]) + CRLF;
      Result := Result + format(fmtNameValueCode,['Cosigner (IEN)',CosignerName,Cosigner]) + CRLF;
      Result := Result + format(fmtNameValue,['Subject',Subject]) + CRLF;
      Result := Result + format(fmtNameValueCode,['Location (IEN)',LocationName,Location])+ CRLF;
//    VisitDate: TFMDateTime;
      Result := Result + format(fmtNameValueCode,['Package Ptr/Ref (IEN)',PkgPtr + '/'+ PkgRef,PkgIEN]) + CRLF;
      Result := Result + format(fmtNameValueCode,['LastCosigner (IEN)',LastCosignerName,LastCosigner]) + CRLF;

      Result := Result + NamedBool('Need CPT',NeedCPT) + CRLF;
{
    Addend: Integer;
    IDParent: integer;
    ClinProcSummCode: integer;
    ClinProcDateTime: TFMDateTime;
}
      if Assigned(Lines) then
        Result := Result + 'Lines:' + CRLF + Lines.Text + CRLF
      else
        Result := Result + 'Lines: not assigned' + CRLF;

      if Assigned(GenLines) then
        Result := Result + 'Common Lines:' + CRLF + GenLines.Text + CRLF
      else
        Result := Result + 'Common Lines: not assigned' + CRLF;

      if Assigned(PtLines) then
        Result := Result + 'Pt. Lines:' + CRLF + PtLines.Text + CRLF
      else
        Result := Result + 'Pt. Lines: not assigned' + CRLF;

      Result := Result + 'Error text:' + ErrTxt + CRLF;
      Result := Result + 'Note Record---------------------------------------------end' + CRLF;

{
    PRF_IEN: integer;
    ActionIEN: string;
}
    end;

end;


initialization

_marginW := 6;
_marginH := 3;
end.
