unit fGN_SelectedPatients;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.Buttons, Vcl.StdCtrls, Vcl.ComCtrls,
  Vcl.ExtCtrls, System.Actions, Vcl.ActnList
  , uPCE, fGN_PtSel, WinAPI.CommCtrl
  ;

type
  TfrmGN_SelectedPatients = class(TForm)
    lblInfo: TLabel;
    lvGnPtList: TListView;
    pnlTools: TPanel;
    alPatientList: TActionList;
    acRemove: TAction;
    acRemoveAll: TAction;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure acRemoveExecute(Sender: TObject);
    procedure acRemoveAllExecute(Sender: TObject);
    procedure lvGnPtListCompare(Sender: TObject; Item1, Item2: TListItem;
      Data: Integer; var Compare: Integer);
    procedure lvGnPtListColumnClick(Sender: TObject; Column: TListColumn);
    procedure lvGnPtListChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    FsortCol: integer;
    FsortAscending: boolean;
  public
    { Public declarations }
    procedure setActionStatus;
    procedure addPatientData(aPtData:TPatientData;aLocation:String);
  end;

var
  frmGN_SelectedPatients: TfrmGN_SelectedPatients;

implementation

{$R *.dfm}
uses
  uCore
  , uGN_Const
  , ORFn
  , rGN_Core
  , dmGN_Common;

procedure TfrmGN_SelectedPatients.setActionStatus;
begin
  acRemove.Enabled := (lvGnPtList.Items.Count > 0) and
    (lvGnPtList.ItemIndex >=0);
  acRemoveAll.Enabled := lvGnPtList.Items.Count > 0;
  sendMessage(Application.MainForm.Handle,UM_GNSELECT,0,0);
end;

procedure TfrmGN_SelectedPatients.acRemoveAllExecute(Sender: TObject);
begin
  if (lvGnPtlist.Items.Count > 0) then
    begin
      lvGnPtList.Items.Clear;
      CleanGNPtList;
    end;
  setActionStatus;
end;

procedure TfrmGN_SelectedPatients.acRemoveExecute(Sender: TObject);
var
  idx,idy: integer;
begin
  if lvGNPtList.SelCount <= 0 then
    InfoBox('There is no selected patient', 'Warning', MB_OK or MB_ICONWARNING)
  else
    begin
//      idy := -1;
      for idx := 0 to lvGNPtList.Items.Count - 1 do
      begin
        if lvGNPtList.Items[idx].Selected  then
        begin
          idy := GNPtList.IndexOf(lvGNPtList.Items[idx].Data);
          if idy >= 0 then
          begin
            TPatient(GNPtList.Items[idy]).Free;
            GNPtList.Delete(idy);
          end;
        end;
      end;

      lvGnPtList.DeleteSelected;
{
      if idy >=0 then
        begin
          if idy >= lvGnPtList.Items.Count then
            idy := lvGnPtList.Items.Count - 1;
          if idy >= 0 then
            begin
              lvGNPtList.ItemIndex := idy;
              lvGNPtList.Selected := lvGNPtList.Items[idy];
            end;
        end;
}
      setActionStatus;
    end;
end;

procedure TfrmGN_SelectedPatients.addPatientData(aPtData:TPatientData;aLocation:String);
var
  AnItem: TListItem;
  PtAdmit: String;
  AdmitDT: TDateTime;
begin
  if not assigned(aPtData) then
    exit;

  PtAdmit := '';
  if (APtData.Patient.AdmitTime > 0) then
  begin
    AdmitDT := FMDateTimeToDateTime(APtData.Patient.AdmitTime);
    PtAdmit := DateToStr(AdmitDT);
  end;

  AnItem := lvGNPtList.Items.Add;
  AnItem.Data := APtData;
  AnItem.Caption := APtData.Patient.Name;
  AnItem.SubItems.Add(APtData.Patient.SSN);
  AnItem.SubItems.Add(IntToStr(APtData.Patient.Age));
  AnItem.SubItems.Add(APtData.Patient.Sex);
  AnItem.SubItems.Add(aLocation);
  AnItem.SubItems.Add(PtAdmit);
  AnItem.SubItems.Add(APtData.Patient.PrimaryTeam);
  AnItem.SubItems.Add(APtData.Patient.PrimaryProvider);
end;

procedure TfrmGN_SelectedPatients.FormCreate(Sender: TObject);
begin
  FsortAscending := true;
end;

procedure TfrmGN_SelectedPatients.lvGnPtListChange(Sender: TObject;
  Item: TListItem; Change: TItemChange);
begin
  SetActionStatus;
end;

procedure ListViewClearSortIndicator(aHandle:HWND; aColumn: Integer);
var
  Header: HWND;
  Item: THDItem;
begin
  Header := ListView_GetHeader(aHandle);
  ZeroMemory(@Item, SizeOf(Item));
  Item.Mask := HDI_FORMAT;

  // Clear the previous arrow
  Header_GetItem(Header, aColumn, Item);
  Item.fmt := Item.fmt and not (HDF_SORTUP or HDF_SORTDOWN);//remove both flags
  Header_SetItem(Header, aColumn, Item);
end;

procedure TfrmGN_SelectedPatients.lvGnPtListColumnClick(Sender: TObject;
  Column: TListColumn);


  procedure UpdateHeader(aHandle:HWND; aColumn: Integer);
  var
    Header: HWND;
    Item: THDItem;
  begin
    Header := ListView_GetHeader(aHandle);
    ZeroMemory(@Item, SizeOf(Item));
    Item.Mask := HDI_FORMAT;

    ListViewClearSortIndicator(aHandle,FsortCol);

    if Column.Index <> FsortCol then
      begin
        FsortAscending := False;
        FsortCol := Column.Index;
      end
    else
      FsortAscending := not FsortAscending;

    // Get the new column
    Header_GetItem(Header, FsortCol, Item);
    Item.fmt := Item.fmt and not (HDF_SORTUP or HDF_SORTDOWN);//remove both flags

    if FsortAscending then
      Item.fmt := Item.fmt or HDF_SORTDOWN//include the sort descending flag
    else
      Item.fmt := Item.fmt or HDF_SORTUP;//include the sort ascending flag

    Header_SetItem(Header, FsortCol, Item);

    with TListView(Sender) do
      begin
        SortType := stText;
        Items.BeginUpdate;
        AlphaSort;
        Items.EndUpdate;
      end;
  end;

begin
{
  if ((FsortCol = Column.Index))  then
        FsortAscending := not FsortAscending;
  FsortCol := Column.Index;
  lvGnPtList.AlphaSort;
}
  UpdateHeader(TListView(Sender).Handle,FsortCol);
end;

procedure TfrmGN_SelectedPatients.lvGnPtListCompare(Sender: TObject; Item1,
  Item2: TListItem; Data: Integer; var Compare: Integer);
begin
  if not(Sender is TListView) then Exit;
  if not FsortAscending then
    begin
      if FsortCol = 0 then Compare := CompareStr(Item1.Caption, Item2.Caption)
      else Compare := CompareStr(Item1.SubItems[FsortCol - 1], Item2.SubItems[FsortCol - 1]);
    end
  else
    begin
      if FsortCol = 0 then Compare := CompareStr(Item2.Caption, Item1.Caption)
      else Compare := CompareStr(Item2.SubItems[FsortCol - 1], Item1.SubItems[FsortCol - 1]);
    end;
end;

end.
