unit fGN_PtSel;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ORCtrls, ORDtTmRng, ExtCtrls, ComCtrls, Buttons, ORFn,
  rGN_Core,ORNet, ORDtTm
  , fGN_Page
  , fGN_MainFrame, uCore, uPCE
  , fPtSelDemog
  , uTIU, System.Actions, Vcl.ActnList
  ;

type
  TSetPtListTopProc = procedure(IEN: Int64) of object;

  TPatientData = Class(TObject)
  private
    FOKForSign: Boolean;
    FPatient: TPatient;
    FAdditionalSigner: boolean;
  public
    PtNote: TEditNoteRec;
    PCEData: TPCEData;
    constructor Create;
    procedure Clear;
    property OKForSign: boolean read FOKForSign  write FOKForSign;
    property Patient: TPatient read FPatient write FPatient;
    property AdditionalSigner: boolean read FAdditionalSigner write FAdditionalSigner;
  end;

  TfrmGNPtSel = class(TfrmPage)
    pnlTop: TPanel;
    pnlOptions: TPanel;
    pnlRight: TPanel;
    bbInquiryPatient: TBitBtn;
    Splitter1: TSplitter;
    pnlPtSel: TPanel;
    cboPatient: TORComboBox;
    pnlOptionsHeader: TPanel;
    lblOptions: TLabel;
    pnlPatientHeader: TPanel;
    lblPatient: TLabel;
    calApptRng: TORDateRangeDlg;
    pnlSelectedPatients: TPanel;
    pnlDemographics: TPanel;
    pnlGroupEncounter: TPanel;
    bbInquiryDemographics: TBitBtn;
    alPatientSelector: TActionList;
    acInquiry: TAction;
    bvlTool: TBevel;
   procedure cboPatientNeedData(Sender: TObject; const StartFrom: String;
      Direction, InsertAt: Integer);
    procedure FormCreate(Sender: TObject);
    procedure cboPatientChange(Sender: TObject);
    procedure cboPatientClick(Sender: TObject);
    procedure cboPatientKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure cboPatientDblClick(Sender: TObject);
    procedure acInquiryExecute(Sender: TObject);
  private
    fOneClickSelection: boolean;
    FLastTopList: string;
    FSrcType: Integer;
    FSetPtListTop: TSetPtListTopProc;
    FDfltSrc: string;
    FDfltSrcType: string;
    FLastDFN: string;
//    FsortCol: integer;
//    FsortAscending: boolean;
    FLastDateIndex: Integer;
    procedure ShowDemog(ItemID: string);
    procedure AddToGNPtList(APtData:TPatientData);
    procedure ClearIDInfo;

    function DupLastSSN(var DFN: string): Boolean;
    procedure DoInquiry;
    procedure DoAdd(anID:String);

  public
    property OneCLick: Boolean read fOneClickSelection write fOneClickSelection;
    property LastTopList: string read FLastTopList write FLastTopList;
    property SrcType: Integer read FSrcType write FSrcType;
    property SetPtListTopProc: TSetPtListTopProc   read FSetPtListTop  write FSetPtListTop;
    procedure SetCaptionTop;
    procedure SetPtListTop(IEN: Int64);
    procedure InquiryPosition(onRight:Boolean);
  end;

var
  frmGNPtSel: TfrmGNPtSel;
  IsRPL, RPLJob, DupDFN: string;
  RPLProblem: boolean;
  FDfltSrc, FDfltSrcType: string;

implementation
{$R *.dfm}

uses
  fGN_Encounter, uGN_Utils, fGN_SelectedPatients, fGN_GroupEncounter
  , rPCE
  , rCore
  , uConst
  , fPtSelOptns
  , uGN_Const
  , fRptBox
  , dmGN_Common;

{ TPatientData }
procedure TPatientData.Clear;
begin
  with PtNote do
  begin
    NoteIEN      := 0;
    DocType      := 0;
    Title        := 0;
    TitleName    := '';
    DateTime     := 0;
    Author       := 0;
    AuthorName   := '';
    Cosigner     := 0;
    CosignerName := '';
    Subject      := '';
    Location     := 0;
    LocationName := '';
    PkgIEN       := 0;
    PkgPtr       := '';
    PkgRef       := '';
    NeedCPT      := False;
    Addend       := 0;
    Lines.Clear;
    ErrTxt       := '';
  end;
  FPatient.Free;
  PCEData.Free;
  FAdditionalSigner := False;
end;

constructor TPatientData.Create;
begin
  FOKForSign := False;
  FPatient := TPatient.Create;
  PCEData := TPCEData.Create;
  AdditionalSigner := False;
  with PtNote do
  begin
    NoteIEN      := 0;
    DocType      := 0;
    Title        := 0;
    TitleName    := '';
    DateTime     := 0;
    Author       := 0;
    AuthorName   := '';
    Cosigner     := 0;
    CosignerName := '';
    Subject      := '';
    Location     := 0;
    LocationName := '';
    PkgIEN       := 0;
    PkgPtr       := '';
    PkgRef       := '';
    NeedCPT      := False;
    Addend       := 0;
    Lines        := TStringList.Create;
    GenLines     := TStringList.Create;
    PtLines      := TStringList.Create;
    ErrTxt       := '';
  end;
end;

////////////////////////////////////////////////////////////////////////////////

procedure TfrmGNPtSel.FormCreate(Sender: TObject);

  procedure SetupOptions;
  begin
    frmPtSelOptns := TfrmPtSelOptns.Create(self); // Was application - kcm

    setFormParented(frmPtSelOptns,pnlOptions);

    with frmPtSelOptns do
      begin
        SetCaptionTopProc := SetCaptionTop;
        SetPtListTopProc := SetPtListTop;
        TabOrder := 0; //cmdSaveList.TabOrder; // Put just before save default list button
        Show;
      end;
  end;

  procedure setupSelectedList;
  begin
    if not assigned(frmGN_SelectedPatients) then
      frmGN_SelectedPatients := TfrmGN_SelectedPatients.Create(self);
    setFormParented(frmGN_SelectedPatients,pnlSelectedPatients);
  end;

  procedure setPatientList;
    var
      APtData: TPatientData;
      i : integer;
  begin
    if not Assigned(GNPtList) then
      GNPtList := TList.Create;
    if (GNPtList.Count > 0) then
    begin
      for i := 0 to GNPtList.Count - 1 do
      begin
        APtData := TPatientData(GNPtList.Items[i]);
        AddToGNPtList(aPtData);
      end;
    end;
    cboPatient.InitLongList('');
  end;

  procedure setDemographics;
  begin
    if not assigned(frmPtSelDemog) then
      frmPtSelDemog := TfrmPtSelDemog.Create(self);
    setFormParented(frmPtSelDemog,pnlDemographics);
  end;

  procedure setGroupEncounter;
  begin
    if not assigned(frmGN_GroupEncounter) then
      frmGN_GroupEncounter := TfrmGN_GroupEncounter.Create(self);
    setFormParented(frmGN_GroupEncounter,pnlGroupEncounter);
  end;

begin
  SetupOptions;
  setupSelectedList;
  setDemographics;
  setGroupencounter;

  RPLProblem := false;

  FDfltSrc := DfltPtList;
  FDfltSrcType := Piece(FDfltSrc, U, 2);
  FDfltSrc := Piece(FDfltSrc, U, 1);

  FLastDateIndex := -1;

  if (IsRPL = '1') then             // Deal with restricted patient list users.
    FDfltSrc := '';
  ClearIDInfo;
  if RPLProblem then exit;

  if (IsRPL = '1') then             // Deal with restricted patient list users.
    pnlOptions.Visible := False;  // Removes unnecessary components from view.

  setPatientList;

  frmGN_GroupEncounter.Init;

  frmPtSelOptns.rgPtList.ItemIndex := 0;
end;

procedure TfrmGNPtSel.cboPatientNeedData(Sender: TObject; const StartFrom: string;
  Direction, InsertAt: Integer);
var
  i: Integer;
  NoAlias, ThePatient: String;
  PatientList: TStringList;

const
  ALIASSTRING = ' -- ALIAS';

begin
  NoAlias := StartFrom;
  with Sender as TORComboBox do
  begin
    if Items.Count > ShortCount then
      NoAlias := Piece(Items[Items.Count-1], U, 1) + U + NoAlias;
  end;
  if pos(AliasString, NoAlias)> 0 then
    NoAlias := Copy(NoAlias, 1, pos(AliasString, NoAlias)-1);
  PatientList := TStringList.Create;
  try
    begin
      if (IsRPL  = '1') then
        PatientList.Assign(ReadRPLPtList(RPLJob, NoAlias, Direction))
      else
      begin
        PatientList.Assign(SubSetOfPatients(NoAlias, Direction));
        for i := 0 to PatientList.Count-1 do
        begin
          ThePatient := PatientList[i];
          if (Uppercase(Piece(ThePatient, U, 2)) <> Uppercase(Piece(ThePatient, U, 6))) then
          begin
            SetPiece(ThePatient, U, 2, Piece(ThePatient, U, 2) + AliasString);
            PatientList[i] := ThePatient;
          end;
        end;
      end;
      cboPatient.ForDataUse(PatientList);
    end;
  finally
    PatientList.Free;
  end;
end;

procedure TfrmGNPtSel.ShowDemog(ItemID: string);
{ gets a record of patient indentifying information from the server and displays it }
begin
  if ItemID = FLastDFN then
    exit;
  if (StrToInt64Def(ItemID, 0) < 1) then
    exit;

  FLastDFN := ItemID;

  acInquiry.Enabled := True;

  if assigned(frmPtSelDemog) then
    frmPtSelDemog.ShowDemog(ItemID);
end;

procedure TfrmGNPtSel.ClearIDInfo;
begin
  FLastDFN := '';

  acInquiry.Enabled := false;

  if assigned(frmPtSelDemog) then
    frmPtSelDemog.ClearIDInfo;
end;

procedure TfrmGNPtSel.cboPatientChange(Sender: TObject);

  procedure ShowMatchingPatients;
  begin
    with cboPatient do
    begin
      ClearIDInfo;
      if ShortCount > 0 then
      begin
        if ShortCount = 1 then
        begin
          ItemIndex := 0;
          ShowDemog(cboPatient.ItemID);
        end;
        Items.Add(LLS_LINE);
        Items.Add(LLS_SPACE);
      end;
      InitLongList('');
    end;
  end;

begin
  with cboPatient do
  begin
    if IsLast5(Text) then
    begin
      if (IsRPL = '1') then
        ListPtByRPLLast5(Items, Text)
      else
        ListPtByLast5(Items, Text);
      ShowMatchingPatients;
    end
    else if IsFullSSN(Text) then
    begin
      if (IsRPL = '1') then
        ListPtByRPLFullSSN(Items, Text)
      else
        ListPtByFullSSN(Items, Text);
      ShowMatchingPatients;
    end;
  end;
end;

function TfrmGNPtSel.DupLastSSN(var DFN: string): Boolean;
var
  i: integer;
  PtStrs: TStringList;
begin
  Result := False;
  CallV('DG CHK BS5 XREF ARRAY', [DFN]);
  if (RPCBrokerV.Results[0] <> '1') then
    Exit;
  Result := True;
  PtStrs := TStringList.Create;
  with RPCBrokerV do if Results.Count > 0 then
  begin
    for i := 1 to Results.Count - 1 do
    begin
      if Piece(Results[i], U, 1) = '1' then
        PtStrs.Add(Piece(Results[i], U, 2) + U + Piece(Results[i], U, 3) + U +
                   FormatFMDateTimeStr('mmm dd,yyyy', Piece(Results[i], U, 4)) + U +
                   Piece(Results[i], U, 5));
    end;
  end;
  InfoBox('Confirm Selection of Patient!'+CRLF+ 'SelectDupPts','Patient Selection',MB_OK);
//  SelectDupPt(DFN,PtStrs);
end;

procedure TfrmGNPtSel.cboPatientClick(Sender: TObject);
var
  NewDFN, AMsg: string;
  AccessStatus: Integer;
  DateDied: TFMDateTime;
//  APtData: TPatientData;

const
//  ALIASSTRING = ' -- ALIAS';
  TX_DGSR_ERR    = 'Unable to perform sensitive record checks';
  TC_DGSR_ERR    = 'Error';
  TC_DGSR_SHOW   = 'Restricted Record';
  TC_DGSR_DENY   = 'Access Denied';
  TX_DGSR_YESNO  = CRLF + 'Do you want to continue processing this patient record?';

begin
  ShowDemog(cboPatient.ItemID);
  Application.ProcessMessages;

  NewDFN := cboPatient.ItemID;
  if StrToInt64Def(NewDFN, 0) < 1 then
    exit;
  if DupLastSSN(NewDFN) then
    if (Length(NewDFN) = 0) then
      exit;

  CheckSensitiveRecordAccess(NewDFN, AccessStatus, AMsg);

{
  if AccessStatus = DGSR_ASK then
    btnInquiry.Enabled := False
  else
    btnInquiry.Enabled := True;
}
  acInquiry.Enabled := AccessStatus <> DGSR_ASK;

  case AccessStatus of
    DGSR_FAIL:
      begin
        InfoBox(TX_DGSR_ERR, TC_DGSR_ERR, MB_OK);
        exit;
      end;
    DGSR_NONE: { Nothing - allow access to the patient. }
      ;
    DGSR_SHOW:
      InfoBox(AMsg, TC_DGSR_SHOW, MB_OK);
    DGSR_ASK:
      if InfoBox(AMsg + TX_DGSR_YESNO, TC_DGSR_SHOW,
        MB_YESNO or MB_ICONWARNING or MB_DEFBUTTON2) = IDYES then
      begin
        LogSensitiveRecordAccess(NewDFN);
        acInquiry.Enabled := True;
      end
      else
        exit;
  else
    begin
      InfoBox(AMsg, TC_DGSR_DENY, MB_OK);
      exit;
    end;
  end;

  DateDied := DateOfDeath(NewDFN);
  if (DateDied > 0) and
    (InfoBox('This patient died ' + FormatFMDateTime('mmm dd,yyyy hh:nn',
    DateDied) + CRLF + 'Do you wish to continue?', 'Deceased Patient',
    MB_YESNO or MB_DEFBUTTON2) = ID_NO) then
    exit;

  if fOneClickSelection then
    doAdd(NewDFN);
end;

procedure TfrmGNPtSel.cboPatientDblClick(Sender: TObject);
begin
  inherited;
  if not fOneClickSelection then
    doAdd(IntToStr(cboPatient.ItemID))
  else
    doInquiry;
end;

procedure TfrmGNPtSel.DoAdd(anID: string);
var
  aPtData: TPatientData;

  function DupPtInList(APtDFN: string): Boolean;
  var
    i: integer;
    APatient: TPatientData;
  begin
    Result := False;
    for i := 0 to (GnPtList.Count - 1) do
    begin
      APatient := TPatientData(GnPtList.Items[i]);
      if APatient.Patient.DFN = APtDFN then
      begin
        Result := True;
        Exit;
      end;
    end;
  end;

begin
  if not DupPtInList(anID) then
    begin
      APtData := TPatientData.Create;
      APtData.PCEData := TPCEData.Create;
      APtData.Patient.DFN := anID;
      AddToGNPtList(APtData);

      sendMessage(Application.MainForm.Handle,UM_GNSELECT,0,0);
    end;
end;

procedure TfrmGNPtSel.acInquiryExecute(Sender: TObject);
begin
  inherited;
  doInquiry;
end;

procedure TfrmGNPtSel.AddToGNPtList(APtData:TPatientData);
begin
  if assigned(frmGN_SelectedPatients) and assigned(frmPtSelDemog) then
    frmGN_SelectedPatients.addPatientData(APtData,frmPtSelDemog.lblPtLocation.Caption);

  GNPtList.Add(APtData);
end;

procedure TfrmGNPtSel.DoInquiry;
var
  sl: TStringList;
  s: String;
begin
  if cboPatient.ItemID <> '' then
    begin
      s := IntToStr(cboPatient.ItemID);
      sl := TSTringList.Create;
      LoadDemographics(sl,s);
      ReportBox(sl, 'Patient Inquiry', True);
      sl.Free;
    end;
end;

procedure TfrmGNPtSel.cboPatientKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  inherited;
  if Key = VK_RETURN then
    cboPatientDblClick(Sender);
end;

procedure TfrmGNPtSel.FormShow(Sender: TObject);
begin
  inherited;
  if StartOver and Assigned(frmGN_SelectedPatients) then
    frmGN_SelectedPatients.lvGnPtList.Items.Clear;
end;

procedure TfrmGNPtSel.SetCaptionTop;
{ Show patient list name, set top list to 'Select ...' if appropriate. }
var
  X: string;
begin
  X := '';
  lblPatient.Caption := 'Patients';
  if (not User.IsReportsOnly) then
    begin
      case frmPtSelOptns.SrcType of
        TAG_SRC_DFLT:
          lblPatient.Caption := 'Patients (' + FDfltSrc + ')';
        TAG_SRC_PROV:
          X := 'Provider';
        TAG_SRC_TEAM:
          X := 'Team';
        TAG_SRC_SPEC:
          X := 'Specialty';
        TAG_SRC_CLIN:
          X := 'Clinic';
        TAG_SRC_WARD:
          X := 'Ward';
        TAG_SRC_PCMM:
          X := 'Pcmm Team'; // TDP - Added 5/27/2014 to handle PCMM team addition
//        TAG_SRC_ALL: { Nothing }
//          ;
      end; // case stmt
    end; // begin
  if Length(X) > 0 then
    with cboPatient do
      begin
        RedrawSuspend(Handle);
        ClearIDInfo;
        ClearTop;
        Text := '';
        Items.Add('^Select a ' + X + '...');
        Items.Add(LLS_LINE);
        Items.Add(LLS_SPACE);
        cboPatient.InitLongList('');
        RedrawActivate(cboPatient.Handle);
      end;
end;

{ List Source events: }

procedure TfrmGNPtSel.SetPtListTop(IEN: Int64);
{ Sets top items in patient list according to list source type and optional list source IEN. }
var
  NewTopList: string;
  FirstDate, LastDate: string;
begin
  // NOTE:  Some pieces in RPC returned arrays are rearranged by ListPtByDflt call in rCore!
  IsRPL := User.IsRPL;
  if (IsRPL = '') then // First piece in ^VA(200,.101) should always be set (to 1 or 0).
    begin
      InfoBox('Patient selection list flag not set.', 'Incomplete User Information', MB_OK);
      RPLProblem := True;
      Exit;
    end;
  // FirstDate := 0; LastDate := 0; // Not req'd, but eliminates hint.
  // Assign list box TabPosition, Pieces properties according to type of list to be displayed.
  // (Always use Piece "2" as the first in the list to assure display of patient's name.)
  cboPatient.pieces := '2,3'; // This line and next: defaults set - exceptions modifield next.
  cboPatient.tabPositions := '20,28';
  if ((frmPtSelOptns.SrcType = TAG_SRC_DFLT) and (FDfltSrc = 'Combination')) then
    begin
      cboPatient.pieces := '2,3,4,5,9';
      cboPatient.tabPositions := '20,28,35,45';
    end;
  if ((frmPtSelOptns.SrcType = TAG_SRC_DFLT) and
    (FDfltSrcType = 'Ward')) or (frmPtSelOptns.SrcType = TAG_SRC_WARD) then
    cboPatient.tabPositions := '35';
  if ((frmPtSelOptns.SrcType = TAG_SRC_DFLT) and
    (AnsiStrPos(pChar(FDfltSrcType), 'Clinic') <> nil)) or (frmPtSelOptns.SrcType = TAG_SRC_CLIN) then
    begin
      cboPatient.pieces := '2,3,9';
      cboPatient.tabPositions := '24,45';
    end;
  NewTopList := IntToStr(frmPtSelOptns.SrcType) + U + IntToStr(IEN); // Default setting.
  if (frmPtSelOptns.SrcType = TAG_SRC_CLIN) then
    with frmPtSelOptns.cboDateRange do
      begin
        if ItemID = '' then
          Exit; // Need both clinic & date range.
        FirstDate := Piece(ItemID, ';', 1);
        LastDate := Piece(ItemID, ';', 2);
        NewTopList := IntToStr(frmPtSelOptns.SrcType) + U + IntToStr(IEN) + U + ItemID; // Modified for clinics.
      end;
  if NewTopList = frmPtSelOptns.LastTopList then
    Exit; // Only continue if new top list.
  frmPtSelOptns.LastTopList := NewTopList;
  RedrawSuspend(cboPatient.Handle);
  ClearIDInfo;
  cboPatient.ClearTop;
  cboPatient.Text := '';
  if (IsRPL = '1') then // Deal with restricted patient list users.
    begin
      RPLJob := MakeRPLPtList(User.RPLList); // MakeRPLPtList is in rCore, writes global "B" x-ref list.
      if (RPLJob = '') then
        begin
          InfoBox('Assignment of valid OE/RR Team List Needed.', 'Unable to build Patient List', MB_OK);
          RPLProblem := True;
          Exit;
        end;
    end
  else
    begin
      case frmPtSelOptns.SrcType of
        TAG_SRC_DFLT:
          ListPtByDflt(cboPatient.Items);
        TAG_SRC_PROV:
          ListPtByProvider(cboPatient.Items, IEN);
        TAG_SRC_TEAM:
          ListPtByTeam(cboPatient.Items, IEN);
        TAG_SRC_SPEC:
          ListPtBySpecialty(cboPatient.Items, IEN);
        TAG_SRC_CLIN:
          ListPtByClinic(cboPatient.Items, frmPtSelOptns.cboList.ItemIEN, FirstDate, LastDate);
        TAG_SRC_WARD:
          ListPtByWard(cboPatient.Items, IEN);
        // TDP - Added 5/27/2014 to handle PCMM team addition
        TAG_SRC_PCMM:
          ListPtByPcmmTeam(cboPatient.Items, IEN);
        TAG_SRC_ALL:
          ListPtTop(cboPatient.Items);
      end;
    end;
  if frmPtSelOptns.cboList.Visible then
    lblPatient.Caption := 'Patients (' + frmPtSelOptns.cboList.Text + ')';
  if frmPtSelOptns.SrcType = TAG_SRC_ALL then
    lblPatient.Caption := 'Patients (All Patients)';
  with cboPatient do
    if ShortCount > 0 then
      begin
        Items.Add(LLS_LINE);
        Items.Add(LLS_SPACE);
      end;
  cboPatient.Caption := lblPatient.Caption;
  cboPatient.InitLongList('');
  RedrawActivate(cboPatient.Handle);
end;

procedure TfrmGNPtSel.InquiryPosition(onRight:Boolean);
begin
  bbInquiryPatient.Visible := not onRight;
  bbInquiryDemographics.Visible := onRight;
end;


end.
