unit fGN_MainFrame;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, ComCtrls, ToolWin, StdCtrls, Menus,
  uCore
  ,fGN_Page
  , uConst,  fBase508Form, VA508AccessibilityManager,
  uPCE, ShellAPI
  , uInit, ORSystem, Vcl.Buttons, Vcl.ActnList,
  System.Actions, Vcl.StdActns, System.ImageList, Vcl.ImgList, System.UITypes,
  uGN_Const;

const
  TX_IN_USE = 'Group Notes in use by: ';

type
  TfrmMainFrame = class(TfrmBase508Form)
    pnlPage: TPanel;
    mnuGNMain: TMainMenu;
    Help1: TMenuItem;
    LastBroker1: TMenuItem;
    Font1: TMenuItem;
    N8pt1: TMenuItem;
    N10pt1: TMenuItem;
    N12pt1: TMenuItem;
    N14pt1: TMenuItem;
    N18pt1: TMenuItem;
    Contents1: TMenuItem;
    N1: TMenuItem;
    About1: TMenuItem;
    File1: TMenuItem;
    Exit1: TMenuItem;
    pnlToolbar: TPanel;
    alMain: TActionList;
    acPtSelector: TAction;
    BitBtn1: TBitBtn;
    acNoteCreate: TAction;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    acNewGroupNote: TAction;
    BitBtn4: TBitBtn;
    acExitGN: TAction;
    acOneClick: TAction;
    OneClickSelection1: TMenuItem;
    acTopToolbar: TAction;
    ools1: TMenuItem;
    oolbaratthetop1: TMenuItem;
    pnlMain: TPanel;
    bvlTool: TBevel;
    acAbout: TAction;
    acLastRPC: TAction;
    acHelpContents: TAction;
    acHelpPosition: TAction;
    HelpMenuonRight1: TMenuItem;
    acInquiryPosition: TAction;
    InquirybuttononRight1: TMenuItem;
    acShowDisabled: TAction;
    ShowDisabledButtons1: TMenuItem;
    Debug1: TMenuItem;
    acChangeLog: TAction;
    N2: TMenuItem;
    ChangeLog1: TMenuItem;
    N3: TMenuItem;
    SelectPatients1: TMenuItem;
    CreateGroupNote1: TMenuItem;
    StartNewGroupNote1: TMenuItem;
    acDebugLayout: TAction;
    DebugLayout1: TMenuItem;
    sbMain: TStatusBar;
    ac8: TAction;
    ac10: TAction;
    ac12: TAction;
    ac14: TAction;
    ac18: TAction;
    ppFontSize: TPopupMenu;
    N81: TMenuItem;
    N101: TMenuItem;
    N121: TMenuItem;
    N141: TMenuItem;
    N181: TMenuItem;
    acAppLog: TAction;
    tbMain: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton8: TToolButton;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    ToolButton12: TToolButton;
    ToolButton13: TToolButton;
    ToolButton14: TToolButton;
    ToolButton15: TToolButton;
    ToolButton16: TToolButton;
    ToolButton17: TToolButton;
    ToolButton7: TToolButton;
    ToolButton18: TToolButton;
    tbFont: TToolButton;
    ToolButton6: TToolButton;
    ToolButton9: TToolButton;
    ToolButton19: TToolButton;
    ToolButton20: TToolButton;
    procedure FormCreate(Sender: TObject);
    procedure LastBroker1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure mnuFontSizeClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure UMShowPage(var Message: TMessage); message UM_SHOWPAGE;
    procedure WMSetFocus(var Message: TMessage); message WM_SETFOCUS;
    procedure FormDestroy(Sender: TObject);
    procedure Contents1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure acPtSelectorExecute(Sender: TObject);
    procedure acNoteCreateExecute(Sender: TObject);
    procedure acNewGroupNoteExecute(Sender: TObject);
    procedure WindowClose1Execute(Sender: TObject);
    procedure acExitGNExecute(Sender: TObject);
    procedure acOneClickExecute(Sender: TObject);
    procedure acTopToolbarExecute(Sender: TObject);
    procedure acAboutExecute(Sender: TObject);
    procedure acLastRPCExecute(Sender: TObject);
    procedure acHelpPositionExecute(Sender: TObject);
    procedure acInquiryPositionExecute(Sender: TObject);
    procedure acShowDisabledExecute(Sender: TObject);
    procedure acChangeLogExecute(Sender: TObject);
    procedure acDebugLayoutExecute(Sender: TObject);
    procedure ac8Execute(Sender: TObject);
    procedure ac10Execute(Sender: TObject);
    procedure ac12Execute(Sender: TObject);
    procedure ac18Execute(Sender: TObject);
    procedure ac14Execute(Sender: TObject);
  private
    FClosing: Boolean;
    FLastPage: TfrmPage;
    procedure ChangeFont(aNewFontSize: Integer);
    procedure timeOutAction;
    procedure setActionStatus;
  public
    property Closing: Boolean read fClosing;
    procedure SwitchTo(NewForm: TfrmPage);
    procedure _UM_GNSELECT(var Message: TMessage); message UM_GNSELECT;
    procedure _UM_GNDEBUG(var Message: TMessage); message UM_GNDEBUG;
  end;

var
  frmMainFrame: TfrmMainFrame;
  CloseFromMain: boolean = False;
  DEAContext: Boolean = False;
  DelayReviewChanges: Boolean = False;

procedure GroupNotes;

implementation

{$R *.dfm}

uses ORNet, ORFn,
  fGN_PtSel, fGN_Encounter, fxBroker, rMisc, rGN_Core, VAUtils
  , uGN_Utils, fGN_GroupEncounter, fGN_About, fEncounterFrame, uGN_ChangeLog,
  fRptBox, dmGN_Common, fGN_SelectedPatients;

procedure GroupNotes;
begin
  if not assigned(frmMainFrame) then
    Application.CreateForm(TfrmMainFrame,frmMainFrame);
  frmMainFrame.ShowModal;
end;

procedure TfrmMainFrame.FormCreate(Sender: TObject);
begin
  if not ConnectToServer('OR CPRS GUI CHART') or
    not IsCorrectVersion({$IFDEF DEBUG}True {$ELSE}False{$ENDIF}) then
    Application.Terminate
  else
  begin
    SizeHolder := TSizeHolder.Create; // 2FA - adding SizeHolder

    User := TUser.Create;
    Encounter := TEncounter.Create;

    Changes := TChanges.Create;
    if User.IsProvider then
    begin
      Encounter.Provider := User.DUZ;
      // 2FA      Encounter.ProviderName := User.Name;
    end;
    Caption := TX_IN_USE + MixedCase(User.Name) + '  (' +
      RPCBrokerV.Server + ')';

     sbMain.Panels[1].Text := MixedCase(User.Name);
     sbMain.Panels[2].Text := RPCBrokerV.Server + ':' + IntToStr(RPCBrokerV.ListenerPort);

    frmGNPtSel := TfrmGNPtSel.Create(self);
    setFormParented(frmGNPtSel, pnlPage);
    frmGNPtSel.OneClick := OneClickSelection1.Checked;

    frmGNEncounter := TfrmGNEncounter.Create(self);
    frmGNEncounter.Parent := pnlPage;
    frmGNEncounter.Align := alClient;
    frmGNEncounter.BorderStyle := bsNone;
//    setFormParented(frmGNEncounter,pnlPage);

    Application.ShowHint := True;
    // rpk 1/21/2012                         ICD-10

    ChangeFont(UserFontSize);
    SetUserBounds(TControl(frmMainFrame));

    SwitchTo(frmGNPtSel);

    GImplementationDate := GetImplementationDate();
    // rpk 2/14/2012       ICD-10

    InitTimeOut(nil, timeOutAction);
    UpdateTimeOutInterval(User.DTIME * 1000); // DTIME * 1000 mSec

    if acHelpPosition.Checked then
      MenuItemMoveRight(mnuGNMain.Handle, Help1.Command);

    MenuItemMoveRight(mnuGNMain.Handle, Debug1.Command);
  end;
end;

procedure TfrmMainFrame.FormDestroy(Sender: TObject);
begin
  Encounter.Free;
  User.Free;
//  Patient.Free;
  SizeHolder.Free; // 2FA - added component
  inherited;
end;

procedure TfrmMainFrame.SwitchTo(NewForm: TfrmPage);
begin
  if FLastPage <> NewForm then
  begin
    if (FLastPage <> nil) then
    begin
      if assigned(FLastPage.Menu) then
        mnuGNMain.Unmerge(FLastPage.Menu);
      FLastPage.Hide;
    end;
    if assigned(NewForm) then
    begin
      if assigned(NewForm.Menu) then
        mnuGNMain.Merge(NewForm.Menu);
      NewForm.Show;
    end;
    FLastPage := NewForm;
    if NewForm <> nil then
    begin
      NewForm.BringToFront;
      NewForm.FocusFirstControl;
      Application.ProcessMessages;
    end;
  end;

  if acHelpPosition.Checked then
    MenuItemMoveRight(mnuGNMain.Handle, Help1.Command);
  MenuItemMoveRight(mnuGNMain.Handle, Debug1.Command);

  MenuItemMoveRight(mnuGNMain.Handle, frmGNEncounter.Debug1.Command);

  PostMessage(Handle, UM_SHOWPAGE, 0, 0);
  setActionStatus;
end;

procedure TfrmMainFrame.LastBroker1Click(Sender: TObject);
begin
  ShowBroker;
end;

procedure TfrmMainFrame.ac10Execute(Sender: TObject);
begin
  inherited;
  ChangeFont(10);
end;

procedure TfrmMainFrame.ac12Execute(Sender: TObject);
begin
  inherited;
  ChangeFont(12);

end;

procedure TfrmMainFrame.ac18Execute(Sender: TObject);
begin
  inherited;
  ChangeFont(18);
end;

procedure TfrmMainFrame.ac8Execute(Sender: TObject);
begin
  inherited;
  ChangeFont(8);
end;

procedure TfrmMainFrame.acAboutExecute(Sender: TObject);
begin
  inherited;
  ShowAbout;
end;

procedure TfrmMainFrame.acChangeLogExecute(Sender: TObject);
begin
  inherited;
{$IFDEF DEBUG}
  ReportBox(ChangeLog,'Change Log',False);
{$ENDIF}
end;

procedure TfrmMainFrame.acDebugLayoutExecute(Sender: TObject);
begin
  inherited;
  acDebugLayout.Checked := not acDebugLayout.Checked;

  if assigned(frmGNEncounter) then
    begin
      frmGNEncounter.acDebugView.Checked := acDebugLayout.Checked;
      if acDebugLayout.Checked  then
        frmGNEncounter.setLayout('DEBUG')
      else
        frmGNEncounter.setLayout('');
    end;
  if assigned(frmGNPtSel) then
    frmGNPtSel.bvlTool.Visible := not acDebugLayout.Checked;

  sbMain.Visible := acDebugLayout.Checked;

  if acDebugLayout.Checked then
    begin
      pnlToolbar.Align := alTop;
      bvlTool.Align := alTop;
      Caption := 'Group Notes/Encounters';
    end
  else
    begin
      pnlToolbar.Align := alBottom;
      bvlTool.Align := alBottom;
      Caption := TX_IN_USE + MixedCase(User.Name) + '  (' +
        RPCBrokerV.Server + ')';
    end;

  acTopToolbar.Checked := acDebugLayout.Checked;
  tbMain.Visible := acDebugLayout.Checked;
  pnlToolbar.Visible := not acDebugLayout.Checked;

  width := width + 1;
  Application.ProcessMessages;
  width := width -1;
end;

procedure TfrmMainFrame.acExitGNExecute(Sender: TObject);
begin
  inherited;
  Close;
end;

procedure TfrmMainFrame.acHelpPositionExecute(Sender: TObject);
begin
  inherited;
  acHelpPosition.Checked := not acHelpPosition.Checked;
  if acHelpPosition.Checked then
    begin
      MenuItemMoveRight(mnuGNMain.Handle, Help1.Command);
      acHelpPosition.Enabled := false;
    end;
  MenuItemMoveRight(mnuGNMain.Handle, Debug1.Command);
end;

procedure TfrmMainFrame.acInquiryPositionExecute(Sender: TObject);
begin
  inherited;
  acInquiryPosition.Checked := not acInquiryPosition.Checked;
  if assigned(frmGNPtSel) then
    frmGNPtSel.InquiryPosition(acInquiryPosition.Checked);
end;

procedure TfrmMainFrame.acLastRPCExecute(Sender: TObject);
begin
  inherited;
  ShowBroker;
end;

procedure TfrmMainFrame.acNewGroupNoteExecute(Sender: TObject);
begin
  if assigned(frmGNEncounter) then
    frmGNEncounter.DoStartOver;
end;

procedure TfrmMainFrame.acNoteCreateExecute(Sender: TObject);
begin
  if GNPtList.Count < 1 then
    MessageDlg(TXT_NOSELECT, mtWarning, [mbOK], 0)
  else
    begin
      if assigned(frmGN_GroupEncounter) then
        frmGN_GroupEncounter.setEncounter;

      SwitchTo(frmGNEncounter);
      StartOver := False;

      if acDebugLayout.Checked then
        frmGNEncounter.setLayout('DEBUG')
      else
        frmGNEncounter.setLayout('');
    end;
end;

procedure TfrmMainFrame.acOneClickExecute(Sender: TObject);
begin
  inherited;
  acOneClick.Checked := not acOneClick.Checked;
  if assigned(frmGNPtSel) then
    frmGNPtSel.OneClick := acONeClick.Checked;
end;

procedure TfrmMainFrame.acPtSelectorExecute(Sender: TObject);
begin
  with frmGNEncounter do
    begin
      if not GroupEdit then
      begin
        if lstPatients.ItemIndex > -1 then
          SelectedPatient :=
            TPatient(lstPatients.Items.Objects[lstPatients.ItemIndex]).DFN;
      end;
      if GroupEdit then
        SelectedPatient := '';
      tbAllPatients.Down := False;
      GroupEdit := False;
    end;
  SwitchTo(frmGNPtSel);
end;

procedure TfrmMainFrame.acShowDisabledExecute(Sender: TObject);
begin
  inherited;
  acShowDisabled.Checked := not acShowDisabled.Checked;
  setActionStatus;
end;

procedure TfrmMainFrame.ac14Execute(Sender: TObject);
begin
  inherited;
  ChangeFont(14);
end;

procedure TfrmMainFrame.acTopToolbarExecute(Sender: TObject);
begin
  inherited;
  acTopToolbar.Checked := not acTopToolbar.Checked;
  if acTopToolbar.Checked then
    begin
      pnlToolbar.Align := alTop;
      bvlTool.Align := alTop;
    end
  else
    begin
      pnlToolbar.Align := alBottom;
      bvlTool.Align := alBottom;
    end;
end;

procedure TfrmMainFrame.ChangeFont(aNewFontSize: Integer);
var
  i: Integer;
begin
  i := aNewFontSize;

    Screen.MenuFont.Size := i;

  Font.Size := i;
  Repaint;
  if Assigned(frmGNPtSel) then
    frmGNPtSel.SetFontSize(aNewFontSize);
  if Assigned(frmGNEncounter) then
    frmGNEncounter.SetFontSize(aNewFontSize);

  pnlToolbar.Height := 18 +  // default margins for panel and buttons
    getMainFormTextHeight;

  N8pt1.Checked := i = 8;
  N10pt1.Checked := i = 10;
  N12pt1.Checked := i = 12;
  N14pt1.Checked := i = 14;
  N18pt1.Checked := i = 18;

  ac8.Checked := i = 8;
  ac10.Checked := i = 10;
  ac12.Checked := i = 12;
  ac14.Checked := i = 14;
  ac18.Checked := i = 18;


  for i := 0 to pnlToolbar.ControlCount - 1 do
    if (pnlToolbar.Controls[i] is TBitBtn) and
      (TBitBtn(pnlToolbar.Controls[i]).Tag = 0) then
      adjustBitBtn(TBitBtn(pnlToolbar.Controls[i]));

  tbFont.Caption := 'Font: '+IntToStr(aNewFontSize);
end;

procedure TfrmMainFrame.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FClosing := True;
  try
    ShutDownTimeout;
  except on e: exception do
    InfoBox(E.Message, 'Error', MB_OK);
  end;

  CleanGNPtList;
  SaveUserBounds(self);
  CloseFromMain := True;
end;

procedure TfrmMainFrame.mnuFontSizeClick(Sender: TObject);
{
  procedure smfs(aSize:Integer);
  var
    ncm: TNonClientMetrics;
    ppi: Integer;
  begin
    ncm.cbSize := sizeOf(TnonClientMetrics);
    SystemParametersInfo(SPI_GETNONCLIENTMETRICS,
      sizeOf(NONCLIENTMETRICS), @ncm, 0);
    ppi := GetDeviceCaps(GetDC(0), LOGPIXELSY);
    ncm.lfMenuFont.lfHeight := -MulDiv(aSize,ppi, 72);

    SystemParametersInfo(SPI_GETNONCLIENTMETRICS,
      sizeOf(NONCLIENTMETRICS), @ncm, SPIF_UPDATEINIFILE);
  end;
}

begin
  with Sender as TMenuItem do
    ChangeFont(Tag);
end;

procedure TfrmMainFrame.FormResize(Sender: TObject);
begin
  sbMain.Panels[1].Width := 24 + Canvas.TextWidth(sbMain.Panels[1].Text);
  sbMain.Panels[2].Width := 24 + Canvas.TextWidth(sbMain.Panels[2].Text);
  sbMain.Panels[0].Width := sbMain.Width -  sbMain.Panels[1].Width -  sbMain.Panels[2].Width;
  self.Repaint;
end;

procedure TfrmMainFrame.UMShowPage(var Message: TMessage);
begin
  if FLastPage <> nil then
    FLastPage.DisplayPage;
end;

procedure TfrmMainFrame.WindowClose1Execute(Sender: TObject);
begin
  inherited;
  close;
end;

procedure TfrmMainFrame.WMSetFocus(var Message: TMessage);
begin
  if (FLastPage <> nil) and (not(csDestroying in FLastPage.ComponentState)) and
    FLastPage.Visible then
    FLastPage.FocusFirstControl;
end;

procedure TfrmMainFrame.Contents1Click(Sender: TObject);
var
  RC: Integer;
  x, AFile, Param: String;
begin
  RC := 0;
  x := Contents1.Hint;
  AFile := Piece(x, ' ', 1);
  Param := Copy(x, Length(AFile) + 1, Length(x));
  try
    RC := ShellExecute(Handle, 'open', PChar(AFile), PChar(Param), '', SW_NORMAL);
  except
    on E: Exception do
    if RC < 32 then
      InfoBox('Error opening help file'+ CRLF+CRLF +
        E.Message + CRLF+ '(RC = '+IntToStr(RC) + ')', 'Error',MB_OK);
  end;
end;

procedure TfrmMainFrame.About1Click(Sender: TObject);
begin
  ShowAbout;
end;

procedure TfrmMainFrame.timeOutAction;
begin
  Close;
end;

procedure TfrmMainFrame.setActionStatus;
begin
  acPtSelector.Enabled :=
    (FLastPage <> frmGNPtSel);
  acNewGroupNote.Enabled :=
    (FLastPage <> frmGNPtSel);
  acNoteCreate.Enabled :=
    ((FLastPage = frmGNPtSel) and (GNPtList.Count>0));


  acPtSelector.Visible := acPtSelector.Enabled or acShowDisabled.Checked;
  acNewGroupNote.Visible := acNewGroupNote.Enabled or acShowDisabled.Checked;
  acNoteCreate.Visible := acNoteCreate.Enabled or acShowDisabled.Checked;
end;

procedure TfrmMainFrame._UM_GNSELECT(var Message: TMessage);
begin
  SetActionStatus;
end;

procedure TfrmMainFrame._UM_GNDEBUG(var Message: TMessage);
begin
  if assigned(frmEncounterFrame) then
    with frmEncounterFrame do
      begin
        mmLog.Visible := Message.WParam = 1;
        if mmLog.Visible then
          tabControl.Top := mmLog.Height;
    end;
  Application.ProcessMessages;
end;

{$IFDEF ICD10DEBUG}
procedure setParams;
var
  i: Integer;
begin
  for i := 0 to ParamCount do
  begin
    if UpperCase(ParamStr(i)) = '/ICD10DEBUG' then
      bICD10Debug := True;
  end;
end;

initialization

setParams;
{$ENDIF}

end.
