unit fGN_GroupEncounter;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, fBase508Form, Vcl.StdCtrls, ORDtTm,
  ORCtrls, Vcl.ExtCtrls, VA508AccessibilityManager, System.UITypes;

type
  TfrmGN_GroupEncounter = class(TfrmBase508Form)
    pnlEncounterGroupHeader: TPanel;
    Label4: TLabel;
    pnlEncounterGroupData: TPanel;
    Label3: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    cboPtProvider: TORComboBox;
    cboNewVisit: TORComboBox;
    dtVisit: TORDateBox;
    procedure cboPtProviderNeedData(Sender: TObject; const StartFrom: string;
      Direction, InsertAt: Integer);
    procedure cboNewVisitNeedData(Sender: TObject; const StartFrom: string;
      Direction, InsertAt: Integer);
    procedure dtVisitChange(Sender: TObject);
    procedure cboNewVisitExit(Sender: TObject);
    procedure cboNewVisitChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure setEncounter;
    procedure Init;
  end;

var
  frmGN_GroupEncounter: TfrmGN_GroupEncounter;

implementation

{$R *.dfm}
uses
  rCore, uCore, rPCE;

procedure TfrmGN_GroupEncounter.cboNewVisitChange(Sender: TObject);
begin
  inherited;
{  if not IsValidLocation(cboNewVisit.ItemIEN) then
  begin
    ShowMessage('Invalid location for Group Notes.');
    cboNewVisit.ItemIndex := -1;
    Exit;
  end;}
end;

procedure TfrmGN_GroupEncounter.cboNewVisitExit(Sender: TObject);
begin
  inherited;
  if cboNewVisit.ItemIEN < 1 then
    Exit;
  {if not IsValidLocation(cboNewVisit.ItemIEN) then
  begin
    ShowMessage('Invalid location for Group Notes.');
    cboNewVisit.ItemIndex := -1;
    cboNewVisit.SetFocus;
  end;}
end;

procedure TfrmGN_GroupEncounter.cboNewVisitNeedData(Sender: TObject;
  const StartFrom: string; Direction, InsertAt: Integer);
begin
  inherited;
  cboNewVisit.ForDataUse(SubSetOfNewLocs(StartFrom, Direction));
end;

procedure TfrmGN_GroupEncounter.cboPtProviderNeedData(Sender: TObject;
  const StartFrom: string; Direction, InsertAt: Integer);
begin
  inherited;
  cboPtProvider.ForDataUse(SubSetOfProviders(StartFrom, Direction));
end;

procedure TfrmGN_GroupEncounter.dtVisitChange(Sender: TObject);
begin
  inherited;
  if dtVisit.FMDateTime > FMNow then
  begin
{$IFDEF ICD10DEBUG}
    ///
    /// TEST ONLY; allow Encounters with an ICD-10 date >= FMNow.
    ///
    if bICD10Debug then
      MessageDlg('Future date/time is being used.'+#13#10+
        '(DEBUG version only)', mtInformation, [mbOK], 0)
    else
      begin
        MessageDlg('Future date/time is not allowed', mtWarning,[mbOK],0);
        dtVisit.FMDateTime := FMNow;
      end;
{$ELSE}
    MessageDlg('Future date/time is not allowed', mtWarning, [mbOK], 0);
    dtVisit.FMDateTime := FMNow;
{$ENDIF}
  end;
end;

procedure TfrmGN_GroupEncounter.setEncounter;
begin
  if trim(cboNewVisit.Text) = '' then
    cboNewvisit.ItemIndex := -1;
  if (cboNewVisit.ItemIndex > -1) then
  begin
    Encounter.Location := cboNewVisit.ItemIEN;
    Encounter.LocationName := cboNewVisit.Text;
    Encounter.VisitCategory := GetVisitCat('A', Encounter.Location, False);
  end
  else begin
    Encounter.Location := 0;
    Encounter.LocationName := '';
  end;
  if dtVisit.FMDateTime > 0 then
    Encounter.DateTime := dtVisit.FMDateTime;
  if cboPtProvider.ItemIEN > 0 then
  begin
    Encounter.Provider := cboPtProvider.ItemIEN;
{ $ IFDEF GROUPNOTES}
{ $ ELSE}
//    Encounter.ProviderName := cboPtProvider.Text;
{ $ ENDIF}
  end;
end;

procedure TfrmGN_GroupEncounter.Init;
begin
  cboNewVisit.LongList := True;
  cboNewVisit.InitLongList('');
  if (Encounter.Location > 0) then
    cboNewVisit.SelectByIEN(Encounter.Location);

  cboPtProvider.LongList := True;
  cboPtProvider.InitLongList(Encounter.ProviderName);
  cboPtProvider.SelectByIEN(Encounter.Provider);

  dtVisit.FMDateTime := FMNow;
end;
end.
