unit fGN_Encounter;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, ExtCtrls, ComCtrls, ORCtrls, fGN_MainFrame, StdCtrls, ORDtTm,
  fGN_Page, ORFn, uPCE, rPCE, uCore, rCore, uTIU, rTIU, uConst, rConsults,
  Menus, ToolWin, ActnList, fAddlSigners, System.Actions, System.UITypes
  , fGN_PtSel, System.ImageList, Vcl.ImgList
 ;

type
  TfrmGNEncounter = class(TfrmPage)
    pnlLeft: TPanel;
    lstPatients: TListBox;
    splPatients: TSplitter;
    pnlRight: TPanel;
    pnlEncounter: TPanel;
    txtPCEData: TRichEdit;
    pnlNote: TPanel;
    lblEnctInfo: TLabel;
    pnlBaseNote: TPanel;
    lblBaseNoteInfo: TLabel;
    memCommNote: TRichEdit;
    splNote: TSplitter;
    pnlSingleNote: TPanel;
    lblIndvNoteInfo: TLabel;
    memIndvNote: TRichEdit;
    mmEncounter: TMainMenu;
    mnBacktoPatientSelection: TMenuItem;
    StartNewGroupPatients1: TMenuItem;
    ActList: TActionList;
    actNewNote: TAction;
    actChangeNote: TAction;
    actSaveNoSig: TAction;
    actSignNote: TAction;
    actForAllPatients: TAction;
    actNewEncounter: TAction;
    actEditEncounter: TAction;
    CoolBar1: TCoolBar;
    ToolBar1: TToolBar;
    tbAllPatients: TToolButton;
    ToolButton1: TToolButton;
    tbNewNote: TToolButton;
    tbChangeNote: TToolButton;
    tbSaveNoSig: TToolButton;
    tbSignNote: TToolButton;
    tbNewEncounter: TToolButton;
    tbEditEncounter: TToolButton;
    pnlBasicEncounter: TPanel;
    lblBasicEnct: TLabel;
    lblSignature: TLabel;
    tbAdditionalSigner: TToolButton;
    mnAction: TMenuItem;
    mnNewProgressNote: TMenuItem;
    mnChangeTitle: TMenuItem;
    mnSavewithoutSignature: TMenuItem;
    mnSignNoteNow: TMenuItem;
    mnIdentifyAdditionalSigners: TMenuItem;
    mnNewEncounter: TMenuItem;
    mnEditEncounter: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    mnForAllPatients: TMenuItem;
    N7: TMenuItem;
    popMenu: TPopupMenu;
    pm3ForAllPatients: TMenuItem;
    MenuItem2: TMenuItem;
    pm3NewNote: TMenuItem;
    pm3ChangeTitle: TMenuItem;
    MenuItem7: TMenuItem;
    pm3NewEncounter: TMenuItem;
    pm3EditEncounter: TMenuItem;
    MenuItem10: TMenuItem;
    pm3SaveWithoutSignature: TMenuItem;
    pm3SignNote: TMenuItem;
    pm3IdentifyAdditionalSigner: TMenuItem;
    actIdentifyAdditionalSigner: TAction;
    N10: TMenuItem;
    ChangeNote1: TMenuItem;
    bbUpdate: TBitBtn;
    acUpdateBasicEncounter: TAction;
    N3: TMenuItem;
    Update1: TMenuItem;
    pnlDetails: TPanel;
    mmDetails: TMemo;
    acDebug: TAction;
    splDetails: TSplitter;
    pnlDebugTools: TPanel;
    acDebugView: TAction;
    pnlSignature: TPanel;
    sbNoteSign: TSpeedButton;
    sbUpdate: TSpeedButton;
    pnlNoteTools: TPanel;
    sbNoteNew: TSpeedButton;
    pnlEncounterTools: TPanel;
    sbEncounterNew: TSpeedButton;
    pnlPatient: TPanel;
    lblPatient: TLabel;
    lblNoteShared: TLabel;
    lblNote: TLabel;
    ckbForAll: TCheckBox;
    acDebugShowToolbar: TAction;
    Debug1: TMenuItem;
    splEncounter: TSplitter;
    pnlCosigners: TPanel;
    reCosigners: TRichEdit;
    pnlCosignersTools: TPanel;
    sbSignersAdd: TSpeedButton;
    lblCosigners: TLabel;
    splCosigners: TSplitter;
    bvlBasicInfo: TBevel;
    pnlNoteShared: TPanel;
    sbSaveNoSign: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure lstPatientsDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure FormShow(Sender: TObject);
    procedure lstPatientsClick(Sender: TObject);
    procedure pnlAllPatientsClick(Sender: TObject);
    procedure btnPrevClick(Sender: TObject);
    procedure memCommNoteExit(Sender: TObject);
    procedure memIndvNoteExit(Sender: TObject);
    procedure btnStartOverClick(Sender: TObject);
    procedure pm1SpellcheckClick(Sender: TObject);
    procedure pm1GrammarCheckClick(Sender: TObject);
    procedure pm2GrammarCheckClick(Sender: TObject);
    procedure pm2SpellCheckClick(Sender: TObject);
    procedure actNewNoteExecute(Sender: TObject);
    procedure actForAllPatientsExecute(Sender: TObject);
    procedure actChangeNoteExecute(Sender: TObject);
    procedure actSignNoteExecute(Sender: TObject);
    procedure actNewEncounterExecute(Sender: TObject);
    procedure memCommNoteEnter(Sender: TObject);
    procedure memIndvNoteEnter(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure actIdentifyAdditionalSignerExecute(Sender: TObject);
    procedure actSaveNoSigExecute(Sender: TObject);
    procedure memCommNoteKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure pnlBaseNoteResize(Sender: TObject);
    procedure pnlSingleNoteResize(Sender: TObject);
    procedure acUpdateBasicEncounterExecute(Sender: TObject);
    procedure acDebugExecute(Sender: TObject);
    procedure pnlLeftResize(Sender: TObject);
    procedure acDebugViewExecute(Sender: TObject);
    procedure acDebugShowToolbarExecute(Sender: TObject);
    procedure FormHide(Sender: TObject);
  private
    FVerifyNoteTitle: Integer;
    FSignRst: string;
    FChangeNote: boolean;
    FSigned: boolean;
    //PCE section
    procedure RemovePCEFromChanges(IEN: Int64; AVisitStr: string = '');
    function EditPCEData(APatientData: TPatientData): boolean;
    //note section
    procedure populatePtList;
    function SaveEachNote(APatientData: TPatientData): Boolean;
    function NewNoteForIndividualPatient(APatientData: TPatientData):Boolean;
//    procedure SaveEditedNote(var Saved: boolean; APatientData: TPatientData);
    function LacksRequiredForCreate (ANote: TEditNoteRec): Boolean;
    function VerifyNoteTitle: Boolean;
    function LockNote(AnIEN: Int64): Boolean;
    procedure MakeEncounterEnable(TheEnable: boolean);
    procedure ShowBasicEnctInfo;
//    procedure AdditionalSignerForSingleNote(aPatientData:TPatientData);
    function NeedTOSign: boolean;
    procedure DeleteCurrentNotes(onlyEmptyNotes: boolean);
    //casecade update through different controls
    procedure UpdateControlsAfterSign(IsSigned: boolean);

    procedure NoteEnable(aNote: TRichEdit;TheEnable: boolean);
    procedure SelectPatientByDFN(aDFN:String);
    procedure ShowPatientInfo(aPatientData:TPatientData;ShowEncounter: Boolean=false);

    function SaveWithoutSigning:Boolean;

{$IFDEF DEBUG}
    procedure LogUpdate(aText:String);
    procedure LogClear;
    procedure UpdateDebugInfo(aPatientData:TPatientData;anEncounter:TEncounter;aClear: Boolean = TRUE);overload;
    procedure UpdateDebugInfo(aPatientData:TPatientData); overload;
    procedure UpdateDebugInfo(anEncounter:TEncounter); overload;
{$ENDIF}
    procedure BasicEncounterUpdate;

  public
    procedure SetFontSize( FontSize: integer); override;
    function GetPatientData(APatient: TPatient): TPatientData; overload;
    function GetPatientData(APatientDFN: String): TPatientData; overload;
    procedure SetPatientData(APatient: TPatient; APCEData: TPCEData; ANote: TEditNoteRec); overload;
    procedure SetPatientData(APatient: TPatient; ANote: TEditNoteRec); overload;

    procedure DoStartOver;
    procedure setLayout(aLayout:String);
    procedure setActionStatus(aStatus:Boolean);
  end;

var
  frmGNEncounter: TfrmGNEncounter;
  SelectedPatient: string; // remember highlighted patient on individual patient edit
  StartOver: boolean;

implementation

uses
fEncnt,
fNoteProps,
fSignItem
, uSpell
, fGN_NoteDeleteReason
, rGN_Core
, fEncounterFrame
, uGN_Utils, uGN_ChangeLog, dmGN_Common;

{$R *.dfm}
const
  NT_NEW_NOTE = -10;                             // Holder IEN for a new note
  NT_ADDENDUM = -20;                             // Holder IEN for a new addendum

  TX_CREATE_ERR = 'Error Creating Note';
  TX_COSIGN     = 'Cosign Note';
  TX_SIGN       = 'Sign Note';
  TX_AUTH_SIGNED    = 'Author has not signed, are you SURE you want to sign.' +CRLF;
  TX_ABSAVE       = 'It appears the session terminated abnormally when this' + CRLF +
                    'note was last edited. Some text may not have been saved.' + CRLF + CRLF +
                    'Do you wish to continue and sign the note?';
  TX_UNSIGNNOTES  = 'There are unsigned notes for group patients, would you like to sign them?';
  TC_ABSAVE       = 'Possible Missing Text';
  TC_NO_LOCK      = 'Unable to Lock Note';


procedure TfrmGNEncounter.populatePtList;
var
  i: integer;
  APatient: TPatient;
begin
  lstPatients.Clear;
  for i := 0 to GNPtList.Count - 1 do
  begin
    APatient := TPatientData(GNPtList.Items[i]).Patient;
    lstPatients.AddItem(APatient.Name,APatient);
  end;

  SelectPatientByDFN(SelectedPatient);
end;

procedure TfrmGNEncounter.SelectPatientByDFN(aDFN: string);
var
  i: integer;
begin
  if Length(aDFN)>0 then
  begin
    for i := 0 to lstPatients.Items.Count - 1 do
    begin
      if TPatient(lstPatients.Items.Objects[i]).DFN = aDFN then
      begin
        lstPatients.ItemIndex := i;
        lstPatientsClick(Self);
      end;
    end;
  end;
end;

procedure TfrmGNEncounter.lstPatientsDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
begin
  with (Control as TListBox).Canvas do
  begin
    FillRect(Rect);
    TextOut(Rect.Left,Rect.Top,(Control as TListBox).Items[Index]);
  end;
end;

procedure TfrmGNEncounter.FormShow(Sender: TObject);
begin
  inherited;
  NoteEnable(memCommNote,False);
  NoteEnable(memIndvNote,False);
  MakeEncounterEnable(False);
  populatePtList;
  ShowBasicEnctInfo;

  if lstPatients.Items.Count = 1 then   // select the only patient
    begin
      if tbAllPatients.Down then
        actForAllPatientsExecute(lstPatients);
      lstPatients.ItemIndex := 0;
    end
   else
     tbAllPatients.Click;

  actNewNote.Enabled := True;
  actChangeNote.Enabled := False;
  actSaveNoSig.Enabled := False;
  actSignNote.Enabled := False;
  actForAllPatients.Enabled := True;
  actNewEncounter.Enabled := True;
  actEditEncounter.Enabled := False;
  actIdentifyAdditionalSigner.Enabled := False;
  acUpdateBasicEncounter.Enabled := True;
end;

procedure TfrmGNEncounter.SetFontSize(FontSize: integer);
var
  i: Integer;
begin
  inherited;
  i := canvas.TextHeight('TEXT')+ 12;   // 2FA
  CoolBar1.Bands[0].MinHeight := i     // 2FA
end;

function TfrmGNEncounter.LacksRequiredForCreate(ANote: TEditNoteRec): boolean;
var
  CurTitle: Integer;
begin
  Result := False;
  with ANote do
  begin
    if Title <= 0 then
      Result := True;
    if Author <= 0 then
      Result := True;
    if DateTime <= 0 then
      Result := True;
    if IsConsultTitle(Title) and (PkgIEN = 0) then
      Result := True;
    if (DocType = TYP_ADDENDUM) then
    begin
      if AskCosignerForDocument(Addend, Author, DateTime { 2FA } ) and
        (Cosigner <= 0) then
        Result := True;
    end
    else
    begin
      if Title > 0 then
        CurTitle := Title
      else
        CurTitle := DocType;
      if AskCosignerForTitle(CurTitle, Author, DateTime { 2FA } ) and
        (Cosigner <= 0) then
        Result := True;
    end;
  end;
end;

function TfrmGNEncounter.VerifyNoteTitle: boolean;
const
  VNT_UNKNOWN = 0;
  VNT_NO = 1;
  VNT_YES = 2;
var
  AParam: string;
begin
  if FVerifyNoteTitle = VNT_UNKNOWN then
  begin
    AParam := GetUserParam('ORWOR VERIFY NOTE TITLE');
    if AParam = '1' then
      FVerifyNoteTitle := VNT_YES
    else
      FVerifyNoteTitle := VNT_NO;
  end;
  Result := FVerifyNoteTitle = VNT_YES;
end;

function TfrmGNEncounter.GetPatientData(APatient: TPatient): TPatientData;
begin
  Result := nil;
  if assigned(aPatient) then
    Result := getPatientData(aPatient.DFN);
end;

function TfrmGNEncounter.GetPatientData(APatientDFN: String): TPatientData;
var
  i: integer;
begin
  Result := nil;
  for i := 0 to GNPtList.Count - 1 do
  begin
    if ( TPatientData(GNPtList.Items[i]).Patient.DFN = APatientDFN ) then
      begin
        Result := TPatientData(GNPtList.Items[i]);
        break;   // assuming there are no duplicates
      end;
  end;
end;

procedure TfrmGNEncounter.SetPatientData(APatient: TPatient;
  APCEData: TPCEData; ANote: TEditNoteRec);
var
  i: integer;
begin
  for i := 0 to GNPTList.Count - 1 do
  begin
    if (TPatientData(GNPTList.Items[i]).Patient.DFN = APatient.DFN) then
    begin
      APCEData.CopyPCEData(TPatientData(GNPTList.Items[i]).PCEData);
      TPatientData(GNPtList.Items[i]).PtNote := ANote;
    end;
  end;
end;

procedure TfrmGNEncounter.SetPatientData(APatient: TPatient;
  ANote: TEditNoteRec);
var
  i: integer;
begin
  for i := 0 to GNPTList.Count - 1 do
  begin
    if (TPatientData(GNPTList.Items[i]).Patient.DFN = APatient.DFN) then
      TPatientData(GNPtList.Items[i]).PtNote := ANote;
  end;
end;

function TfrmGNEncounter.SaveEachNote(APatientData: TPatientData):Boolean;
var
  UpdatedNote: TCreatedDoc;
begin
  inherited;
  Result := False;
  if APatientData.PtNote.Lines.Count = 0 then
  begin
    InfoBox('Empty note, can not save!', 'Save Note', MB_OK);
  end
  else
  begin
    UpdatedNote.IEN := APatientData.PtNote.NoteIEN;
    UpdatedNote.ErrorText := APatientData.PtNote.ErrTxt;
    PutEditedNote(UpdatedNote, APatientData.PtNote,APatientData.PtNote.NoteIEN);
    Result := UpdatedNote.IEN > 0;
  end;
end;

procedure TfrmGNEncounter.RemovePCEFromChanges(IEN: Int64; AVisitStr: string);
begin
  if IEN = NT_ADDENDUM then
    Exit; // no PCE information entered for an addendum
  // do we need to call DeletePCE(AVisitStr), as was done with NT_NEW_NOTE (ien=-10)???
  if AVisitStr = '' then
    AVisitStr := VisitStrForNote(IEN);

  Changes.Remove(CH_PCE, 'V' + AVisitStr);
  Changes.Remove(CH_PCE, 'P' + AVisitStr);
  Changes.Remove(CH_PCE, 'D' + AVisitStr);
  Changes.Remove(CH_PCE, 'I' + AVisitStr);
  Changes.Remove(CH_PCE, 'S' + AVisitStr);
  Changes.Remove(CH_PCE, 'A' + AVisitStr);
  Changes.Remove(CH_PCE, 'H' + AVisitStr);
  Changes.Remove(CH_PCE, 'E' + AVisitStr);
  Changes.Remove(CH_PCE, 'T' + AVisitStr);
end;

function TfrmGNEncounter.EditPCEData(APatientData: TPatientData): boolean;
const
//  TX_NEED_VISIT2 = 'A visit is required before entering encounter information.';
  TX_NOPCE_TXT   = 'You can not edit encounter information because ';
  TX_NOPCE_TXT1  = 'the encounter date is in the future.';
  TX_NOPCE_TXT2  = 'encounter entry has been disabled.';
  TX_NOPCE_HDR   = 'Can not edit encounter';
var
  txt: string;
begin
  Result := False;
  if Assigned(APatientData.PCEData) then
  begin
    if not CanEditPCE(APatientData.PCEData) then
    begin
      if FutureEncounter(APatientData.PCEData) then
        txt := TX_NOPCE_TXT1
      else
        txt := TX_NOPCE_TXT2;
      InfoBox(TX_NOPCE_TXT + txt, TX_NOPCE_HDR, MB_OK or MB_ICONWARNING);
      // Exit;
    end
    else
    begin
      UpdatePCE(APatientData.PCEData);
      if not GroupEdit then
        APatientData.PCEData := uEncPCEData;
      Result := True;
    end;
  end
end;

procedure TfrmGNEncounter.ShowPatientInfo(APatientData: TPatientData;
  ShowEncounter: boolean = False);
var
  s: String;
begin
  s := '';
  if assigned(aPatientData) then
    s := APatientData.Patient.Name + ' (' + APatientData.Patient.SSN + ') ';

  lblNote.Visible := pnlPatient.Visible;
  pnlNoteShared.Visible := pnlPatient.Visible;

  if pnlPatient.Visible then
    begin
      lblBaseNoteInfo.Caption := 'Title: ' + APatientData.PtNote.TitleName;
      lblIndvNoteInfo.Caption := 'Title: ' + APatientData.PtNote.TitleName;
      lblIndvNoteInfo.Visible := false;
      if ShowEncounter then
        lblEnctInfo.Caption := 'Encounter data for ' + s;
    end
  else
    begin
      lblBaseNoteInfo.Caption := 'Common note content for ' +  s +
        ' Title: ' + APatientData.PtNote.TitleName;
      lblIndvNoteInfo.Caption := 'Additional note text for ' + s +
        ' Title: ' + APatientData.PtNote.TitleName;

      if ShowEncounter then
        lblEnctInfo.Caption := 'Encounter data for ' + s;
    end;

  if s = '' then
    s := 'No Patient selected'
  else
    s := 'Patient: '+s;
  lblPatient.Caption := s;
end;

{$IFDEF DEBUG}
procedure TfrmGNEncounter.LogUpdate(aText: string);
begin
  mmDetails.Lines.text := mmDetails.Lines.text + CRLF +  aText;
//  AppLogAdd(aText);
end;

procedure TfrmGNEncounter.LogClear;
begin
  mmDetails.Lines.Clear;
end;

procedure TfrmGNEncounter.UpdateDebugInfo(aPatientData:TPatientData);
begin
  if assigned(aPatientData) then
    LogUpdate(EditNoteRecToStr(aPatientData.PtNote)+CRLF)
  else
    LogUpdate('Patient Data not assigned'+CRLF);
end;

procedure TfrmGNEncounter.UpdateDebugInfo(anEncounter:TEncounter);
begin
  LogUpdate(EncounterToStr(anEncounter)+CRLF);
end;

procedure TfrmGNEncounter.UpdateDebugInfo(aPatientData:TPatientData;anEncounter:TEncounter;aClear: Boolean = TRUE);
begin
  if aClear then
    LogClear;

  UpdateDebugInfo(aPatientData);
  UpdateDebugInfo(anEncounter);
end;
{$ENDIF}
procedure TfrmGNEncounter.lstPatientsClick(Sender: TObject);
var
  i: integer;
  APatient: TPatient;
  APatientData: TPatientData;

begin
  inherited;
  i := lstPatients.ItemIndex;
  lstPatients.MultiSelect := False;
  ckbForAll.Checked := i < 0;
  if i > - 1 then
  begin
    txtPCEData.Lines.Clear;
    memCommNote.Lines.Clear;
    memIndvNote.Lines.Clear;
    GroupEdit := False;
    if tbAllPatients.Down then
      tbAllPatients.Down := False;

    APatient := TPatient(lstPatients.Items.Objects[i]);
    APatientData := GetPatientData(APatient);
    if APatientData.PCEData.HasData then
    begin
      actNewEncounter.Enabled := False;
      if not FSigned then
        actEditEncounter.Enabled := True;
      APatientData.PCEData.AddStrData(txtPCEData.Lines);
    end else
    begin
      if not FSigned then
      begin
        actNewEncounter.Enabled := True;
        actEditEncounter.Enabled := False;
      end;
    end;
{$IFDEF DEBUG}
    UpdateDebugInfo(aPatientData,Encounter,TRUE);
{$ENDIF}
    if APatientData.PtNote.NoteIEN > 0 then
    begin
      if not FSigned then
      begin
        NoteEnable(memCommNote,False);
        NoteEnable(memIndvNote,True);
      end;
{ AA: Moved outside of "if"
      if Assigned(APatientData.PtNote.GenLines) then
        memCommNote.Lines.Assign(APatientData.PtNote.GenLines);
      if Assigned(APatientData.PtNote.PtLines) then
        memIndvNote.Lines.Assign(APatientData.PtNote.PtLines);
}
    end else
    begin
      NoteEnable(memCommNote,False);
      NoteEnable(memIndvNote,True);// AA: was False
    end;

    if Assigned(APatientData.PtNote.GenLines) then
      memCommNote.Lines.Assign(APatientData.PtNote.GenLines);
    if Assigned(APatientData.PtNote.PtLines) then
      memIndvNote.Lines.Assign(APatientData.PtNote.PtLines);

    ShowPatientInfo(aPatientData,True);
    actChangeNote.Enabled := False;
  end;
end;

procedure TfrmGNEncounter.pnlAllPatientsClick(Sender: TObject);
begin
  inherited;
  GroupEdit := not GroupEdit;
  if GroupEdit then
  begin
    lstPatients.MultiSelect := True;
    lstPatients.SelectAll;
    NoteEnable(memIndvNote,False);
  end
  else
  begin
    lstPatients.MultiSelect := False;
    lstPatients.ClearSelection;
  end;
end;

procedure TfrmGNEncounter.btnPrevClick(Sender: TObject);
begin
  inherited;
  if not GroupEdit then
  begin
    if lstPatients.ItemIndex > -1 then
      SelectedPatient :=
        TPatient(lstPatients.Items.Objects[lstPatients.ItemIndex]).DFN;
  end;
  if GroupEdit then
    SelectedPatient := '';
  tbAllPatients.Down := False;
  GroupEdit := False;
  frmMainFrame.SwitchTo(frmGNPtSel);
end;

procedure TfrmGNEncounter.memCommNoteExit(Sender: TObject);
var
  i: Integer;
  APatientData: TPatientData;
begin
  inherited;
  if (memCommNote.ReadOnly) or (not memCommNote.Enabled) then
    Exit;
  if GroupEdit then
  begin
    for i := 0 to GNPtList.Count - 1 do
    begin
      APatientData := TPatientData(GNPtList.Items[i]);
      if assigned(APatientData.PtNote.GenLines) then
        APatientData.PtNote.GenLines.Clear
      else
        APatientData.PtNote.GenLines := TStringList.Create;
      APatientData.PtNote.GenLines.Assign(memCommNote.Lines);
      if assigned(APatientData.PtNote.Lines) then
        APatientData.PtNote.Lines.Clear
      else
        APatientData.PtNote.Lines := TStringList.Create;
      APatientData.PtNote.Lines.AddStrings(APatientData.PtNote.GenLines);
      if assigned(APatientData.PtNote.PtLines) then
        APatientData.PtNote.Lines.AddStrings(APatientData.PtNote.PtLines);
    end;
  end
  else
  begin
    if lstPatients.ItemIndex < 0 then
      Exit;
    APatientData := GetPatientData
      (TPatient(lstPatients.Items.Objects[lstPatients.ItemIndex]));
    if assigned(APatientData.PtNote.GenLines) then
      APatientData.PtNote.GenLines.Clear
    else
      APatientData.PtNote.GenLines := TStringList.Create;
    if assigned(APatientData.PtNote.Lines) then
      APatientData.PtNote.Lines.Clear
    else
      APatientData.PtNote.Lines := TStringList.Create;
    APatientData.PtNote.GenLines.Assign(memCommNote.Lines);
    APatientData.PtNote.Lines.AddStrings(APatientData.PtNote.GenLines);
    if assigned(APatientData.PtNote.PtLines) then
      APatientData.PtNote.Lines.AddStrings(APatientData.PtNote.PtLines);
  end;
end;

procedure TfrmGNEncounter.memIndvNoteExit(Sender: TObject);
var
  APatientData: TPatientData;
begin
  inherited;
  if (memIndvNote.ReadOnly) then Exit;
  if (lstPatients.ItemIndex < 0) then Exit;
  APatientData := GetPatientData(TPatient(lstPatients.Items.Objects[lstPatients.ItemIndex]));
  if Assigned(APatientData.PtNote.PtLines) then APatientData.PtNote.PtLines.Clear
  else APatientData.PtNote.PtLines := TStringList.Create;
  APatientData.PtNote.PtLines.Assign(memIndvNote.Lines);
  if Assigned(APatientData.PtNote.Lines) then APatientData.PtNote.Lines.Clear
  else APatientData.PtNote.Lines := TStringList.Create;
  if Assigned(APatientData.PtNote.GenLines) then
    APatientData.PtNote.Lines.AddStrings(APatientData.PtNote.GenLines);
  APatientData.PtNote.Lines.AddStrings(APatientData.PtNote.PtLines);
end;

procedure TfrmGNEncounter.btnStartOverClick(Sender: TObject);
begin
  DoStartOver;
end;

procedure TfrmGNEncounter.DoStartOver;
var
  i: integer;
begin
  inherited;
  if not FSigned then
  begin
    if Changes.Documents.Count > 0 then
    begin
      if  NeedToSign then
      begin
        if MessageDlg(TX_UNSIGNNOTES,mtWarning,[mbYes, mbNo],0) = mrNo then
        begin
          DeleteCurrentNotes(True);  // automatically delete empty notes
          actSaveNoSigExecute(Self);
          Changes.Clear;
        end
        else
        begin
          if tbSignNote.Enabled then
          begin
            DeleteCurrentNotes(True); // automatically delete empty notes
            actSignNoteExecute(Self);
          end;
        end
      end
      else
      begin
        DeleteCurrentNotes(False);
        Changes.Clear;
      end;
    end;
  end;
  if Assigned(GNPtlist) then
    for i := 0 to GNPtList.Count - 1 do
    begin
      TPatientData(GNPtList.Items[i]).Free;
    end;
  GNPtList.Clear;
  Changes.Clear;
  txtPCEData.Lines.Clear;
  memCommNote.Lines.Clear;
  NoteEnable(memCommNote,False);
  memIndvNote.Lines.Clear;
  NoteEnable(memIndvNote,False);

  lstPatients.ItemIndex := -1;
  lstPatients.Items.Clear;
  SelectedPatient := '';

  GroupEdit := False;
  StartOver := True;

  actNewNote.Enabled := True;
  actChangeNote.Enabled := False;
  actSaveNoSig.Enabled := False;
  actSignNote.Enabled := False;
  actEditEncounter.Enabled := False;
  actNewEncounter.Enabled := True;

  acUpdateBasicEncounter.Enabled := True;

  lblBaseNoteInfo.Caption := 'Progress note: content shared by all patients';
  lblIndvNoteInfo.Caption := 'Progress note: content for individual patient';
  FSigned := False;
  lblSignature.Caption := '';
  ClearNote(BaseNote);

  Changes.Clear;
  Encounter.Clear;
  BasePCE.Clear;
  frmMainFrame.SwitchTo(frmGNPtSel{, PG_GNECTER});
end;

procedure TfrmGNEncounter.pm1SpellcheckClick(Sender: TObject);
begin
  inherited;
  try
    SpellCheckForControl(memCommNote);
  finally
  end;
end;

procedure TfrmGNEncounter.pm1GrammarCheckClick(Sender: TObject);
begin
  inherited;
  try
    GrammarCheckForControl(memCommNote);
  finally
  end;
end;

procedure TfrmGNEncounter.pm2GrammarCheckClick(Sender: TObject);
begin
  inherited;
  try
    GrammarCheckForControl(memIndvNote);
  finally
  end;
end;

procedure TfrmGNEncounter.pm2SpellCheckClick(Sender: TObject);
begin
  inherited;
  try
    SpellCheckForControl(memIndvNote);
  finally
  end;
end;

procedure TfrmGNEncounter.FormCreate(Sender: TObject);
begin
  FChangeNote := False;
  FSigned := False;
  FSignRst := '';
  ShowBasicEnctInfo;
{$IFDEF DEBUG}
  acDebug.Visible := True;
{$ENDIF}
end;

procedure TfrmGNEncounter.FormHide(Sender: TObject);
begin
  inherited;
  setActionStatus(False);
end;

procedure TfrmGNEncounter.NoteEnable(aNote: TRichEdit;TheEnable: boolean);
begin
  aNote.Enabled := theEnable;
  aNote.ReadOnly := not theEnable;
  if TheEnable then
    aNote.Color := clWindow
  else
    aNote.Color := clBtnFace;
end;

procedure TfrmGNEncounter.MakeEncounterEnable(TheEnable: boolean);
begin
  txtPCEData.Enabled := TheEnable;
  txtPCEData.ReadOnly := True;
end;

procedure setNoteRecord(var aNote: TEditNoteRec);
begin
  with aNote do
  begin
    DocType      := TYP_PROGRESS_NOTE;
    IsNewNote    := True;
    Title        := DfltNoteTitle;
    TitleName    := DfltNoteTitleName;
    DateTime     := FMNow;
    Author       := User.DUZ;
    AuthorName   := User.Name;
    Location     := Encounter.Location;
    LocationName := Encounter.LocationName;
    VisitDate    := Encounter.DateTime;
  end;
end;

procedure setNoteRecordGenLines(aNoteRec: TEditNoteRec);
var
  SL: TStringList;
begin
  SL := nil;
  try
    SL := TStringList.Create;
    LoadBoilerPlate(SL, aNoteRec.Title);
    // save boilerplate text into note.genLines
    if SL.Count > 0 then
    begin
      if not assigned(aNoteRec.GenLines) then
        aNoteRec.GenLines := TStringList.Create;
      aNoteRec.GenLines.Assign(SL);
    end;
  finally
    SL.Free;
  end;
end;

function CreateAndLockNewProgressNote(aCreatedDoc: TCreatedDoc;
  aNoteRec: TEditNoteRec; APatientData: TPatientData): boolean;
begin
  Result := False;
  PutNewNote(aCreatedDoc, aNoteRec); // 2FA

  if aCreatedDoc.IEN > 0 then
  begin
    LockDocument(aCreatedDoc.IEN, aCreatedDoc.ErrorText);

    if Length(aCreatedDoc.ErrorText) > 0 then
    begin
      InfoBox('For patient ' + APatientData.Patient.Name +
        aCreatedDoc.ErrorText, TX_CREATE_ERR, MB_OK);
    end
    else
      Result := True;
  end;
end;

function UpdateChanges(aCreatedDoc: TCreatedDoc; aNoteRec: TEditNoteRec;
  APatientData: TPatientData): boolean;
begin
  APatientData.PCEData.NoteIEN := aNoteRec.NoteIEN;
  Changes.Add(CH_DOC, IntToStr(aCreatedDoc.IEN),
    aNoteRec.TitleName + ' for patient ' + APatientData.Patient.Name, '',
    CH_SIGN_YES);

  if aNoteRec.ErrTxt = '' then // AA: I don't see ErrTxt is assigned anywhere
  begin
    setNoteRecordGenLines(aNoteRec);
    APatientData.PtNote := aNoteRec;
  end;
  Result := True;
end;

function TfrmGNEncounter.NewNoteForIndividualPatient(APatientData: TPatientData):Boolean;
var
  HaveRequired: Boolean;
  IndvNote: TEditNoteRec;
  CreatedNote: TCreatedDoc;

begin
  Result := False;
  FillChar(IndvNote, SizeOf(IndvNote), 0);
  setNoteRecord(IndvNote);

  if LacksRequiredForCreate(IndvNote) or VerifyNoteTitle or UnresolvedConsultsExist
  then
    HaveRequired := ExecuteNoteProperties(IndvNote, CT_NOTES, False,
      False, '', 0)
  else
    HaveRequired := True;

  if HaveRequired then
  begin
    APatientData.PCEData.UseEncounter := True;
    //APtPCE.VisitCategory := GetVisitCat('A', Encounter.Location, APatientData.Patient.Inpatient);
    APatientData.PCEData.NoteDateTime := IndvNote.DateTime;
    IndvNote.NeedCPT  := aPatientData.PCEData.CPTRequired; //APtPCE.CPTRequired;
(*
    PutNewNote(CreatedNote, IndvNote); // 2FA

    if CreatedNote.IEN > 0 then
      LockDocument(CreatedNote.IEN, CreatedNote.ErrorText);

    if Length(CreatedNote.ErrorText) > 0 then
    begin
      InfoBox('For patient ' + APatientData.Patient.Name +
        CreatedNote.ErrorText, TX_CREATE_ERR, MB_OK);
    end
    else
      begin
        aPatientData.PCEData.NoteIEN := IndvNote.NoteIEN;
        Changes.Add(CH_DOC, IntToStr(CreatedNote.IEN),
          IndvNote.TitleName + ' for patient ' + APatientData.Patient.Name, '',
          CH_SIGN_YES);

        if IndvNote.ErrTxt = '' then  // AA: I don't see ErrTxt is assigned anywhere
        begin
          setNoteRecordGenLines(IndvNote);
          APatientData.PtNote := IndvNote;
        end;
        Result := True;
      end;
*)
    Result := CreateAndLockNewProgressNote(CreatedNote,IndvNote,aPatientData);
    if Result then
      Result := UpdateChanges(CreatedNote,IndvNote,aPatientData);
  end;
end;

procedure TfrmGNEncounter.actNewNoteExecute(Sender: TObject);
var
  HaveRequired: boolean;
  TmpBoilerPlate: TStringList;
  APatientData: TPatientData;
  i: Integer;
  CreatedNote: TCreatedDoc;
begin
  inherited;
  HaveRequired := False;
  if Encounter.NeedVisit then
    if not UpdateEncounter(NPF_ALL) then
      Exit;
  ShowBasicEnctInfo;
  if GroupEdit then
    Patient := TPatient(lstPatients.Items.Objects[0])
  else
  begin
    if lstPatients.ItemIndex < 0 then
    begin
      InfoBox('Please select a patient before creating a new note.','New Note',MB_OK);
      Exit;
    end;
    Patient := TPatient(lstPatients.Items.Objects[lstPatients.ItemIndex]);
  end;

  APatientData := GetPatientData(Patient);
  if not GroupEdit then
  begin
    if NewNoteForIndividualPatient(APatientData) then
    begin
      if assigned(APatientData.PtNote.GenLines) then
        memCommNote.Lines.Assign(APatientData.PtNote.GenLines);

      ShowPatientInfo(APatientData);
      NoteEnable(memCommNote, True);
      NoteEnable(memIndvNote, True);
    end;

{$IFDEF DEBUG}
    UpdateDebugInfo(aPatientData,Encounter);
{$ENDIF}

    Exit;
  end;

  memCommNote.Clear;
  memCommNote.Text := ' ';// AA: a flag notifying the note is open for editing
  memIndvNote.Clear;

  TmpBoilerPlate := nil;
  ClearNote(BaseNote);
  try
    FillChar(BaseNote, SizeOf(BaseNote), 0); // not needed after ClearNote

    setNoteRecord(BaseNote);

    if FChangeNote then
    begin
      HaveRequired := ExecuteNoteProperties(BaseNote, CT_NOTES, False,
        False, '', 0);
      actChangeNote.Enabled := True;
      FChangeNote := False;
    end
    else if LacksRequiredForCreate(BaseNote) or VerifyNoteTitle or UnresolvedConsultsExist
    then
      HaveRequired := ExecuteNoteProperties(BaseNote, CT_NOTES, False,
        False, '', 0)
    else
      HaveRequired := True;

    if HaveRequired then
    begin
      NoteEnable(memCommNote,True);
      APatientData.PCEData.UseEncounter := True;
      // set up PCE data for entry of new note
      // APatientData.PCEData.VisitCategory := GetVisitCat('A', Encounter.Location, APatientData.Patient.Inpatient);
      APatientData.PCEData.NoteDateTime := BaseNote.DateTime;
      BaseNote.NeedCPT := APatientData.PCEData.CPTRequired;
      if (GNPtList.Count > 1) then // set up PCE for group patients
      begin
        for i := 1 to GNPtList.Count - 1 do
        // first patient's note is default to BaseNote.
        begin
          ClearNote(TPatientData(GNPtList.Items[i]).PtNote);
          TPatientData(GNPtList.Items[i]).PCEData.UseEncounter := True;
          TPatientData(GNPtList.Items[i]).PCEData.NoteDateTime :=
            BaseNote.DateTime;
          TPatientData(GNPtList.Items[i]).PtNote := BaseNote;
          TPatientData(GNPtList.Items[i]).PtNote.NeedCPT :=
            TPatientData(GNPtList.Items[i]).PCEData.CPTRequired;
        end;
      end;

      PutNewNote(CreatedNote, BaseNote);
      // create the base note for GNPtList.Items[0]
      if CreatedNote.IEN > 0 then
        LockDocument(CreatedNote.IEN, CreatedNote.ErrorText);
      if Length(CreatedNote.ErrorText) > 0 then
      begin
        InfoBox(CreatedNote.ErrorText, TX_CREATE_ERR, MB_OK);
        Exit;
      end;
      TPatientData(GNPtList.Items[0]).PtNote := BaseNote;
      TPatientData(GNPtList.Items[0]).PCEData.NoteIEN := BaseNote.NoteIEN;
      Changes.Add(CH_DOC, IntToStr(CreatedNote.IEN),
        BaseNote.TitleName + ' for patient ' + TPatientData(GNPtList.Items[0])
        .Patient.Name, '', CH_SIGN_YES);

      if (GNPtList.Count > 1) then // create note for each patient in the group
      begin
        for i := 1 to GNPtList.Count - 1 do
        // first patient's note is default to BaseNote.
        begin
          CreatedNote.IEN := 0;
          CreatedNote.ErrorText := '';
          // PutNewNote(CreatedNote, TPatientData(GNPtList.Items[i]).PtNote,TPatientData(GNPtList.Items[i]).Patient.DFN);
          PutNewNote(CreatedNote,TPatientData(GNPtList.Items[i]).PtNote);  { 2FA }
          if CreatedNote.IEN > 0 then
            LockDocument(CreatedNote.IEN, CreatedNote.ErrorText);
          if Length(CreatedNote.ErrorText) > 0 then
          begin
            InfoBox('For patient ' + TPatientData(GNPtList.Items[i])
              .Patient.Name + CreatedNote.ErrorText, TX_CREATE_ERR, MB_OK);
            Continue;
          end;
          TPatientData(GNPtList.Items[i]).PCEData.NoteIEN := CreatedNote.IEN;
          Changes.Add(CH_DOC, IntToStr(CreatedNote.IEN),
            TPatientData(GNPtList.Items[i]).PtNote.TitleName + ' for patient ' +
            TPatientData(GNPtList.Items[0]).Patient.Name, '', CH_SIGN_YES);
        end;
      end;

      lblBaseNoteInfo.Caption := 'Common note content for group patients.' +
        ' Title:' + BaseNote.TitleName;
      lblIndvNoteInfo.Caption := 'Additional note text for selected patient. ' +
        ' Title: ' + BaseNote.TitleName;

      if GroupEdit then
        actChangeNote.Enabled := True;

      if BaseNote.ErrTxt = '' then
      begin
        if not Assigned(TmpBoilerPlate) then
          TmpBoilerPlate := TStringList.Create;
        // AA: requires Pt and Encounter to be set priot the call
        LoadBoilerPlate(TmpBoilerPlate, BaseNote.Title);
        memCommNote.Lines.Clear;
        memIndvNote.Lines.Clear;
        memCommNote.Lines.Assign(TmpBoilerPlate);
        acUpdateBasicEncounter.Enabled := False;
      end
      else
      begin
        HaveRequired := False;
        InfoBox(BaseNote.ErrTxt,'New Note',MB_OK);
        Exit;
      end;
    end
    else
      Exit;
  finally
    if Assigned(TmpBoilerPlate) then
      TmpBoilerPlate.Free;
    if HaveRequired then
    begin
      memCommNote.SetFocus;
      actNewNote.Enabled := False;
      // BackToPtSelect(False);
    end;
    LimitEditWidth(memCommNote, 70);
    LimitEditWidth(memIndvNote, 70);
    Application.ProcessMessages;
{$IFDEF DEBUG}
    UpdateDebugInfo(aPatientData,Encounter);
{$ENDIF}
  end;
end;

procedure TfrmGNEncounter.actForAllPatientsExecute(Sender: TObject);
var
  aPtData: TPatientData;

  function CommonNoteIsEditable:Boolean;
  begin
    Result := not FSigned and
      (memCommNote.Text <> '');
  end;

begin
  inherited;
{$IFDEF DEBUG}
  aPtData := nil;
{$ENDIF}
  if (not memCommNote.ReadOnly) and (memCommNote.Lines.Count > 0) then
    memCommNoteExit(Self);
  if (not memIndvNote.ReadOnly) then //and (memIndvNote.Enabled) then
      memIndvNoteExit(Self);

  GroupEdit := not GroupEdit;

  if GroupEdit then
  begin
    tbAllPatients.Down := True;
    lstPatients.MultiSelect := True;
    lstPatients.SelectAll;
    if FSigned then Exit;
    if BaseNote.NoteIEN > 0 then // selecting group patients with base note was created already
    begin
      lblBaseNoteInfo.Caption :='Common note content for group patients.' + ' Title:' + BaseNote.TitleName;
      lblIndvNoteInfo.Caption :='Additional note text for selected patient. ' + ' Title: ' + BaseNote.TitleName;
      NoteEnable(memCommNote,True); // AA: Should it be locked for editing as soon as the NoteIEN was set?
      actChangeNote.Enabled := True;
    end else
    begin  //selecting group patients when note was not created yet
      NoteEnable(memCommNote,CommonNoteIsEditable); // AA: enbling area if the notes were not signed;
      lblBaseNoteInfo.Caption := 'Progress note:  content shared by all patients';
      lblIndvNoteInfo.Caption := 'Progress note:  content for individual patient';
      memCommNote.Lines.Clear;
      txtPCEData.Lines.Clear;
    end;
    lblEnctInfo.Caption     := 'Encounter data for all patients';

    actNewEncounter.Enabled := not BasePCE.HasData;
    actEditEncounter.Enabled := BasePCE.HasData;

    aPtData := nil;
    if assigned(lstPatients.Items.Objects[0]) and
      (lstPatients.Items.Objects[0] is TPatient) then
      aPtData := GetPatientData(TPatient(lstPatients.Items.Objects[0]));
    if assigned(aPtData) and assigned(aPtData.PtNOte.GenLines) then
      memCommNote.Lines.Assign(aPtData.PtNote.GenLines); // AA: 20170427

    memIndvNote.Lines.Clear;
    NoteEnable(memIndvNote,False);

    lblPatient.Caption := 'Data shared by all patients';
  end
  else
  begin
    tbAllPatients.Down := False;
    lstPatients.MultiSelect := False;
    lstPatients.ClearSelection;
    lblPatient.Caption := 'Patient: not selected';
    NoteEnable(memCommNote,False);
    actChangeNote.Enabled := False ;
  end;

  actForAllPatients.Checked := GroupEdit;

  pnlSingleNote.Visible := not GroupEdit;
  splNote.Visible := not GroupEdit;
  if splNote.Visible then
    splNote.Top := pnlNote.Height - pnlSingleNote.Height;

{$IFDEF DEBUG}
    UpdateDebugInfo(aPtData,Encounter);
{$ENDIF}

end;

procedure TfrmGNEncounter.acDebugViewExecute(Sender: TObject);
begin
  inherited;
  acDebugView.Checked := not acDebugView.Checked;
  if acDebugView.Checked then
    SetLayout('DEBUG')
  else
    SetLayout('');
end;

procedure TfrmGNEncounter.setLayout(aLayout: string);
var
  bDebug: Boolean;
begin
  bDebug := aLayout = 'DEBUG';

  pnlCosigners.Visible := bDebug;
  splCosigners.Visible := bDebug;
  pnlPatient.Visible := bDebug;

  if not bDebug then
    begin
      self.color := clBtnFace;
      pnlBasicEncounter.Parent := self;
      lblBasicEnct.Font.Style := lblBasicEnct.Font.Style + [fsBold];
      pnlBasicEncounter.Top := 0;

      reCosigners.BorderStyle := bsSingle;
      memCommNote.BorderStyle := bsSingle;
      memIndvNote.BorderStyle := bsSingle;
      txtPCEData.BorderStyle := bsSingle;
    end
  else
    begin
//      color := clCream;
      pnlBasicEncounter.Parent := pnlRight;
      lblBasicEnct.Font.Style := lblBasicEnct.Font.Style - [fsBold];

      pnlPatient.Top := 0;
      pnlBasicEncounter.Top := pnlPatient.Height;
      splCosigners.Top := pnlRight.Height - pnlCosigners.Height ;
{
      reCosigners.BorderStyle := bsNone;
      memCommNote.BorderStyle := bsNone;
      memIndvNote.BorderStyle := bsNone;
      txtPCEData.BorderStyle := bsNone;
}
    end;

  bbUpdate.Visible := not bDebug;
  bvlBasicInfo.Visible := not bDebug;
  CoolBar1.Visible := not bDebug;
  acDebugShowToolbar.Checked := not bDebug;

  sbUpdate.Visible := bDebug;
  sbNoteSign.Visible := bDebug;
  sbSaveNoSign.Visible := bDebug;
  sbNoteNew.Visible := bDebug;
  sbSignersAdd.Visible := bDebug;
  sbEncounterNew.Visible := bDebug;
{
  sbUpdate.Flat := bDebug;
  sbNoteSign.Flat := bDebug;
  sbNoteNew.Flat := bDebug;
  sbSignersAdd.Flat := bDebug;
  sbEncounterNew.Flat := bDebug;
}
  lblIndvNoteInfo.Visible := not bDebug;
  lblNote.Visible := bDebug;
//  pnlNoteShared.Visible := bDebug;

  Invalidate;
end;

procedure TfrmGNEncounter.acDebugExecute(Sender: TObject);
begin
  inherited;
  acDebug.Checked := not acDebug.Checked;
  pnlDetails.Visible := acDebug.Checked;
  splDetails.Visible := acDebug.Checked;
  if splDetails.Visible then
    splDetails.Top := Height - mmDetails.Height;
end;

procedure TfrmGNEncounter.acDebugShowToolbarExecute(Sender: TObject);
begin
  inherited;
  acDebugShowToolbar.Checked := not acDebugShowToolbar.Checked;
  CoolBar1.Visible := acDebugShowToolbar.Checked;
end;

procedure TfrmGNEncounter.actChangeNoteExecute(Sender: TObject);

  function HasAnyNote: boolean;
  var
    i: integer;
  begin
    Result := False;
    for i := 0 to GNPtList.Count - 1 do
    begin
      if (TPatientData(GNPtList.Items[i]).PtNote.NoteIEN > 0) then
      begin
        Result := True;
        Break;
      end;
    end;
  end;

begin
  inherited;
  FChangeNote := True;
  if HasAnyNote then
    if MessageDlg
      ('All current patients'' notes will be erased, are you sure to continue?',
      mtWarning, [mbOK, mbCancel], 0) = mrCancel then
      Exit;
  DeleteCurrentNotes(false);
  actNewNoteExecute(Self);
end;

procedure TfrmGNEncounter.actSignNoteExecute(Sender: TObject);
const
  SIG_COSIGN = 'COSIGNATURE';
  SIG_SIGN = 'SIGNATURE';
  SIG_TEXT = 'The signature will be applied to all notes for group patients.';
var
  // Saved: Boolean;
  ActionType, ESCode, SignTitle: string;
  ActionSts, SignSts: TActionRec;
  OK: boolean;
  // SavedDocID, tmpItem: string;
  // EditingID: string;
  i: Integer;
  APatientData: TPatientData;
  // APatient: TPatient;
  // ableToClose: boolean;
begin
  inherited;
  if SaveWithoutSigning then
  begin
    // if lstPatients.ItemIndex < 0 then exit;
    tbAllPatients.Down := True;
    lstPatients.MultiSelect := True;
    lstPatients.SelectAll;
    GroupEdit := True;
    OK := false;
    for i := 0 to GNPtList.Count - 1 do
    begin
      APatientData := TPatientData(GNPtList.Items[i]);
      if CosignDocument(APatientData.PtNote.NoteIEN) then
      begin
        SignTitle := TX_COSIGN;
        ActionType := SIG_COSIGN;
      end
      else
      begin
        SignTitle := TX_SIGN;
        ActionType := SIG_SIGN;
      end;
      ActOnDocument(ActionSts, APatientData.PtNote.NoteIEN, ActionType);
      if ActionSts.Success then
      begin
        GroupEdit := not GroupEdit;
        // 2FA      OK := IsOK2Sign(APatientData.PCEData, APatientData.PtNote.NoteIEN,
        // 2FA        APatientData.PtNote.TitleName, APatientData.Patient);
        OK := IsOK2Sign(APatientData.PCEData, APatientData.PtNote.NoteIEN);

        GroupEdit := not GroupEdit;
        if APatientData.PCEData.HasData then
          MakeEncounterEnable(True);
        if not AuthorSignedDocument(APatientData.PtNote.NoteIEN) then
        begin
          if (InfoBox(TX_AUTH_SIGNED + APatientData.PtNote.TitleName, TX_SIGN,
            MB_YESNO) = ID_NO) then
            Exit;
        end;
        APatientData.OKForSign := OK;
      end
      else
      begin
        InfoBox('Has problem to sign ' + APatientData.PtNote.TitleName +
          ' for ' + APatientData.Patient.Name + '.' + #10#13 + 'Reason: ' +
          ActionSts.Reason + #10#13 + 'Rest of notes will be signed...', 'Sign Note', MB_OK);
        APatientData.OKForSign := false;
        Continue; // Exit;
      end;
    end;
    if OK then
      // SignatureForItem(Font.Size, SIG_TEXT, SignTitle, ESCode, FSignRst);
      { 2FA } SignatureForItem(Font.Size, SIG_TEXT, SignTitle, ESCode);
    if FSignRst = 'cancel' then
      Exit;
    if FSignRst = 'notsign' then
    begin
      for i := 0 to GNPtList.Count - 1 do
      begin
        APatientData := TPatientData(GNPtList.Items[i]);
        UnlockDocument(APatientData.PtNote.NoteIEN);
        RemovePCEFromChanges(APatientData.PtNote.NoteIEN);
        Changes.Remove(CH_DOC, IntToStr(APatientData.PtNote.NoteIEN));
      end;
      UpdateControlsAfterSign(false);
    end
    else if Length(ESCode) > 0 then
    begin
      for i := 0 to GNPtList.Count - 1 do
      begin
        APatientData := TPatientData(GNPtList.Items[i]);
        if APatientData.OKForSign then
        begin
          SignDocument(SignSts, APatientData.PtNote.NoteIEN, ESCode);
          UnlockDocument(APatientData.PtNote.NoteIEN);
          RemovePCEFromChanges(APatientData.PtNote.NoteIEN);
          Changes.Remove(CH_DOC, IntToStr(APatientData.PtNote.NoteIEN));
        end;
      end;
      UpdateControlsAfterSign(True);
    end;
  end;
end;

procedure TfrmGNEncounter.actNewEncounterExecute(Sender: TObject);
var
  thePatient: TPatient;
  APatientData: TPatientData;

  function EncounterEraseCanceled: boolean;
  begin
    Result := MessageDlg
      ('Creating encounter for group patients will erase all patients current encounter data, Continue? ',
      mtWarning, [mbOK, mbCancel], 0) = mrCancel;
  end;

  procedure setButtonStatus(aStatus:Boolean);
  begin
    if not aStatus then
      exit;
    actEditEncounter.Enabled := aStatus;
    actNewEncounter.Enabled := not aStatus;
    acUpdateBasicEncounter.Enabled := not aStatus; // update button
  end;

  function ptListHasData:Boolean;
  var
    i: Integer;
  begin
    Result := False;
    for i := 0 to lstPatients.Items.Count - 1 do
    begin
      thePatient := TPatient(lstPatients.Items.Objects[i]);
      APatientData := GetPatientData(thePatient);
      Result := APatientData.PCEData.HasData;
      if Result then
        Break;
    end;
  end;

  procedure UpdateGroupPatientPCEData;
  var
    i: integer;
  begin
    // copy BasePCE to all records
    for i := 0 to GNPtlist.Count - 1 do
      BasePCE.CopyPCEData(TPatientData(GNPtList.Items[i]).PCEData);
  end;

begin
  inherited;

  if (not GroupEdit) and (lstPatients.ItemIndex < 0) then
  begin
    InfoBox('Please select patient before creating a new encounter!','New Encounter', MB_OK);
  end
  else
  begin
    if (ptListHasData and GroupEdit and (not BasePCE.HasData)) then
    begin
      if EncounterEraseCanceled then
        Exit;
    end;

    if Assigned(BasePCE) then
    begin
      if ((BasePCE.HasData) and GroupEdit) then
      begin
        if EncounterEraseCanceled then
          Exit;
      end;
    end;

    if Encounter.NeedVisit then
      if not UpdateEncounter(NPF_ALL) then
        Exit;

    ShowBasicEnctInfo;

    if GroupEdit then
      lblEnctInfo.Caption := 'Encounter Data for all patients'
    else
      lblEnctInfo.Caption := 'Encounter data for ' + lstPatients.Items
        [lstPatients.ItemIndex];

    txtPCEData.Enabled := True;

    Encounter.VisitCategory := GetVisitCat('A', Encounter.Location, False);

    if GroupEdit then
    begin
      Patient := TPatient(lstPatients.Items.Objects[0]);
      APatientData := GetPatientData(Patient);
    end
    else
    begin
      Patient := TPatient(lstPatients.Items.Objects[lstPatients.ItemIndex]);
      APatientData := GetPatientData(Patient);
    end;

    if EditPCEData(APatientData) then
    begin
      txtPCEData.Lines.Clear;
      if GroupEdit then
      begin
        UpdateGroupPatientPCEData;// copies BasePCE to every Parient in the list
        BasePCE.AddStrData(txtPCEData.Lines);
      end
      else
        APatientData.PCEData.AddStrData(txtPCEData.Lines);
    end;

//    if (not memCommNote.ReadOnly) then
    if memCommNote.Enabled then
      memCommNote.SetFocus;

    if GroupEdit then
      setButtonStatus(BasePCE.HasData)
    else
      setButtonStatus(aPatientData.PCEData.HasData);

  end;
{$IFDEF DEBUG}
    mmDetails.Clear;
    UpdateDebugInfo(APatientData);
    UpdateDebugInfo(Encounter);
{$ENDIF}

end;

procedure TfrmGNEncounter.memCommNoteEnter(Sender: TObject);
begin
  inherited;
  actSignNote.Enabled := True;
  actSaveNoSig.Enabled := True;
end;

procedure TfrmGNEncounter.memIndvNoteEnter(Sender: TObject);
begin
  inherited;
  actSignNote.Enabled := True;
  actSaveNoSig.Enabled := True;
end;

procedure TfrmGNEncounter.ShowBasicEnctInfo;
var
  providernm, locname, datetime, dquote: string;
begin
  dquote := '''' + ' ' + '''';
  if Assigned(Encounter) then
  begin
    if Encounter.Provider > 0 then
      providernm := getExternalName(IntToStr(Encounter.Provider),'200')
    else
      providernm := dquote;

    if Encounter.Location > 0 then
      locname := Encounter.LocationName
    else
      locname := dquote;

    if Encounter.DateTime > 0 then
      datetime := FormatFMDateTime('mm/dd/yyyy hh:nn', Encounter.DateTime)
    else
      datetime := dquote;

    lblBasicEnct.Caption := 'Provider: ' +  providernm
      + '  Location: ' + LocName
      + '  Date: ' + DateTime;
  end;

  Application.ProcessMessages;
end;

procedure TfrmGNEncounter.BasicEncounterUpdate;
begin
  inherited;
  // AA: Need to set Pt ID to get correct location
  if not GroupEdit and (lstPatients.ItemIndex<>-1) then
    Patient := TPatient(lstPatients.Items.Objects[lstPatients.ItemIndex]);
  if UpdateEncounter(NPF_ALL) then
    ShowBasicEnctInfo;
end;

procedure TfrmGNEncounter.acUpdateBasicEncounterExecute(Sender: TObject);
begin
  inherited;
  BasicEncounterUpdate;
end;

procedure TfrmGNEncounter.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  inherited;
  if CloseFromMain then
  begin
    memCommNoteExit(Self);
    memIndvNoteExit(Self);
  end;

  if not NeedToSign then
  begin
    DeleteCurrentNotes(True);
    Exit;
  end;

  if not FSigned then
  begin
    if Changes.Documents.Count > 0 then
    begin
      if MessageDlg(TX_UNSIGNNOTES,mtWarning,[mbYes, mbNo],0) = mrNo then
      begin
        DeleteCurrentNotes(True);
        actSaveNoSigExecute(Self);
        Changes.Clear;
      end
      else
      begin
        if tbSignNote.Enabled then
        begin
          DeleteCurrentNotes(True);
          if NeedToSign then actSignNoteExecute(Self);
          {while not FSigned do
            actSignNoteExecute(Self);}
        end;
      end;
    end;
  end;
end;

function TfrmGNEncounter.LockNote(AnIEN: Int64): Boolean;
var
  LockMsg: string;
begin
  Result := True;
  if Changes.Exist(CH_DOC, IntToStr(AnIEN)) then Exit;  // already locked
  if Result then
  begin
    LockDocument(AnIEN, LockMsg);
    if LockMsg <> '' then
    begin
      Result := False;
      InfoBox(LockMsg, TC_NO_LOCK, MB_OK);
    end;
  end;
end;

function getSigAction(aNoteIEN:Int64):Integer;
var
  ActionSts: TActionRec;
  x, y: boolean;
begin
  Result := -1;

  x := CanChangeCosigner(aNoteIEN);
  ActOnDocument(ActionSts, aNoteIEN, 'IDENTIFY SIGNERS');
  y := ActionSts.Success;

  if x and not y then
  begin
    if InfoBox(ActionSts.Reason + CRLF + CRLF +
      'Would you like to change the cosigner?', TX_IN_AUTH,
      MB_YESNO or MB_DEFBUTTON2 or MB_ICONQUESTION) = ID_YES then
      Result := SG_COSIGNER;
  end
  else if y and not x then
    Result := SG_ADDITIONAL
  else if x and y then
    Result := SG_BOTH
  else
    InfoBox(ActionSts.Reason, TX_IN_AUTH, MB_OK);
end;
(*
procedure TfrmGNEncounter.AdditionalSignerForSingleNote(aPatientData: TPatientData);
var
  aNoteIEN: Int64;
  Exclusions: TStrings;
  SignerList: TSignerList;
  SigAction: Integer;
  ARefDate: TFMDateTime;

begin
  ARefDate := APatientData.PtNote.DateTime;
  aNoteIEN := APatientData.PtNote.NoteIEN;

  SigAction := getSigAction(aNoteIEN);
  if SigAction < 0 then
    Exit;

  if not LockNote(APatientData.PtNote.NoteIEN) then
    Exit;
  Exclusions := GetCurrentSigners(APatientData.PtNote.NoteIEN);
  SelectAdditionalSigners(Font.Size, APatientData.PtNote.NoteIEN, SigAction,
    Exclusions, SignerList, CT_NOTES, ARefDate);
  with SignerList do
  begin
    case SigAction of
      SG_ADDITIONAL:
        if Changed and (Signers <> nil) and (Signers.Count > 0) then
          UpdateAdditionalSigners(APatientData.PtNote.NoteIEN, Signers);
      SG_COSIGNER:
        if Changed then
          ChangeCosigner(APatientData.PtNote.NoteIEN, Cosigner);
      SG_BOTH:
        if Changed then
        begin
          if (Signers <> nil) and (Signers.Count > 0) then
            UpdateAdditionalSigners(APatientData.PtNote.NoteIEN, Signers);
          ChangeCosigner(APatientData.PtNote.NoteIEN, Cosigner);
        end;
    end;
    APatientData.AdditionalSigner := True;
  end;
  UnlockDocument(APatientData.PtNote.NoteIEN);
  // AdditionalSigner(False);
end;
*)
procedure TfrmGNEncounter.actIdentifyAdditionalSignerExecute(Sender: TObject);
var
  aNoteIEN: Int64;
  aPatient: TPatient;
  i: integer;
  APatientData: TPatientData;
  TmpNoteList: TStringList;
  Exclusions: TStrings;
  SignerList: TSignerList;
  SigAction: integer;
  ARefDate: TFMDateTime;

begin
  inherited;
{$IFDEF DEBUG}
  aPatientData := nil;
{$ENDIF}
  SigAction := -1;
  aRefDate := 0.0;
  //apply additional signer to all the notes of group patients
  TmpNoteList := TStringList.Create;

  if GroupEdit then
  begin
    for i := 0 to GNPtList.Count - 1 do
    begin
      aPatientData := TPatientData(GNPtList.Items[i]);
      aRefDate := aPatientData.PtNote.DateTime; // -- not sure it is correct
      if APatientData.AdditionalSigner then
        continue;
      aNoteIEN := APatientData.PtNote.NoteIEN;
      if i = 0 then             // originally it was taken from the first record
        SigAction := getSigAction(aNoteIEN);
      if SigAction < 0 then     // exiting if the first record fails
        exit;                   // could be "continue" if allowed to browse all
      if not LockNote(aNoteIEN) then
        Continue;
      APatientData.AdditionalSigner := True;
      TmpNoteList.Add(IntToStr(aNoteIEN));
    end;
  end
  else
  begin
    if lstPatients.ItemIndex < 0 then
      InfoBox('Please select a patient first before identifying additional signer.', 'Additional Signer for a single Note',MB_OK)
    else
    begin
      aPatient := TPatient(lstPatients.Items.Objects[lstPatients.ItemIndex]);
      aPatientData := getPatientData(aPatient);
      aNoteIEN := APatientData.PtNote.NoteIEN;
      if aPatientData.AdditionalSigner then
        InfoBox('The additional signer has already been identified.','Identify Additioal Signer',MB_OK)
      else
        if LockNote(aNoteIEN) then
          TmpNoteList.Add(IntToStr(aNoteIEN));
    end;
  end;

  if tmpNoteList.Count > 0 then
    begin
      Exclusions := GetCurrentSigners(StrToInt(TmpNoteList[0]));
      SelectAdditionalSigners(Font.Size, StrToInt(TmpNoteList[0]), SigAction, Exclusions, SignerList, CT_NOTES,
             aRefDate );
      with SignerList do
        begin
          case SigAction of
            SG_ADDITIONAL:  if Changed and (Signers <> nil) and (Signers.Count > 0) then
                            begin
                              for i := 0 to TmpNoteList.Count - 1 do
                                UpdateAdditionalSigners(StrToInt(TmpNoteList[i]), Signers);
                            end;
            SG_COSIGNER:    if Changed then
                            begin
                              for i := 0 to TmpNoteList.Count - 1 do
                                ChangeCosigner(StrToInt(tmpNoteList[i]), Cosigner);
                            end;
            SG_BOTH:        if Changed then
                            begin
                              if (Signers <> nil) and (Signers.Count > 0) then
                              begin
                                for i := 0 to TmpNoteList.Count - 1 do
                                  UpdateAdditionalSigners(StrToInt(TmpNoteList[i]), Signers);
                              end;
                              for i := 0 to TmpNoteList.Count - 1 do
                                ChangeCosigner(StrToInt(tmpNoteList[i]), Cosigner);
                            end;
          end;

          for i := 0 to GNPtlist.Count - 1 do
          begin
            if not TPatientData(GNPtlist.Items[i]).AdditionalSigner then
              TPatientData(GNPtlist.Items[i]).AdditionalSigner := True;
          end;
        end;

     for i := 0 to TmpNoteList.Count - 1 do
        UnlockDocument(StrToInt(tmpNoteList[i]));
     //AdditionalSigner(False);
    end;

  tmpNoteList.Free;

{$IFDEF DEBUG}
  reCosigners.Lines.Text := SignerList.Signers.Text;
  mmDetails.Clear;
  UpdateDebugInfo(APatientData);
  UpdateDebugInfo(Encounter);
{$ENDIF}
  SignerList.Signers.Free;
end;

procedure TfrmGNEncounter.actSaveNoSigExecute(Sender: TObject);
begin
  inherited;
  SaveWithoutSigning;
end;

function TfrmGNEncounter.SaveWithoutSigning:Boolean;
var
  i: integer;
  APatientData: TPatientData;
begin
  Result := False;
  if not NeedToSign then
    InfoBox('Empty notes can not be signed','Sign Note',MB_OK)
  else
    begin
      memCommNoteExit(Self);
      memIndvNoteExit(Self);
      for i := 0 to GNPtList.Count - 1 do
      begin
        APatientData := TPatientData(GNPtList.Items[i]);
        if APatientData.PtNote.Lines.count > 0 then
          SaveEachNote(APatientData);
      end;
      actIdentifyAdditionalSigner.Enabled := False;
      Result := True;
    end;
end;

function TfrmGNEncounter.NeedToSign: boolean;
var
  i: integer;
  APatientData: TPatientData;
begin
  Result := False;
  if not assigned(GNPtList) then
    Exit;
  if GNPtList.Count < 1 then
    Exit;

  for i := 0 to GNPtlist.Count - 1 do
  begin
    APatientData := TPatientData(GNPtList.Items[i]);
    if Assigned(aPatientData) and
        Assigned(aPatientData.PtNote.Lines) and

    (APatientData.PtNote.Lines.Count > 0) then
    begin
      Result := True;
      Break;
    end;
  end;
end;

procedure TfrmGNEncounter.UpdateControlsAfterSign(IsSigned: boolean);
begin
  NoteEnable(memCommNote,False);
  NoteEnable(memIndvNote,False);
  if IsSigned then  // signed or don't sign
  begin
    lblBaseNoteInfo.Caption := lblBaseNoteInfo.Caption + '--- Signed';
    lblIndvNoteInfo.Caption := lblIndvNoteInfo.Caption + '--- Signed';
    lblSignature.Visible := True;
    lblSignature.Enabled := True;
//    lblSignature.Font.Style := [fsBold];
    lblSignature.Caption := ' Signed by: ' + User.Name + ' at ' + DateTimeToStr(Now);
    actIdentifyAdditionalSigner.Enabled := True;
  end;
  FSigned := True;  // mark it true no matter signed or don't sign
  actSignNote.Enabled := False;
  actChangeNote.Enabled := False;
  actSaveNoSig.Enabled := False;
  actNewEncounter.Enabled := False;
  actEditEncounter.Enabled := False;
  tbAllPatients.Down := False;
  lstPatients.MultiSelect := False;
  lstPatients.ClearSelection;
  GroupEdit := False;
  Changes.Clear;
end;

procedure TfrmGNEncounter.DeleteCurrentNotes(onlyEmptyNotes: boolean);
var
  i, SavedDocIEN: Integer;
  AVisitStr, ReasonForDelete, x: string;
  APatientData: TPatientData;
  DeleteSts, ActionSts: TActionRec;
begin
  for i := 0 to GNPtList.Count - 1 do
  begin
    APatientData := TPatientData(GNPtList.Items[i]);
    if onlyEmptyNotes
      and (APatientData.PtNote.Lines.Count > 0) then
        Continue;

    ActOnDocument(ActionSts, APatientData.PtNote.NoteIEN, 'DELETE RECORD');
    if ShowMsgOn(not ActionSts.Success, ActionSts.Reason, TX_IN_AUTH) then
      Continue;

    ReasonForDelete := SelectDeleteReason(APatientData.PtNote.NoteIEN);
    // do the appropriate locking
    if not LockNote(APatientData.PtNote.NoteIEN) then
      Continue;
    // retraction notification message
    if JustifyDocumentDelete(APatientData.PtNote.NoteIEN) then
      InfoBox('Justify document message.', 'Delete Note', MB_OK);
    SavedDocIEN := APatientData.PtNote.NoteIEN;
    DeleteSts.Success := True;
    x := GetPackageRefForNote(SavedDocIEN);
    AVisitStr := VisitStrForNote(SavedDocIEN);
    RemovePCEFromChanges(SavedDocIEN, AVisitStr);
    // 2FA
    if SavedDocIEN > 0 then
      DeleteDocument(DeleteSts, SavedDocIEN, ReasonForDelete);
    if not Changes.Exist(CH_DOC, IntToStr(SavedDocIEN)) then
      UnlockDocument(SavedDocIEN);
    Changes.Remove(CH_DOC, IntToStr(SavedDocIEN));
    // this will unlock the document if in Changes
    // reset the display now that the note is gone
    if DeleteSts.Success then
    begin
      DeletePCE(AVisitStr);
      // removes PCE data if this was the only note pointing to it
    end;
  end;
end;

procedure TfrmGNEncounter.memCommNoteKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  if ( ( (Key=ord('c')) or (Key=ord('v'))) and (ssCtrl in Shift)) then
    Exit;
end;

procedure TfrmGNEncounter.pnlBaseNoteResize(Sender: TObject);
begin
  inherited;
  LimitEditWidth(memCommNote, 70);
end;

procedure TfrmGNEncounter.pnlLeftResize(Sender: TObject);
begin
  inherited;
  pnlDebugTools.Width := pnlLeft.Width;
end;

procedure TfrmGNEncounter.pnlSingleNoteResize(Sender: TObject);
begin
  inherited;
  LimitEditWidth(memIndvNote, 70);
end;

procedure TfrmGNEncounter.setActionStatus(aStatus: Boolean);
begin
  actNewNote.Enabled := aStatus;
  actChangeNote.Enabled := aStatus;
  actSaveNoSig.Enabled := aStatus;
  actSignNote.Enabled := aStatus;
  actForAllPatients.Enabled := aStatus;
  actNewEncounter.Enabled := aStatus;
  actEditEncounter.Enabled := aStatus;
  actIdentifyAdditionalSigner.Enabled := aStatus;
  acUpdateBasicEncounter.Enabled := aStatus;
end;

initialization
 SelectedPatient := '';
 StartOver := False;

  BasePCE := TPCEData.Create;
  GroupEdit := False;
  with BaseNote do
  begin
    NoteIEN      := 0;
    DocType      := 0;
    Title        := 0;
    TitleName    := '';
    DateTime     := 0;
    Author       := 0;
    AuthorName   := '';
    Cosigner     := 0;
    CosignerName := '';
    Subject      := '';
    Location     := 0;
    LocationName := '';
    PkgIEN       := 0;
    PkgPtr       := '';
    PkgRef       := '';
    NeedCPT      := False;
    Addend       := 0;
    Lines        := TStringList.Create;
    GenLines     := TStringList.Create;
    PTLines      := TStringList.Create;
    ErrTxt       := '';
  end;

finalization
  BasePCE.Free;
end.
