unit fGN_About;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, VA508AccessibilityManager, fBase508Form, Vcl.AppEvnts;

type
  TfrmAbout = class(TfrmBase508Form)
    pnlCanvas: TPanel;
    Image1: TImage;
    cmdOK: TButton;
    lblProductName: TStaticText;
    lblFileVersion: TStaticText;
    lblCompanyName: TStaticText;
    lblComments: TStaticText;
    lblCRC: TStaticText;
    lblLegalCopyright: TMemo;
    bvlBottom: TBevel;
    lblFileDescription: TStaticText;
    lblInternalName: TStaticText;
    lblOriginalFileName: TStaticText;
    pnlBottom: TPanel;
    pnlButton: TPanel;
    pnlBackground: TPanel;
    pnlINfo: TPanel;
    Bevel1: TBevel;
    ae: TApplicationEvents;
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure aeIdle(Sender: TObject; var Done: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

procedure ShowAbout;
procedure SplashAbout;
procedure SplashHide;


implementation
{$R *.DFM}

uses
  ORSystem
  , ORFn
  , VAUtils // ICD-10 Remediation
  ;
var
  frmAbout: TfrmAbout;

procedure SplashHide;
begin
  if assigned(frmAbout) then
    frmAbout.Hide;
  Application.ProcessMessages;
end;

procedure SplashAbout;
begin
  if not Assigned(frmAbout) then
    frmAbout := TfrmAbout.Create(Application);  // show splash screen
  with frmAbout do
    begin
      lblLegalCopyright.Margins.Top := 20;
      lblLegalCopyright.Margins.Bottom := 20;
      pnlButton.Visible := False;
      BorderStyle := bsNone;
      Show;
      Refresh;
    end;
end;

procedure ShowAbout;
begin
  if not Assigned(frmAbout) then
    frmAbout := TfrmAbout.Create(Application);
  try
    ResizeFormToFont(TForm(frmAbout));
    with frmAbout do
      begin
        BorderStyle := bsSingle;
        pnlButton.Visible := True;
        lblLegalCopyright.Margins.Top := 8;
        lblLegalCopyright.Margins.Bottom := 8;
        Caption := 'About Group Notes/Encounters';
        ShowModal;
      end;
  finally
    frmAbout.Hide;
  end;
end;

procedure TfrmAbout.aeIdle(Sender: TObject; var Done: Boolean);
begin
  inherited;
//  ae.OnIdle := nil; does not work if is hidden only once :(
  HideCaret(lblLegalCopyright.Handle);
end;

procedure TfrmAbout.FormCreate(Sender: TObject);
begin
  inherited;
  lblCompanyName.Caption        := 'Developed by the ' + FileVersionValue(Application.ExeName, FILE_VER_COMPANYNAME);
  lblFileDescription.Caption    := 'Compiled: ' + FileVersionValue(Application.ExeName, FILE_VER_FILEDESCRIPTION);  //date
  lblFileVersion.Caption        := FileVersionValue(Application.ExeName, FILE_VER_FILEVERSION);
  lblInternalName.Caption       := FileVersionValue(Application.ExeName, FILE_VER_INTERNALNAME);
  lblLegalCopyright.Text        := FileVersionValue(Application.ExeName, FILE_VER_LEGALCOPYRIGHT);
  lblOriginalFileName.Caption   := FileVersionValue(Application.ExeName, FILE_VER_ORIGINALFILENAME);  //patch
  lblProductName.Caption        := FileVersionValue(Application.ExeName, FILE_VER_PRODUCTNAME);
  lblComments.Caption           := FileVersionValue(Application.ExeName, FILE_VER_COMMENTS);  // version comment
  lblCRC.Caption                := 'CRC: ' + IntToHex(CRCForFile(Application.ExeName), 8);
end;

procedure TfrmAbout.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  inherited;
  if Key = VK_ESCAPE then
    Close;
end;

end.
