unit fxBroker;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DateUtils
  , ORNet, ORFn
  , rMisc
  , ComCtrls, Buttons, ExtCtrls,
  ORCtrls
  , ORSystem
//  , fBase508Form, VA508AccessibilityManager  // ICD-10 Remediation
  , ExtDlgs;

type
  TfrmBroker = class(TForm)
    pnlTop: TORAutoPanel;
    lblMaxCalls: TLabel;
    txtMaxCalls: TCaptionEdit;
    cmdPrev: TBitBtn;
    cmdNext: TBitBtn;
    udMax: TUpDown;
    memData: TRichEdit;
    lblCallID: TStaticText;
    Panel1: TPanel;
    lbCallList: TListBox;
    splLog: TSplitter;
    pnlControls: TPanel;
    pnlLog: TPanel;
    pnlLastCall: TPanel;
    Panel2: TPanel;
    btnRLT: TButton;
    ckbWordWrap: TCheckBox;
    pnlTools: TPanel;
    SaveTextFileDialog1: TSaveTextFileDialog;
    Button1: TButton;
    Label1: TLabel;
    ckbSaveOnExit: TCheckBox;
    cmbSearch: TComboBox;
    lblRpcItem: TLabel;
    procedure cmdPrevClick(Sender: TObject);
    procedure cmdNextClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormResize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnRLTClick(Sender: TObject);
    procedure lbCallListClick(Sender: TObject);
    procedure txtMaxCallsChange(Sender: TObject);
    procedure ckbWordWrapClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure lbCallListDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure edSearchChange(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure pnlLogResize(Sender: TObject);
  private
    { Private declarations }
    FRetained: Integer;
    FCurrent: Integer;
    procedure setCurrentInfo(anID: Integer);
    function getLogText:String;
  public
    { Public declarations }
    procedure NextCall;
    procedure PrevCall;
  end;

procedure ShowBroker;
procedure AddLogLine(aLine,aTitle:string;bLoud: Boolean = True);
{$IFDEF RPCLOG}
procedure NextCall;
procedure PrevCall;

var
  frmBroker: TfrmBroker;
{$ENDIF}

implementation
{$IFDEF RPCLOG}
uses fMainFrame;
{$ENDIF}

{$R *.DFM}
{$IFDEF RPCLOG}
procedure NextCall;
begin
  if Assigned(frmBroker) then
    frmBroker.NextCall;
end;

procedure PrevCall;
begin
  if Assigned(frmBroker) then
    frmBroker.PrevCall;
end;
{$ENDIF}



procedure AddLogLine(aLine,aTitle:string;bLoud: Boolean = True);
{$IFDEF RPCLOG}
var
  sl: TStringList;
{$ENDIF}
begin
{$IFDEF RPCLOG}
  if not bLoud then
    Exit;
  sl := TStringList.Create;
  sl.Text := aLine;
  RPCCalls.InsertObject(0,aTitle,sl);

  if Assigned(frmBroker) then
    with frmBroker do
      begin
        lbCallList.Items.Assign(RPCCalls);
        lbCallList.ItemIndex := 0;
        lbCallListClick(lbCallList);
      end;
{$ENDIF}
end;

procedure ShowBroker;
{$IFNDEF RPCLOG}
var
  frmBroker: TfrmBroker;
{$ENDIF}
begin
{$IFDEF RPCLOG}
  if Assigned(frmBroker) then
    frmBroker.Show
  else
    begin
{$ENDIF}
  frmBroker := TfrmBroker.Create(Application);
  try
    ResizeAnchoredFormToFont(frmBroker);
    with frmBroker do
    begin
      FRetained := RetainedRPCCount - 1;
      FCurrent := FRetained;
      LoadRPCData(memData.Lines, FCurrent);
      memData.SelStart := 0;
{$IFDEF RPCLOG}
      // adding RPC names used by ICD-10 patch for quick search in the log

      cmbSearch.Items.Add('');
      cmbSearch.Items.Add('Providers');
      cmbSearch.Items.Add('Update');
      cmbSearch.Items.Add('Encounter');
      cmbSearch.Items.Add('ORWGN IDTVALID');
      cmbSearch.Items.Add('ORWGN MAXFRQ');
      cmbSearch.Items.Add('ORWLEX GETI10DX');
      cmbSearch.Items.Add('ORWPCE ACTPROB');
      cmbSearch.Items.Add('ORWPCE DIAG');
      cmbSearch.Items.Add('ORWPCE LEX');
      cmbSearch.Items.Add('ORWPCE SAVE');

      pnlLog.Visible := True;
      splLog.Visible := True;
      lbCallList.Items.Assign(RPCCalls);
      lbCallListClick(nil);

      pnlControls.Visible := False;
      lblCallID.Visible := False;
      pnlTools.Visible := True;
      pnlTools.Align := alRight;
      Position := poDesigned;
      top := frmMainFrame.Top;
      Height := frmMainFrame.Height;
      Left := frmMainFrame.Left + frmMainFrame.Width;

      Show;
{$ELSE}
      lblCallID.Caption := 'Last Call Minus: ' + IntToStr(FRetained - FCurrent);
      txtMaxCalls.Text := '300';
      ShowModal;
{$ENDIF}
    end;
  finally
{$IFNDEF RPCLOG}
    frmBroker.Release;
{$ENDIF}
  end;
{$IFDEF RPCLOG}
    end;
{$ENDIF}
end;

procedure TfrmBroker.cmdPrevClick(Sender: TObject);
begin
  FCurrent := HigherOf(FCurrent - 1, 0);
  LoadRPCData(memData.Lines, FCurrent);
  memData.SelStart := 0;
  setCurrentInfo(FRetained - FCurrent);
end;

procedure TfrmBroker.cmdNextClick(Sender: TObject);
begin
  FCurrent := LowerOf(FCurrent + 1, FRetained);
  LoadRPCData(memData.Lines, FCurrent);
  memData.SelStart := 0;
  setCurrentInfo(FRetained - FCurrent);
end;

procedure TfrmBroker.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  SetRetainedRPCMax(StrToIntDef(txtMaxCalls.Text, 5))
end;

procedure TfrmBroker.FormResize(Sender: TObject);
begin
  Refresh;
end;

procedure TfrmBroker.FormCreate(Sender: TObject);
begin
  udMax.Position := GetRPCMax;
{$IFDEF RPCLOG}
  memData.WordWrap := true;
{$ENDIF}
end;

procedure TfrmBroker.FormDestroy(Sender: TObject);
{$IFDEF RPCLOG}
var
  i: integer;
{$ENDIF}
begin
{$IFDEF RPCLOG}
  if ckbSaveOnExit.Checked then
    begin
      for i := 0 to lbCallList.Items.Count - 1 do
        lbCallList.Selected[i] := True;

      Button1Click(nil);
    end;
{$ENDIF}
end;

procedure TfrmBroker.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_ESCAPE then
  begin
    Key := 0;
    Close;
  end;
end;

procedure TfrmBroker.btnRLTClick(Sender: TObject);
var
  startTime, endTime: tDateTime;
  sMessage,
  clientVer, serverVer, diffDisplay: string;
  theDiff: integer;
const
  TX_OPTION  = 'OR CPRS GUI CHART';
  disclaimer = 'NOTE: Strictly relative indicator:';
begin
  clientVer := clientVersion(Application.ExeName); // Obtain before starting.

  // Check time lapse between a standard RPC call:
  startTime := now;
  serverVer :=  serverVersion(TX_OPTION, clientVer);
  endTime := now;
  theDiff := milliSecondsBetween(endTime, startTime);
  diffDisplay := intToStr(theDiff);

  // Show the results:
  sMessage :='Lapsed time (milliseconds) = ' + diffDisplay + '.';
  infoBox(sMessage, disclaimer, MB_OK);
{$IFDEF RPCLOG}
  AddLogLine(sMessage,disclaimer);
  lbCallList.Items.Assign(RPCCalls);
  lbCallList.ItemIndex := 0;
  lbCallListClick(lbCallList);
{$ENDIF}
end;
 
procedure TfrmBroker.SetCurrentInfo(anID: Integer);
begin
  lblCallID.Caption := 'Last Call Minus: ' + IntToStr(anID);
end;

procedure TfrmBroker.txtMaxCallsChange(Sender: TObject);
begin
  inherited;
  try
    SetRetainedRPCMax(StrToIntDef(txtMaxCalls.Text, 5));
  finally
  end;
end;

procedure TfrmBroker.edSearchChange(Sender: TObject);
begin
  inherited;
  lbCallList.Invalidate;
  Application.ProcessMessages;
end;

function TfrmBroker.getLogText:String;
var
  s: String;
  i: integer;
begin
  s := '';
  for i  := lbCallList.Count - 1 downto 0 do
    begin
      if lbCallList.Selected[i] then
          s := s + TStringList(lbCallList.Items.Objects[i]).Text + CRLF+CRLF;
    end;
  if s = '' then
    if lbCallList.ItemIndex> -1 then
      s := TStringList(lbCallList.Items.Objects[lbCallList.ItemIndex]).Text + CRLF+CRLF;
  Result := Application.MainForm.Caption + CRLF+CRLF + s;
end;

procedure TfrmBroker.Button1Click(Sender: TObject);
var
  s,sName: String;
  SL: TStringList;
begin
  inherited;
  s := getLogText;
  if s = '' then
    ShowMessage('Please first select an item from the list')
  else //if SaveTextFileDialog1.Execute then
    begin
      sName := ExtractFilePath(Application.ExeName) + '\'+
        FormatDateTime('yyyymmdd_hhnnss',Now)+'.txt';
      SL := TStringList.Create;
      SL.Text := s;
//      SL.SaveToFile(SaveTextFileDialog1.FileName);
      SL.SaveToFile(sName);
      SL.Free;
    end;
end;

procedure TfrmBroker.ckbWordWrapClick(Sender: TObject);
begin
  inherited;
  memData.WordWrap := ckbWordWrap.Checked;
end;

procedure TfrmBroker.lbCallListClick(Sender: TObject);
begin
  inherited;
  lblRpcItem.Caption := '';
  lblRPCItem.Font.Color := clWindowText;
  if lbCallList.ItemIndex > -1  then
    begin
      memData.Lines.Assign(TStringList(lbCallList.Items.Objects[lbCallList.ItemIndex]));
      pnlLastCall.Caption := Format(' %d of %d ',[lbCallList.ItemIndex+1,lbCallList.Items.Count]);
      memData.SelStart := 0;
      lblRpcItem.Caption := lbCallList.Items[lbCallList.ItemIndex];
      if (cmbSearch.Text <> '')and (pos(cmbSearch.Text,lblRPCItem.Caption)>0) then
        lblRPCItem.Font.Color := clRed;

      
    end
  else
    pnlLastCall.Caption := '';
end;

procedure TfrmBroker.lbCallListDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var
  s: String;
begin
  inherited;
  s := cmbSearch.Text;
  With (Control as TListBox).Canvas do
    begin
      if (Length(s)>0) and (pos(s,(Control as TListBox).Items[Index])>0) then
        Font.Color := clRed
      else if {(odFocused in State) or} (odSelected in State) then
        Font.Color := clWhite
      else
        Font.Color := clWindowText;
      FillRect(Rect);
      TextOut(Rect.Left, Rect.Top,(Control as TListBox).Items[Index]);
      if odFocused In State then
        begin
          Brush.Color := lbCallList.Color;
          DrawFocusRect(Rect);
        end;
    end;
end;

procedure TfrmBroker.NextCall;
begin
  if lbCallList.ItemIndex = lbCallList.Items.Count -1 then
    Exit;
  try
    lbCallList.ItemIndex := lbCallList.ItemIndex + 1;
    lbCallListClick(nil);
  except
  end;
end;

procedure TfrmBroker.pnlLogResize(Sender: TObject);
begin
  lblRpcItem.Left := pnlLog.Width + splLog.Width;
end;

procedure TfrmBroker.PrevCall;
begin
  if lbCallList.ItemIndex <= 0 then
    Exit;
  try
    lbCallList.ItemIndex := lbCallList.ItemIndex - 1;
    lbCallListClick(nil);
  except
  end;

end;


end.
