unit fSignItem;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ORFn, rCore, XWBHash, ORCtrls;  // 2FA

type
  TfrmSignItem = class(TForm)
    lblESCode: TLabel;
    cmdOK: TButton;
    cmdCancel: TButton;
    lblText: TMemo;
    txtESCode: TCaptionEdit;
    procedure cmdOKClick(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure txtESCodeChange(Sender: TObject);
  private
    FESCode: string;
    FResponse: string;
  public
    { Public declarations }
  end;

procedure SignatureForItem(FontSize: Integer; const AText, ACaption: string;
  var ESCode: string; var mrBtn: string);

implementation

{$R *.DFM}

const
  TX_INVAL_MSG = 'Not a valid electronic signature code.  Enter a valid code or press Cancel.';
  TX_INVAL_CAP = 'Unrecognized Signature Code';

procedure SignatureForItem(FontSize: Integer; const AText, ACaption: string;
  var ESCode: string; var mrBtn: string);
var
  frmSignItem: TfrmSignItem;
begin
  frmSignItem := TfrmSignItem.Create(Application);
  try
    ResizeAnchoredFormToFont(frmSignItem);
    with frmSignItem do
    begin
      FESCode := '';
      Caption := ACaption;
      lblText.Text := AText;
      ShowModal;
      ESCode := FESCode;
      mrBtn := FResponse;
    end;
  finally
    frmSignItem.Release;
  end;
end;

procedure TfrmSignItem.cmdOKClick(Sender: TObject);
begin
  if cmdOK.Caption = 'Sign' then
    FResponse := 'sign'
  else
  begin
    FResponse := 'notsign';
    FESCode := '';
    Close;
    Exit;
  end;
  if not ValidESCode(txtESCode.Text) then
  begin
    InfoBox(TX_INVAL_MSG, TX_INVAL_CAP, MB_OK);
    txtESCode.SetFocus;
    txtESCode.SelectAll;
    Exit;
  end;
  FESCode := Encrypt(txtESCode.Text);
  Close;
end;

procedure TfrmSignItem.cmdCancelClick(Sender: TObject);
begin
  FESCode := '';
  FResponse := 'cancel';
  Close;
end;

procedure TfrmSignItem.FormCreate(Sender: TObject);
begin
  cmdOK.Caption := 'Don''t sign';
end;

procedure TfrmSignItem.txtESCodeChange(Sender: TObject);
begin
    if Length(txtESCode.Text) > 0 then cmdOK.Caption := 'Sign'
    else  cmdOK.Caption := 'Don''t Sign';
end;

end.
