unit fDupPts;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, ORCtrls, ExtCtrls, OrFn;

type
  TfrmDupPts = class(TForm)
    pnlDupPts: TPanel;
    btnOK: TButton;
    btnCancel: TButton;
    pnlSelDupPt: TPanel;
    lboSelPt: TORListBox;
    lblDupPts: TLabel;
    lblSelDupPts: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure lboSelPtDblClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
  private
    FDFN:    string;
    FOKPressed: boolean;
  public
    { Public declarations }
  end;

procedure SelectDupPt(var DFN: string; PtList: TStringList);

implementation

{$R *.dfm}

uses fGNPtSel;

procedure SelectDupPt(var DFN: string; PtList: TStringList);
var
  frmDupPts: TfrmDupPts;
begin
  frmDupPts := TfrmDupPts.Create(Application);
  try
    frmDupPts.lboSelPt.Items.Assign(PtList);
    frmDupPts.ShowModal;
    if frmDupPts.FOKPressed then
      DFN := frmDupPts.FDFN
    else
      DFN := '';
  finally
    frmDupPts.Release;
  end;
end;

procedure TfrmDupPts.FormCreate(Sender: TObject);
begin
  FDFN    := '';
  FOKPressed := False;
end;

procedure TfrmDupPts.btnOKClick(Sender: TObject);
begin
  if not (Length(lboSelPt.ItemID) > 0) then
  begin
    infoBox('A patient has not been selected.', 'No Patient Selected', MB_OK);
    exit;
  end;
  FOKPressed := True;
  FDFN := lboSelPt.ItemID;
  Close;
end;

procedure TfrmDupPts.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (key = 27) then
    btnCancelClick(Self);
end;

procedure TfrmDupPts.lboSelPtDblClick(Sender: TObject);
begin
  btnOKClick(Self);
end;

procedure TfrmDupPts.btnCancelClick(Sender: TObject);
begin
  Close;
end;

end.
