unit fAbout;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fAutoSz, StdCtrls, ExtCtrls;

type
  TfrmAbout = class(TfrmAutoSz)
    Panel1: TPanel;
    Image1: TImage;
    cmdOK: TButton;
    lblProductName: TStaticText;
    lblFileVersion: TStaticText;
    lblCompanyName: TStaticText;
    lblComments: TStaticText;
    lblCRC: TStaticText;
    lblLegalCopyright: TMemo;
    bvlBottom: TBevel;
    lblFileDescription: TStaticText;
    lblInternalName: TStaticText;
    lblOriginalFileName: TStaticText;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    {$IFDEF ICD10DEBUG}
    mm: TMemo;
    procedure mmClick(Sender: TObject);
    {$ENDIF}
  public
    { Public declarations }
  end;

procedure ShowAbout;
procedure SplashAbout;
var
  frmAbout: TfrmAbout;

implementation
{$R *.DFM}

uses ORSystem, ORFn
  , VAUtils   // ICD-10 Remediation
{$IFDEF ICD10DEBUG}
  , uUtils
  , fMainFrame
{$ENDIF}
  ;

procedure SplashAbout;
begin
  frmAbout := TfrmAbout.Create(Application);  // show splash screen
  frmAbout.cmdOK.Visible := False;
  frmAbout.Show;                               
  frmAbout.Refresh;
end;

procedure ShowAbout;
var
  frmAbout: TfrmAbout;
begin
  frmAbout := TfrmAbout.Create(Application);
  try
    ResizeFormToFont(TForm(frmAbout));
    frmAbout.lblLegalCopyright.SelStart := 0;
    frmAbout.lblLegalCopyright.SelLength := 0;
    //frmAbout.lbl508Notice.SelStart := 0;
    //frmAbout.lbl508Notice.SelLength := 0;
    frmAbout.Caption := 'About Group Notes/Encounters';
    frmAbout.ShowModal;
  finally
    frmAbout.Release;
  end;
end;

procedure TfrmAbout.FormCreate(Sender: TObject);
begin
  inherited;
  lblCompanyName.Caption        := 'Developed by the ' + FileVersionValue(Application.ExeName, FILE_VER_COMPANYNAME);
  lblFileDescription.Caption    := 'Compiled ' + FileVersionValue(Application.ExeName, FILE_VER_FILEDESCRIPTION);  //date
  lblFileVersion.Caption        := FileVersionValue(Application.ExeName, FILE_VER_FILEVERSION);
  lblInternalName.Caption       := FileVersionValue(Application.ExeName, FILE_VER_INTERNALNAME);
  lblLegalCopyright.Text        := FileVersionValue(Application.ExeName, FILE_VER_LEGALCOPYRIGHT);
  lblOriginalFileName.Caption   := FileVersionValue(Application.ExeName, FILE_VER_ORIGINALFILENAME);  //patch
  lblProductName.Caption        := FileVersionValue(Application.ExeName, FILE_VER_PRODUCTNAME);
  lblComments.Caption           := FileVersionValue(Application.ExeName, FILE_VER_COMMENTS);  // version comment
  lblCRC.Caption                := 'CRC: ' + IntToHex(CRCForFile(Application.ExeName), 8);
{$IFDEF ICD10DEBUG}
  mm := TMemo.Create(Panel1);
  mm.Parent := Panel1;
  mm.Align := alClient;
  mm.ScrollBars := ssVertical;
  mm.Lines.Text := DebugInfo;
  mm.Repaint;
  mm.Color := clInfoBk;
  mm.OnClick := mmClick;
  mm.ReadOnly := True;
  mm.Repaint;
  mm.Visible := False;
  Image1.OnClick := mmClick;
{$ENDIF}
end;

{$IFDEF ICD10DEBUG}
procedure TfrmAbout.mmClick(Sender: TObject);
begin
  mm.Visible := not mm.Visible;
  Image1.Visible := not mm.Visible;
end;
{$ENDIF}
end.
