unit fPCEEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ORFn, uPCE, uCore;

type
  TfrmPCEEdit = class(TForm)
    btnNew: TButton;
    lblNew: TMemo;
    lblNote: TMemo;
    btnCancel: TButton;
    Label1: TStaticText;
    procedure FormCreate(Sender: TObject);
  private

  public
    { Public declarations }
  end;

var
  FPatient: TPatient;

function EditPCEData(APatientData: TPatientData; AnEncounter: TEncounter): boolean;

implementation

uses rCore, fEncounterFrame; //, fEncnt, fFrame,

{$R *.DFM}

const
  TX_NEED_VISIT2 = 'A visit is required before entering encounter information.';
  TX_NOPCE_TXT1  = 'the encounter date is in the future.';
  TX_NOPCE_TXT2  = 'encounter entry has been disabled.';
  TX_NOPCE_TXT   = 'You can not edit encounter information because ';
  TX_NOPCE_HDR   = 'Can not edit encounter';

var
  uPCETemp: TPCEData = nil;
  uPCETempOld: TPCEData = nil;
  uPatient: string = '';

function EditPCEData(APatientData: TPatientData; AnEncounter: TEncounter): boolean;   // Returns TRUE if APCEData is edited
var
//  frmPCEEdit: TfrmPCEEdit;
//  BtnTxt, NewTxt,
  txt: string;
  Ans: integer;
begin
  Result := FALSE;
  if Assigned(APatientData.PCEData)  then
    Ans := mrYes;
  if ans = mrYes then
  begin
    if AnEncounter.NeedVisit then
    begin
      InfoBox(TX_NEED_VISIT2, TX_NO_VISIT, MB_OK or MB_ICONWARNING);
      Exit;
    end;
    if not assigned(uPCETemp) then
      uPCETemp := TPCEData.Create;
    uPCETemp.UseEncounter := True;
    if not CanEditPCE(uPCETemp) then
    begin
      if FutureEncounter(uPCETemp) then
        txt := TX_NOPCE_TXT1
      else
        txt := TX_NOPCE_TXT2;
      InfoBox(TX_NOPCE_TXT + txt, TX_NOPCE_HDR, MB_OK or MB_ICONWARNING);
      Exit;
    end;
    uPCETemp.PCEForNote(USE_CURRENT_VISITSTR, uPCETempOld);
    UpdatePCE(uPCETemp);
    if not assigned(uPCETempOld) then
      uPCETempOld := TPCEData.Create;
    uPCETemp.CopyPCEData(uPCETempOld);
    if not GroupEdit then
      APatientData.PCEData := uEncPCEData;
    Result := True;
  end
end;

procedure TfrmPCEEdit.FormCreate(Sender: TObject);
begin
  if uPatient <> FPatient.DFN then
    begin
      KillObj(@uPCETemp);
      KillObj(@uPCETempOld);
    end;
  uPatient := FPatient.DFN;
end;

initialization

finalization
  KillObj(@uPCETemp);
  KillObj(@uPCETempOld);
  uPatient := '';

end.
