unit fPCEBaseMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fPCEBaseGrid, ComCtrls, StdCtrls, ORCtrls, ExtCtrls, Buttons, rPCE, uPCE,
  CheckLst, ORFn, rmisc; //DNS   BELLC added rMISC as per [spec30.3.3]

type
  TCopyItemsMethod = procedure(Dest: TStrings) of object;
  TListSectionsProc = procedure(Dest: TStrings);

  TfrmPCEBaseMain = class(TfrmPCEBaseGrid)
    lbSection: TORListBox;
    edtComment: TCaptionEdit;
    lblSection: TLabel;
    lblList: TLabel;
    lblComment: TLabel;
    btnRemove: TButton;
    btnOther: TButton;
    bvlMain: TBevel;
    btnSelectAll: TButton;
    lbxSection: TORListBox;
    pnlMain: TPanel;
    pnlLeft: TPanel;
    splLeft: TSplitter;
    cbICD10DebugRPC: TCheckBox;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    procedure lbSectionClick(Sender: TObject);
    procedure btnOtherClick(Sender: TObject);
    procedure edtCommentExit(Sender: TObject);
    procedure edtCommentChange(Sender: TObject);
    procedure btnRemoveClick(Sender: TObject);
    procedure clbListClick(Sender: TObject);
    procedure lbGridSelect(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnSelectAllClick(Sender: TObject);
    procedure FormResize(Sender: TObject); virtual;
    procedure clbListMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lbxSectionClickCheck(Sender: TObject; Index: Integer);
    procedure splLeftMoved(Sender: TObject);
    procedure edtCommentKeyPress(Sender: TObject; var Key: Char);
    procedure FormCreate(Sender: TObject);
    procedure cbICD10DebugRPCClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
  private
    FCommentItem: integer;
    FCommentChanged: boolean;
    FUpdateCount: integer;
    //FUpdatingGrid: boolean;  moved to 'protected' so frmDiagnoses can see it  (RV)
  protected
    FUpdatingGrid: boolean;
    FPCEListCodesProc: TPCEListCodesProc;
    FPCEItemClass: TPCEItemClass;
    FPCECode: string;
    FSplitterMove: boolean;
    function GetCat: string;
    procedure UpdateNewItemStr(var x: string); virtual;
//    procedure UpdateNewItem(APCEItem: TPCEItem); virtual;
    procedure GridChanged; virtual;
    procedure UpdateControls; override;
    procedure BeginUpdate;
    procedure EndUpdate;
    function NotUpdating: boolean;
    procedure CheckOffEntries;
    procedure UpdateTabPos;
    procedure Sync2Grid;
    procedure Sync2Section;
  public
    procedure AllowTabChange(var AllowChange: boolean); override;
    procedure InitTab(ACopyProc: TCopyItemsMethod; AListProc: TListSectionsProc);
  end;

var
  frmPCEBaseMain: TfrmPCEBaseMain;

const
  LBCheckWidthSpace = 18;

implementation

uses fPCELex, fPCEOther, fEncounterFrame, fHFSearch,
{$IFDEF ICD10TEST01}
  fxBroker, uUtils,
{$ENDIF}
  uCore;  // rpk 2/14/2012

{$R *.DFM}

procedure TfrmPCEBaseMain.lbSectionClick(Sender: TObject);
// OR_30_350 ------------------------------------------------------------- begin
{
var
  SecItems : TStrings;
const
  DX_PROBLEM_LIST_TXT     = 'Problem List Items';
}
// OR_30_350 --------------------------------------------------------------- end
begin
  inherited;
  ClearGrid;
  FPCEListCodesProc(lbxSection.Items, lbSection.ItemIEN);
  CheckOffEntries;
// OR_30_350 ------------------------------------------------------------- begin
//  FSectionPopulated := TRUE;
  if (lbSection.Items.Count > 0) then
    lblList.Caption := StringReplace(lbSection.DisplayText[lbSection.ItemIndex],
      '&', '&&', [rfReplaceAll] );
{
  if (lbSection.DisplayText[lbSection.ItemIndex] = DX_PROBLEM_LIST_TXT) then
  begin
    SecItems := lbxSection.Items;
    FastAssign(SecItems, FProblems);
  end;
}
// OR_30_350 --------------------------------------------------------------- end
end;

procedure TfrmPCEBaseMain.UpdateNewItemStr(var x: string);
begin
end;

procedure TfrmPCEBaseMain.GridChanged;
var
  i: integer;
  tmpList: TStringList;
begin
  tmpList := TStringList.Create;
  BeginUpdate;
  try
    SaveGridSelected;
    tmpList.Assign(lbGrid.Items);
    for i := 0 to lbGrid.Items.Count-1 do
    begin
      //lbGrid.Items[i] := TPCEItem(lbGrid.Items.Objects[i]).ItemStr;   v22.5 - RV
      tmpList[i] := TPCEItem(lbGrid.Items.Objects[i]).ItemStr;
      tmpList.Objects[i] := lbGrid.Items.Objects[i];
    end;
    lbGrid.Items.Assign(tmpList);
    RestoreGridSelected;
    SyncGridData;
  finally
    EndUpdate;
    tmpList.Free;
  end;
  UpdateControls;
end;

//procedure TfrmPCEBaseMain.UpdateNewItem(APCEItem: TPCEItem);
//begin
//end;

procedure TfrmPCEBaseMain.btnOtherClick(Sender: TObject);
var
  x, Code: string;
  APCEItem: TPCEItem;
  SrchCode: integer;
begin
  inherited;
  ClearGrid;
  SrchCode := (Sender as TButton).Tag;
  if(SrchCode <= LX_Threshold) then begin
    if Assigned(uEncPCEData) then
      LexiconLookup(Code, SrchCode, Trunc(uEncPCEData.DateTime) )  // rpk 2/15/2012  ICD-10. SDD 3.3.50
    else
      LexiconLookup(Code, SrchCode)
{$IFDEF ICD10DEBUG235}
    ;
    x :=       'Code:       '+Code+CRLF;
    x := x +   'SearchCode: '+IntToStr(SrchCode) + CRLF;
    if Assigned(uEncPCEData) then
      x := x + 'DateTime:   '+FormatFMDateTime('mmm dd,yyyy hh:nn',Trunc(uEncPCEData.DateTime))+CRLF
    else
      x := x + 'DateTime:   N/A (no uEncPceData assigned)'+CRLF;
    AddLogLine(x,'LexiconLookup (TfrmPCEBaseMain.btnOtherClick)');
{$ENDIF}
  end
  else
  if(SrchCode = PCE_HF) then
    HFLookup(Code)
  else
    OtherLookup(Code, SrchCode);
  btnOther.SetFocus;
  if Code <> '' then
  begin
    x := FPCECode + U + Piece(Code, U, 1) + U + U + Piece(Code, U, 2);
    if FPCEItemClass = TPCEProc then
      SetPiece(x, U, pnumProvider, IntToStr(uProviders.PCEProvider));
{$IFDEF ICD10DEBUG235}
    AddLogLine('Adding Procedure:'+CRLF+ x + CRLF+CRLF+
      'Providers: '+CRLF+ uProviders.toString,'TfrmPCEBaseMain.btnOtherClick 2');
{$ENDIF}
    UpdateNewItemStr(x);
    if FPCEItemClass = TPCEDiag then x := x + U + Piece(Code, U, 4);            // ICD-10 ? SDD 3.3.50
    APCEItem := FPCEItemClass.Create;
    APCEItem.SetFromString(x);
//    UpdateNewItem(APCEItem);
    GridIndex := lbGrid.Items.AddObject(APCEItem.ItemStr, APCEItem);
    SyncGridData;
  end;
  UpdateControls;
end;

procedure TfrmPCEBaseMain.edtCommentExit(Sender: TObject);
begin
  inherited;
  if(FCommentChanged) then
  begin
    FCommentChanged := FALSE;
    if(FCommentItem >= 0) then
      TPCEItem(lbGrid.Items.Objects[FCommentItem]).Comment := edtComment.text;
  end;
end;

procedure TfrmPCEBaseMain.AllowTabChange(var AllowChange: boolean);
begin
  edtCommentExit(Self);
end;

procedure TfrmPCEBaseMain.edtCommentChange(Sender: TObject);
begin
  inherited;
  FCommentItem := GridIndex;
  FCommentChanged := TRUE;
end;

procedure TfrmPCEBaseMain.btnRemoveClick(Sender: TObject);
var
  i, j: Integer;
  APCEItem: TPCEItem;
  CurCategory: string;

begin
  inherited;
  FUpdatingGrid := TRUE;
  try
    for i := lbGrid.Items.Count-1 downto 0 do if(lbGrid.Selected[i]) then
    begin
      CurCategory := GetCat;
      APCEItem := TPCEDiag(lbGrid.Items.Objects[i]);
      if APCEItem.Category = CurCategory then
      begin
        with APCEItem do for j := 0 to lbxSection.Items.Count - 1 do
          if ORFn.Pieces(lbxSection.Items[j], U, 1, 2) = Code + U + Narrative then
            lbxSection.Checked[j] := False;
      end;
      APCEItem.Free;
      lbGrid.Items.Delete(i);
    end;
    ClearGrid;
  finally
    FUpdatingGrid := FALSE;
  end;
end;

procedure TfrmPCEBaseMain.UpdateControls;
var
  CommentOK: boolean;

begin
  btnSelectAll.Enabled := (lbGrid.Items.Count > 0);
  btnRemove.Enabled := (lbGrid.SelCount > 0);
  if(NotUpdating) then
  begin
    BeginUpdate;
    try
      inherited;
      CommentOK := (lbGrid.SelCount = 1);
      lblComment.Enabled := CommentOK;
      edtComment.Enabled := CommentOK;
      if(CommentOK) then
        edtComment.Text := TPCEItem(lbGrid.Items.Objects[GridIndex]).Comment
      else
        edtComment.Text := '';
    finally
      EndUpdate;
    end;
  end;
end;

procedure TfrmPCEBaseMain.clbListClick(Sender: TObject);
begin
  inherited;
//  with clbList do
//  if(ItemIndex >= 0) and (not(Checked[ItemIndex])) then
//    ClearGrid;
end;

procedure TfrmPCEBaseMain.lbGridSelect(Sender: TObject);
begin
  inherited;
//  clbList.ItemIndex := -1;
  UpdateControls;
end;

procedure TfrmPCEBaseMain.FormCreate(Sender: TObject);
begin
  inherited;
{$IFDEF ICD10TEST01}
  cbICD10DebugRPC.Visible := True;
{$ENDIF}
{$IFDEF RPCLOG}
  SpeedButton1.Visible := True;
  SpeedButton2.Visible := True;
{$ENDIF}
end;

procedure TfrmPCEBaseMain.FormDestroy(Sender: TObject);
var
  i:integer;

begin
  inherited;
  with lbGrid.Items do for i := 0 to Count - 1 do TPCEItem(Objects[i]).Free;
end;

procedure TfrmPCEBaseMain.InitTab(ACopyProc: TCopyItemsMethod; AListProc: TListSectionsProc);
begin
  AListProc(lbSection.Items);
  ACopyProc(lbGrid.Items);
  lbSection.ItemIndex := 0;
  lbSectionClick(lbSection);
  ClearGrid;
  GridChanged;
//  CheckOffEntries;
end;

procedure TfrmPCEBaseMain.BeginUpdate;
begin
  inc(FUpdateCount);
end;

procedure TfrmPCEBaseMain.EndUpdate;
begin
  if(FUpdateCount > 0) then
    dec(FUpdateCount);
end;

function TfrmPCEBaseMain.NotUpdating: boolean;
begin
  Result := (FUpdateCount = 0);
end;

procedure TfrmPCEBaseMain.SpeedButton1Click(Sender: TObject);
begin
  inherited;
{$IFDEF RPCLOG}
  fxBroker.PrevCall;
{$ENDIF}
end;

procedure TfrmPCEBaseMain.SpeedButton2Click(Sender: TObject);
begin
  inherited;
{$IFDEF RPCLOG}
  fxBroker.NextCall;
{$ENDIF}

end;

procedure TfrmPCEBaseMain.CheckOffEntries;

(*const
  TX_INACTIVE_ICD_CODE1 = 'The diagnosis of "';
  TX_INACTIVE_ICD_CODE2 = '" entered for this encounter' + #13#10 + 'contains an inactive ICD code of "';
  TX_INACTIVE_ICD_CODE3 = '" as of the encounter date, and will be removed.' + #13#10#13#10 +
                          'Please select another diagnosis.';
  TC_INACTIVE_ICD_CODE = 'Diagnosis Contains Inactive Code';*)
var
  i, j: Integer;
  CurCategory, CodeNarr: string;
  APCEItem: TPCEItem;
begin
  FUpdatingGrid := TRUE;
  try
    if(lbSection.Items.Count < 1) then exit;
    CurCategory := GetCat;
    for i := lbGrid.Items.Count - 1 downto 0 do
    begin
      APCEItem := TPCEItem(lbGrid.Items.Objects[i]);
      if APCEItem.Category = CurCategory then
      begin
        CodeNarr := APCEItem.Code + U + APCEItem.Narrative;
        for j := 0 to lbxSection.Items.Count - 1 do
          if ORFn.Pieces(lbxSection.Items[j], U, 1, 2) = CodeNarr then
            begin

(*              if (CurCategory = 'Problem List Items') and (Piece(lbxSection.Items[j], U, 5) = '#') then
                begin
                  InfoBox(TX_INACTIVE_ICD_CODE1 + APCEItem.Narrative + TX_INACTIVE_ICD_CODE2 +
                         APCEItem.Code + TX_INACTIVE_ICD_CODE3, TC_INACTIVE_ICD_CODE, MB_ICONWARNING or MB_OK);
                  lbxSection.Checked[j] := False;
                  APCEItem.Free;
                  lbGrid.Items.Delete(i);
                end
              else*)
                lbxSection.Checked[j] := True;
            end;
      end;
    end;
  finally
    FUpdatingGrid := FALSE;
  end;
end;

procedure TfrmPCEBaseMain.btnSelectAllClick(Sender: TObject);
var
  i: integer;

begin
  inherited;
  BeginUpdate;
  try
    for i := 0 to lbGrid.Items.Count-1 do
      lbGrid.Selected[i] := TRUE;
  finally
    EndUpdate;
  end;
  UpdateControls;
end;

procedure TfrmPCEBaseMain.cbICD10DebugRPCClick(Sender: TObject);
begin
  inherited;
{$IFDEF ICD10TEST01}
  gDebugProblemList := cbICD10DebugRPC.Checked;
{$ENDIF}
end;

procedure TfrmPCEBaseMain.FormResize(Sender: TObject);
begin
  if FSplitterMove then
    FSplitterMove := FALSE
  else
    inherited;
end;

procedure TfrmPCEBaseMain.clbListMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  inherited;
//  if(Button <> mbLeft) then
//    clbList.Itemindex := clbList.itemAtPos(Point(X,Y), TRUE);
end;

function TfrmPCEBaseMain.GetCat: string;
begin
  Result := '';
  if(lbSection.Items.Count > 0) and (lbSection.ItemIndex >= 0) then
    Result := Piece(lbSection.Items[lbSection.ItemIndex], U, 2);
end;

procedure TfrmPCEBaseMain.lbxSectionClickCheck(Sender: TObject;
  Index: Integer);
var
  i, j: Integer;
  sCode: String;
  x, x0, CodeCatNarr, LongDesc: string;  //DNS   BELLC [spec30.3.3]
  APCEItem: TPCEItem;
  Found, DoSync: boolean;

begin
  inherited;
  if FUpdatingGrid or FClosing then exit;
  DoSync := FALSE;
//  BeginUpdate; // Commented to address CodeCR CPRS172
  x0 := GetCat;
{$IFDEF ICD10DEBUG235}
AddLogLine('lbxSection.Items: '+#13#10+lbxSection.Items.Text,'TfrmPCEBaseMain.lbxSectionClickCheck: 1');
{$ENDIF}
  for i := 0 to lbxSection.Items.Count-1 do
  begin
    x := x0 + U + ORFn.Pieces(lbxSection.Items[i], U, 1, 2);
    CodeCatNarr := Piece(x, U, 2) + U + Piece(x, U, 1) + U + Piece(x, U, 3);
    sCode := Piece(x, U, 2);
// ICD10. CodeCR CPRS162 ------------------------------------------------- BEGIN
// No need to add code to the description
//    if Trunc(uEncPCEData.DateTime) >= Trunc(StrToFloat(GImplementationDate)) then  //DNS   BELLC [spec30.3.3]
//      CodeCatNarr := CodeCatNarr + #9 + sCode  //DNS   BELLC [spec30.3.3]
// ICD10. CodeCR CPRS162 --------------------------------------------------- END
    LongDesc := ORFn.Piece(lbxSection.Items[i], U, 6); //DNS   BELLC [spec30.3.3]

    Found := FALSE;
    for j := lbGrid.Items.Count - 1 downto 0 do
    begin
      APCEItem := TPCEItem(lbGrid.Items.Objects[j]);
      with APCEItem do if CodeCatNarr = Code + U + Category + U + Narrative then // ICD10-R. CodeCR CPRS162.
      begin
        Found := TRUE;
        if(lbxSection.Checked[i]) then break;
        APCEItem.Free;
        lbGrid.Items.Delete(j);
      end;
    end;
    if(lbxSection.Checked[i] and (not Found)) then
    begin
      x := FPCECode + U + CodeCatNarr;
      if FPCEItemClass = TPCEProc then
        SetPiece(x, U, pnumProvider, IntToStr(uProviders.PCEProvider));

      UpdateNewItemStr(x);
// ICD10. CodeCR 235 ----------------------------------------------------- begin
//      SetPiece(x, U, 6, LongDesc);  <-- overrides the Provider ID
//                                    piece 6 of the PCE items is
//                                    reserved for Provider ID
//                                    LongDesc is added to the item caption
// ICD10. CodeCR 235 ------------------------------------------------------- end

      APCEItem := FPCEItemClass.Create;

      APCEItem.SetFromString(x);
// ICD10. CodeCR CPRS162 ------------------------------------------------- BEGIN
// No need to add code to the description
//      if Trunc(uEncPCEData.DateTime) >= Trunc(StrToFloat(GImplementationDate)) then  //DNS   BELLC [spec30.3.3]
//        APCEItem.Narrative := APCEItem.Narrative + #9 + APCEItem.Code;  //DNS   BELLC [spec30.3.3]
// ICD10. CodeCR CPRS162 --------------------------------------------------- END
      GridIndex := lbGrid.Items.AddObject(APCEItem.ItemStr + U + LongDesc, APCEItem);
      DoSync := TRUE;
    end;
  end;
{$IFDEF ICD10DEBUG235}
AddLogLine('lbxSection.Items: '+#13#10+lbxSection.Items.Text,'TfrmPCEBaseMain.lbxSectionClickCheck: 2');
{$ENDIF}
  if(DoSync) then
    SyncGridData;
  UpdateControls;
end;

procedure TfrmPCEBaseMain.UpdateTabPos;
begin
  lbxSection.TabPositions := SectionString;
end;

procedure TfrmPCEBaseMain.splLeftMoved(Sender: TObject);
begin
  inherited;
  lblList.Left := lbxSection.Left + pnlMain.Left;
  FSplitterMove := TRUE;
  FormResize(Sender);
end;

procedure TfrmPCEBaseMain.Sync2Grid;
var
  i, idx, cnt, NewIdx: Integer;
  CodeNarr: string;
  APCEItem: TPCEItem;

begin
  if(FUpdatingGrid or FClosing) then exit;
  FUpdatingGrid := TRUE;
  try
    cnt := 0;
    idx := -1;
    for i := 0 to lbGrid.Items.Count - 1 do
    begin
      if(lbGrid.Selected[i]) then
      begin
        if(idx < 0) then idx := i;
        inc(cnt);
        if(cnt > 1) then break;
      end;
    end;
    NewIdx := -1;
    if(cnt = 1) then
    begin
      APCEItem := TPCEItem(lbGrid.Items.Objects[idx]);
      if APCEItem.Category = GetCat then
      begin
        CodeNarr := APCEItem.Code + U + APCEItem.Narrative;
        for i := 0 to lbxSection.Items.Count - 1 do
        begin
          if Pieces(lbxSection.Items[i], U, 1, 2) = CodeNarr then
          begin
            NewIdx := i;
            break;
          end;
        end;
      end;
    end;
    lbxSection.ItemIndex := NewIdx;
  finally
    FUpdatingGrid := FALSE;
  end;
end;

procedure TfrmPCEBaseMain.Sync2Section;
var
  i, idx: Integer;
  ACode: string;

begin
  if(FUpdatingGrid or FClosing) then exit;
  FUpdatingGrid := TRUE;
  try
    idx := lbxSection.ItemIndex;
    if(idx >= 0) then
      ACode := GetCat + U + Pieces(lbxSection.Items[idx], U, 1, 2)
    else
      ACode := '~@^~@^@~';
    for i := 0 to lbGrid.Items.Count - 1 do
    begin
      with TPCEItem(lbGrid.Items.Objects[i]) do
        lbGrid.Selected[i] := (ACode = (Category + U + Code + U + Narrative));
    end;
  finally
    FUpdatingGrid := FALSE;
  end;
end;

procedure TfrmPCEBaseMain.edtCommentKeyPress(Sender: TObject;
  var Key: Char);
begin
  inherited;
  if (Key = '?') and
     ((edtComment.Text = '') or (edtComment.SelStart = 0)) then
    Key := #0;
end;

end.
