unit fEncnt;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ORCtrls, ORDtTm, ORFn, ExtCtrls, ComCtrls, ORDtTmRng, fAutoSz, rGroupNote,
  Buttons;

type
  TfrmEncounter = class(TForm)
    cboPtProvider: TORComboBox;
    lblProvider: TLabel;
    cmdOK: TButton;
    cmdCancel: TButton;
    lblLocation: TLabel;
    txtLocation: TCaptionEdit;
    pgeVisit: TPageControl;
    tabNewVisit: TTabSheet;
    lblVisitDate: TLabel;
    lblNewVisit: TLabel;
    calVisitDate: TORDateBox;
    cboNewVisit: TORComboBox;
    dlgDateRange: TORDateRangeDlg;
    lblInstruct: TLabel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure pgeVisitChange(Sender: TObject);
    procedure cmdOKClick(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
    procedure cboNewVisitNeedData(Sender: TObject; const StartFrom: String;
      Direction, InsertAt: Integer);
    procedure calVisitDateChange(Sender: TObject);
    procedure cboNewVisitChange(Sender: TObject);
    procedure calVisitDateExit(Sender: TObject);
    procedure cboPtProviderNeedData(Sender: TObject;
      const StartFrom: String; Direction, InsertAt: Integer);
    procedure ckbHistoricalClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
  private
    FFilter: Int64;
    FPCDate: TFMDateTime;
    FProvider: Int64;
    FLocation: Integer;
    FLocationName: string;
    FDateTime: TFMDateTime;
    FVisitCategory: Char;
    FStandAlone: Boolean;
    FFromSelf: Boolean;
    FFromCreate: Boolean;
    FOldHintEvent: TShowHintEvent;
    OKPressed: Boolean;
    procedure AppShowHint(var HintStr: string; var CanShow: Boolean;
                          var HintInfo: THintInfo);
  public
    { Public declarations }
  end;

function UpdateEncounter(PersonFilter: Int64; ADate: TFMDateTime = 0; TIULocation: integer = 0): boolean;
procedure UpdateVisit(FontSize: Integer); overload;
procedure UpdateVisit(FontSize: Integer; TIULocation: integer); overload;

implementation

{$R *.DFM}

uses rCore, uCore, uConst, uPCE, rPCE
{$IFDEF ICD10DEBUG}
, fMainFrame
{$ENDIF}
, fxBroker;

const
  TC_MISSING = 'Incomplete Encounter Information';
  TX_NO_DATE = 'A valid date/time has not been entered.';
  TX_NO_TIME = 'A valid time has not been entered.';
  TX_NO_LOC  = 'A visit location has not been selected.';
  TC_LOCONLY = 'Location for Current Activities';

var
  uTIULocation: integer;
  uTIULocationName: string;

procedure UpdateVisit(FontSize: Integer);
begin
  UpdateEncounter(NPF_SUPPRESS);
end;

procedure UpdateVisit(FontSize: Integer; TIULocation: integer);
begin
  UpdateEncounter(NPF_SUPPRESS, 0, TIULocation);
end;

function UpdateEncounter(PersonFilter: Int64; ADate: TFMDateTime = 0;
  TIULocation: integer = 0): boolean;
const
  UP_SHIFT = 85;
var
  frmEncounter: TfrmEncounter;
//  CanChange: Boolean;
  TimedOut: Boolean;
begin
{$IFDEF ICD10DEBUG235}
  AddLogLine(Encounter.toString,'UpdateEncounter: Begin');
{$ENDIF}
  Result := False;
  uTIULocation := TIULocation;
  if uTIULocation <> 0 then uTIULocationName := ExternalName(uTIULocation, FN_HOSPITAL_LOCATION);
  frmEncounter := TfrmEncounter.Create(Application);
  try
    TimedOut := False;
    ResizeAnchoredFormToFont(frmEncounter);
    frmEncounter.FFilter := PersonFilter;
    frmEncounter.FPCDate := ADate;
    if PersonFilter = NPF_SUPPRESS then           // not prompting for provider
    begin
      frmEncounter.lblProvider.Visible := False;
      frmEncounter.cboPtProvider.Visible := False;
      frmEncounter.lblInstruct.Visible := True;
      frmEncounter.Caption := TC_LOCONLY;
      frmEncounter.Height := frmEncounter.Height - UP_SHIFT;
      if frmEncounter.pgeVisit.ActivePage = frmEncounter.tabNewVisit then
      begin
        if uTIULocation <> 0 then
          frmEncounter.ActiveControl := frmEncounter.calVisitDate
        else
          frmEncounter.ActiveControl := frmEncounter.cboNewVisit;
      end;
    end
    else                                          // also prompt for provider
    begin
      // InitLongList must be done AFTER FFilter is set
      frmEncounter.cboPtProvider.InitLongList(Encounter.ProviderName);
      frmEncounter.cboPtProvider.SelectByIEN(frmEncounter.FProvider);
    end;

    frmEncounter.ShowModal;

    if frmEncounter.OKPressed then with frmEncounter do
    begin
      if Encounter.Provider <> fProvider then
        begin
          Encounter.Provider      := FProvider;
// ICD-10. CodeCR CPRS235 -- adding provider name ------------------------------
          Encounter.ProviderName  := ExternalName(fProvider, FN_NEW_PERSON);
        end;

      Encounter.Location      := FLocation;
      Encounter.LocationName  := FLocationName;
      Encounter.DateTime      := FDateTime;
      Encounter.VisitCategory := FVisitCategory;
      Encounter.StandAlone    := FStandAlone;
      Result := True;
    end;

  finally
    frmEncounter.Release;
  end;
{$IFDEF ICD10DEBUG235}
  AddLogLine(Encounter.toString,'UpdateEncounter: End');
{$ENDIF}
end;

////////////////////////////////////////////////////////////////////////////////

procedure TfrmEncounter.FormCreate(Sender: TObject);

begin
  inherited;
  FProvider      := Encounter.Provider;
  FLocation      := Encounter.Location;
  FLocationName  := Encounter.LocationName;
  FDateTime      := Encounter.DateTime;
  FVisitCategory := Encounter.VisitCategory;
  FStandAlone    := Encounter.StandAlone;
  with txtLocation do if Length(FLocationName) > 0 then
  begin
    Text := FLocationName + '  ';
    if (FVisitCategory <> 'H') and (FDateTime <> 0) then
      Text := Text + FormatFMDateTime('mmm dd,yy hh:nn', FDateTime);
  end
  else Text := '< Select a location from the tabs below.... >';
  OKPressed := False;
  pgeVisitChange(Self);
  FOldHintEvent := Application.OnShowHint;
  Application.OnShowHint := AppShowHint;
  FFromCreate := False;
  cboNewVisit.LongList := True;
  cboNewVisit.InitLongList('');

{$IFDEF RPCLOG}
  SpeedButton1.Visible := True;
  SpeedButton2.Visible := True;
{$ENDIF}

end;

procedure TfrmEncounter.cboPtProviderNeedData(Sender: TObject; const StartFrom: string;
  Direction, InsertAt: Integer);
begin
  inherited;
  case FFilter of
    NPF_PROVIDER:  cboPtProvider.ForDataUse(SubSetOfProviders(StartFrom, Direction));
    else cboPtProvider.ForDataUse(SubSetOfPersons(StartFrom, Direction));
  end;
end;

procedure TfrmEncounter.pgeVisitChange(Sender: TObject);
begin
  inherited;
  if pgeVisit.ActivePage = tabNewVisit then
  begin
    if cboNewVisit.Items.Count = 0 then
    begin
      if FVisitCategory <> 'H' then
      begin
        if uTIULocation <> 0 then
        begin
          cboNewVisit.InitLongList(uTIULocationName);
          cboNewVisit.SelectByIEN(uTIULocation);
        end
        else
        begin
          cboNewVisit.InitLongList(FLocationName);
          if Encounter.Location <> 0 then cboNewVisit.SelectByIEN(FLocation);
        end;
        FFromSelf := True;
        with calVisitDate do if FDateTime <> 0 then FMDateTime := FDateTime else Text := 'NOW';
        FFromSelf := False;
      end
      else cboNewVisit.InitLongList('');
    end; {if cboNewVisit}
    if uTIULocation <> 0
      then ActiveControl := calVisitDate
    else if (FFromCreate and User.IsProvider) or (not FFromCreate) or (not cboPtProvider.Visible)
      then ActiveControl := cboNewVisit
  end; {if pgeVisit.ActivePage}
end;

procedure TfrmEncounter.SpeedButton1Click(Sender: TObject);
begin
{$IFDEF RPCLOG}
  PrevCall;
{$ENDIF}
end;

procedure TfrmEncounter.SpeedButton2Click(Sender: TObject);
begin
{$IFDEF RPCLOG}
  NextCall;
{$ENDIF}
end;

procedure TfrmEncounter.cboNewVisitNeedData(Sender: TObject; const StartFrom: string;
  Direction, InsertAt: Integer);
begin
  inherited;
  cboNewVisit.ForDataUse(rGroupNote.SubSetOfNewLocs(StartFrom, Direction));
end;

procedure TfrmEncounter.cboNewVisitChange(Sender: TObject);
begin
  inherited;
  with cboNewVisit do
  begin
    {if not IsValidLocation(ItemIEN) then
    begin
      ShowMessage('Invalid location for Group Notes.');
      ItemIndex := -1;
      Exit;
    end;}
    FLocation := ItemIEN;
    FLocationName := DisplayText[ItemIndex];
    FDateTime := calVisitDate.FMDateTime;
    with txtLocation do
    begin
      Text := FLocationName + '  ';
      if FDateTime <> 0 then Text := Text + FormatFMDateTime('mmm dd,yy hh:nn', FDateTime);
    end;
  end;
end;

procedure TfrmEncounter.calVisitDateChange(Sender: TObject);
begin
  inherited;
  if FFromSelf then Exit;
  if calVisitDate.FMDateTime > FMNow then
  begin
{$IFDEF ICD10DEBUG}
    ///
    /// TEST ONLY; allow Encounters with an ICD-10 date >= FMNow.
    ///
    if bICD10Debug then
      MessageDlg('Future date/time is being used.'+#13#10+
        '(DEBUG version only)', mtInformation, [mbOK], 0)
    else
      begin
        MessageDlg('Future date/time is not allowed', mtWarning,[mbOK],0);
        calVisitDate.FMDateTime := FMNow;
      end;
{$ELSE}
    MessageDlg('Future date/time is not allowed', mtWarning,[mbOK],0);
    calVisitDate.FMDateTime := FMNow;
{$ENDIF}
  end;
  with cboNewVisit do
  begin
    FLocation := ItemIEN;
    FLocationName := DisplayText[ItemIndex];
    FDateTime := calVisitDate.FMDateTime;
    txtLocation.Text := FLocationName + '  ' + calVisitDate.Text;
  end;
end;

procedure TfrmEncounter.calVisitDateExit(Sender: TObject);
begin
  inherited;
  with cboNewVisit do if ItemIEN > 0 then
  begin
    FLocation := ItemIEN;
    FLocationName := DisplayText[ItemIndex];
    FDateTime := calVisitDate.FMDateTime;
    with txtLocation do
    begin
      Text := FLocationName + '  ';
      if FDateTime <> 0 then Text := Text + FormatFMDateTime('mmm dd,yy hh:nn', FDateTime);
    end;
  end;
end;

procedure TfrmEncounter.cmdOKClick(Sender: TObject);
var
  msg: string;

begin
  inherited;
  msg := '';
  if FLocation = 0 then msg := TX_NO_LOC;
  if FDateTime <= 0 then msg := TX_NO_DATE;
  if(pos('.',FloatToStr(FDateTime)) = 0) then msg := TX_NO_TIME;
  if(msg <> '') then
  begin
    InfoBox(msg,  TC_MISSING, MB_OK);
    Exit;
  end;
  if FFilter <> NPF_SUPPRESS then FProvider := cboPtProvider.ItemIEN;
  OKPressed := True;
{$IFDEF ICD10DEBUG235}
//  AddLogLine(Encounter.toString,'Encounter Dlg: Begin');
{$ENDIF}
  Close;
{$IFDEF ICD10DEBUG235}
//  AddLogLine(Encounter.toString,'Encounter Dlg: end');
{$ENDIF}
end;

procedure TfrmEncounter.cmdCancelClick(Sender: TObject);
begin
  inherited;
  Close;
end;

procedure TfrmEncounter.ckbHistoricalClick(Sender: TObject);
begin
  //SetVisitCat;
end;

procedure TfrmEncounter.AppShowHint(var HintStr: string;
  var CanShow: Boolean; var HintInfo: THintInfo);
const
  HistHintDelay = 30000; // 30 seconds

begin
  if (not Assigned(HintInfo.HintControl)) then exit;
  if(assigned(FOldHintEvent)) then
    FOldHintEvent(HintStr, CanShow, HintInfo);
end;

procedure TfrmEncounter.FormDestroy(Sender: TObject);
begin
  //Application.OnShowHint := FOldHintEvent;     v22.11f - RV
end;


procedure TfrmEncounter.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Application.OnShowHint := FOldHintEvent;
end;


end.
