unit fDiagnoses;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fPCEBase, StdCtrls, CheckLst, ORCtrls, ExtCtrls, Buttons, uPCE, rPCE, ORFn,
  ComCtrls, fPCEBaseMain; //, UBAGlobals;

type
  TfrmDiagnoses = class(TfrmPCEBaseMain)
    cmdDiagPrimary: TButton;
    ckbDiagProb: TCheckBox;
    lblAdd2PL: TLabel;
    procedure cmdDiagPrimaryClick(Sender: TObject);
    procedure ckbDiagProbClicked(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnRemoveClick(Sender: TObject);
    procedure FormResize(Sender: TObject); override;
    procedure lbxSectionClickCheck(Sender: TObject; Index: Integer);

    //
    // NOTE: Set lbxSection.ItemTipEnable to False in order to see normal operation
    // of tooltip fly-over hints.  rpk 1/22/2012
    //
    procedure lbxSectionMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure lbxSectionEnter(Sender: TObject); // rpk 1/20/2012
  private
    procedure EnsurePrimaryDiag;
  protected
    procedure UpdateNewItemStr(var x: string); override;
    procedure UpdateControls; override;
  public
  end;

const
  // ICD10-R.
  xTX_INACTIVE_CODE = 'The "#" character next to the code for this problem indicates that the problem' + #13#10 +
    'references an ICD code that is not active as of the date of this encounter.' + #13#10 +
    'Before you can select this problem, you must update the ICD code it contains' + #13#10 +
    'via the Problems tab.';
  TX_INACTIVE_CODE =
    'The "#" character next to the code for this problem indicates ' + CRLF+
    'that the problem references an ICD code that is not active ' + CRLF+
    'as of the date of this encounter.' + CRLF+CRLF+
    'Before you can select this problem, you must '+ CRLF+
    'update the ICD code it contains via the Problems tab.';

  TC_INACTIVE_CODE = 'Problem Contains Inactive Code';

  TX_INV_ICD10_DX =
    'The selected ICD-10-CM diagnosis cannot be added to an encounter prior to ICD-10 implementation.' + CRLF + CRLF +
    'Please select a valid ICD-9-CM diagnosis which best describes the diagnosis.';
  TC_INV_ICD10_DX = 'Invalid Selection';

var
  frmDiagnoses: TfrmDiagnoses;

implementation

{$R *.DFM}

uses
  fEncounterFrame, uConst, uUtils, rMisc;

var
  CurrentItem: Integer;  // rpk 1/20/2012                             SDD 3.3.72  should be form field?

procedure TfrmDiagnoses.EnsurePrimaryDiag;
var
  i: Integer;
  Primary: Boolean;

begin
  with lbGrid do
  begin
    Primary := False;
    for i := 0 to Items.Count - 1 do
      if TPCEDiag(Items.Objects[i]).Primary then
        Primary := True;

    if not Primary and (Items.Count > 0) then
    begin
      GridIndex := 0;
      TPCEDiag(Items.Objects[0]).Primary := True;
      GridChanged;
    end;
  end;
end;

procedure TfrmDiagnoses.cmdDiagPrimaryClick(Sender: TObject);
var
  gi, i: Integer;
  ADiagnosis: TPCEDiag;

begin
  inherited;
  gi := GridIndex;
  with lbGrid do for i := 0 to Items.Count - 1 do
    begin
      ADiagnosis := TPCEDiag(Items.Objects[i]);
      ADiagnosis.Primary := (gi = i);
    end;
  GridChanged;
end;

procedure TfrmDiagnoses.ckbDiagProbClicked(Sender: TObject);
var
  i: integer;
const
  PL_ITEMS = 'Problem List Items';

begin
  inherited;
  if (NotUpdating) then
  begin
    for i := 0 to lbGrid.Items.Count - 1 do
      if (lbGrid.Selected[i]) then
        TPCEDiag(lbGrid.Items.Objects[i]).AddProb := (ckbDiagProb.Checked) and
          (TPCEDiag(lbGrid.Items.Objects[i]).Category <> PL_ITEMS);
    GridChanged;
  end;
end;

procedure TfrmDiagnoses.FormCreate(Sender: TObject);
begin
  inherited;
  FTabName := CT_DiagNm;
  FPCEListCodesProc := ListDiagnosisCodes;
  FPCEItemClass := TPCEDiag;
  FPCECode := 'POV';
  FSectionTabCount := 3;
  CurrentItem := -1; // rpk 1/21/2012         SDD 3.3.71
  FormResize(Self);
  ckbDiagProb.Caption := ''; // ICD-10. CodeCR CPRS163. Overlapping with lblAdd2Pl
  Application.HintHidePause := 15000;
{$IFDEF ICD10TEST01}
  cbICD10DebugRPC.Checked := gDebugProblemList;
{$ENDIF}
end;

procedure TfrmDiagnoses.btnRemoveClick(Sender: TObject);
begin
  inherited;
  EnsurePrimaryDiag;
end;

procedure TfrmDiagnoses.UpdateNewItemStr(var x: string);
begin
  inherited;
  if lbGrid.Items.Count = 0 then
    x := x + U + '1'
  else
    x := x + U + '0';
end;

procedure TfrmDiagnoses.UpdateControls;
var
  i, j, k, PLItemCount: integer;
  OK: boolean;
const
  PL_ITEMS = 'Problem List Items';
begin
  inherited;
  if (NotUpdating) then
  begin
    BeginUpdate;
    try
      cmdDiagPrimary.Enabled := (lbGrid.SelCount = 1);
      OK := (lbGrid.SelCount > 0);
      PLItemCount := 0;
      if OK then
        for k := 0 to lbGrid.Items.Count - 1 do
          if (lbGrid.Selected[k]) and
            (TPCEDiag(lbGrid.Items.Objects[k]).Category = PL_ITEMS) then
            PLItemCount := PLItemCount + 1;
      OK := OK and (PLItemCount < lbGrid.SelCount);
      lblAdd2PL.Enabled := OK;
      ckbDiagProb.Enabled := OK;
      if (OK) then
      begin
        j := 0;
        for i := 0 to lbGrid.Items.Count - 1 do
        begin
          if (lbGrid.Selected[i]) and
            (TPCEDiag(lbGrid.Items.Objects[i]).AddProb) then
            inc(j);
        end;
        if (j = 0) then
          ckbDiagProb.Checked := FALSE
        else
          if (j < lbGrid.SelCount) then
            ckbDiagProb.State := cbGrayed
          else
            ckbDiagProb.Checked := TRUE;
      end
      else
        ckbDiagProb.Checked := FALSE;
    finally
      EndUpdate;
    end;
  end;
end;

procedure TfrmDiagnoses.FormResize(Sender: TObject);
begin
  inherited;
  FSectionTabs[0] := -(lbxSection.width - LBCheckWidthSpace -
                      (8 * MainFontWidth) - ScrollBarWidth);
  FSectionTabs[1] := -FSectionTabs[0] + 2;
  FSectionTabs[2] := -FSectionTabs[0] + 4;
  UpdateTabPos;
end;

procedure TfrmDiagnoses.lbxSectionClickCheck(Sender: TObject;
  Index: Integer);
var
  sSystem: String;
  EncDT: TFMDateTime;
begin
  if not FUpdatingGrid then
    begin
    FUpdatingGrid := TRUE;
    if (lbxSection.Checked[Index]) and (Piece(lbxSection.Items[Index], U, 5) = '#') then
    begin
      InfoBox(TX_INACTIVE_CODE, TC_INACTIVE_CODE, MB_ICONWARNING or MB_OK);
      lbxSection.Checked[Index] := False;
      FUpdatingGrid := FALSE;
      btnOtherClick(btnOther);                              // ICD-10 SDD 3.3.73
      exit;
    end
    // CodeCR 186 -------------------------------------------------------- begin
{
    else if (Piece(Encounter.GetICDVersion, U, 1) = 'ICD') and
      ((Pos('ICD-10', Piece(lbxSection.Items[Index], U, 2)) > 0) or (Piece(lbxSection.Items[Index], U, 6)='10D')) then
    begin
      // Attempting to add an ICD10 diagnosis code to an ICD9 encounter
      InfoBox(TX_INV_ICD10_DX, TC_INV_ICD10_DX, MB_ICONERROR or MB_OK);
      lbxSection.Checked[Index] := False;
      exit;
    end
}
    else
      begin
        sSystem := Piece(lbxSection.Items[Index], U, 7);
        EncDT := Trunc(uEncPCEData.VisitDateTime);
        if (sSystem='ICD-10') and (Trunc(StrToFloat(GImplementationDate))>EncDT) then
        begin
          InfoBox(TX_INV_ICD10_DX, TC_INV_ICD10_DX, MB_ICONWARNING or MB_OK);
          lbxSection.Checked[Index] := False;
          FUpdatingGrid := FALSE;
          btnOtherClick(btnOther);                              // ICD-10 SDD 3.3.73
          exit;
        end;
      end;
    // CodeCR 186 ---------------------------------------------------------- end
    FUpdatingGrid := FALSE;
    end;
  inherited;
  EnsurePrimaryDiag;
end;

procedure TfrmDiagnoses.lbxSectionEnter(Sender: TObject);
begin
  inherited;
  CurrentItem := -1;  // rpk 2/22/2012                                SDD 3.3.73
end;

procedure TfrmDiagnoses.lbxSectionMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer); // rpk 1/20/2012
var
  idx: Integer;
  s: string;
  APoint: TPoint;
  lbx: TORListBox;  // rpk 2/27/2012


  function getItemStatus(anItem:String):String;
  begin
    Result := piece(anItem,U,5);
    if Result = '#'  then
      Result := '(#) '
    else
      Result := '';
  end;

begin
  inherited;

  APoint.X := X;
  APoint.Y := Y;

  lbx := Sender as TORListBox;
  idx := lbx.ItemAtPos(APoint, True);

  if (idx = -1) or (CurrentItem <> idx) then begin
    Application.CancelHint;
    lbx.Hint := '';
  end
  else begin
    s := lbx.Items[idx];
    // get ICD-10 long description in piece 6 and put in hover hint.
    If lbx.Name = 'lbGrid' then
      begin
        lbx.Hint := HintString(Piece(s, U, 4)); //DNS   BELLC [spec30.3.3]            SDD 3.3.73
      end
    else
      begin
        s := getItemStatus(s)+' '+Piece(s, U, 6);
        s := RemoveDuplicate(s,' - '); // RPC Description format fix for "Section Name" item
//        lbx.Hint := HintString(getItemStatus(s)+' '+Piece(s, U, 6));  // rpk 2/27/2012
        lbx.Hint := HintString(s);  // rpk 2/27/2012
      end;
  end;

  CurrentItem := idx;

end;  // lbxSectionMouseMove


end.
