unit uTIU;

interface

uses SysUtils, Classes, ORNet, ORFn, rCore, uCore, uConst, ORCtrls, ComCtrls, Controls;
  // ORCtrls is not required -- ICD10 20130603

type

  TEditNoteRec = record
    NoteIEN: int64;
    DocType: Integer;
    IsNewNote: boolean;
    Title: Integer;
    TitleName: string;
    DateTime: TFMDateTime;
    Author: Int64;
    AuthorName: string;
    Cosigner: Int64;
    CosignerName: string;
    Subject: string;
    Location: Integer;
    LocationName: string;
    VisitDate: TFMDateTime;
    PkgRef: string;      // 'IEN;GMR(123,' or 'IEN;SRF('
    PkgIEN: integer;     // file IEN
    PkgPtr: string;      // 'GMR(123,' or 'SRF(' 
    NeedCPT: Boolean;
    Addend: Integer;
    LastCosigner: Int64;
    LastCosignerName: string;
    IDParent: integer;
    ClinProcSummCode: integer;
    ClinProcDateTime: TFMDateTime;
    Lines:    TStrings;  // a complete patient note = Lines + PtLines
    GenLines: TStrings;  //general note content for all patients
    PtLines: TStrings;   //patient specific additional note's content
    ErrTxt: string;
  end;

  TNoteRec = TEditNoteRec;

  TActionRec = record
    Success: Boolean;
    Reason: string;
  end;

  TCreatedDoc = record
    IEN: Integer;
    ErrorText: string;
  end;

  TTIUContext = record
    Changed: Boolean;
    BeginDate: string;
    EndDate: string;
    FMBeginDate: TFMDateTime;
    FMEndDate: TFMDateTime;
    Status: string;
    Author: int64;
    MaxDocs: integer;
    ShowSubject: Boolean;
    SortBy: string;
    ListAscending: Boolean;
    GroupBy: string;
    TreeAscending: Boolean;
    SearchField: string;
    KeyWord: string;
    Filtered: Boolean;
  end ;

  TNoteTitles = class
    DfltTitle: Integer;
    DfltTitleName: string;
    ShortList: TStringList;
    constructor Create;
    destructor Destroy; override;
  end;

  TTIUPrefs = class
    DfltLoc: Integer;
    DfltLocName: string;
    SortAscending: Boolean;
    SortBy: string;    // D,R,S,A
    AskNoteSubject: Boolean;
    AskCosigner: Boolean;
    DfltCosigner: Int64;
    DfltCosignerName: string;
    MaxNotes: Integer;
  end;

//  notes tab specific procedures
function MakeNoteDisplayText(RawText: string): string;
function MakeConsultDisplayText(RawText:string): string;
function SetLinesTo74ForSave(AStrings: TStrings; AParent: TWinControl): TStrings;

implementation

function MakeConsultDisplayText(RawText:string): string;
var
 x: string;
begin
   x := RawText;
   Result := Piece(x, U, 2) + ',' + Piece(x, U, 3) + ',' +
             Piece(x, U, 4) + ', '+ Piece(x, U, 5);

end;

function MakeNoteDisplayText(RawText: string): string;
var
  x: string;
begin
  x := RawText;
  if Piece(x, U, 1) = '' then
    Result := FormatFMDateTime('mmm dd,yy', MakeFMDateTime(Piece(x, U, 3))) + '  ' +
        Piece(x, U, 2) + ', ' + Piece(x, U, 6) + ', ' + Piece(Piece(x, U, 5), ';', 2)
  else if Piece(x, U, 1)[1] in ['A', 'N', 'E'] then
    Result := Piece(x, U, 2)
  else
    Result := FormatFMDateTime('mmm dd,yy', MakeFMDateTime(Piece(x, U, 3))) + '  ' +
              Piece(x, U, 2) + ', ' + Piece(x, U, 6) + ', ' + Piece(Piece(x, U, 5), ';', 2);
end;


{ Progress Note Titles  -------------------------------------------------------------------- }
constructor TNoteTitles.Create;
{ creates an object to store progress note titles so only obtained from server once }
begin
  inherited Create;
  ShortList := TStringList.Create;
end;

destructor TNoteTitles.Destroy;
{ frees the lists that were used to store the progress note titles }
begin
  ShortList.Free;
  inherited Destroy;
end;

function SetLinesTo74ForSave(AStrings: TStrings; AParent: TWinControl): TStrings;
var
  ARichEdit74: TRichEdit;
begin
  Result := AStrings;
  ARichEdit74 := TRichEdit.Create(AParent);
  try
    with ARichEdit74 do
      begin
        Parent := AParent;
        Lines.Text := AStrings.Text;
        Width := 525;
        Result.Assign(Lines);
      end;
  finally
    ARichEdit74.Free;
  end;
end;

end.
