unit uGroupNote;

interface

uses
  Forms, Windows, Messages, SysUtils, Classes, ExtCtrls, ORSystem, ORFn, ORClasses, uPCE, uCore;

type
  TPatientData = Class(TObject)
  private
    FPtDFN: string;
    FPtName: string;
    FPtSSN: string;
  public
    procedure Clear;
    property PtDFN: string    read FPtDFN   write FPtDFN;
    property PtName: string   read FPtName  write FPtName;
    property PtSSN: string    read FPtSSN   write FPtSSN;
  end;

const
  UM_SHOWPAGE     = (WM_USER + 9336);  // originally in fFrame

  PG_GNPTSEL = 1;
  LB_GNPTSEL = 'frmGNPtSel';
  PG_GNECTER = 2;
  LB_GNECTER = 'frmGNEncounter';
  TXT_NOSELECT = 'You need to select at least one patient';

var
  GNPtList: TList;
  BaseEncounter: TPCEData;

procedure CleanGNPtList;


implementation

uses rGroupNote;

var
  URLMonHandle: THandle = 0;

{ TPatientData }

procedure TPatientData.Clear;
begin
  FPtDFN := '';
  FPtName := '';
  FPtSSN := '';
end;

procedure CleanGNPtList;
var
  i: integer;
begin
  if not Assigned(GNPtList) then Exit;
  for i := GNPtList.Count - 1 downto 0 do
  begin
    if TPatient(GNPtList.Items[i]) <> nil then
      TPatient(GNPtList.Items[i]).Free;
  end;
  if GnPtList.Count > 0 then
    GNPtList.Clear;
end;

initialization
  BaseEncounter := TPCEData.Create;

finalization
  BaseEncounter.Free;

end.
