{ **************************************************************
	Package: XWB - Kernel RPCBroker
	Date Created: Sept 18, 1997 (Version 1.1)
	Site Name: Oakland, OI Field Office, Dept of Veteran Affairs
	Developers: Herlan Westra
	Description: Contains TRPCBroker and related components.
  Unit: XMLbroker encapsulates and parses RPC data calls into XML documents
        to use the XML (M2M) RPC broker in VistA.
	Current Release: Version 1.1 Patch 60
*************************************************************** }

{ **************************************************
  Changes in v1.1.60 (HGW 4/7/2015) XWB*1.1*60
  1. Experimental: First attempt to use XML (M2M) broker in VistA instead of
     old or new style broker. If successful, this will pave the way for using
     SOAP headers for security and authentication, wide strings, unicode data,
     true encryption, and centralized Identification and Access Management (IAM)
     SecID services.
************************************************** }
unit XMLbroker;

interface

uses
  {System}
  //AnsiStrings, SysUtils,
  Classes,
  {WinApi}
  //Windows, WinTypes, WinProcs, WinSock2,
  {VA}
  //Xwbut1, Trpcb, RpcbErr,
  {VCL}
  //Dialogs, Forms, Controls, StdCtrls, ClipBrd,
  {XML}
  XMLDoc, Xml.xmldom, Xml.Win.msxmldom, Xml.XMLSchema; // Xml.XMLIntf;

type
  {Use TXMLDocument to represent an XML document. TXMLDocument can read an
  existing XML document from a file, it can be associated with an in-memory
  string that is the contents of an XML document, or it can create a new, empty
  XML document. TXMLDocument implements the IXMLDocument interface. Typically,
  the TXMLDocument component is the starting point for working with an XML
  document.}
  //TXMLDocument = class(TComponent, IInterface, IXMLDocument, IXMLDocumentAccess)
  TXMLDocument = class(TComponent)
    private
    //XCounter: integer; //placeholder, not sure what types I'll need
    public
    //XObject: string;   //placeholder, not sure what types I'll need
  end;
  PXMLDocument = ^TXMLDocument;

  {Use IXMLDocument to work with an XML document. Applications can obtain an
  IXMLDocument interface through a TXMLDocument component, using the global
  LoadXMLDocument function, or through the OwnerDocument property of any node
  in the document. You can use IXMLDocument to access the contents of an XML
  document and to create new nodes. In addition, IXMLDocument lets you load an
  XML document that is stored on disk or assign a string of raw (unparsed) XML
  as the contents of the document.}
  //IXMLDocument = interface(IInterface)
  //end;

var
  xmldoc : TXMLDocument;

implementation
  var strXML : string;
  //strXML := "<a><a1>1</a1><a2>2</a2></a>";
  //xmldoc.loadXML(strXML);  //loadXML is Windows implementation of DOM

{ See Wsockc.TXWBWinsock.BuildPar which is where the RPC Broker data is currently
built for the call to VistA. Also see where the initial connection is set up.
Maybe build functions in this unit for both the initial connection and subsequent
calls to VistA.

TRPCBroker.pchCall calls:
  TXWBWinsock(XWBWinsock).tCall(Socket, RemoteProcedure, RpcVersion, Param,
                      Sec, App,FRPCTimeLimit)
  which calls:
  BuildPar(hSocket, api, apVer, Parameters)
}

  {
  procedure SaveToXML(var XML: DOMString); overload;
  procedure SaveToXML(var XML: WideString); overload;
  procedure SaveToXML(var XML: UTF8String); overload;

  procedure LoadFromXML(const XML: AnsiString); overload;
  procedure LoadFromXML(const XML: DOMString); overload;

  TXMLDocument uses an external DOM(Document Object Model) parser to analyze the
  XML document. This parser is usually assigned by specifying the DOMVendor
  property.

  [
  Note to self, use Windows.Data.Xml.Dom APIs and SAX2 APIs. See
  msdn.microsoft.com/en-us/library/ms763742(v=vs.85).aspx
  ]

  [
  Note to self, create an API and sample application to read/save an external
  XML file to test with VistA to test new IAM services.
  ]

  Use the XML Data Binding Wizard to generate interface and class definitions
  that correspond to the structure of an XML document or schema. The wizard
  generates a global function that returns the interface for the root element
  of the document. The wizard is only available inside an existing Delphi application.
  }

  {
  Possibly mirror VistA APIs as methods:
  $$ATTRIB^MXMLDOM(handle,node[,attrib])
    This extrinsic function retrieves the first or next attribute associated
    with the specified node.
  $$CHILD^MXMLDOM(handle,parent[,child])
    This extrinsic function retrieves the node of the first or next child of
    a given parent node, or zero (0) if there are none remaining.
  $$CMNT^MXMLDOM(handle,node,text)
    This extrinsic function extracts comment text associated with the specified
    node.
  DELETE^MXMLDOM(handle)
    This API deletes the specified document instance. A client application
    should always call this API when finished with a document instance.
  $$EN^MXMLDOM(doc[,opt])
    This extrinsic function performs initial processing of the XML document.
    The client application must first call this entry point to build the
    in-memory image of the document before the remaining methods can be applied.
    The return value is a handle to the document instance that was created and
    is used by the remaining API calls to identify a specific document instance.
    The parameters for this entry point are listed by type, requirement (yes or
    no), and description.
  $$NAME^MXMLDOM(handle,node)
    This extrinsic function retrieves the name of the element at the specified
    node within the document parse tree.
  $$PARENT^MXMLDOM(handle,node)
    This extrinsic function retrieves the parent node of the specified node, or
    zero (0) if there is none.
  $$SIBLING^MXMLDOM(handle,node)
    This extrinsic function retrieves the node of the specified node's immediate
    sibling, or zero (0) if there is none.
  $$TEXT^MXMLDOM(handle,node,text)
    This extrinsic function extracts non-markup text associated with the
    specified node.
  TEXT^MXMLDOM(handle,node,text)
    This API extracts non-markup text associated with the specified node.
  $$VALUE^MXMLDOM(handle,node[,attrib])
    This extrinsic function retrieves the value associated with the named
    attribute.
  EN^MXMLPRSE(doc[,cbk][,opt])
    This API is based on the well-established Simple API for XML (SAX) interface
    employed by many XML parsers. This API has a single method.
  $$SYMENC^MXMLUTL(str)
    This extrinsic function replaces reserved XML symbols in a string with their
    XML encoding for strings used in an extensible markup language (XML) message.
  $$XMLHDR^MXMLUTL
    This extrinsic function returns a standard extensible markup language (XML)
    header for encoding XML messages.
  }
end.
