function loadLOBForm() {

    var HDFORMID = "1b2cbe28-74b5-48a9-9187-4568b0852b0e";
    var HBFORMID = "6b9bedc8-de6c-458a-862e-438da6ee1d1f";
    var ROFORMID = "924f3759-91e8-415c-a3c7-7f283e94eef7";
    var NCCHVFORMID = "6ed0e345-cd03-4ad9-937b-b8642b3f521c";
    var HECFORMID = "caa14ba1-0a64-4818-8593-ee1584d05980";
    
    if (Xrm.Page.ui.getFormType() != 1) {
        var currentFormName = Xrm.Page.ui.formSelector.getCurrentItem().getLabel();
        var currentFormId = Xrm.Page.ui.formSelector.getCurrentItem().getId();

        var lob = Xrm.Page.getAttribute("DNS  m_lobid").getValue();
        var formId = ROFORMID;

        switch (lob[0].name) {
            case "Help Desk":
                if (Xrm.Page.ui.formSelector.items.get(HDFORMID) != null) {
                    formId = HDFORMID;
                }
                break;
            case "Health Benefits":
                if (Xrm.Page.ui.formSelector.items.get(HBFORMID) != null) {
                    formId = HBFORMID;
                }
                break;
            case "HRC":
                if (Xrm.Page.ui.formSelector.items.get(ROFORMID) != null) {
                    formId = HBFORMID;
                }
                break;
            case "NCCHV":
                if (Xrm.Page.ui.formSelector.items.get(NCCHVFORMID) != null) {
                    formId = NCCHVFORMID;
                }
                break;
			 case "HEC":
                if (Xrm.Page.ui.formSelector.items.get(HECFORMID) != null) {
                    formId = HECFORMID;
                }
                break;
            default:
                formId = ROFORMID;
                break;
        }

        if (Xrm.Page.ui.formSelector.items.get(formId) != null && currentFormId != formId) {
            Xrm.Page.ui.formSelector.items.get(formId).navigate();
        }
    }
}

var refresh = {
    firstname_OnChange: function() {
        refreshMVI();
    },

    lastname_OnChange: function() {
        refreshMVI();
    },

    dob_OnChange: function () {
        refreshMVI();
    },

    ssn_OnChange: function () {
        refreshMVI();
    },

    edipi_OnChange: function () {
        refreshMVI();
    },

    gender_OnChange: function () {
        refreshMVI();
    },

    daytimePhone_OnChange: function () {
        refreshMVI();
    },
}

function refreshMVI() {
    try { 
        var webResArea = Xrm.Page.ui.controls.get("WebResource_mvisearch");
        webResArea.setSrc(webResArea.getSrc());
    }
    catch (e) {
        alert('Error in refreshMVI(): ' + e.Message);
    }
}

var mvi = {
    personSelected: function (id, name) {
        var veteran = new Array();
        veteran[0] = new Object();
        veteran[0].id = id;
        veteran[0].name = name;
        veteran[0].entityType = "contact";
        Xrm.Page.getAttribute("bah_veteranid").setValue(veteran);

        loadWebParts();

        Xrm.Page.getAttribute("bah_veteranid").fireOnChange();
    }
}

function loadEsrResources(icn) {
    SDK.REST.retrieveMultipleRecords("bah_keyvaluepair",
		"$select=*&$filter=bah_name_text eq 'esr_endpoint'",
		function (data) {
		    if (data.length > 0) {
		        //figure out the full url to the BAH esr proxy
		        var esrEndpoint = data[0].bah_stringvalue_text;
		        var actualEndpoint = esrEndpoint.replace('{0}', '000000' + icn + '000000'); //pad ICN with six zeroes on beginning and end

		        //build the querystring to call the page that will query esr and display the data - note CRM requires everything be encoded and passed in a 'data' parameter
		        var qs = 'data=' + encodeURIComponent('esr=' + encodeURIComponent(actualEndpoint));

		        //array containing esr resources to load - assumes iframes are named WebResource_[resourcename] - this is case sensitive!
		        //also assumes web resources are named .../[resourcename].htm - this is not case sensitive.
		        //var resources = ['enrollment', 'eligibility', 'demographics'];

		        if (arguments.length > 1) {
		            for (var i = 1; i < arguments.length; i++) {
		                //get a reference to the iframe
		                var webresource = Xrm.Page.ui.controls.get('WebResource_' + arguments[i]);

		                //set the iframe's url
		                var webresourceUrl = Xrm.Page.context.getClientUrl() + '/webresources/DNS  m_/ESRParts/' + arguments[i] + '.htm?' + qs;
		                webresource.setSrc(webresourceUrl);
		            }
		        }
		    }
		},
		function (error) {
		    //do nothing
		},
		function () {
		    //do nothing on completion
		}
	);
}