﻿/// <reference path='../../triipcrm_/TR_KU_V2015_2_902/js/jquery.min.js' />
/// <reference path='../../triipcrm_/TR_KU_V2015_2_902/js/kendo.all.min.js' />

//CorrespondenceAddressSelectorScriptLib.js
//Contains variables and functions used by the CorrespondenceAddressSelector.html page

//Static Variables
var cas_crmOdataEndPoint = '/XRMServices/2011/OrganizationData.svc';
var cas_veteranId = null;
var cas_context = GetGlobalContext();
var cas_serverUrl = cas_context.getClientUrl();
var cas_crmEntityId = window.parent.Xrm.Page.data.entity.getId();
cas_crmEntityId = cas_reformatCrmGuid(cas_crmEntityId);
var cas_crmEntityTypeName = window.parent.Xrm.Page.data.entity.getEntityName();
var cas_checkedIds = {};


function cas_FormLoad() {
    try {
        //Get the Veteran Id (contactid) from the parent form
        if (parent.Xrm.Page.getAttribute('DNS  m_veteranid') != null && parent.Xrm.Page.getAttribute('DNS  m_veteranid').getValue() != null) {
            cas_veteranId = cas_reformatCrmGuid(parent.Xrm.Page.getAttribute('DNS  m_veteranid').getValue()[0].id);
        }
        if (cas_veteranId == null) {
            //No veteran selected
            cas_delayFormLoadEvent();
            return false;
        }

        //Proceed to grid data load....
        cas_createAddressSelectorGrid();
    }
    catch (err) {
        alert("Correspondence Address Selector Web Resource Function Error(cas_FormLoad): " + err.message);
    }
}

function cas_delayFormLoadEvent() {
    try {
        setTimeout(function () {
            //Wait 2 seconds and retry Form Load function to check for Veteran Id
            cas_FormLoad();
        }, 2000);
    }
    catch (err) {
        alert("Correspondence Address Selector Web Resource Function Error(cas_delayFormLoadEvent): " + err.message);
    }
}

function cas_createAddressSelectorGrid() {
    try {
        $('#ku_addressselectorgrid').kendoGrid({
            columns: [
            { field: 'ID', type: 'string', hidden: true },
            { field: 'Primary', title: 'Primary', type: 'boolean', template: '<input type="checkbox" #= Primary ? "checked=checked" : "" # disabled="disabled"  />', width: 70 },
            { field: 'Mailing', title: 'Mailing', type: 'boolean', template: '<input type="checkbox" #= Mailing ? "checked=checked" : "" # disabled="disabled"  />', width: 70 },
            { field: 'Address', title: 'Address', type: 'string', width: 300 },
            { field: 'Street1', title: 'Street1', type: 'string', width: 120, hidden: true },
            { field: 'Street2', title: 'Street2', type: 'string', width: 120, hidden: true },
            { field: 'Street3', title: 'Street3', type: 'string', width: 120, hidden: true },
            { field: 'City', title: 'City', type: 'string', width: 120, hidden: true },
            { field: 'StateCode', title: 'StateCode', type: 'integer', width: 120, hidden: true },
            { field: 'StateName', title: 'StateName', type: 'string', width: 120, hidden: true },
            { field: 'PostalCode', title: 'PostalCode', type: 'string', width: 120, hidden: true },
            { field: 'CountryCode', title: 'CountryCode', type: 'integer', width: 120, hidden: true },
            { field: 'CountryName', title: 'CountryName', type: 'string', width: 120, hidden: true },
            { field: 'Title', title: 'Title', type: 'string', width: 120 }
            ],
            dataSource: {
                schema: {
                    model: {
                        id: 'ID'
                    }
                }
            },
            groupable: false,
            sortable: false,
            editable: false,
            height: 170,
            resizable: true,
            navigatable: true,
            selectable: "row",
            noRecords: true,
            change: cas_selectGridRow
        });

        //Populate Address Grid
        var cas_addressSelectorGrid = $('#ku_addressselectorgrid').data('kendoGrid');
        cas_getCrmContactAddressData(cas_addressSelectorGrid);
    }
    catch (err) {
        alert('Address Selector Script Failure: Function(cas_createAddressSelectorGrid) Error Detail: ' + err.message);
        return null;
    }
}

function cas_getCrmContactAddressData(cas_addressSelectorControl) {
    try {
        var cas_attributeSet = 'ContactId, Address1_Line1, Address1_Line2, Address1_Line3, Address1_City, bah_address1_state_code, ' +
        'Address1_PostalCode, bah_address1_country_code, DNS  m_address1_isprimary_bool, DNS  m_address1_ismailing_bool, ' +
        'Address2_Line1, Address2_Line2, Address2_Line3, Address2_City, bah_address2_state_code, Address2_PostalCode, ' +
        'bah_address2_country_code, DNS  m_address2_isprimary_bool, DNS  m_address2_ismailing_bool';
        var cas_contactData = cas_getSingleEntityDataSync('ContactSet', cas_attributeSet , cas_veteranId);
        if (cas_contactData != null) {
            //Extract data retrieved
            if (cas_contactData.d.ContactId != null) {
                var cas_address1 = '';
                var cas_addr1_line1 = null;
                var cas_addr1_line2 = null;
                var cas_addr1_line3 = null;
                var cas_addr1_city = null;
                var cas_addr1_statecode = null;
                var cas_addr1_statename = null;
                var cas_addr1_postalcode = null;
                var cas_addr1_countrycode = null;
                var cas_addr1_countryname = null;
                var cas_addr1_isprimary = null;
                var cas_addr1_ismailing = null;

                var cas_address2 = '';
                var cas_addr2_line1 = null;
                var cas_addr2_line2 = null;
                var cas_addr2_line3 = null;
                var cas_addr2_city = null;
                var cas_addr2_statecode = null;
                var cas_addr2_statename = null;
                var cas_addr2_postalcode = null;
                var cas_addr2_countrycode = null;
                var cas_addr2_countryname = null;
                var cas_addr2_isprimary = null;
                var cas_addr2_ismailing = null;

                //Get Address 1 info
                if (cas_contactData.d.Address1_Line1 != null) { cas_addr1_line1 = cas_contactData.d.Address1_Line1; }
                if (cas_contactData.d.Address1_Line2 != null) { cas_addr1_line2 = cas_contactData.d.Address1_Line2; }
                if (cas_contactData.d.Address1_Line3 != null) { cas_addr1_line3 = cas_contactData.d.Address1_Line3; }
                if (cas_contactData.d.Address1_City != null) { cas_addr1_city = cas_contactData.d.Address1_City; }
                if (cas_contactData.d.bah_address1_state_code != null) {
                    cas_addr1_statecode = cas_contactData.d.bah_address1_state_code.Value;
                    if (cas_addr1_statecode != null) {
                        cas_addr1_statename = parent.Xrm.Page.getAttribute('DNS  m_state_code').getOption(cas_addr1_statecode).text;
                    }
                }
                if (cas_contactData.d.Address1_PostalCode != null) { cas_addr1_postalcode = cas_contactData.d.Address1_PostalCode; }
                if (cas_contactData.d.bah_address1_country_code != null) {
                    cas_addr1_countrycode = cas_contactData.d.bah_address1_country_code.Value;
                    if (cas_addr1_countrycode != null) {
                        cas_addr1_countryname = parent.Xrm.Page.getAttribute('DNS  m_country_code').getOption(cas_addr1_countrycode).text;
                    }
                }
                if (cas_contactData.d.DNS  m_address1_isprimary_bool != null) { cas_addr1_isprimary = cas_contactData.d.DNS  m_address1_isprimary_bool; }
                if (cas_contactData.d.DNS  m_address1_ismailing_bool != null) { cas_addr1_ismailing = cas_contactData.d.DNS  m_address1_ismailing_bool; }

                //Get Address 2 info
                if (cas_contactData.d.Address2_Line1 != null) { cas_addr2_line1 = cas_contactData.d.Address2_Line1; }
                if (cas_contactData.d.Address2_Line2 != null) { cas_addr2_line2 = cas_contactData.d.Address2_Line2; }
                if (cas_contactData.d.Address2_Line3 != null) { cas_addr2_line3 = cas_contactData.d.Address2_Line3; }
                if (cas_contactData.d.Address2_City != null) { cas_addr2_city = cas_contactData.d.Address2_City; }
                if (cas_contactData.d.bah_address2_state_code != null) {
                    cas_addr2_statecode = cas_contactData.d.bah_address2_state_code.Value;
                    if (cas_addr2_statecode != null) {
                        cas_addr2_statename = parent.Xrm.Page.getAttribute('DNS  m_state_code').getOption(cas_addr2_statecode).text;
                    }
                }
                if (cas_contactData.d.Address2_PostalCode != null) { cas_addr2_postalcode = cas_contactData.d.Address2_PostalCode; }
                if (cas_contactData.d.bah_address2_country_code != null) {
                    cas_addr2_countrycode = cas_contactData.d.bah_address2_country_code.Value;
                    if (cas_addr2_countrycode != null) {
                        cas_addr2_countryname = parent.Xrm.Page.getAttribute('DNS  m_country_code').getOption(cas_addr2_countrycode).text;
                    }
                }
                if (cas_contactData.d.DNS  m_address2_isprimary_bool != null) { cas_addr2_isprimary = cas_contactData.d.DNS  m_address2_isprimary_bool; }
                if (cas_contactData.d.DNS  m_address2_ismailing_bool != null) { cas_addr2_ismailing = cas_contactData.d.DNS  m_address2_ismailing_bool; }

                //Construct Address 1
                if (cas_addr1_line1 != null) { cas_address1 = cas_address1 + cas_addr1_line1; }
                if (cas_addr1_line2 != null) { if (cas_address1 == '') { cas_address1 = cas_address1 + cas_addr1_line2; } else { cas_address1 = cas_address1 + '  ' + cas_addr1_line2; } }
                if (cas_addr1_city != null) { if (cas_address1 == '') { cas_address1 = cas_address1 + cas_addr1_city + ','; } else { cas_address1 = cas_address1 + '  ' + cas_addr1_city + ','; } }
                if (cas_addr1_statename != null) { if (cas_address1 == '') { cas_address1 = cas_address1 + cas_addr1_statename; } else { cas_address1 = cas_address1 + ' ' + cas_addr1_statename; } }
                if (cas_addr1_postalcode != null) { if (cas_address1 == '') { cas_address1 = cas_address1 + cas_addr1_postalcode; } else { cas_address1 = cas_address1 + ' ' + cas_addr1_postalcode; } }
                if (cas_addr1_countryname != null) { if (cas_address1 == '') { cas_address1 = cas_address1 + cas_addr1_countryname; } else { cas_address1 = cas_address1 + ' ' + cas_addr1_countryname; } }

                //Construct Address 2
                if (cas_addr2_line1 != null) { cas_address2 = cas_address2 + cas_addr2_line1; }
                if (cas_addr2_line2 != null) { if (cas_address2 == '') { cas_address2 = cas_address2 + cas_addr2_line2; } else { cas_address2 = cas_address2 + '  ' + cas_addr2_line2; } }
                if (cas_addr2_city != null) { if (cas_address2 == '') { cas_address2 = cas_address2 + cas_addr2_city + ','; } else { cas_address2 = cas_address2 + ' ' + cas_addr2_city + ','; } }
                if (cas_addr2_statename != null) { if (cas_address2 == '') { cas_address2 = cas_address2 + cas_addr2_statename; } else { cas_address2 = cas_address2 + ' ' + cas_addr2_statename; } }
                if (cas_addr2_postalcode != null) { if (cas_address2 == '') { cas_address2 = cas_address2 + cas_addr2_postalcode; } else { cas_address2 = cas_address2 + ' ' + cas_addr2_postalcode; } }
                if (cas_addr2_countryname != null) { if (cas_address2 == '') { cas_address2 = cas_address2 + cas_addr2_countryname; } else { cas_address2 = cas_address2 + ' ' + cas_addr2_countryname; } }

                //Determine if Address 1 info should be added
                if (cas_addr1_line1 != null || cas_addr1_line2 != null) {
                    cas_addressSelectorControl.dataSource.pushCreate({
                        ID: '01',
                        Primary: cas_addr1_isprimary,
                        Mailing: cas_addr1_ismailing,
                        Address: cas_address1,
                        Street1: cas_addr1_line1,
                        Street2: cas_addr1_line2,
                        Street3: cas_addr1_line3,
                        City: cas_addr1_city,
                        StateCode: cas_addr1_statecode,
                        StateName: cas_addr1_statename,
                        PostalCode: cas_addr1_postalcode,
                        CountryCode: cas_addr1_countrycode,
                        CountryName: cas_addr1_countryname,
                        Title: 'Address 1'
                    });
                }

                //Determine if Address 2 info should be added
                if (cas_addr2_line1 != null || cas_addr2_line2 != null) {
                    cas_addressSelectorControl.dataSource.pushCreate({
                        ID: '02',
                        Primary: cas_addr2_isprimary,
                        Mailing: cas_addr2_ismailing,
                        Address: cas_address2,
                        Street1: cas_addr2_line1,
                        Street2: cas_addr2_line2,
                        Street3: cas_addr2_line3,
                        City: cas_addr2_city,
                        StateCode: cas_addr2_statecode,
                        StateName: cas_addr2_statename,
                        PostalCode: cas_addr2_postalcode,
                        CountryCode: cas_addr2_countrycode,
                        CountryName: cas_addr2_countryname,
                        Title: 'Address 2'
                    });
                }
            }
        }

        //Get additional Address Entity Data for this veteran
        cas_getCrmAddressEntityData(0, cas_addressSelectorControl);
    }
    catch (err) {
        alert('Address Selector Script Failure: Function(cas_getCrmContactAddressData) Error Detail: ' + err.message);
        return null;
    }
}

function cas_getCrmAddressEntityData(cas_skipCount, cas_addressSelectorControl) {
    try {
        var cas_conditionalFilter = '(ParentId/Id eq (guid' + "'" + cas_veteranId + "'" + ') and ObjectTypeCode eq ' + "'contact'" + ' and AddressNumber ge 4)';
        cas_getMultipleEntityDataAsync('CustomerAddressSet', 'CustomerAddressId, Name, Line1, Line2, Line3, City, bah_state_code, PostalCode, bah_country_code, DNS  m_isprimary_bool, DNS  m_ismailing_bool', cas_conditionalFilter, 'AddressNumber', 'asc', cas_skipCount, cas_getCrmAddressEntityData_response, cas_addressSelectorControl);
    }
    catch (err) {
        alert('Address Selector Script Failure: Function(cas_getCrmAddressEntityData) Error Detail: ' + err.message);
        return null;
    }
}

function cas_getCrmAddressEntityData_response(cas_addressEntityData, cas_lastSkip, cas_addressSelectorControl) {
    try {
        //cas_lastSkip is the starting point in the result (use if more than 50 records)
        for (var i = 0; i <= cas_addressEntityData.d.results.length - 1; i++) {
            var cas_addressid = null;
            var cas_addresstitle = null;
            var cas_address1 = '';
            var cas_addr1_line1 = null;
            var cas_addr1_line2 = null;
            var cas_addr1_line3 = null;
            var cas_addr1_city = null;
            var cas_addr1_statecode = null;
            var cas_addr1_statename = null;
            var cas_addr1_postalcode = null;
            var cas_addr1_countrycode = null;
            var cas_addr1_countryname = null;
            var cas_addr1_isprimary = null;
            var cas_addr1_ismailing = null;

            //Get Address 1 info
            if (cas_addressEntityData.d.results[i].CustomerAddressId != null) { cas_addressid = cas_addressEntityData.d.results[i].CustomerAddressId; }
            if (cas_addressEntityData.d.results[i].Name != null) { cas_addresstitle = cas_addressEntityData.d.results[i].Name; }
            if (cas_addressEntityData.d.results[i].Line1 != null) { cas_addr1_line1 = cas_addressEntityData.d.results[i].Line1; }
            if (cas_addressEntityData.d.results[i].Line2 != null) { cas_addr1_line2 = cas_addressEntityData.d.results[i].Line2; }

            if (cas_addressEntityData.d.results[i].Line3 != null) { cas_addr1_line3 = cas_addressEntityData.d.results[i].Line3; }
            if (cas_addressEntityData.d.results[i].City != null) { cas_addr1_city = cas_addressEntityData.d.results[i].City; }
            if (cas_addressEntityData.d.results[i].bah_state_code != null) {
                cas_addr1_statecode = cas_addressEntityData.d.results[i].bah_state_code.Value;
                if (cas_addr1_statecode != null) {
                    cas_addr1_statename = parent.Xrm.Page.getAttribute('DNS  m_state_code').getOption(cas_addr1_statecode).text;
                }
            }
            if (cas_addressEntityData.d.results[i].PostalCode != null) { cas_addr1_postalcode = cas_addressEntityData.d.results[i].PostalCode; }
            if (cas_addressEntityData.d.results[i].bah_country_code != null) {
                cas_addr1_countrycode = cas_addressEntityData.d.results[i].bah_country_code.Value;
                if (cas_addr1_countrycode != null) {
                    cas_addr1_countryname = parent.Xrm.Page.getAttribute('DNS  m_country_code').getOption(cas_addr1_countrycode).text;
                }
            }
            if (cas_addressEntityData.d.results[i].DNS  m_isprimary_bool != null) { cas_addr1_isprimary = cas_addressEntityData.d.results[i].DNS  m_isprimary_bool; }
            if (cas_addressEntityData.d.results[i].DNS  m_ismailing_bool != null) { cas_addr1_ismailing = cas_addressEntityData.d.results[i].DNS  m_ismailing_bool; }

            //Construct Address 1
            if (cas_addr1_line1 != null) { cas_address1 = cas_address1 + cas_addr1_line1; }
            if (cas_addr1_line2 != null) { if (cas_address1 == '') { cas_address1 = cas_address1 + cas_addr1_line2; } else { cas_address1 = cas_address1 + '  ' + cas_addr1_line2; } }
            if (cas_addr1_city != null) { if (cas_address1 == '') { cas_address1 = cas_address1 + cas_addr1_city + ','; } else { cas_address1 = cas_address1 + '  ' + cas_addr1_city + ','; } }
            if (cas_addr1_statename != null) { if (cas_address1 == '') { cas_address1 = cas_address1 + cas_addr1_statename; } else { cas_address1 = cas_address1 + ' ' + cas_addr1_statename; } }
            if (cas_addr1_postalcode != null) { if (cas_address1 == '') { cas_address1 = cas_address1 + cas_addr1_postalcode; } else { cas_address1 = cas_address1 + ' ' + cas_addr1_postalcode; } }
            if (cas_addr1_countryname != null) { if (cas_address1 == '') { cas_address1 = cas_address1 + cas_addr1_countryname; } else { cas_address1 = cas_address1 + ' ' + cas_addr1_countryname; } }

            //Determine if Address info should be added
            if (cas_addr1_line1 != null || cas_addr1_line2 != null) {
                cas_addressSelectorControl.dataSource.pushCreate({
                    ID: cas_addressid,
                    Primary: cas_addr1_isprimary,
                    Mailing: cas_addr1_ismailing,
                    Address: cas_address1,
                    Street1: cas_addr1_line1,
                    Street2: cas_addr1_line2,
                    Street3: cas_addr1_line3,
                    City: cas_addr1_city,
                    StateCode: cas_addr1_statecode,
                    StateName: cas_addr1_statename,
                    PostalCode: cas_addr1_postalcode,
                    CountryCode: cas_addr1_countrycode,
                    CountryName: cas_addr1_countryname,
                    Title: cas_addresstitle
                });
            }
        }
        if (cas_addressEntityData.d.__next != null) {
            cas_getCrmAddressEntityData(cas_lastSkip + 50, cas_addressSelectorControl);
        }
    }
    catch (err) {
        alert('Address Selector Script Failure: Function(cas_getCrmAddressEntityData_response) Error Detail: ' + err.message);
        return null;
    }
}

//Common Script Functions
//********************************************************
function cas_reformatCrmGuid(cas_crmGuid) {
    cas_crmGuid = cas_crmGuid.replace('%7b', '');
    cas_crmGuid = cas_crmGuid.replace('%7d', '');
    cas_crmGuid = cas_crmGuid.replace('{', '');
    cas_crmGuid = cas_crmGuid.replace('}', '');
    return cas_crmGuid;
}
//*********************************************************

//Address Selector Grid Event Functions
//*********************************************************
function cas_selectGridRow(arg) {
    try {
        var cas_selectedRows = this.select();
        var cas_selectedDataItems = [];
        for (var i = 0; i < cas_selectedRows.length; i++) {
            var cas_dataItem = this.dataItem(cas_selectedRows[i]);
            //Write back selected data to CRM parent form
            parent.Xrm.Page.getAttribute('DNS  m_line1_text').setValue(cas_dataItem.Street1);
            parent.Xrm.Page.getAttribute('DNS  m_line2_text').setValue(cas_dataItem.Street2);
            parent.Xrm.Page.getAttribute('DNS  m_city_text').setValue(cas_dataItem.City);
            parent.Xrm.Page.getAttribute('DNS  m_state_code').setValue(cas_dataItem.StateCode);
            parent.Xrm.Page.getAttribute('DNS  m_postalcode_text').setValue(cas_dataItem.PostalCode);
            parent.Xrm.Page.getAttribute('DNS  m_country_code').setValue(cas_dataItem.CountryCode);
			parent.Xrm.Page.getAttribute('DNS  m_addressname_text').setValue(cas_dataItem.Title);
        }
    }
    catch (err) {
        alert("Correspondence Address Selector Web Resource Function Error(cas_selectGridRow): " + err.message);
    }
}
//*********************************************************

//Crm Ajax Query Funcions
//*********************************************************
function cas_executeCrmOdataGetRequest(cas_jsonQuery, cas_aSync, cas_aSyncCallback, cas_skipCount, cas_optionArray) {
    //This function executes a CRM Odata web service call to retrieve Crm data
    //*cas_jsonQuery* - a properly formatted CRM Odata Query string (required)
    //*cas_aSync* - specify 'true' to execute asynchronously otherwise 'false' (required)
    //*cas_aSyncCallback* - specify the name of the return function to call upon completion (required if cas_aSync = true.  Otherwise '')
    //*cas_skipCount* - Initial setting is always '0', increments by 50 per CRM SDK Odata standards (required)
    //*cas_optionArray* - is an optional array or single value, that contains additional task specific variables that can be passed between functions (pass 'null' if not used)
    try {
        var cas_entityData = null;
        $.ajax({
            type: 'GET',
            contentType: 'application/json; charset=utf-8',
            datatype: 'json',
            url: cas_jsonQuery,
            beforeSend: function (XMLHttpRequest) {
                XMLHttpRequest.setRequestHeader('Accept', 'application/json');
            },
            success: function (data, textStatus, XmlHttpRequest) {
                cas_entityData = data;
                if (cas_aSync == true) {
                    cas_aSyncCallback(cas_entityData, cas_skipCount, cas_optionArray);
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                alert('Fail: Ajax Error in cas_executeCrmOdataGetRequest: ' + errorThrown);
            },
            async: cas_aSync,
            cache: false
        });
        return cas_entityData;
    }
    catch (err) {
        alert('An error occured in the cas_executeCrmOdataGetRequest function.  Error Detail Message: ' + err);
    }
}

function cas_getSingleEntityDataSync(cas_entitySetName, cas_attributeSet, cas_entityId) {
    //This function returns a CRM JSON dataset for a single entity record based on the entity id provided Syncronously
    //*cas_entitySetName* - is the name of the entity set e.g 'ContactSet'
    //*cas_attributeSet* -  is a string containing the Crm Attributes to retrieve e.g. 'FirstName, LastName, Telephone1, EMailAddress1'
    //*cas_entityId* - is the Guid for the entity record

    try {
        var cas_entityIdNoBracket = cas_entityId.replace(/({|})/g, '');
        var cas_selectString = '(guid' + "'" + cas_entityIdNoBracket + "'" + ')?$select=' + cas_attributeSet;
        var cas_jsonQuery = cas_serverUrl + cas_crmOdataEndPoint + '/' + cas_entitySetName + cas_selectString;
        var cas_entityData = cas_executeCrmOdataGetRequest(cas_jsonQuery, false, '', 0, null);
        return cas_entityData;
    }
    catch (err) {
        alert('An error occured in the cas_getSingleEntityDataSync function.  Error Detail Message: ' + err);
    }
}

function cas_getMultipleEntityDataAsync(cas_entitySetName, cas_attributeSet, cas_conditionalFilter, cas_sortAttribute, cas_sortDirection, cas_skipCount, cas_aSyncCallback, cas_optionArray) {
    //This function returns a CRM JSON dataset for all entity records matching criteria provided Asyncronously
    //*cas_entitySetName* - is the name of the entity set e.g 'ContactSet'
    //*cas_attributeSet* -  is a string containing the Crm Attributes to retrieve e.g. 'FirstName, LastName, Telephone1, EMailAddress1'
    //*cas_conditionalFilter* - is the conditional filter value placed on the data values retrived e.g. 'StateCode/Value eq 0'  to retrieve active contact records only
    //*cas_sortAttribute* - is a string containing the name of the attribute to sort the result set by e.g. 'LastName'
    //*cas_sortDirection* - is a string specifying the sort as Ascending or Descending e.g. 'asc' or 'desc'
    //*cas_skipCount* - is the starting point in the result (use if more than 50), (Put 0 if not used)
    //*cas_aSyncCallback* - is the name of the function to call when returning the result
    //*cas_optionArray* - is an optional array, that contains additional task specific variables that can be passed between functions

    try {
        var cas_jsonQuery = cas_serverUrl + cas_crmOdataEndPoint + '/' + cas_entitySetName + '?$select=' + cas_attributeSet + '&$filter=' + cas_conditionalFilter + '&$orderby=' + cas_sortAttribute + ' ' + cas_sortDirection + '&$skip=' + cas_skipCount;
        cas_executeCrmOdataGetRequest(cas_jsonQuery, true, cas_aSyncCallback, cas_skipCount, cas_optionArray);
    }
    catch (err) {
        alert('An error occured in the cas_getMultipleEntityDataAsync function.  Error Detail Message: ' + err);
    }
}
//*********************************************************