package vler.exchange.domain.data.generation;

import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.openhealthtools.mdht.uml.cda.ccd.CCDFactory;
import org.openhealthtools.mdht.uml.cda.ccd.ContinuityOfCareDocument;
import org.openhealthtools.mdht.uml.cda.util.CDAUtil;

/**
 * Abstract data generator Primary responsibility is to create the Base CCD Document 
 * @author MesserleB
 *
 */
public class AbstractDataGenerator {
	
	/** MDHT CCD **/
	private ContinuityOfCareDocument document;
	
	/** File name of the xml file **/
	private String outputFileName;
	

	/**
	 * @return the document
	 */
	public final ContinuityOfCareDocument getDocument() {
		return document;
	}

	/**
	 * @param document the document to set
	 */
	public final void setDocument(ContinuityOfCareDocument document) {
		this.document = document;
	}
	
	
	/**
	 * @return the outputFileName
	 */
	public final String getOutputFileName() {
		return outputFileName;
	}

	/**
	 * @param outputFileName the outputFileName to set
	 */
	public final void setOutputFileName(String outputFileName) {
		this.outputFileName = outputFileName;
	}

	public void generateXml() throws Exception{
	
		final SimpleDateFormat dateformatMMDDYYYY = new SimpleDateFormat("MMddyyyyHHmmss");
		final String s = dateformatMMDDYYYY.format(new Date());

		final File outfile = new File(this.getOutputFileName());
		System.out.println("outputfile: " + outfile);

		// // if file doesnt exists, then create it
		// if (!outfile.exists()) {
		// outfile.createNewFile();
		// }
		//
		FileWriter fw = new FileWriter(outfile.getAbsoluteFile());
		CDAUtil.save(this.getDocument(), fw);
		fw.flush();
		fw.close();
		
		
	}
	
	
	/**
	 * Create the CCD Document
	 */
	public void createDocument(){
		this.setDocument(CCDFactory.eINSTANCE.createContinuityOfCareDocument().init());
	}
	
	
}
