<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:n3="http://www.w3.org/1999/xhtml"
	xmlns:n1="urn:hl7-org:v3"
	xmlns:n2="urn:hl7-org:v3/meta/voc"
	xmlns:voc="urn:hl7-org:v3/voc"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:section="urn:gov.va.med"
	xmlns:msxsl="urn:schemas-microsoft-com:xslt">
		
	
	<xsl:output method="html" indent="yes" version="4.01" encoding="ISO-8859-1"/>
	
	<xsl:template match="/">
	<!--
		<xsl:copy-of select="/n1:ClinicalDocument/n1:component/n1:structuredBody/n1:component/n1:section[n1:code/@code='48765-2']/n1:text/n1:table"/>
	-->	
		<xsl:call-template name="displayAllergyTable"/>
	</xsl:template>
	

	<xsl:template name="displayAllergyTable">
		<xsl:variable name="allergySection" select="/n1:ClinicalDocument/n1:component/n1:structuredBody/n1:component/n1:section[n1:code/@code='48765-2']"/>
		<xsl:variable name="allergyTable" select="$allergySection/n1:text/n1:table"/>
		
		<!--  Get the table -->
		<table style="font-size:14p" border="1">
			<thead>
				<tr>
					<xsl:for-each select="$allergyTable/n1:thead/n1:tr/n1:th">
						<th class="first"><xsl:value-of select="."/></th>
					</xsl:for-each>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="$allergyTable/n1:tbody/n1:tr">
					<xsl:sort select="./n1:td[3]"/>
					<xsl:message><xsl:value-of select="./n1:td[3]"/></xsl:message>
					<tr class="second">
						<td>
							<xsl:call-template name="displayDataRow">
								<xsl:with-param name="tableRow" select="."/>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	
	<xsl:template name="displayAllergyDataRow">
		<xsl:param name="tableRow"/>
		<xsl:message><xsl:value-of select="$tableRow"/></xsl:message>
		<xsl:for-each select="$tableRow/n1:td">
			<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
				<span onmouseover="DisplayTip(this,25,-50,0)"><xsl:value-of select="."/></span>
			</div>
		</xsl:for-each>
	</xsl:template>
 	
	<!--
	<xsl:template match="/n1:ClinicalDocument/n1:component/n1:structuredBody/n1:component/n1:section[n1:code/@code='48765-2']/n1:text/n1:table">
		<xsl:copy>
			<xsl:attribute name="style">font-size:14px</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="n1:thead/n1:tr/n1:th">
		<xsl:copy>
			<xsl:attribute name="class">first</xsl:attribute>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="n1:tbody/n1:tr">
		<xsl:copy-of select="n1:tbody"/>
		<xsl:copy>
			<xsl:attribute name="class">second</xsl:attribute>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="n1:td">
		<n1:tr>
			<n1:div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
				<xsl:value-of select="."/>
			</n1:div>
		</n1:tr>
	</xsl:template>
-->	
</xsl:stylesheet>