package vler.exchange.domain.data.generation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openhealthtools.mdht.uml.cda.Act;
import org.openhealthtools.mdht.uml.cda.AssignedAuthor;
import org.openhealthtools.mdht.uml.cda.Author;
import org.openhealthtools.mdht.uml.cda.CDAFactory;
import org.openhealthtools.mdht.uml.cda.ClinicalDocument;
import org.openhealthtools.mdht.uml.cda.Component1;
import org.openhealthtools.mdht.uml.cda.Consumable;
import org.openhealthtools.mdht.uml.cda.EncompassingEncounter;
import org.openhealthtools.mdht.uml.cda.Encounter;
import org.openhealthtools.mdht.uml.cda.EntryRelationship;
import org.openhealthtools.mdht.uml.cda.HealthCareFacility;
import org.openhealthtools.mdht.uml.cda.Location;
import org.openhealthtools.mdht.uml.cda.ManufacturedProduct;
import org.openhealthtools.mdht.uml.cda.Material;
import org.openhealthtools.mdht.uml.cda.Observation;
import org.openhealthtools.mdht.uml.cda.Organization;
import org.openhealthtools.mdht.uml.cda.Participant2;
import org.openhealthtools.mdht.uml.cda.ParticipantRole;
import org.openhealthtools.mdht.uml.cda.Person;
import org.openhealthtools.mdht.uml.cda.Place;
import org.openhealthtools.mdht.uml.cda.PlayingEntity;
import org.openhealthtools.mdht.uml.cda.Procedure;
import org.openhealthtools.mdht.uml.cda.Product;
import org.openhealthtools.mdht.uml.cda.SubstanceAdministration;
import org.openhealthtools.mdht.uml.cda.Supply;
import org.openhealthtools.mdht.uml.cda.ccd.AgeObservation;
import org.openhealthtools.mdht.uml.cda.ccd.CCDFactory;
import org.openhealthtools.mdht.uml.cda.ccd.EncounterLocation;
import org.openhealthtools.mdht.uml.cda.ccd.ProblemAct;
import org.openhealthtools.mdht.uml.cda.ccd.ProblemObservation;
import org.openhealthtools.mdht.uml.cda.ccd.ProblemSection;
import org.openhealthtools.mdht.uml.cda.ccd.SupplyActivity;
import org.openhealthtools.mdht.uml.hl7.datatypes.AD;
import org.openhealthtools.mdht.uml.hl7.datatypes.CD;
import org.openhealthtools.mdht.uml.hl7.datatypes.CE;
import org.openhealthtools.mdht.uml.hl7.datatypes.CS;
import org.openhealthtools.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.openhealthtools.mdht.uml.hl7.datatypes.ED;
import org.openhealthtools.mdht.uml.hl7.datatypes.EN;
import org.openhealthtools.mdht.uml.hl7.datatypes.II;
import org.openhealthtools.mdht.uml.hl7.datatypes.IVL_TS;
import org.openhealthtools.mdht.uml.hl7.datatypes.IVXB_TS;
import org.openhealthtools.mdht.uml.hl7.datatypes.ON;
import org.openhealthtools.mdht.uml.hl7.datatypes.PN;
import org.openhealthtools.mdht.uml.hl7.datatypes.SXCM_TS;
import org.openhealthtools.mdht.uml.hl7.datatypes.TEL;
import org.openhealthtools.mdht.uml.hl7.datatypes.TS;
import org.openhealthtools.mdht.uml.hl7.vocab.NullFlavor;
import org.openhealthtools.mdht.uml.hl7.vocab.ParticipationTargetLocation;
import org.openhealthtools.mdht.uml.hl7.vocab.ParticipationType;
import org.openhealthtools.mdht.uml.hl7.vocab.RoleClassRoot;
import org.openhealthtools.mdht.uml.hl7.vocab.x_ActRelationshipEntryRelationship;

public class Generators {
	private static String[] rootTIds = { "1.3.6.1.4.1.19376.1.5.3.1.1.1", "2.16.840.1.113883.10.20.3",
			"2.16.840.1.113883.3.88.11.32.1", "2.16.840.1.113883.3.88.11.83.1" };

	private static GetWords word = new GetWords();

	public static ClinicalDocument createCCDDocument() {
		ClinicalDocument cda = CCDFactory.eINSTANCE.createContinuityOfCareDocument().init();
		cda.getTemplateIds().addAll(createRootTIds());

		return cda;
	}

	public static IVL_TS createTime(final String value, final String low, final String high) {
		IVL_TS ts = DatatypesFactory.eINSTANCE.createIVL_TS();
		if (StringUtils.isNotBlank(value)) {
			ts.setValue(value);
		}

		if (StringUtils.isNotBlank(low)) {
			ts.setLow(createTime(low, null));
		}

		if (StringUtils.isNotBlank(high)) {
			ts.setHigh(createTime(high, null));
		}

		return ts;
	}

	public static IVXB_TS createTime(final String value, final NullFlavor nullFlavor) {
		IVXB_TS ts = DatatypesFactory.eINSTANCE.createIVXB_TS();

		if (StringUtils.isNotBlank(value)) {
			ts.setValue(value);
		}

		if (nullFlavor != null) {
			ts.setNullFlavor(nullFlavor);
		}
		return ts;
	}

	public static TS createTimeValue(final String time) {
		TS ts = DatatypesFactory.eINSTANCE.createTS(time);
		return ts;
	}

	public static SXCM_TS createRootTime(final String value) {
		SXCM_TS time = DatatypesFactory.eINSTANCE.createSXCM_TS();
		time.setValue(value);
		return time;
	}

	public static Observation createObservation(final IVL_TS time, final CD code, final Author author, final ED text) {
		Observation obs = CCDFactory.eINSTANCE.createAlertObservation().init();
		obs.setEffectiveTime(time);
		obs.setCode(code);
		obs.getAuthors().add(author);
		obs.setStatusCode(createCode(word.next()));
		obs.setText(text);
		return obs;
	}

	public static II createII(final String root, final String extension) {
		II ii = DatatypesFactory.eINSTANCE.createII();
		if (StringUtils.isNotBlank(root)) {
			ii.setRoot(root);
		}

		if (StringUtils.isNotBlank(extension)) {
			ii.setExtension(extension);
		}

		return ii;
	}

	public static List<II> createRootTIds() {
		List<II> ret = new ArrayList<II>();
		for (String id : rootTIds) {
			II newId = DatatypesFactory.eINSTANCE.createII();
			newId.setRoot(id);
			ret.add(newId);
		}
		if (CollectionUtils.isNotEmpty(ret)) {
			return ret;
		}

		return Collections.emptyList();
	}

	public static EN createEN(final String name) {
		EN en = DatatypesFactory.eINSTANCE.createEN();

		en.addText(name);

		return en;
	}

	public static PN createPN(final String name) {
		PN pn = DatatypesFactory.eINSTANCE.createPN();

		pn.addText(name);

		return pn;
	}

	public static Material createMaterial() {
		Material mat = CDAFactory.eINSTANCE.createMaterial();
		mat.setCode(createCode(word.next()));
		mat.setName(createEN(word.next()));
		return mat;
	}

	public static ManufacturedProduct createManProduct() {
		ManufacturedProduct manProd = CDAFactory.eINSTANCE.createManufacturedProduct();
		manProd.setManufacturedMaterial(createMaterial());
		manProd.setManufacturerOrganization(createRepOrg(word.next()));
		return manProd;
	}

	public static Product createProduct() {
		Product product = CDAFactory.eINSTANCE.createProduct();
		product.setManufacturedProduct(createManProduct());
		return product;
	}

	public static Consumable createConsumable() {
		Consumable cons = CDAFactory.eINSTANCE.createConsumable();
		cons.setManufacturedProduct(createManProduct());
		return cons;
	}

	public static CD createCode(final String codeVal, final String codeSystem, final String codeSystemName,
			final String displayName, final ED originalText, final List<? extends CD> trans) {
		CD code = DatatypesFactory.eINSTANCE.createCD();
		code.setCode(codeVal);
		code.setCodeSystem(codeSystem);
		code.setCodeSystemName(codeSystemName);
		code.setDisplayName(displayName);
		code.setOriginalText(originalText);
		if (CollectionUtils.isNotEmpty(trans)) {
			code.getTranslations().addAll(trans);
		}
		return code;
	}

	public static ED createOriginalText(final String text, final TEL ref) {
		ED oText = DatatypesFactory.eINSTANCE.createED();
		if (StringUtils.isNotBlank(text)) {
			oText.addText(text);
		}
		if (ref != null) {
			oText.setReference(ref);
		}
		return oText;
	}

	public static TEL createRef(final String reference) {
		TEL ref = DatatypesFactory.eINSTANCE.createTEL();
		ref.setValue(reference);
		return ref;
	}

	public static Organization createRepOrg(final String name) {
		Organization org = CDAFactory.eINSTANCE.createOrganization();
		ON oName = DatatypesFactory.eINSTANCE.createON();
		oName.addText(name);
		org.getNames().add(oName);
		return org;
	}

	public static Person createPerson(final String name) {
		Person person = CDAFactory.eINSTANCE.createPerson();
		PN pn = DatatypesFactory.eINSTANCE.createPN();
		pn.addText(name);
		person.getNames().add(pn);
		return person;
	}

	public static AssignedAuthor createAssignedAuthor(final String name) {
		AssignedAuthor aAuthor = CDAFactory.eINSTANCE.createAssignedAuthor();
		aAuthor.setAssignedPerson(createPerson(name));
		aAuthor.setRepresentedOrganization(createRepOrg(word.next()));

		return aAuthor;
	}

	public static Author createAuthor(final String name) {
		Author author = CDAFactory.eINSTANCE.createAuthor();
		author.setTime(createTimeValue(word.next()));
		author.setAssignedAuthor(createAssignedAuthor(name));

		return author;
	}

	public static EntryRelationship createReason(final String reason) {
		EntryRelationship entry = CDAFactory.eINSTANCE.createEntryRelationship();
		entry.setTypeCode(x_ActRelationshipEntryRelationship.RSON);

		Encounter encounter = CDAFactory.eINSTANCE.createEncounter();
		encounter.setText(createOriginalText(reason, null));
		entry.setEncounter(encounter);

		return entry;
	}

	public static CE createCECode(final String codeVal, final String codeSystem, final String codeSystemName,
			final String displayName, final ED originalText, final List<? extends CD> trans) {
		CE code = DatatypesFactory.eINSTANCE.createCE();
		code.setCode(codeVal);
		code.setCodeSystem(codeSystem);
		code.setCodeSystemName(codeSystemName);
		code.setDisplayName(displayName);
		code.setOriginalText(originalText);
		if (CollectionUtils.isNotEmpty(trans)) {
			code.getTranslations().addAll(trans);
		}
		return code;
	}

	public static CS createCode(final String code) {
		CS cs = DatatypesFactory.eINSTANCE.createCS();
		cs.setCode(code);

		return cs;
	}

	public static PlayingEntity createPlayingEntity() {
		PlayingEntity entity = CDAFactory.eINSTANCE.createPlayingEntity();
		entity.setCode(createCode(word.next()));
		entity.getNames().add(createPN(word.next() + ", " + word.next()));
		return entity;
	}

	public static ParticipantRole createRole(final RoleClassRoot classCode) {
		ParticipantRole role = CDAFactory.eINSTANCE.createParticipantRole();
		if (classCode != null) {
			role.setClassCode(RoleClassRoot.SDLOC);
		}
		role.setPlayingEntity(createPlayingEntity());
		return role;
	}

	public static Participant2 createParticipant(final ParticipationType type, final RoleClassRoot classCode) {
		Participant2 part = CDAFactory.eINSTANCE.createParticipant2();
		if (type != null) {
			part.setTypeCode(type);
		}
		part.setTime(createTime(word.next(), null, null));

		part.setParticipantRole(createRole(classCode));
		return part;
	}

	public static Act createAct() {
		Act act = CDAFactory.eINSTANCE.createAct();
		act.getIds().add(createII(null, word.next()));
		act.setCode(createCode(null, null, null, word.next(), null, null));
		act.setText(createOriginalText(word.next(), null));
		act.setStatusCode(createCode(word.next()));
		act.setEffectiveTime(createTime(word.next(), null, null));
		act.getAuthors().add(createAuthor(word.next()));
		act.getEntryRelationships().add(createReason(word.next()));
		// Create facility location
		act.getParticipants().add(createParticipant(ParticipationType.LOC, RoleClassRoot.SDLOC));
		// Create Admission Source
		act.getParticipants().add(createParticipant(ParticipationType.ORG, null));

		return act;
	}

	public static AD createAddress() {
		AD ad = DatatypesFactory.eINSTANCE.createAD();

		ad.addCountry(word.next());
		ad.addStreetAddressLine(word.next());
		ad.addState(word.next());

		return ad;
	}

	public static ClinicalDocument createEncompassing() {
		ClinicalDocument ccd = Generators.createCCDDocument();

		Component1 c1 = CDAFactory.eINSTANCE.createComponent1();
		ccd.setComponentOf(c1);

		EncompassingEncounter encounter = CDAFactory.eINSTANCE.createEncompassingEncounter();
		c1.setEncompassingEncounter(encounter);

		encounter.getIds().add(createII(null, word.next()));
		encounter.setCode(createCECode(null, null, null, "Some rando", null, null));
		encounter.setDischargeDispositionCode(createCECode(null, null, null, "Clean Bill of Health", null, null));
		encounter.setEffectiveTime(createTime(word.next(), null, null));

		Location loc = CDAFactory.eINSTANCE.createLocation();
		encounter.setLocation(loc);

		loc.setTypeCode(ParticipationTargetLocation.LOC);

		HealthCareFacility hcf = CDAFactory.eINSTANCE.createHealthCareFacility();
		loc.setHealthCareFacility(hcf);

		hcf.getIds().add(createII(word.next(), word.next()));
		hcf.setCode(createCECode(null, null, null, "Some Facility Type", null, null));

		Place place = CDAFactory.eINSTANCE.createPlace();
		hcf.setLocation(place);

		place.setAddr(createAddress());
		place.setName(createEN(word.next()));

		return ccd;
	}

	public static Encounter createEncounter() {
		Encounter encounter = CCDFactory.eINSTANCE.createEncountersActivity().init();
		encounter.getIds().add(createII(null, word.next()));
		encounter.setCode(createCode(null, null, null, word.next(), null, null));
		encounter.setText(createOriginalText(word.next(), null));
		encounter.setEffectiveTime(createTime(word.next(), null, null));
		encounter.setPriorityCode(createCode(word.next()));
		encounter.getAuthors().add(createAuthor(word.next()));
		encounter.getEntryRelationships().add(createReason(word.next()));
		EncounterLocation loc = CCDFactory.eINSTANCE.createEncounterLocation().init();
		loc.setTime(createTime(null, word.next(), word.next()));
		loc.setParticipantRole(createRole(RoleClassRoot.ROL));
		encounter.getParticipants().add(loc);
		return encounter;
	}

	public static Observation createObservation() {
		Observation obs = CCDFactory.eINSTANCE.createAlertObservation().init();
		obs.getIds().add(createII(null, word.next()));
		obs.setCode(createCode(null, null, null, word.next(), createOriginalText(word.next(), null), null));
		obs.setText(createOriginalText(word.next(), null));
		obs.setStatusCode(createCode(word.next()));
		obs.setEffectiveTime(createTime("Today", null, null));
		obs.getAuthors().add(createAuthor(word.next()));
		obs.getEntryRelationships().add(createReason(word.next()));
		return obs;
	}

	public static Supply createSupply() {
		SupplyActivity supply = CCDFactory.eINSTANCE.createSupplyActivity().init();
		supply.getIds().add(createII(null, word.next()));
		supply.setCode(createCode("334443", "System", null, word.next(), null, null));
		supply.setText(createOriginalText(word.next(), null));
		supply.getEffectiveTimes().add(createRootTime(word.next()));
		supply.getAuthors().add(createAuthor(word.next()));
		supply.setProduct(createProduct());
		supply.getEntryRelationships().add(createReason(word.next()));

		return supply;
	}

	public static Procedure createProcedure() {
		Procedure proc = CCDFactory.eINSTANCE.createProcedureActivityProcedure().init();
		proc.getIds().add(createII(null, word.next()));
		proc.setCode(createCode(null, null, null, word.next(), createOriginalText(word.next(), null), null));
		proc.setText(createOriginalText(word.next(), null));
		proc.setStatusCode(createCode(word.next()));
		proc.setEffectiveTime(createTime("Today", null, null));
		proc.getAuthors().add(createAuthor(word.next()));
		proc.getEntryRelationships().add(createReason(word.next()));
		proc.getApproachSiteCodes().add(createCode(null, null, null, word.next(), null, null));
		proc.getTargetSiteCodes().add(createCode(null, null, null, word.next(), null, null));
		proc.setPriorityCode(createCode(word.next()));

		return proc;
	}

	public static SubstanceAdministration createSubstance() {
		SubstanceAdministration sub = CDAFactory.eINSTANCE.createSubstanceAdministration();
		sub.getIds().add(createII(null, word.next()));
		sub.setCode(createCode("334443", "System", null, word.next(), null, null));
		sub.setText(createOriginalText(word.next(), null));
		sub.getEffectiveTimes().add(createRootTime(word.next()));
		sub.getAuthors().add(createAuthor(word.next()));
		sub.setConsumable(createConsumable());
		sub.getEntryRelationships().add(createReason(word.next()));

		return sub;
	}

	public static void createProblem() {
		ProblemSection ps = CCDFactory.eINSTANCE.createProblemSection().init();
		ProblemAct pa = CCDFactory.eINSTANCE.createProblemAct().init();
		ProblemObservation po = CCDFactory.eINSTANCE.createProblemObservation().init();
		AgeObservation ao = CCDFactory.eINSTANCE.createAgeObservation().init();

	}
}
