<#include "parsingFunctions.xml">

<#macro displayDefault>
	-@-
</#macro>

<#macro valueOrDefault value="">
	<#if value?? || value?has_content>
		${value}
	<#else>
		<@displayDefault />
	</#if>
</#macro>

<#macro displayCode code>
<#-- BR for Displaying codes.  1) OriginalTextRef 2) OriginalText 3)codeDisplayName 4) Code -->
<#if code.codeOriginalTextMap??>
	<#assign omap = code.codeOriginalTextMap>
	<${omap.name} 
	<#list omap.attributes as attr>
		${attr.reference}="${attr.value}"
	</#list>
	>${omap.value!"--"}
	</${omap.name}>
<#elseif code.codeOriginalText??>
	${code.codeOriginalText}
<#elseif code.codeDisplayName??>
	${code.codeDisplayName}	
<#elseif code.translations??>
	<#list code.translations as tran>
		${tran.codeDisplayName!""}
	</#list>
<#elseif code.code??>
	${code.code}
</#if>
</#macro>

<#macro codeDispTranText code={}>
<#if code.codeDisplayName??>
	${code.codeDisplayName}
<#elseif code.translations??>
	<#list code.translations as tran>
		${tran.codeDisplayName!"--"}
	</#list>
<#elseif code.codeOriginalText??>
	${code.codeOriginalText}
<#else>
	--
</#if>
</#macro>

<#macro codeDispTextText code={}>
<#if code.codeDisplayName??>
	${code.codeDisplayName}
<#elseif code.codeOriginalText??>
	${code.codeOriginalText}
<#elseif code.OriginalTextMap??>
	<#assign omap = code.OriginalTextMap>
	<${omap.name} 
	<#list omap.attributes as attr>
		${attr.reference}="${attr.value}"
	</#list>
	>${omap.value!"--"}
	</${omap.name}>
<#elseif code.OriginalText??>
	${code.OriginalText}
<#else>
	--
</#if>
</#macro>

<#macro codeDispTran code={}>
<#if code.codeDisplayName??>
	${code.codeDisplayName}
<#elseif code.translations??>
	<#list code.translations as tran>
		${tran.codeDisplayName!"--"}
	</#list>
<#else>
	--
</#if>
</#macro>

 <#macro codeOriginalText code={}>
<#if code.codeOriginalTextMap??>
	<#assign omap = code.codeOriginalTextMap>
	<${omap.name} 
	<#list omap.attributes as attr>
		${attr.reference}="${attr.value}"
	</#list>
	>${omap.value!"--"}
	</${omap.name}>
<#elseif code.codeOriginalText??>
	${code.codeOriginalText}
<#else>
	--
</#if>
</#macro>
 
<#macro codeOriginalTextText code={}>
<#if code.codeOriginalTextMap??>
	<#assign omap = code.codeOriginalTextMap>
	<${omap.name} 
	<#list omap.attributes as attr>
		${attr.reference}="${attr.value}"
	</#list>
	>${omap.value!"--"}
	</${omap.name}>
<#elseif code.codeOriginalText??>
	${code.codeOriginalText}
<#else>
	<@displayTextWithDefault code />
</#if>
</#macro>

<#macro displayCodeWithDefault code={}>
<#-- BR for Displaying codes.  1) OriginalTextRef 2) OriginalText 3)codeDisplayName 4) Code -->
<#if ! code??>
	--
	<#return>
</#if>
<#if code.codeOriginalTextMap??>
	<#assign omap = code.codeOriginalTextMap>
	<${omap.name} 
	<#list omap.attributes as attr>
		${attr.reference}="${attr.value}"
	</#list>
	>${omap.value!"--"}
	</${omap.name}>
<#elseif code.codeOriginalText??>
	${code.codeOriginalText}
<#elseif code.codeDisplayName??>
	${code.codeDisplayName}	
<#elseif code.translations??>
	<#list code.translations as tran>
		${tran.codeDisplayName!"--"}
	</#list>
<#elseif code.code??>
	${code.code!"--"}
<#else>
	--
</#if>
</#macro>

<#macro displayTextWithDefault text = {}>
<#if text.OriginalTextMap??>
	<#assign omap = text.OriginalTextMap>
	<${omap.name} 
	<#list omap.attributes as attr>
		${attr.reference}="${attr.value}"
	</#list>
	>${omap.value!"--"}
	</${omap.name}>
<#elseif text.OriginalText??>
	${text.OriginalText}
<#elseif text.lowvalue??>
	${text.lowvalue} <#if ! text.highvalue??>${text.lowunit!""}</#if>
	<#if text.highvalue??>
		- ${text.highvalue} ${text.highunit!""}
	</#if>
<#else>
	--
</#if>
</#macro>

<#macro displayTextWithJavaScript text>
<#if text.OriginalTextMap??>
	<#assign omap = text.OriginalTextMap>
	<${omap.name} 
	<#list omap.attributes as attr>
		${attr.reference}="${attr.value}"
	</#list>
	>
	<href target="javascript:var win=window.open();win.document.write('script${omap.value!"--"}');" />
	</${omap.name}>
<#elseif text.OriginalText??>
	${text.OriginalText}
<#elseif text.lowvalue??>
	${text.lowvalue} ${text.lowunit!""}
	<#if text.highvalue??>
		- ${text.highvalue} ${text.highunit!""}
	</#if>
<#else>
	--
</#if>
</#macro>

<#macro displayTime time = {}>
<#if time.timeLow?? && time.timeHigh??>
	<#if time.timeLow = time.timeHigh>
		${time.timeLow}
	<#else>
		${time.timeLow} ${time.timeHigh} FromTo
	</#if>
<#elseif time.timeLow??>
	${time.timeLow}
<#elseif time.timeHigh??>
	${time.timehigh}
<#elseif time.timeValue??>
	${time.timeValue}
<#else>
	--
</#if>
</#macro>


