package gov.va.ccd.service.value.objects.impl;

import gov.va.ccd.service.value.object.SectionValueObject;

import java.lang.reflect.Field;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MedicationsVO implements SectionValueObject
{
	private static final Logger logger = LoggerFactory.getLogger(MedicationsVO.class);

	/** VA Fields **/
	private ItemObject medication = new ItemObject();

	/** 8.14 or 8.16 **/
	private ItemObject medicationBrandName = new ItemObject();

	private ItemObject medicationStatus = new ItemObject();

	private ItemObject sig = new ItemObject();

	private ItemObject source = new ItemObject();

	/** 8.29 **/
	private ItemObject orderExpiration = new ItemObject();

	/** 8.30 **/
	private ItemObject orderDate = new ItemObject();

	/** 8.34 **/
	private ItemObject prescriptionNumber = new ItemObject();

	/** 8.35 **/
	private ItemObject provider = new ItemObject();

	/** 8.37 **/
	private ItemObject dispenseDate = new ItemObject();

	/** 8.38 **/
	private ItemObject quantityDispensed = new ItemObject();

	/** 8.40 **/
	private ItemObject fillStatus = new ItemObject();

	/** The rest of the spec fields **/

	/** 8.02 **/
	private ItemObject indicateMedicationStopped = new ItemObject();

	/** 8.03 - 8.06 */
	private ItemObject effectiveTime = new ItemObject();

	/** 8.07 **/
	private ItemObject routeCode = new ItemObject();

	/** 8.08 **/
	private ItemObject doseQuanity = new ItemObject();

	/** 8.09 **/
	private ItemObject siteCode = new ItemObject();

	/** 8 .10 **/
	private ItemObject doseRestriction = new ItemObject();

	/** 8.11 **/
	private ItemObject productForm = new ItemObject();

	/** 8.12 **/
	private ItemObject deliveryMethod = new ItemObject();

	/** 8.13 **/
	private ItemObject codedProductName = new ItemObject();

	/** 8.14 **/
	private ItemObject codedBrandName = new ItemObject();

	/** 8.15 **/
	private ItemObject productName = new ItemObject();

	/** 8.16 **/
	private ItemObject brandName = new ItemObject();

	/** 8.17 **/
	private ItemObject drugManufacture = new ItemObject();

	/** 8.18 **/
	private ItemObject productConcentration = new ItemObject();

	/** 8.19 **/
	private ItemObject typeOfMedication = new ItemObject();

	/** 8.20 **/
	private ItemObject statusOfMedication = new ItemObject();

	/** 8.21 **/
	private ItemObject indication = new ItemObject();

	/** 8.22 **/
	private ItemObject patientInstructions = new ItemObject();

	/** 8.23 **/
	private ItemObject reaction = new ItemObject();

	/** 8.24 **/
	private ItemObject vehicle = new ItemObject();

	/** 8.25 **/
	private ItemObject doseIndicator = new ItemObject();

	/** 8.26 **/
	private ItemObject orderNumber = new ItemObject();

	/** 8.27 **/
	private ItemObject fills = new ItemObject();

	/** 8.28 **/
	private ItemObject quantityOrdered = new ItemObject();

	/** 8.31 **/
	private ItemObject orderingProvider = new ItemObject();

	/** 8.32 **/
	private ItemObject fulfillmentInstructions = new ItemObject();

	/** 8.33 **/
	private ItemObject fulfillmentHistory = new ItemObject();

	/** 8.36 **/
	private ItemObject pharmacyLocation = new ItemObject();

	/** 8.39 **/
	private ItemObject fillNumber = new ItemObject();

	/**
	 * @return the medications
	 */
	public final ItemObject getMedication()
	{
		return medication;
	}

	/**
	 * @param medication the medication to set
	 */
	public final void setMedication(ItemObject medication)
	{
		this.medication = medication;
	}

	public final void setMedication(String medication)
	{
		this.medication.setValue(medication);
	}

	/**
	 * @return the medicationBrandName
	 */
	public final ItemObject getMedicationBrandName()
	{
		return medicationBrandName;
	}

	/**
	 * @param medicationBrandName the medicationBrandName to set
	 */
	public final void setMedicationBrandName(ItemObject medicationBrandName)
	{
		this.medicationBrandName = medicationBrandName;
	}

	public final void setMedicationBrandName(String medicationBrandName)
	{
		this.medicationBrandName.setValue(medicationBrandName);
	}

	/**
	 * @return the medicationStatus
	 */
	public final ItemObject getMedicationStatus()
	{
		return medicationStatus;
	}

	/**
	 * @param medicationStatus the medicationStatus to set
	 */
	public final void setMedicationStatus(ItemObject medicationStatus)
	{
		this.medicationStatus = medicationStatus;
	}

	public final void setMedicationStatus(String medicationStatus)
	{
		this.medicationStatus.setValue(medicationStatus);
	}

	/**
	 * @return the orderDate
	 */
	public final ItemObject getOrderDate()
	{
		return orderDate;
	}

	/**
	 * @param orderDate the orderDate to set
	 */
	public final void setOrderDate(ItemObject orderDate)
	{
		this.orderDate = orderDate;
	}

	public final void setOrderDate(String orderDate)
	{
		this.orderDate.setValue(orderDate);
	}

	/**
	 * @return the orderExpiration
	 */
	public final ItemObject getOrderExpiration()
	{
		return orderExpiration;
	}

	/**
	 * @param orderExpiration the orderExpiration to set
	 */
	public final void setOrderExpiration(ItemObject orderExpiration)
	{
		this.orderExpiration = orderExpiration;
	}

	public final void setOrderExpiration(String orderExpiration)
	{
		this.orderExpiration.setValue(orderExpiration);
	}

	/**
	 * @return the provider
	 */
	public final ItemObject getProvider()
	{
		return provider;
	}

	/**
	 * @param provider the provider to set
	 */
	public final void setProvider(ItemObject provider)
	{
		this.provider = provider;
	}

	/**
	 * @return the prescriptionNumber
	 */
	public final ItemObject getPrescriptionNumber()
	{
		return prescriptionNumber;
	}

	/**
	 * @param prescriptionNumber the prescriptionNumber to set
	 */
	public final void setPrescriptionNumber(ItemObject prescriptionNumber)
	{
		this.prescriptionNumber = prescriptionNumber;
	}

	public final void setPrescriptionNumber(String prescriptionNumber)
	{
		this.prescriptionNumber.setValue(prescriptionNumber);
	}

	/**
	 * @return the fillStatus
	 */
	public final ItemObject getFillStatus()
	{
		return fillStatus;
	}

	/**
	 * @param fillStatus the fillStatus to set
	 */
	public final void setFillStatus(ItemObject fillStatus)
	{
		this.fillStatus = fillStatus;
	}

	public final void setFillStatus(String fillStatus)
	{
		this.fillStatus.setValue(fillStatus);
	}

	/**
	 * @return the quantityDispensed
	 */
	public final ItemObject getQuantityDispensed()
	{
		return quantityDispensed;
	}

	/**
	 * @param quantityDispensed the quantityDispensed to set
	 */
	public final void setQuantityDispensed(ItemObject quantityDispensed)
	{
		this.quantityDispensed = quantityDispensed;
	}

	public final void setQuantityDispensed(String quantityDispensed)
	{
		this.quantityDispensed.setValue(quantityDispensed);
	}

	/**
	 * @return the dispenseDate
	 */
	public final ItemObject getDispenseDate()
	{
		return dispenseDate;
	}

	/**
	 * @param dispenseDate the dispenseDate to set
	 */
	public final void setDispenseDate(ItemObject dispenseDate)
	{
		this.dispenseDate = dispenseDate;
	}

	public final void setDispenseDate(String dispenseDate)
	{
		this.dispenseDate.setValue(dispenseDate);
	}

	/**
	 * @return the sig
	 */
	public final ItemObject getSig()
	{
		return sig;
	}

	/**
	 * @param sig the sig to set
	 */
	public final void setSig(ItemObject sig)
	{
		this.sig = sig;
	}

	/**
	 * @return the source
	 */
	public final ItemObject getSource()
	{
		return source;
	}

	/**
	 * @param source the source to set
	 */
	public final void setSource(ItemObject source)
	{
		this.source = source;
	}

	public final void setSource(String source)
	{
		this.source.setValue(source);
	}

	/**
	 * @return the effectiveTime
	 */
	public final ItemObject getEffectiveTime()
	{
		return effectiveTime;
	}

	/**
	 * @param effectiveTime the effectiveTime to set
	 */
	public final void setEffectiveTime(ItemObject effectiveTime)
	{
		this.effectiveTime = effectiveTime;
	}

	public final void setEffectiveTime(String effectiveTime)
	{
		this.effectiveTime.setValue(effectiveTime);
	}

	/**
	 * @return the routeCode
	 */
	public final ItemObject getRouteCode()
	{
		return routeCode;
	}

	/**
	 * @param routeCode the routeCode to set
	 */
	public final void setRouteCode(ItemObject routeCode)
	{
		this.routeCode = routeCode;
	}

	public final void setRouteCode(String routeCode)
	{
		this.routeCode.setValue(routeCode);
	}

	/**
	 * @return the doseQuanity
	 */
	public final ItemObject getDoseQuanity()
	{
		return doseQuanity;
	}

	/**
	 * @param doseQuanity the doseQuanity to set
	 */
	public final void setDoseQuanity(ItemObject doseQuanity)
	{
		this.doseQuanity = doseQuanity;
	}

	public final void setDoseQuanity(String doseQuanity)
	{
		this.doseQuanity.setValue(doseQuanity);
	}

	/**
	 * @return the siteCode
	 */
	public final ItemObject getSiteCode()
	{
		return siteCode;
	}

	/**
	 * @param siteCode the siteCode to set
	 */
	public final void setSiteCode(ItemObject siteCode)
	{
		this.siteCode = siteCode;
	}

	public final void setSiteCode(String siteCode)
	{
		this.siteCode.setValue(siteCode);
	}

	/**
	 * @return the doseRestriction
	 */
	public final ItemObject getDoseRestriction()
	{
		return doseRestriction;
	}

	/**
	 * @param doseRestriction the doseRestriction to set
	 */
	public final void setDoseRestriction(ItemObject doseRestriction)
	{
		this.doseRestriction = doseRestriction;
	}

	public final void setDoseRestriction(String doseRestriction)
	{
		this.doseRestriction.setValue(doseRestriction);
	}

	/**
	 * @return the productForm
	 */
	public final ItemObject getProductForm()
	{
		return productForm;
	}

	/**
	 * @param productForm the productForm to set
	 */
	public final void setProductForm(ItemObject productForm)
	{
		this.productForm = productForm;
	}

	public final void setProductForm(String productForm)
	{
		this.productForm.setValue(productForm);
	}

	/**
	 * @return the deliveryMethod
	 */
	public final ItemObject getDeliveryMethod()
	{
		return deliveryMethod;
	}

	/**
	 * @param deliveryMethod the deliveryMethod to set
	 */
	public final void setDeliveryMethod(ItemObject deliveryMethod)
	{
		this.deliveryMethod = deliveryMethod;
	}

	public final void setDeliveryMethod(String deliveryMethod)
	{
		this.deliveryMethod.setValue(deliveryMethod);
	}

	/**
	 * @return the productName
	 */
	public final ItemObject getProductName()
	{
		return productName;
	}

	/**
	 * @param productName the productName to set
	 */
	public final void setProductName(ItemObject productName)
	{
		this.productName = productName;
	}

	public final void setProductName(String productName)
	{
		this.productName.setValue(productName);
	}

	/**
	 * @return the drugManufacture
	 */
	public final ItemObject getDrugManufacture()
	{
		return drugManufacture;
	}

	/**
	 * @param drugManufacture the drugManufacture to set
	 */
	public final void setDrugManufacture(ItemObject drugManufacture)
	{
		this.drugManufacture = drugManufacture;
	}

	public final void setDrugManufacture(String drugManufacture)
	{
		this.drugManufacture.setValue(drugManufacture);
	}

	/**
	 * @return the productConcentration
	 */
	public final ItemObject getProductConcentration()
	{
		return productConcentration;
	}

	/**
	 * @param productConcentration the productConcentration to set
	 */
	public final void setProductConcentration(ItemObject productConcentration)
	{
		this.productConcentration = productConcentration;
	}

	/**
	 * @return the typeOfMedication
	 */
	public final ItemObject getTypeOfMedication()
	{
		return typeOfMedication;
	}

	/**
	 * @param typeOfMedication the typeOfMedication to set
	 */
	public final void setTypeOfMedication(ItemObject typeOfMedication)
	{
		this.typeOfMedication = typeOfMedication;
	}

	public final void setTypeOfMedication(String typeOfMedication)
	{
		this.typeOfMedication.setValue(typeOfMedication);
	}

	/**
	 * @return the statusOfMedication
	 */
	public final ItemObject getStatusOfMedication()
	{
		return statusOfMedication;
	}

	/**
	 * @param statusOfMedication the statusOfMedication to set
	 */
	public final void setStatusOfMedication(ItemObject statusOfMedication)
	{
		this.statusOfMedication = statusOfMedication;
	}

	/**
	 * @return the indication
	 */
	public final ItemObject getIndication()
	{
		return indication;
	}

	/**
	 * @param indication the indication to set
	 */
	public final void setIndication(ItemObject indication)
	{
		this.indication = indication;
	}

	public final void setIndication(String indication)
	{
		this.indication.setValue(indication);
	}

	/**
	 * @return the patientInstructions
	 */
	public final ItemObject getPatientInstructions()
	{
		return patientInstructions;
	}

	/**
	 * @param patientInstructions the patientInstructions to set
	 */
	public final void setPatientInstructions(ItemObject patientInstructions)
	{
		this.patientInstructions = patientInstructions;
	}

	/**
	 * @return the reaction
	 */
	public final ItemObject getReaction()
	{
		return reaction;
	}

	/**
	 * @param reaction the reaction to set
	 */
	public final void setReaction(ItemObject reaction)
	{
		this.reaction = reaction;
	}

	public final void setReaction(String reaction)
	{
		this.reaction.setValue(reaction);
	}

	/**
	 * @return the vehicle
	 */
	public final ItemObject getVehicle()
	{
		return vehicle;
	}

	/**
	 * @param vehicle the vehicle to set
	 */
	public final void setVehicle(ItemObject vehicle)
	{
		this.vehicle = vehicle;
	}

	public final void setVehicle(String vehicle)
	{
		this.vehicle.setValue(vehicle);
	}

	/**
	 * @return the doseIndicator
	 */
	public final ItemObject getDoseIndicator()
	{
		return doseIndicator;
	}

	/**
	 * @param doseIndicator the doseIndicator to set
	 */
	public final void setDoseIndicator(ItemObject doseIndicator)
	{
		this.doseIndicator = doseIndicator;
	}

	public final void setDoseIndicator(String doseIndicator)
	{
		this.doseIndicator.setValue(doseIndicator);
	}

	/**
	 * @return the orderNumber
	 */
	public final ItemObject getOrderNumber()
	{
		return orderNumber;
	}

	/**
	 * @param orderNumber the orderNumber to set
	 */
	public final void setOrderNumber(ItemObject orderNumber)
	{
		this.orderNumber = orderNumber;
	}

	public final void setOrderNumber(String orderNumber)
	{
		this.orderNumber.setValue(orderNumber);
	}

	/**
	 * @return the fills
	 */
	public final ItemObject getFills()
	{
		return fills;
	}

	/**
	 * @param fills the fills to set
	 */
	public final void setFills(ItemObject fills)
	{
		this.fills = fills;
	}

	public final void setFills(String fills)
	{
		this.fills.setValue(fills);
	}

	/**
	 * @return the quantityOrdered
	 */
	public final ItemObject getQuantityOrdered()
	{
		return quantityOrdered;
	}

	/**
	 * @param quantityOrdered the quantityOrdered to set
	 */
	public final void setQuantityOrdered(ItemObject quantityOrdered)
	{
		this.quantityOrdered = quantityOrdered;
	}

	/**
	 * @return the orderingProvider
	 */
	public final ItemObject getOrderingProvider()
	{
		return orderingProvider;
	}

	/**
	 * @param orderingProvider the orderingProvider to set
	 */
	public final void setOrderingProvider(ItemObject orderingProvider)
	{
		this.orderingProvider = orderingProvider;
	}

	public final void setOrderingProvider(String orderingProvider)
	{
		this.orderingProvider.setValue(orderingProvider);
	}

	/**
	 * @return the fulfillmentInstructions
	 */
	public final ItemObject getFulfillmentInstructions()
	{
		return fulfillmentInstructions;
	}

	/**
	 * @param fulfillmentInstructions the fulfillmentInstructions to set
	 */
	public final void setFulfillmentInstructions(ItemObject fulfillmentInstructions)
	{
		this.fulfillmentInstructions = fulfillmentInstructions;
	}

	public final void setFulfillmentInstructions(String fulfillmentInstructions)
	{
		this.fulfillmentInstructions.setValue(fulfillmentInstructions);
	}

	/**
	 * @return the fulfillmentHistory
	 */
	public final ItemObject getFulfillmentHistory()
	{
		return fulfillmentHistory;
	}

	/**
	 * @param fulfillmentHistory the fulfillmentHistory to set
	 */
	public final void setFulfillmentHistory(ItemObject fulfillmentHistory)
	{
		this.fulfillmentHistory = fulfillmentHistory;
	}

	/**
	 * @return the pharmacyLocation
	 */
	public final ItemObject getPharmacyLocation()
	{
		return pharmacyLocation;
	}

	/**
	 * @param pharmacyLocation the pharmacyLocation to set
	 */
	public final void setPharmacyLocation(ItemObject pharmacyLocation)
	{
		this.pharmacyLocation = pharmacyLocation;
	}

	public final void setPharmacyLocation(String pharmacyLocation)
	{
		this.pharmacyLocation.setValue(pharmacyLocation);
	}

	/**
	 * @return the fillNumber
	 */
	public final ItemObject getFillNumber()
	{
		return fillNumber;
	}

	/**
	 * @param fillNumber the fillNumber to set
	 */
	public final void setFillNumber(ItemObject fillNumber)
	{
		this.fillNumber = fillNumber;
	}

	public final void setFillNumber(String fillNumber)
	{
		this.fillNumber.setValue(fillNumber);
	}

	/**
	 * @return the indicateMedicationStopped
	 */
	public final ItemObject getIndicateMedicationStopped()
	{
		return indicateMedicationStopped;
	}

	/**
	 * @param indicateMedicationStopped the indicateMedicationStopped to set
	 */
	public final void setIndicateMedicationStopped(ItemObject indicateMedicationStopped)
	{
		this.indicateMedicationStopped = indicateMedicationStopped;
	}

	public final void setIndicateMedicationStopped(String indicateMedicationStopped)
	{
		this.indicateMedicationStopped.setValue(indicateMedicationStopped);
	}

	/**
	 * @return the codedProductName
	 */
	public ItemObject getCodedProductName()
	{
		return codedProductName;
	}

	/**
	 * @param codedProductName the codedProductName to set
	 */
	public void setCodedProductName(ItemObject codedProductName)
	{
		this.codedProductName = codedProductName;
	}

	/**
	 * @return the codedBrandName
	 */
	public ItemObject getCodedBrandName()
	{
		return codedBrandName;
	}

	/**
	 * @param codedBrandName the codedBrandName to set
	 */
	public void setCodedBrandName(ItemObject codedBrandName)
	{
		this.codedBrandName = codedBrandName;
	}

	public void setBrandName(final ItemObject brandName)
	{
		this.brandName = brandName;
	}

	public void setBrandName(final String brandName)
	{
		this.brandName.setValue(brandName);
	}

	/**
	 * @return the brandName
	 */
	public ItemObject getBrandName()
	{
		return brandName;
	}

	@Override
	public String toString()
	{
		StringBuilder sb = new StringBuilder();
		for(Field field : this.getClass().getDeclaredFields())
		{
			try
			{
				sb.append("\t").append(field.getName()).append(": ").append(field.get(this)).append("\n");
			}
			catch(IllegalArgumentException e)
			{
				logger.error("Error occurred", e);
			}
			catch(IllegalAccessException e)
			{
				logger.error("Error occurred", e);
			}
		}
		return sb.toString();
	}
}
