package gov.va.ccd.service.value.object;

import org.apache.commons.lang3.StringUtils;

/**
 * @author chmarac
 * 
 */
public class UnitValue
{
	private String value;
	private String unit;
	private String time;
	private final String reference;

	public UnitValue(final String value)
	{
		this(value, StringUtils.EMPTY);
	}

	public UnitValue(final String value, final String unit)
	{
		this(value, unit, StringUtils.EMPTY);
	}

	public UnitValue(final String value, final String unit, final String time)
	{
		this(value, unit, time, StringUtils.EMPTY);
	}

	public UnitValue(final String value, final String unit, final String time, final String reference)
	{
		this.value = value;
		if(!"1".equals(unit))
		{
			this.unit = unit;
		}
		else
		{
			this.unit = StringUtils.EMPTY;
		}
		this.time = time;
		this.reference = reference;
	}

	/**
	 * @return the value
	 */
	public String getValue()
	{
		return value;
	}

	/**
	 * @param value the value to set
	 */
	public void setValue(String value)
	{
		this.value = value;
	}

	/**
	 * @return the unit
	 */
	public String getUnit()
	{
		return unit;
	}

	/**
	 * @param unit the unit to set
	 */
	public void setUnit(String unit)
	{
		this.unit = unit;
	}

	/**
	 * @return the time
	 */
	public String getTime()
	{
		return time;
	}

	/**
	 * @param time the time to set
	 */
	public void setTime(String time)
	{
		this.time = time;
	}

	/**
	 * @return the reference
	 */
	public String getReference()
	{
		return reference;
	}
}
