package gov.va.ccd.service.util;

import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

/**
 * For use when processing effective times.
 * 
 * @author ChmaraC
 * 
 */
public class EffTimeUtils
{
	private static final DateTimeParser[] parsers = { DateTimeFormat.forPattern("yyyyMMddHHmmss").getParser(), DateTimeFormat.forPattern("yMdHmsZ").getParser(), DateTimeFormat.forPattern("yMdHms.SZ").getParser(), DateTimeFormat.forPattern("yMdHms").getParser(), DateTimeFormat.forPattern("yMdHms.S").getParser(), DateTimeFormat.forPattern("yyyyMMddHHmmssZ").getParser(), DateTimeFormat.forPattern("yyyyMMddHHmmss.SSSZ").getParser(), DateTimeFormat.forPattern("yyyyMMdd").getParser(), DateTimeFormat.forPattern("yyyyMMddZ").getParser(), DateTimeFormat.forPattern("yyyy").getParser() };

	private static final DateTimeFormatter formatter = new DateTimeFormatterBuilder().append(null, parsers).toFormatter();

	public static DateTime convertDate(final String dt)
	{
		try
		{
			if(StringUtils.isNotBlank(dt))
			{
				return formatter.withOffsetParsed().parseDateTime(dt);
			}
		}
		catch(IllegalArgumentException ex)
		{

		}
		return null;
	}
}
