package gov.va.ccd.consol.processor;

import gov.va.ccd.consol.component.impl.AdvanceDirConsolComponent;
import gov.va.ccd.consol.component.impl.AllergyConsolComponent;
import gov.va.ccd.consol.component.impl.ImmunizationConsolComponent;
import gov.va.ccd.consol.component.impl.PayerConsolComponent;
import gov.va.ccd.consol.component.impl.PlanOfCareConsolComponent;
import gov.va.ccd.consol.component.impl.ResultConsolComponent;

import org.openhealthtools.mdht.uml.cda.ClinicalDocument;
import org.openhealthtools.mdht.uml.cda.consol.ContinuityOfCareDocument;

public class ConsolProcessor
{
	private final ContinuityOfCareDocument doc;

	public ConsolProcessor(final ClinicalDocument ccd) throws ClassCastException, NullPointerException, IllegalArgumentException
	{
		if(ccd == null)
		{
			// CCR 177821- lang3 does not support NullArgumentException, so
			// updated
			throw new IllegalArgumentException("ccd is null");
		}

		doc = (ContinuityOfCareDocument) ccd;

		if(doc == null)
		{
			throw new NullPointerException("C-CDA is null");
		}
		doc.getAdvanceDirectivesSection();
	}

	public void processDocument()
	{
		if(doc != null)
		{
			processSections();
		}
	}

	private void processSections()
	{
		assert (doc != null);

		AllergyConsolComponent allergies = new AllergyConsolComponent(doc);
		allergies.execute();

		AdvanceDirConsolComponent directives = new AdvanceDirConsolComponent(doc);
		directives.execute();

		ImmunizationConsolComponent immunizations = new ImmunizationConsolComponent(doc);
		immunizations.execute();

		ResultConsolComponent results = new ResultConsolComponent(doc);
		results.execute();

		PlanOfCareConsolComponent plans = new PlanOfCareConsolComponent(doc);
		plans.execute();

		PayerConsolComponent payers = new PayerConsolComponent(doc);
		payers.execute();

	}

	public static boolean isConsolDoc(final ClinicalDocument doc)
	{
		if(doc != null && doc instanceof ContinuityOfCareDocument)
		{
			return true;
		}
		return false;
	}
}
