package gov.va.ccd.consol.component.impl;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import gov.va.ccd.components.transform.Transformer;
import gov.va.ccd.consol.AbstractConsolComponent;
import gov.va.ccd.mapper.TemplateMapper;
import gov.va.ccd.service.value.object.SectionValueObject;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openhealthtools.mdht.uml.cda.Act;
import org.openhealthtools.mdht.uml.cda.Encounter;
import org.openhealthtools.mdht.uml.cda.Entry;
import org.openhealthtools.mdht.uml.cda.Observation;
import org.openhealthtools.mdht.uml.cda.Procedure;
import org.openhealthtools.mdht.uml.cda.SubstanceAdministration;
import org.openhealthtools.mdht.uml.cda.Supply;
import org.openhealthtools.mdht.uml.cda.consol.ContinuityOfCareDocument;
import org.openhealthtools.mdht.uml.cda.consol.PlanOfCareSection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author ChmaraC
 * 
 */
public class PlanOfCareConsolComponent extends AbstractConsolComponent<PlanOfCareSection>
{
	private static final Logger logger = LoggerFactory.getLogger(PlanOfCareConsolComponent.class);

	public PlanOfCareConsolComponent(ContinuityOfCareDocument ccd)
	{
		super(ccd.getPlanOfCareSection(), ccd);
	}

	@Override
	protected String generateXml()
	{
		try
		{
			Configuration cfg = TemplateMapper.getInstance().getCfg();
			Template temp = cfg.getTemplate("PlanOfCare.xml");
			/* Merge data-model with template */

			StringWriter out = new StringWriter();

			temp.process(values, out);
			return out.toString();
		}
		catch(IOException e)
		{
			logger.error("Error occurred", e);
		}
		catch(TemplateException e)
		{
			logger.error("Error occurred", e);
		}
		return StringUtils.EMPTY;
	}

	@Override
	protected void createObjects()
	{
		if(section != null)
		{
			// StrucDocText text = section.getText();

			// LOG.debug(text);
			// Need to loop through all of the items in the plan of care section
			// individually.
			List<Map<String, Object>> encounters = new ArrayList<Map<String, Object>>();
			List<Map<String, Object>> procedures = new ArrayList<Map<String, Object>>();
			List<Map<String, Object>> acts = new ArrayList<Map<String, Object>>();
			List<Map<String, Object>> substances = new ArrayList<Map<String, Object>>();
			List<Map<String, Object>> supplies = new ArrayList<Map<String, Object>>();
			List<Map<String, Object>> observations = new ArrayList<Map<String, Object>>();
			for(Entry entry : section.getEntries())
			{
				Map<String, Object> map = new HashMap<String, Object>();

				// Basically switch each type to see if this is a supported
				// type.
				if(entry.getEncounter() != null)
				{
					Encounter encounter = entry.getEncounter();
					Transformer.mapEncounterItem(map, encounter, narrativeText);
					// entry relationships For reason
					Transformer.mapReasons(map, encounter.getEntryRelationships(), narrativeText);

					encounters.add(map);
				}
				else if(entry.getProcedure() != null)
				{
					Procedure procedure = entry.getProcedure();
					Transformer.mapProcedureItem(map, procedure, narrativeText);
					Transformer.mapReasons(map, procedure.getEntryRelationships(), narrativeText);
					procedures.add(map);
				}
				else if(entry.getAct() != null)
				{
					Act act = entry.getAct();
					Transformer.mapActItem(map, act, narrativeText);
					Transformer.mapReasons(map, act.getEntryRelationships(), narrativeText);
					acts.add(map);
				}
				else if(entry.getSubstanceAdministration() != null)
				{
					SubstanceAdministration subAdm = entry.getSubstanceAdministration();
					Transformer.mapSubstanceItem(map, subAdm, narrativeText);
					Transformer.mapReasons(map, subAdm.getEntryRelationships(), narrativeText);
					substances.add(map);
				}
				else if(entry.getSupply() != null)
				{
					Supply supply = entry.getSupply();
					Transformer.mapSupplyItem(map, supply, narrativeText);
					Transformer.mapReasons(map, supply.getEntryRelationships(), narrativeText);
					supplies.add(map);
				}
				else if(entry.getObservation() != null)
				{
					Observation observation = entry.getObservation();
					Transformer.mapObservationItem(map, observation, narrativeText);
					Transformer.mapReasons(map, observation.getEntryRelationships(), narrativeText);
					observations.add(map);
				}
				else
				{
					logger.error("There is an unsupported item in Plan of Care.");
					logger.error("Type Code of value: {}", entry.getTypeCode());
				}
			}

			if(CollectionUtils.isNotEmpty(encounters))
			{
				values.put("encounters", encounters);
			}

			if(CollectionUtils.isNotEmpty(procedures))
			{
				values.put("procedures", procedures);
			}

			if(CollectionUtils.isNotEmpty(acts))
			{
				values.put("acts", acts);
			}

			if(CollectionUtils.isNotEmpty(substances))
			{
				values.put("substances", substances);
			}

			if(CollectionUtils.isNotEmpty(supplies))
			{
				values.put("supplies", supplies);
			}

			if(CollectionUtils.isNotEmpty(observations))
			{
				values.put("observations", observations);
			}
		}
	}

	@Deprecated
	public List<SectionValueObject> getSectionData()
	{
		throw new UnsupportedOperationException("Get Section data is for legacy code.");
	}

}
