package gov.va.ccd.consol.component.impl;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import gov.va.ccd.consol.AbstractConsolComponent;
import gov.va.ccd.consol.component.transform.TransformerConsolCore;
import gov.va.ccd.mapper.TemplateMapper;
import gov.va.ccd.service.value.object.SectionValueObject;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openhealthtools.mdht.uml.cda.SubstanceAdministration;
import org.openhealthtools.mdht.uml.cda.consol.ContinuityOfCareDocument;
import org.openhealthtools.mdht.uml.cda.consol.ImmunizationsSectionEntriesOptional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author ChmaraC
 * 
 */
public class ImmunizationConsolComponent extends AbstractConsolComponent<ImmunizationsSectionEntriesOptional>
{
	private static final Logger logger = LoggerFactory.getLogger(ImmunizationConsolComponent.class);

	public ImmunizationConsolComponent(ContinuityOfCareDocument ccd)
	{
		super(ccd.getImmunizationsSectionEntriesOptional(), ccd);
	}

	@Deprecated
	public List<SectionValueObject> getSectionData()
	{
		throw new UnsupportedOperationException("Get Section data is for legacy code.");
	}

	@Override
	protected String generateXml()
	{
		if(values.isEmpty())
			return StringUtils.EMPTY;

		try
		{
			Configuration cfg = TemplateMapper.getInstance().getCfg();
			Template temp = cfg.getTemplate("ccda/Immunization.ftl");
			/* Merge data-model with template */

			StringWriter out = new StringWriter();
			temp.process(values, out);
			return out.toString();
		}
		catch(IOException e)
		{
			logger.error("Error occurred", e);
		}
		catch(TemplateException e)
		{
			logger.error("Error occurred", e);
		}
		return StringUtils.EMPTY;
	}

	@Override
	protected void createObjects()
	{
		List<Map<String, Object>> immunizations = new ArrayList<Map<String, Object>>();
		for(SubstanceAdministration subsAdmin : section.getSubstanceAdministrations())
		{
			Map<String, Object> map = new HashMap<String, Object>();

			TransformerConsolCore.mapSubstanceItem(map, subsAdmin, narrativeText);
			if(!map.isEmpty())
			{
				immunizations.add(map);
			}
		}

		if(CollectionUtils.isNotEmpty(immunizations))
		{
			values.put("immunizations", immunizations);
		}
	}
}
