package gov.va.ccd.components.impl;

import gov.va.ccd.service.util.Utils;
import gov.va.ccd.service.value.objects.impl.AllergyVO;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openhealthtools.mdht.uml.cda.Act;
import org.openhealthtools.mdht.uml.cda.EntryRelationship;
import org.openhealthtools.mdht.uml.cda.Observation;
import org.openhealthtools.mdht.uml.cda.Participant2;
import org.openhealthtools.mdht.uml.cda.ParticipantRole;
import org.openhealthtools.mdht.uml.cda.PlayingEntity;
import org.openhealthtools.mdht.uml.cda.StrucDocText;
import org.openhealthtools.mdht.uml.cda.ccd.AlertsSection;
import org.openhealthtools.mdht.uml.cda.ccd.ContinuityOfCareDocument;
import org.openhealthtools.mdht.uml.cda.ccd.impl.AlertObservationImpl;
import org.openhealthtools.mdht.uml.cda.ccd.impl.ProblemObservationImpl;
import org.openhealthtools.mdht.uml.hl7.datatypes.CD;
import org.openhealthtools.mdht.uml.hl7.vocab.ParticipationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This class is used to generate the narrative block with help of allergy
 * helper.
 * 
 * @author vacokandlm
 * @param AlertsSection
 */
public class AllergyComponent extends AbstractComponent<AlertsSection>
{
	private static final Logger logger = LoggerFactory.getLogger(AllergyComponent.class);

	/**
	 * Constructor
	 * 
	 * @param alertsSection
	 * @param ccdDocument
	 */
	public AllergyComponent(final ContinuityOfCareDocument ccdDocument)
	{
		super(ccdDocument.getAlertsSection(), ccdDocument);
	}

	@Override
	public void execute()
	{
		if(section != null)
		{
			List<AllergyVO> rows = this.getAlleryRows();
			appendNarrative(this.generateXml(rows));
		}
	}

	private String generateXml(List<AllergyVO> rows)
	{
		StringBuffer sb = new StringBuffer();
		if(CollectionUtils.isNotEmpty(rows))
		{
			if(CollectionUtils.isNotEmpty(this.getComments()))
			{
				sb.append("<table ID='_nbAllergyComments' border='1' width='100%'>");
				sb.append("<thead>");
				sb.append("<tr><th>Comments</th></tr>");
				sb.append("</thead>");
				sb.append("<tbody>");

				for(String comment : this.getComments())
				{
					sb.append("<tr width='100%'>");
					sb.append("<td width='100%'>");
					sb.append("<p>");
					sb.append(comment);
					sb.append("</p>");
					sb.append("</td></tr>");
				}

				sb.append("</tbody>");
				sb.append("</table>");
			}

			sb.append("<table ID='_nbAllergy' border='1' width='100%'>");
			sb.append("<thead>");
			sb.append("<tr>");
			sb.append("<th>Allergen</th>");
			sb.append("<th>Reaction</th>");
			sb.append("<th>Severity</th>");
			sb.append("<th>Event Type</th>");
			sb.append("<th>Event Date</th>");
			sb.append("<th>Source</th>");
			sb.append("</tr>\n");
			sb.append("</thead>");
			sb.append("<tbody>");
			for(AllergyVO helper : rows)
			{
				sb.append("<tr>");

				sb.append("<td>" + Utils.getNonNullValue(helper.getProductDN(), helper.getAllergen()) + "</td>");

				sb.append("<td>");
				sb.append(Utils.returnDefaultOrBlank(Utils.listToString(helper.getReactionList()), "--"));
				sb.append("</td>");

				sb.append("<td>");
				sb.append(Utils.createReferenceWDefault(helper.getSeverityRef(), Utils.getNonNullValue(helper.getSeverityDN(), helper.getSeverityRN()), "--"));
				sb.append("</td>");

				sb.append("<td>" + Utils.getNonNullValue(helper.getEventType(), null) + "</td>");

				sb.append("<td>" + Utils.getNonNullValue(helper.getEventDate(), null) + "</td>");

				sb.append("<td>" + Utils.getNonNullValue(helper.getSource(), null) + "</td>");

				// sb.append("<td>");
				// sb.append(Utils.createReferenceWDefault(helper.getStatusRef(),
				// Utils.getNonNullValue(helper.getStatusDN(),
				// helper.getStatusRN()), "--"));
				// sb.append("</td>");
				sb.append("</tr>");
			}
			sb.append("</tbody>");
			sb.append("</table>");
		}
		return sb.toString();
	}

	public List<AllergyVO> getAlleryRows()
	{

		List<AllergyVO> list = new ArrayList<AllergyVO>();
		AllergyVO allergyHelper = null;

		StrucDocText narrativeText = section.getText();

		if(section.getActs() != null && section.getActs().size() > 0)
		{
			for(Act act : section.getActs())
			{

				allergyHelper = new AllergyVO();

				// Source
				String source = Utils.getSourceFromAct(act);
				if(StringUtils.isBlank(source))
				{
					source = Utils.getSource(this.getCcdDocument());
				}

				allergyHelper.setSource(source);

				// look at subordinate observations
				// we don't have a domain-specific "getter" method here so we
				// use
				// entry relationshipAllergyIntoleranceImpl
				String eventDateLow = null;
				if(act.getEffectiveTime() != null && act.getEffectiveTime().getLow() != null)
				{
					eventDateLow = act.getEffectiveTime().getLow().getValue();
					// CCR 177986
					logger.debug("Event Date Low {} : ", eventDateLow);
					allergyHelper.setEventDate(eventDateLow);
				}

				for(EntryRelationship entryRelationship : act.getEntryRelationships())
				{
					// check for alert observation
					if(entryRelationship.getObservation() instanceof AlertObservationImpl)
					{

						// get coded value from alert observation
						AlertObservationImpl alertObservation = (AlertObservationImpl) entryRelationship.getObservation();

						if(eventDateLow == null && alertObservation.getEffectiveTime() != null && alertObservation.getEffectiveTime().getLow() != null)
						{
							eventDateLow = alertObservation.getEffectiveTime().getLow().getValue();
							// CCR 177986
							logger.debug("Event Date Low {} : ", eventDateLow);
							allergyHelper.setEventDate(eventDateLow);
						}

						CD value = alertObservation.getCode();
						// CCR 177986
						logger.debug("code {}:", value);
						logger.debug("Event Types {}, {}, {}: ", value.getCode(), value.getCodeSystem(), value.getDisplayName());
						allergyHelper.setEventType(value.getDisplayName());

						for(Participant2 participant : alertObservation.getParticipants())
						{
							if(participant != null && participant.getTypeCode().toString().trim().equals(ParticipationType.CSM.getName()))
							{
								ParticipantRole participantRole = participant.getParticipantRole();
								if(participantRole != null && participantRole.getClassCode().toString().trim().equals("MANU"))
								{
									PlayingEntity playingEntity = participantRole.getPlayingEntity();

									if(playingEntity != null && playingEntity.getClassCode().toString().trim().equals("MMAT"))
									{

										if(participantRole.getPlayingEntity().getCode() != null && participantRole.getPlayingEntity().getCode().getOriginalText() != null && participantRole.getPlayingEntity().getCode().getOriginalText().getReference() != null)
										{
											String prodRef = participantRole.getPlayingEntity().getCode().getOriginalText().getReference().getValue();
											// CCR 177986
											logger.debug("prodRef {}: ", prodRef);
											allergyHelper.setProductRef(prodRef);

											String prodRefValue = Utils.getReferenceValue(narrativeText, prodRef);
											// CCR 177986
											logger.debug("prodRefValue {}: ", prodRefValue);
											allergyHelper.setProductRN(prodRefValue);
										}

										// Allergen
										String allergen = null;
										if(participantRole.getPlayingEntity().getNames() != null && participantRole.getPlayingEntity().getNames().size() > 0)
										{
											allergen = participantRole.getPlayingEntity().getNames().get(0).getText();
											allergyHelper.setAllergen(allergen);
											allergyHelper.setProductRN(allergen);
										}
										// Product Text
										if(participantRole.getPlayingEntity().getCode() != null)
										{
											String prodDispaly = participantRole.getPlayingEntity().getCode().getDisplayName();
											if(prodDispaly != null && prodDispaly.length() > 0)
											{
												allergyHelper.setProductDN(prodDispaly);

											}
											else
											{
												allergyHelper.setProductDN(allergen);

											}
										}
									}
								}
							}
						}

						// Reaction
						for(EntryRelationship entryRelationship2 : alertObservation.getEntryRelationships())
						{

							// LOG.debug("entryRelationship2.getTypeCode(): "
							// + entryRelationship2.getTypeCode());
							if(entryRelationship2.getTypeCode() != null && entryRelationship2.getTypeCode().toString().trim().equals("MFST"))
							{
								Observation reactionObservation = entryRelationship2.getObservation();

								String reactionRN = null;

								if(CollectionUtils.isNotEmpty(reactionObservation.getValues()) && reactionObservation.getValues().get(0) instanceof CD)
								{
									CD value1 = (CD) reactionObservation.getValues().get(0);

									reactionRN = value1.getDisplayName();
									if(StringUtils.isNotBlank(reactionRN))
									{
										allergyHelper.getReactionList().add(reactionRN);
									}
								}

								if(StringUtils.isEmpty(reactionRN) && reactionObservation.getText() != null && reactionObservation.getText().getReference() != null)
								{
									String reactionRef = reactionObservation.getText().getReference().getValue();

									reactionRN = Utils.getReferenceValue(narrativeText, reactionRef);

									if(StringUtils.isNotBlank(reactionRN))
									{
										allergyHelper.getReactionList().add(reactionRN);
									}
								}

							}

							// Severity
							if(entryRelationship2.getTypeCode() != null && entryRelationship2.getTypeCode().toString().trim().equals("SUBJ"))
							{
								Observation reactionObservation = entryRelationship2.getObservation();

								if(reactionObservation.getText() != null)
								{
									String severityRef = reactionObservation.getText().getReference().getValue();
									// CCR 177986
									logger.debug("Severity ref value {}: ", severityRef);
									allergyHelper.setSeverityRef(severityRef);

									String severityRN = Utils.getReferenceValue(narrativeText, severityRef);
									allergyHelper.setSeverityRN(severityRN);
								}

								if(!reactionObservation.getValues().isEmpty() && alertObservation.getValues().get(0) instanceof CD)
								{
									CD value1 = (CD) reactionObservation.getValues().get(0);

									String severityDN = value1.getDisplayName();
									if(severityDN != null && severityDN.length() > 0)
									{

										allergyHelper.setSeverityDN(severityDN);
									}

									// CCR 177986
									logger.debug("severityDN observation value {}, {}, {}: ", value1.getCode(), value1.getCodeSystem(), value1.getDisplayName());
								}
							}

							// Status
							if(entryRelationship2.getTypeCode() != null && entryRelationship2.getTypeCode().toString().trim().equals("REFR"))
							{
								Observation reactionObservation = entryRelationship2.getObservation();
								if(reactionObservation != null)
								{
									if(reactionObservation.getText() != null)
									{
										String statusRef = reactionObservation.getText().getReference().getValue();
										// CCR 177986
										logger.debug("Status ref value {}: " + statusRef);

										allergyHelper.setStatusRef(statusRef);
										String statusRN = Utils.getReferenceValue(narrativeText, statusRef);
										allergyHelper.setStatusRN(statusRN);
									}
									if(CollectionUtils.isNotEmpty(reactionObservation.getValues()) && CollectionUtils.isNotEmpty(alertObservation.getValues()) && alertObservation.getValues().get(0) instanceof CD)
									{
										CD value1 = (CD) reactionObservation.getValues().get(0);

										String statusDN = value1.getDisplayName();
										if(statusDN != null && statusDN.length() > 0)
										{
											allergyHelper.setStatusDN(statusDN);

										}

										// CCR 177986
										logger.debug("Status observation value {}, {}, {}: ", value1.getCode(), value1.getCodeSystem(), value1.getDisplayName());
									}
								}
							}

						}
					}
					if(entryRelationship.getObservation() instanceof ProblemObservationImpl)
					{
						// get coded value from alert observation
						ProblemObservationImpl alertObservation = (ProblemObservationImpl) entryRelationship.getObservation();

						CD value = alertObservation.getCode();
						// CCR 177986
						logger.debug("code {}:" + value);
						logger.debug("Event Type {}, {}, {}: ", value.getCode(), value.getCodeSystem(), value.getDisplayName());
						allergyHelper.setEventType(value.getDisplayName());

						if(eventDateLow == null && alertObservation.getEffectiveTime() != null && alertObservation.getEffectiveTime().getLow() != null)
						{
							eventDateLow = alertObservation.getEffectiveTime().getLow().getValue();
							// CCR 177986
							logger.debug("Event Date Low {} : ", eventDateLow);
							allergyHelper.setEventDate(eventDateLow);
						}

						for(Participant2 participant : alertObservation.getParticipants())
						{

							if(participant != null && participant.getTypeCode().toString().trim().equals(ParticipationType.CSM.getName()))
							{
								ParticipantRole participantRole = participant.getParticipantRole();
								if(participantRole != null && participantRole.getClassCode().toString().trim().equals("MANU"))
								{
									PlayingEntity playingEntity = participantRole.getPlayingEntity();

									if(playingEntity != null && playingEntity.getClassCode().toString().trim().equals("MMAT"))
									{

										if(participantRole.getPlayingEntity().getCode() != null)
										{
											String prodRef = participantRole.getPlayingEntity().getCode().getOriginalText().getReference().getValue();
											// CCR 177986
											logger.debug("prodRef {}: ", prodRef);
											allergyHelper.setProductRef(prodRef);

											String prodRefValue = Utils.getReferenceValue(narrativeText, prodRef);
											// CCR 177986
											logger.debug("prodRefValue {}: ", prodRefValue);
											allergyHelper.setProductRN(prodRefValue);
										}

										// Allergen
										String allergen = null;
										if(participantRole.getPlayingEntity().getNames() != null && participantRole.getPlayingEntity().getNames().size() > 0)
										{
											allergen = participantRole.getPlayingEntity().getNames().get(0).getText();
											allergyHelper.setAllergen(allergen);
											allergyHelper.setProductRN(allergen);
										}
										// Product Text
										if(participantRole.getPlayingEntity().getCode() != null)
										{
											String prodDispaly = participantRole.getPlayingEntity().getCode().getDisplayName();
											if(prodDispaly != null && prodDispaly.length() > 0)
											{
												allergyHelper.setProductDN(prodDispaly);

											}
											else
											{
												allergyHelper.setProductDN(allergen);

											}
										}
									}
								}
							}
						}

						// Reaction
						for(EntryRelationship entryRelationship2 : alertObservation.getEntryRelationships())
						{

							// LOG.debug("entryRelationship2.getTypeCode(): "
							// + entryRelationship2.getTypeCode());
							if(entryRelationship2.getTypeCode() != null && entryRelationship2.getTypeCode().toString().trim().equals("MFST"))
							{
								Observation reactionObservation = entryRelationship2.getObservation();

								String reactionRN = null;
								if(reactionObservation != null)
								{
									if(reactionObservation.getText() != null && reactionObservation.getText().getReference() != null)
									{
										String reactionRef = reactionObservation.getText().getReference().getValue();

										allergyHelper.setReactionRef(reactionRef);
										reactionRN = Utils.getReferenceValue(narrativeText, reactionRef);
										// CCR 177986
										logger.debug("reaction ref Name {} and value {}:  ", reactionRef, reactionRN);
										allergyHelper.setReactionRN(reactionRN);
									}

									if(CollectionUtils.isNotEmpty(reactionObservation.getValues()) && reactionObservation.getValues().get(0) instanceof CD)
									{
										CD value1 = (CD) reactionObservation.getValues().get(0);

										String reactionDN = value1.getDisplayName();
										if(reactionDN != null && reactionDN.length() > 0)
										{
											allergyHelper.setReactionDN(reactionDN);

										}
										if(reactionDN != null)
											allergyHelper.getReactionList().add(reactionDN);
										else
											allergyHelper.getReactionList().add(reactionRN);

										// CCR 177986
										logger.debug("reaction observation value {}, {}, {} : ", value1.getCode(), value1.getCodeSystem(), value1.getDisplayName());
									}
								}
							}

							// Severity
							if(entryRelationship2.getTypeCode() != null && entryRelationship2.getTypeCode().toString().trim().equals("SUBJ"))
							{
								Observation reactionObservation = entryRelationship2.getObservation();

								if(reactionObservation.getText() != null)
								{
									String severityRef = reactionObservation.getText().getReference().getValue();
									// CCR 177986
									logger.debug("Severity ref value {}: ", severityRef);
									allergyHelper.setSeverityRef(severityRef);

									String severityRN = Utils.getReferenceValue(narrativeText, severityRef);
									allergyHelper.setSeverityRN(severityRN);
								}
								if(!reactionObservation.getValues().isEmpty() && alertObservation.getValues().get(0) instanceof CD)
								{
									CD value1 = (CD) reactionObservation.getValues().get(0);

									String severityDN = value1.getDisplayName();
									if(severityDN != null && severityDN.length() > 0)
									{

										allergyHelper.setSeverityDN(severityDN);
									}

									// CCR 177986
									logger.debug("severityDN observation value {}, {}, {}: ", value1.getCode(), value1.getCodeSystem(), value1.getDisplayName());
								}
							}

							// Status
							if(entryRelationship2.getTypeCode() != null && entryRelationship2.getTypeCode().toString().trim().equals("REFR") && entryRelationship2.getObservation() != null)
							{
								Observation reactionObservation = entryRelationship2.getObservation();

								if(reactionObservation.getText() != null)
								{
									String statusRef = reactionObservation.getText().getReference().getValue();
									// CCR 177986
									logger.debug("Status ref value {}: ", statusRef);

									allergyHelper.setStatusRef(statusRef);
									String statusRN = Utils.getReferenceValue(narrativeText, statusRef);
									allergyHelper.setStatusRN(statusRN);
								}

								if(!reactionObservation.getValues().isEmpty() && alertObservation.getValues().get(0) instanceof CD)
								{
									CD value1 = (CD) reactionObservation.getValues().get(0);

									String statusDN = value1.getDisplayName();
									if(statusDN != null && statusDN.length() > 0)
									{
										allergyHelper.setStatusDN(statusDN);

									}

									// CCR 177986
									logger.debug("Status observation value {}, {}, {}: ", value1.getCode(), value1.getCodeSystem(), value1.getDisplayName());
								}
							}
						}
					}
				}
				list.add(allergyHelper);
			}
		}

		return list;
	}

	/**
	 * No-op handled above.
	 */
	@Override
	protected String generateXml()
	{
		return null;
	}

	/**
	 * No-op handled above.
	 */
	@Override
	protected void createObjects()
	{

	}
}
