package gov.va.ccd.components.impl;

import gov.va.ccd.service.util.Utils;
import gov.va.ccd.service.value.objects.impl.AdvanceDirectiveVO;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.openhealthtools.mdht.uml.cda.Entry;
import org.openhealthtools.mdht.uml.cda.Observation;
import org.openhealthtools.mdht.uml.cda.Participant2;
import org.openhealthtools.mdht.uml.cda.ccd.AdvanceDirectivesSection;
import org.openhealthtools.mdht.uml.cda.ccd.ContinuityOfCareDocument;
import org.openhealthtools.mdht.uml.hl7.datatypes.CD;

/**
 * 
 * @author KandlaguntaM
 * 
 */
public class AdvanceDirectiveComponent extends AbstractComponent<AdvanceDirectivesSection> {

	public AdvanceDirectiveComponent(final ContinuityOfCareDocument ccdDocument) {
		super(ccdDocument.getAdvanceDirectivesSection(), ccdDocument);
	}

	@Override
	public void execute() {
		if (section != null) {
			List<AdvanceDirectiveVO> rows = getAdvanceDirectiveRows();
			appendNarrative(generateXml(rows));
		}
	}

	private String generateXml(List<AdvanceDirectiveVO> rows) {
		StringBuffer sb = new StringBuffer();
		if (CollectionUtils.isNotEmpty(rows)) {
			if (CollectionUtils.isNotEmpty(this.getComments())) {
				sb.append("<table ID='_nbAdvDirectiveComments' border='1' width='100%'>");
				sb.append("<thead>");
				sb.append("<tr><th>Comments</th></tr>");
				sb.append("</thead>");
				sb.append("<tbody>");

				for (String comment : this.getComments()) {
					sb.append("<tr width='100%'>");
					sb.append("<td width='100%'>");
					sb.append("<p>");
					sb.append(comment);
					sb.append("</p>");
					sb.append("</td></tr>");
				}

				sb.append("</tbody>");
				sb.append("</table>");
			}
			sb.append("<table ID='_nbAdvDirective' border='1' width='100%'>");
			sb.append("<thead>");
			sb.append("<tr>");
			sb.append("<th>Advance Directive Type</th>");
			sb.append("<th>Advance Directive</th>");
			sb.append("<th>Effective Date</th>");
			sb.append("<th>Custodian</th>");
			sb.append("<th>Source</th>");
			sb.append("</tr>\n");
			sb.append("</thead>");
			sb.append("<tbody>");
			for (Iterator<AdvanceDirectiveVO> iterator = rows.iterator(); iterator.hasNext();) {
				AdvanceDirectiveVO helper = iterator.next();

				sb.append("<tr>");
				sb.append("<td>" + Utils.getNotNullValue(helper.getAdTypeDN(), null) + "</td>");
				sb.append("<td>" + Utils.getNonNullValue(helper.getAdTypeRN(), null) + "</td>");
				sb.append("<td>" + Utils.getNotNullValue(helper.getEffectiveDate(), null) + "</td>");
				sb.append("<td>" + Utils.getNotNullValue(helper.getCustodianOfDoc(), null) + "</td>");
				sb.append("<td>" + Utils.getNotNullValue(helper.getSource(), null) + "</td>");

				sb.append("</tr>");
			}

			sb.append("</tbody>");
			sb.append("</table>");
		}
		return sb.toString();

	}

	private List<AdvanceDirectiveVO> getAdvanceDirectiveRows() {

		List<AdvanceDirectiveVO> list = new ArrayList<AdvanceDirectiveVO>();
		AdvanceDirectiveVO advanceDirectiveHelper = null;

		// source
		String source = Utils.getSource(this.ccdDocument);

		if (section.getEntries() != null && section.getEntries().size() > 0) {
			for (Iterator<Entry> iterator = section.getEntries().iterator(); iterator.hasNext();) {
				Entry entry = iterator.next();
				advanceDirectiveHelper = new AdvanceDirectiveVO();
				advanceDirectiveHelper.setSource(source);

				Observation observation = entry.getObservation();

				// advance type display name, ref value and ref name
				if (observation != null && observation.getCode() != null) {
					CD value = observation.getCode();

					advanceDirectiveHelper.setAdTypeDN(value.getDisplayName());

					if (value.getOriginalText() != null && value.getOriginalText().getReference() != null) {

						String refValue = value.getOriginalText().getReference().getValue();

						advanceDirectiveHelper.setAdTypeRef(refValue);
						advanceDirectiveHelper.setAdTypeRN(this.getReferenceValue(refValue));
					}

					if (observation.getEffectiveTime() != null && observation.getEffectiveTime().getLow() != null) {
						advanceDirectiveHelper.setEffectiveDate(observation.getEffectiveTime().getLow().getValue());
					}

					// name of the custodian
					if (observation.getParticipants() != null && observation.getParticipants().get(0) != null) {
						Participant2 participant2 = observation.getParticipants().get(0);
						if (participant2.getTypeCode() != null
								&& participant2.getTypeCode().toString().trim().equals("CST")) {
							if (participant2.getParticipantRole() != null
									&& participant2.getParticipantRole().getPlayingEntity() != null) {
								if (participant2.getParticipantRole().getPlayingEntity().getNames() != null
										&& !participant2.getParticipantRole().getPlayingEntity().getNames().isEmpty()) {
									if (participant2.getParticipantRole().getPlayingEntity().getNames().get(0) != null) {
										advanceDirectiveHelper.setCustodianOfDoc(participant2.getParticipantRole()
												.getPlayingEntity().getNames().get(0).getText());

									}

								}
							}
						}

					}
				}

				list.add(advanceDirectiveHelper);
			}
		}
		return list;
	}

	/**
	 * No-op handled above.
	 */
	@Override
	protected String generateXml() {
		return null;
	}

	/**
	 * No-op handled above.
	 */
	@Override
	protected void createObjects() {

	}

}
