package gov.va.ccd.components.enums;

public enum PayerFields {
	/* @formatter:off */
	INSURANCE_NARRATIVE("ins_narr","Insurance Narrative"), 
	RESULT_ID("res_id", "Result Id"), 
	GROUP_NUMBER("grp_num", "Group Number"),
	INSURANCE_TYPE("ins_type", "Insurance Type"), 
	SOURCE_ID("src_id", "Information Source ID"), 
	SOURCE_ADDR("src_addr", "Information Source Address"), 
	SOURCE_PHONE("src_phone", "Information Source Phone/email/URL"), 
	SOURCE_NAME("src_name", "Information Source Name"), 
	COVERED_START("cov_start", "Coverage Begin Date"), 
	COVERED_END("cov_end", "Coverage end date"), 
	COVERED_ID("cov_id", "Member ID"), 
	COVERED_RELATIONSHIP("cov_rel", "Relationship type"), 
	COVERED_ADDR("cov_addr", "Patient Address"), 
	COVERED_PHONE("cov_phone", "Patient Phone"), 
	COVERED_NAME("cov_name", "Patient Name"), 
	COVERED_DOB("cov_dob", "Patient Date of Birth"), 
	RESPONSIBLE_PARTY_TYPE("party_type", "Financial Respnsibilty Party"), 
	SUBSCRIBER_ID("sub_id", "Subscriber ID"), 
	SUBSCRIBER_ADDR("sub_addr", "Subscriber Address"), 
	SUBSCRIBER_PHONE("sub_phone", "Subscriber Phone"), 
	SUBSCRIBER_NAME("sub_name", "Subscriber Name"), 
	SUBSCRIBER_DOB("sub_dob", "Subscriber Date of Birth"), 
	GUAR__START("guar_start", "Guarantor Date of Financial Responsibility"), 
	GUAR_ADDR("guar_addr", "Guarantor Address"), 
	GUAR_PHONE("guar_phone", "Guarantor Phone"), 
	GUAR_NAME("guar_name", "Guarantor Name"), 
	PLAN_NAME("plan_name", "Health Plan Name");
	
	/* @formatter:on */

	private final String key;
	private final String displayName;

	private PayerFields(final String key, final String displayName) {
		this.key = key;
		this.displayName = displayName;
	}

	/**
	 * @return the key
	 */
	public String getKey(){
		return key;
	}
	/**
	 * @return the displayName
	 */
	public String getDisplayName() {
		return displayName;
	}
}
