package gov.va.ccd.components.api;

import gov.va.ccd.service.value.object.SectionValueObject;

import java.util.List;

import org.openhealthtools.mdht.uml.cda.ClinicalDocument;
import org.openhealthtools.mdht.uml.cda.Section;

/**
 * CCD Component Interface 
 * 
 * @author Brad Messerle
 * @since 1.0
 *
 */
public interface CcdComponent<S extends Section> {

	
	/**
	 * Process Section
	 */
	void execute();

	
	/**
	 * @return the ccdDocument
	 */
	ClinicalDocument getCcdDocument();
	
	/**
	 * @return the sectionData
	 */
	List<SectionValueObject> getSectionData();
}
