package gov.va.ccd.comments.extractor;

import org.openhealthtools.mdht.uml.hl7.datatypes.II;

public class CommentsExtractorFactory {

	private final static String VA_ROOT_ID = "2.16.840.1.113883.4.349";

	public final static CommentsExtractor getInstance(final II rootId) {

		if (rootId != null && rootId.getRoot().equalsIgnoreCase(VA_ROOT_ID)) {
			return new VACommentsExtractor();
		} else {
			return new NonVACommentsExtractor();
		}

	}

}
