package gov.va.ccd.comments.extractor;

import java.util.List;

import org.openhealthtools.mdht.uml.cda.Section;

public abstract class AbstractCommentsExtractor implements CommentsExtractor {

	
	/**
	 * Generate comments string for the given section.
	 * @return
	 */
	public abstract <S extends Section> List<String> extractSectionComments(final S section);
	
	/**
	 * Get the narrative text for the given section
	 * @param section
	 * @return
	 */
	protected final <S extends Section> String getNarrativeBlock(final S section){
		return section.getText().getText();
	}
	
}
