package com.va.ccd.service.enums;

/**
 * Per the C32 V 2.1 Spec Page 83 Vital Signs 
 * LOINC Concept Codes
 * 
 * @author Brad Messerle
 *
 */
public enum VitialSignCodes {

	RESPIRATION_RATE("9279-1","Respiration Rate"),
	HEART_RATE("8867-4","Heart Rate"),
	OXYGEN_SATURATION("2710-2","Oxygen Saturation"),
	BP_SYSTOLIC("8480-6","BP Systolic"),
	BP_DIASTOLIC("8462-4","BP Diastolic"),
	BODY_MASS_INDEX("39156-5","Body Mass Index"),
	BODY_SURFACE_AREA("3140-1","Body Surface Area"),
	BODY_TEMPERATURE("8310-5","Body Temperature"),
	HEIGHT("8302-2","Height"),
	HEIGHT_LYING("8306-3","Height Lying"),
	HEAD_CIRCUMFERENCE("8287-5","Head Circumference"),
	WEIGHT_MEASURED("3141-9","Weight Measured");
	 
	/** LOINC Code **/
    private String code;
    
    /** Code Description **/
    private String label;

    private VitialSignCodes(final String code, final String label) {

            this.code = code;
            this.label = label;

    }

	/**
	 * @return the code
	 */
	public final String getCode() {
		return code;
	}


	/**
	 * @return the label
	 */
	public final String getLabel() {
		return label;
	}


	
}
