


  CREATE TABLE "ADAPTER"."AUDITS" 
   (	"AUDIT_ID" NUMBER CONSTRAINT "AUDITS_NN1" NOT NULL ENABLE, 
	"ACTION_NAME" VARCHAR2(255 BYTE) CONSTRAINT "AUDITS_NN2" NOT NULL ENABLE, 
	"USER_ID" VARCHAR2(255 BYTE), 
	"ORGANIZATION_ID" VARCHAR2(255 BYTE), 
	"PATIENT_ID" VARCHAR2(255 BYTE), 
	"PURPOSE_FOR_USE" VARCHAR2(255 BYTE), 
	"DOCUMENT_ID" VARCHAR2(255 BYTE), 
	"AUDIT_TIME" TIMESTAMP (6) CONSTRAINT "AUDITS_NN3" NOT NULL ENABLE, 
	"OPTOUT_REASON_ID" NUMBER, 
	"REMOTE_ORGANIZATION_ID" VARCHAR2(255 BYTE), 
	"REMOTE_DOC_REPOSITORY_ID" VARCHAR2(255 BYTE), 
	"REMOTE_DOC_ID" VARCHAR2(255 BYTE), 
	"DETAILS" VARCHAR2(4000 BYTE), 
	"PATIENT_LAST_NAME" VARCHAR2(255 BYTE), 
	"PATIENT_GIVEN_NAME" VARCHAR2(255 BYTE), 
	"USER_NAME" VARCHAR2(255 BYTE), 
	"PATIENT_FACILITY_NUMBER" VARCHAR2(20 BYTE), 
	"PATIENT_SSN" VARCHAR2(20 BYTE), 
	"PATIENT_FACILITY_NAME" VARCHAR2(255 BYTE), 
	"USER_FACILITY_NUMBER" VARCHAR2(255 BYTE), 
	"USER_FACILITY_NAME" VARCHAR2(255 BYTE), 
	"USER_ROLE" VARCHAR2(255 BYTE), 
	"DOC_SPEC_TYPE" VARCHAR2(10 BYTE), 
	 CONSTRAINT "AUDITS_PK" PRIMARY KEY ("AUDIT_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;

  CREATE OR REPLACE TRIGGER "ADAPTER"."AUDIT_ID_TRG" 
BEFORE INSERT
ON AUDITS 
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
declare
  N NUMBER;
begin
  if :NEW.AUDIT_ID is null then
      select AUDIT_ID_SEQ.NEXTVAL into N from DUAL;
      :new.AUDIT_ID := N;
  end if;
end AUDIT_ID_TRG;
/
ALTER TRIGGER "ADAPTER"."AUDIT_ID_TRG" ENABLE;
