spool SensitiveDataFiltering_INSERT.log 
--- Since 6.4.0  This script will add all test data needed for sensitive data filtering to use in the DEV/SQA environments.

Insert into ADAPTER.PROPERTIES
   (PROPERTY_KEY, PROPERTY_VALUE)
 Values
   ('FILTER_SENSITIVE_DATA', 'true');
   
Insert into ADAPTER.PROPERTIES
   (PROPERTY_KEY, PROPERTY_VALUE)
 Values
   ('FILTER_SENSITIVE_OBLIGATION', 'FILTER_SENSITIVE');   
   

---  *************    Start populating Facilities  ********************
INSERT INTO ADAPTER.INT_FACILITIES (FACILITY_NUMBER, FACILITY_NAME) 
	VALUES ('SENSITIVE_INFO_FACILITY','Sensitive Data Filter Facility');

	
COMMIT;
---  *************    Stop populating Facilities  ********************

---  *************    Start populating Filters  **********************
---  For each facility on record this will prepopulate the filters with the defaults provided by MHV.
SET SERVEROUTPUT ON;
DECLARE
  CURSOR c_facility IS
    SELECT FACILITY_ID FROM ADAPTER.INT_FACILITIES where FACILITY_NUMBER = 'SENSITIVE_INFO_FACILITY';
   
  CURSOR c_enums IS	
	SELECT FILTER_ID, FILTER_NAME FROM ADAPTER.INT_FILT_CONST where FILTER_NAME= 'LIST_LIMIT';
	
   v_f_id ADAPTER.INT_FACILITIES.FACILITY_ID%TYPE;
   v_filter_id ADAPTER.INT_FILT_CONST.FILTER_ID%TYPE;
   v_filter_name ADAPTER.INT_FILT_CONST.FILTER_NAME%TYPE;
   
BEGIN
	OPEN c_facility;
  
--Each facility loop
   LOOP
    FETCH c_facility INTO v_f_id;
    EXIT WHEN c_facility%NOTFOUND;
    DBMS_OUTPUT.PUT_LINE('Starting  ' || v_f_id);
	OPEN c_enums;
		LOOP
			--- Each enumeration value.
			FETCH c_enums INTO v_filter_id, v_filter_name;
			EXIT WHEN c_enums%NOTFOUND;
			--- Start looking at each type and add the correct default params.
			INSERT INTO ADAPTER.INT_FAC_FILT 
				(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
			VALUES
				(v_f_id, v_filter_id, 'notes', '', '0');
			COMMIT;
		END LOOP;
		CLOSE c_enums;
   END LOOP;
   CLOSE c_facility;
END;
/
COMMIT;
---  *************    Stop populating Filters  ***********************

spool off